/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.gui.component;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.resources.ResourceProvider;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.swing.UjoTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UjoTable
extends JTable
implements TableCellRenderer {
    private TableCellRenderer superRenderer = null;
    private ImageIcon sortIcon = null;
    private UjoProperty sortedColumn = null;

    public UjoTable() {
        this.init();
    }

    protected void init() {
    }

    public UjoProperty convertColumnIndexToProperty(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        UjoProperty ujoProperty = this.getModel().getColumn(n2);
        return ujoProperty;
    }

    public UjoProperty getColumn(int n) {
        UjoProperty ujoProperty = this.getModel().getColumn(this.convertColumnIndexToModel(n));
        return ujoProperty;
    }

    public TableColumn getTableColumn(UjoProperty ujoProperty) {
        int n = this.getModel().getColumnIndex(ujoProperty);
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        return tableColumn;
    }

    public void selectRow(int n) {
        int n2 = this.getModel().getRowCount();
        if (n >= n2) {
            n = n2 - 1;
        }
        if (n >= 0) {
            this.setRowSelectionInterval(n, n);
            this.scrollRectToVisible(this.getCellRect(n, 0, true));
        }
    }

    public int selectRow(Ujo ujo) {
        UjoTableModel ujoTableModel = this.getModel();
        if (ujo != null) {
            for (int i = 0; i < ujoTableModel.getRowCount(); ++i) {
                if (ujo != ujoTableModel.getRow(i)) continue;
                this.selectRow(i);
                return i;
            }
        }
        this.clearSelection();
        return -1;
    }

    public void enableEnterEditMode() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "InsetrAction");
        this.getActionMap().put("InsetrAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = UjoTable.this.getSelectedRow();
                if (UjoTable.this.editCellAt(n2, n = UjoTable.this.getSelectedColumn(), actionEvent)) {
                    UjoTable.this.getEditorComponent().requestFocusInWindow();
                }
            }
        });
    }

    public void setRenderer(TableCellRenderer tableCellRenderer) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = this.getColumnCount() - 1; i >= 0; --i) {
            tableColumnModel.getColumn(i).setCellRenderer(tableCellRenderer);
        }
    }

    public String getStringModel() {
        StringBuilder stringBuilder = new StringBuilder(256);
        List<List<String>> list = this.getStringModelArray(false);
        for (List<String> list2 : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            for (String string : list2) {
                stringBuilder.append(string);
                stringBuilder.append('\t');
                System.err.println("cell:" + string);
            }
        }
        return stringBuilder.toString();
    }

    public List<List<String>> getStringModelArray(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n;
        ArrayList<Object> arrayList;
        ArrayList<List<String>> arrayList2 = new ArrayList<List<String>>(this.getRowCount());
        UjoTableModel ujoTableModel = this.getModel();
        if (bl && this.getTableHeader() != null) {
            arrayList = new ArrayList<Object>();
            arrayList2.add(arrayList);
            for (n = 0; n < ujoTableModel.getColumnCount(); ++n) {
                UjoProperty ujoProperty = this.getColumn(n);
                object3 = this.getTableColumn(ujoProperty).getHeaderRenderer();
                object2 = ujoTableModel.getColumnName(ujoProperty);
                if (object3 != null && (object = object3.getTableCellRendererComponent(this, object2, false, false, -1, n)) instanceof JLabel) {
                    object2 = ((JLabel)object).getText();
                }
                arrayList.add(object2);
            }
        }
        for (n = 0; n < ujoTableModel.getRowCount(); ++n) {
            arrayList = new ArrayList();
            arrayList2.add(arrayList);
            for (int i = 0; i < ujoTableModel.getColumnCount(); ++i) {
                Component component;
                object3 = this.getColumn(i);
                object2 = this.getTableColumn((UjoProperty)object3).getCellRenderer();
                object = ujoTableModel.getValueAt(n, (UjoProperty)object3);
                String string = String.valueOf(object);
                if (object2 != null && (component = object2.getTableCellRendererComponent(this, object, false, false, n, i)) instanceof JLabel) {
                    string = ((JLabel)component).getText();
                }
                arrayList.add(string);
            }
        }
        return arrayList2;
    }

    public void submitEditMode(boolean bl) {
        Component component = this.getEditorComponent();
        if (component != null) {
            if (bl && this.getRowCount() > 0 && this.getColumnCount() > 0) {
                this.editCellAt(0, 0);
            }
            this.editingCanceled(new ChangeEvent(this));
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (tableModel instanceof UjoTableModel) {
            super.setModel(tableModel);
            tableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getColumn() == -1) {
                        UjoTable.this.submitEditMode(tableModelEvent.getType() != -1);
                    }
                }
            });
        }
    }

    @Override
    public UjoTableModel getModel() {
        return (UjoTableModel)super.getModel();
    }

    public void enableSorting(ApplContext applContext) {
        if (this.superRenderer != null) {
            return;
        }
        this.superRenderer = this.getTableHeader().getDefaultRenderer();
        this.sortIcon = new ResourceProvider().getIcon(ResourceProvider.SORT);
        this.getTableHeader().setDefaultRenderer(this);
        this.getTableHeader().setToolTipText(applContext.getLanguageManager().getText("SortedTableColumn.TIP"));
        this.sortedColumn = this.getModel().getColumn(0);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = UjoTable.this.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                int n2 = UjoTable.this.convertColumnIndexToModel(n);
                UjoTable.this.sortedColumn = UjoTable.this.getModel().getColumn(n2);
                if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1 && UjoTable.this.isEnabled()) {
                    int n3 = UjoTable.this.getSelectedRow();
                    Ujo ujo = UjoTable.this.getRowSelectionAllowed() && n3 >= 0 ? (Ujo)UjoTable.this.getModel().getRow(n3) : null;
                    UjoTable.this.getModel().sort(UjoTable.this.sortedColumn);
                    if (ujo != null) {
                        UjoTable.this.selectRow(ujo);
                    }
                    UjoTable.this.getTableHeader().repaint();
                }
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.superRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setHorizontalTextPosition(10);
            int n3 = jTable.convertColumnIndexToModel(n2);
            UjoProperty ujoProperty = ((UjoTable)jTable).getModel().getColumn(n3);
            jLabel.setIcon(ujoProperty == this.sortedColumn ? this.sortIcon : null);
        }
        return component;
    }

    public void showSortedColumn(UjoProperty ujoProperty) {
        this.sortedColumn = ujoProperty;
        this.getTableHeader().repaint();
    }

    public void showSortedColumn(String string) {
        UjoProperty ujoProperty = this.getColumn(Math.max(0, this.getModel().findColumn(string)));
        this.showSortedColumn(ujoProperty);
    }

    public UjoProperty getSortedColumn() {
        return this.sortedColumn;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 1001) {
            this.selectRow(tableModelEvent.getFirstRow());
        } else {
            super.tableChanged(tableModelEvent);
        }
    }
}

