/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.bo;

import java.util.ArrayList;
import net.ponec.jworksheet.bo.TaskType;
import net.ponec.jworksheet.core.ApplTools;
import org.ujoframework.UjoProperty;
import org.ujoframework.extensions.ListProperty;
import org.ujoframework.implementation.map.MapUjo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends MapUjo
implements Comparable {
    public static final UjoProperty<Project, Integer> P_ID = Project.newProperty("ID", Integer.valueOf(0));
    public static final UjoProperty<Project, Boolean> P_DEFAULT = Project.newProperty("Default", false);
    public static final UjoProperty<Project, Boolean> P_FINISHED = Project.newProperty("Finished", false);
    public static final UjoProperty<Project, Boolean> P_PRIVATE = Project.newProperty("Private", false);
    public static final UjoProperty<Project, String> P_DESCR = Project.newProperty("Description", "");
    public static final ListProperty<Project, TaskType> P_TASKS = Project.newPropertyList("Task", TaskType.class);
    public static final UjoProperty[] TABLE_COLUMNS = new UjoProperty[]{P_ID, P_DEFAULT, P_FINISHED, P_PRIVATE, P_DESCR};

    @Override
    public String toString() {
        String string = P_DESCR.of(this);
        return ApplTools.isValid(string) ? string : String.valueOf(P_ID.of(this));
    }

    public TaskType findTaskType(Integer n) {
        for (TaskType taskType : P_TASKS.getList(this)) {
            if (!TaskType.P_ID.equals(taskType, n)) continue;
            return taskType;
        }
        return null;
    }

    public TaskType findDefaultTask() {
        for (TaskType taskType : P_TASKS.getList(this)) {
            if (!TaskType.P_DEFAULT.of(taskType).booleanValue() || TaskType.P_FINISHED.of(taskType).booleanValue()) continue;
            return taskType;
        }
        return null;
    }

    public ArrayList<TaskType> getOpenTasks() {
        ArrayList<TaskType> arrayList = new ArrayList<TaskType>(P_TASKS.getItemCount(this));
        for (TaskType taskType : P_TASKS.getList(this)) {
            if (TaskType.P_FINISHED.of(taskType).booleanValue()) continue;
            arrayList.add(taskType);
        }
        return arrayList;
    }

    public int compareTo(Object object) {
        int n;
        int n2 = P_ID.of(this);
        int n3 = n = object != null ? P_ID.of((Project)object) : Integer.MAX_VALUE;
        int n4 = n2 < n ? -1 : (n2 > n ? 1 : 0);
        return n4;
    }
}

