/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.CompletionWindow;
import org.cesilko.rachota.gui.Tools;

public class TaskDialog
extends JDialog {
    private Task task;
    private Day day;
    private boolean readOnly;
    private JButton btCancel;
    private JButton btOK;
    private JCheckBox chbAutoStart;
    private JCheckBox chbNotification;
    private JCheckBox chbPrivate;
    private JCheckBox chbRegular;
    private JCheckBox chbStartTask;
    private JComboBox cmbPriority;
    private JComboBox cmbRepetition;
    private JLabel lblCategory;
    private JLabel lblColon;
    private JLabel lblDescription;
    private JLabel lblNotes;
    private JLabel lblPriority;
    private JPanel pnButtons;
    private JSpinner spHours;
    private JSpinner spMinutes;
    private JScrollPane spNotes;
    private JTextArea taNotes;
    private JTextField txtCategory;
    private JTextField txtDescription;

    public TaskDialog(Task task, Day day, boolean readOnly) {
        this.task = task;
        this.day = day;
        this.readOnly = readOnly;
        this.initComponents();
        this.txtDescription.setText(task.getDescription());
        this.txtCategory.setText(task.getKeyword());
        this.taNotes.setText(task.getNotes());
        this.cmbPriority.setSelectedIndex(task.getPriority());
        Date notificationTime = task.getNotificationTime();
        boolean notification = notificationTime != null;
        this.chbNotification.setSelected(notification);
        this.spHours.setEnabled(notification);
        this.lblColon.setEnabled(notification);
        this.spMinutes.setEnabled(notification);
        if (notification) {
            Calendar time = Calendar.getInstance();
            time.setTime(notificationTime);
            this.spHours.setValue(new Integer(time.get(11)));
            this.spMinutes.setValue(new Integer(time.get(12)));
        }
        this.chbAutoStart.setEnabled(notification);
        this.chbAutoStart.setSelected(task.automaticStart());
        boolean regular = task instanceof RegularTask;
        this.chbRegular.setSelected(regular);
        this.cmbRepetition.setEnabled(false);
        this.chbRegular.setEnabled(task == null);
        if (regular) {
            RegularTask regularTask = (RegularTask)task;
            this.cmbRepetition.setSelectedIndex(regularTask.getFrequency());
        }
        this.chbPrivate.setSelected(task.privateTask());
        if (readOnly) {
            this.txtDescription.setEditable(false);
            this.txtCategory.setEditable(false);
            this.taNotes.setEditable(false);
            this.chbPrivate.setEnabled(false);
            this.chbNotification.setEnabled(false);
            this.chbAutoStart.setEnabled(false);
            this.cmbPriority.setEnabled(false);
            this.spHours.setEnabled(false);
            this.spMinutes.setEnabled(false);
        }
        Dimension size = this.spHours.getPreferredSize();
        this.spHours.setPreferredSize(new Dimension((int)(size.getWidth() * 1.5), (int)size.getHeight()));
        this.spMinutes.setPreferredSize(new Dimension((int)(size.getWidth() * 1.5), (int)size.getHeight()));
        this.pack();
    }

    public TaskDialog(Day day) {
        this.task = null;
        this.day = day;
        this.initComponents();
        this.chbRegular.setEnabled(false);
        this.cmbRepetition.setEnabled(false);
        this.chbStartTask.setEnabled(Plan.getDefault().isToday(day));
        this.chbStartTask.setSelected((Boolean)Settings.getDefault().getSetting("startTask"));
    }

    public TaskDialog(RegularTask regularTask) {
        this(regularTask, null, false);
        this.chbRegular.setSelected(true);
        this.chbRegular.setEnabled(false);
        this.cmbRepetition.setEnabled(true);
    }

    public TaskDialog() {
        this.task = null;
        this.day = null;
        this.initComponents();
        this.chbRegular.setSelected(true);
        this.chbRegular.setEnabled(false);
        this.cmbRepetition.setEnabled(true);
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        int i;
        this.lblDescription = new JLabel();
        this.txtDescription = new JTextField();
        this.lblCategory = new JLabel();
        this.txtCategory = new JTextField();
        this.lblNotes = new JLabel();
        this.spNotes = new JScrollPane();
        this.taNotes = new JTextArea();
        this.lblPriority = new JLabel();
        this.cmbPriority = new JComboBox();
        this.chbNotification = new JCheckBox();
        this.spHours = new JSpinner();
        this.lblColon = new JLabel();
        this.spMinutes = new JSpinner();
        this.chbAutoStart = new JCheckBox();
        this.chbRegular = new JCheckBox();
        this.cmbRepetition = new JComboBox();
        this.chbPrivate = new JCheckBox();
        this.chbStartTask = new JCheckBox();
        this.pnButtons = new JPanel();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.setTitle(Translator.getTranslation("TASKDIALOG.TITLE"));
        this.setModal(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                TaskDialog.this.formMouseEntered(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TaskDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblDescription.setDisplayedMnemonic(Translator.getMnemonic("TASKDIALOG.LBL_DESCRIPTION"));
        this.lblDescription.setFont(this.getFont());
        this.lblDescription.setLabelFor(this.txtDescription);
        this.lblDescription.setText(Translator.getTranslation("TASKDIALOG.LBL_DESCRIPTION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblDescription, gridBagConstraints);
        this.txtDescription.setFont(this.getFont());
        this.txtDescription.setToolTipText(Translator.getTranslation("TASKDIALOG.TXT_DESCRIPTION_TOOLTIP"));
        this.txtDescription.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.txtDescriptionKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtDescription, gridBagConstraints);
        this.lblCategory.setDisplayedMnemonic(Translator.getMnemonic("TASKDIALOG.LBL_CATEGORY"));
        this.lblCategory.setFont(this.getFont());
        this.lblCategory.setLabelFor(this.txtCategory);
        this.lblCategory.setText(Translator.getTranslation("TASKDIALOG.LBL_CATEGORY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblCategory, gridBagConstraints);
        this.txtCategory.setFont(this.getFont());
        this.txtCategory.setToolTipText(Translator.getTranslation("TASKDIALOG.TXT_CATEGORY_TOOLTIP"));
        this.txtCategory.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TaskDialog.this.txtCategoryFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TaskDialog.this.txtCategoryFocusLost(evt);
            }
        });
        this.txtCategory.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.txtCategoryKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                TaskDialog.this.txtCategoryKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtCategory, gridBagConstraints);
        this.lblNotes.setDisplayedMnemonic(Translator.getMnemonic("TASKDIALOG.LBL_NOTES"));
        this.lblNotes.setFont(this.getFont());
        this.lblNotes.setLabelFor(this.taNotes);
        this.lblNotes.setText(Translator.getTranslation("TASKDIALOG.LBL_NOTES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblNotes, gridBagConstraints);
        this.taNotes.setFont(this.getFont());
        this.taNotes.setRows(3);
        this.taNotes.setToolTipText(Translator.getTranslation("TASKDIALOG.TXT_NOTES_TOOLTIP"));
        this.taNotes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.taNotesKeyPressed(evt);
            }
        });
        this.spNotes.setViewportView(this.taNotes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spNotes, gridBagConstraints);
        this.lblPriority.setDisplayedMnemonic(Translator.getMnemonic("TASKDIALOG.LBL_PRIORITY"));
        this.lblPriority.setFont(this.getFont());
        this.lblPriority.setLabelFor(this.cmbPriority);
        this.lblPriority.setText(Translator.getTranslation("TASKDIALOG.LBL_PRIORITY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblPriority, gridBagConstraints);
        this.cmbPriority.setFont(this.getFont());
        for (i = Task.PRIORITY_HIGH; i <= Task.PRIORITY_LOW; ++i) {
            this.cmbPriority.addItem(Task.getPriority(i));
        }
        this.cmbPriority.setSelectedIndex(Task.PRIORITY_MEDIUM);
        this.cmbPriority.setToolTipText(Translator.getTranslation("TASKDIALOG.CMB_PRIORITY_TOOLTIP"));
        this.cmbPriority.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.cmbPriorityKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmbPriority, gridBagConstraints);
        this.chbNotification.setFont(this.getFont());
        this.chbNotification.setMnemonic(Translator.getMnemonic("TASKDIALOG.CHB_NOTIFICATION"));
        this.chbNotificationChanged(null);
        this.chbNotification.setText(Translator.getTranslation("TASKDIALOG.CHB_NOTIFICATION"));
        this.chbNotification.setToolTipText(Translator.getTranslation("TASKDIALOG.CHB_NOTIFICATION_TOOLTIP"));
        this.chbNotification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskDialog.this.chbNotificationChanged(evt);
            }
        });
        this.chbNotification.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.chbNotificationKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.chbNotification, gridBagConstraints);
        this.spHours.setFont(this.getFont());
        this.spHours.setToolTipText(Translator.getTranslation("TASKDIALOG.JSP_HOURS_TOOLTIP"));
        this.spHours.setMinimumSize(new Dimension(40, 20));
        this.spHours.setPreferredSize(new Dimension(40, 20));
        this.spHours.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TaskDialog.this.spHoursStateChanged(evt);
            }
        });
        this.spHours.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.spHoursKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spHours, gridBagConstraints);
        this.lblColon.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.lblColon, gridBagConstraints);
        this.spMinutes.setFont(this.getFont());
        this.spMinutes.setToolTipText(Translator.getTranslation("TASKDIALOG.JSP_MINUTES_TOOLTIP"));
        this.spMinutes.setMinimumSize(new Dimension(40, 20));
        this.spMinutes.setPreferredSize(new Dimension(40, 20));
        this.spMinutes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TaskDialog.this.spMinutesStateChanged(evt);
            }
        });
        this.spMinutes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.spMinutesKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spMinutes, gridBagConstraints);
        this.chbAutoStart.setFont(this.getFont());
        this.chbAutoStart.setMnemonic(Translator.getMnemonic("TASKDIALOG.CHB_AUTOSTART"));
        this.chbAutoStart.setText(Translator.getTranslation("TASKDIALOG.CHB_AUTOSTART"));
        this.chbAutoStart.setToolTipText(Translator.getTranslation("TASKDIALOG.CHB_AUTOSTART_TOOLTIP"));
        this.chbAutoStart.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.chbAutoStartKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.chbAutoStart, gridBagConstraints);
        this.chbRegular.setFont(this.getFont());
        this.chbRegular.setText(Translator.getTranslation("TASKDIALOG.CHB_REGULAR"));
        this.chbRegular.setToolTipText(Translator.getTranslation("TASKDIALOG.CHB_REGULAR_TOOLTIP"));
        this.chbRegular.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.chbRegularKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.chbRegular, gridBagConstraints);
        this.cmbRepetition.setFont(this.getFont());
        for (i = RegularTask.FREQUENCY_DAILY; i <= RegularTask.FREQUENCY_WEEKEND; ++i) {
            this.cmbRepetition.addItem(RegularTask.getFrequency(i));
        }
        this.cmbRepetition.setSelectedIndex(RegularTask.FREQUENCY_DAILY);
        this.cmbRepetition.setToolTipText(Translator.getTranslation("TASKDIALOG.CMB_REPETITION_TOOLTIP"));
        this.cmbRepetition.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.cmbRepetitionKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmbRepetition, gridBagConstraints);
        this.chbPrivate.setFont(this.getFont());
        this.chbPrivate.setMnemonic(Translator.getMnemonic("TASKDIALOG.CHB_PRIVATE"));
        this.chbPrivate.setText(Translator.getTranslation("TASKDIALOG.CHB_PRIVATE"));
        this.chbPrivate.setToolTipText(Translator.getTranslation("TASKDIALOG.CHB_PRIVATE_TOOLTIP"));
        this.chbPrivate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.chbPrivateKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.chbPrivate, gridBagConstraints);
        this.chbStartTask.setFont(this.getFont());
        this.chbStartTask.setMnemonic(Translator.getMnemonic("TASKDIALOG.CHB_START_TASK"));
        this.chbStartTask.setText(Translator.getTranslation("TASKDIALOG.CHB_START_TASK"));
        this.chbStartTask.setToolTipText(Translator.getTranslation("TASKDIALOG.CHB_START_TASK_TOOLTIP"));
        this.chbStartTask.setEnabled(false);
        this.chbStartTask.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TaskDialog.this.chbStartTaskKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.chbStartTask, gridBagConstraints);
        this.btOK.setFont(this.getFont());
        this.btOK.setMnemonic(Translator.getMnemonic("TASKDIALOG.BT_OK_NAME"));
        this.btOK.setText(Translator.getTranslation("TASKDIALOG.BT_OK_NAME"));
        this.btOK.setToolTipText(Translator.getTranslation("TASKDIALOG.BT_OK_TOOLTIP"));
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskDialog.this.btOKActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btOK);
        this.btCancel.setFont(this.getFont());
        this.btCancel.setMnemonic(Translator.getMnemonic("TASKDIALOG.BT_CANCEL_NAME"));
        this.btCancel.setText(Translator.getTranslation("TASKDIALOG.BT_CANCEL_NAME"));
        this.btCancel.setToolTipText(Translator.getTranslation("TASKDIALOG.BT_CANCEL_TOOLTIP"));
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskDialog.this.btCancelActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnButtons, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 419) / 2, (screenSize.height - 428) / 2, 419, 428);
    }

    private void chbPrivateKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void cmbRepetitionKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbRegularKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbAutoStartKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void spMinutesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void spHoursKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbNotificationKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void cmbPriorityKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void taNotesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && evt.isControlDown()) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtCategoryKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtDescriptionKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtCategoryFocusLost(FocusEvent evt) {
        this.txtCategory.setToolTipText(Translator.getTranslation("TASKDIALOG.TXT_CATEGORY_TOOLTIP"));
    }

    private void txtCategoryFocusGained(FocusEvent evt) {
        if (this.txtCategory.getText().equals("")) {
            int modifier = System.getProperty("os.name").indexOf("Windows") != -1 ? 2 : 1;
            this.txtCategory.setToolTipText(Translator.getTranslation("TASKDIALOG.COMPLETION_HINT", new String[]{KeyEvent.getKeyModifiersText(modifier)}));
            ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this.txtCategory, 0, 0L, 0, 0, 0, 0, false));
        }
    }

    private void txtCategoryKeyTyped(KeyEvent evt) {
        int modifier;
        int n = System.getProperty("os.name").indexOf("Windows") != -1 ? 2 : (modifier = 1);
        if (evt.getModifiers() == modifier & evt.getKeyChar() == ' ') {
            evt.consume();
            new CompletionWindow(this.txtCategory, Plan.getDefault().getCategories(), this).setVisible(true);
        }
    }

    private void btOKActionPerformed(ActionEvent evt) {
        RegularTask regularTask;
        String description;
        if (this.readOnly) {
            this.closeDialog(null);
        }
        if ((description = this.txtDescription.getText()).equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, Translator.getTranslation("ERROR.MISSING_DESCRIPTION"), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
            return;
        }
        if (this.day != null) {
            boolean error = false;
            if (this.day.getTask(description) != null) {
                if (this.task == null) {
                    error = true;
                } else if (!this.task.getDescription().equals(description)) {
                    error = true;
                }
            }
            if (error) {
                JOptionPane.showMessageDialog(this, Translator.getTranslation("ERROR.TASK_EXISTS"), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
                return;
            }
        }
        String keyword = this.txtCategory.getText();
        String notes = this.taNotes.getText();
        int priority = this.cmbPriority.getSelectedIndex();
        int state = Task.STATE_NEW;
        long duration = 0L;
        Date notificationTime = null;
        boolean automaticStart = false;
        boolean privateTask = this.chbPrivate.isSelected();
        if (this.chbNotification.isSelected()) {
            Integer hours = (Integer)this.spHours.getValue();
            Integer minutes = (Integer)this.spMinutes.getValue();
            Calendar time = Calendar.getInstance();
            time.set(11, hours);
            time.set(12, minutes);
            notificationTime = time.getTime();
            automaticStart = this.chbAutoStart.isSelected();
        }
        if (this.task != null) {
            this.task.setDescription(description);
            this.task.setKeyword(keyword);
            this.task.setNotes(notes);
            this.task.setPriority(priority);
            this.task.setNotificationTime(notificationTime);
            this.task.setAutomaticStart(automaticStart);
            this.task.setPrivateTask(privateTask);
            if (this.task instanceof RegularTask) {
                regularTask = (RegularTask)this.task;
                regularTask.setFrequency(this.cmbRepetition.getSelectedIndex());
            }
            this.firePropertyChange("task_changed", null, this.task);
        } else {
            if (this.chbRegular.isSelected()) {
                regularTask = new RegularTask(description, keyword, notes, priority, state, duration, notificationTime, automaticStart, privateTask, this.cmbRepetition.getSelectedIndex());
                this.task = regularTask;
            } else {
                this.task = new Task(description, keyword, notes, priority, state, duration, notificationTime, automaticStart, privateTask);
                Boolean logTaskEvents = (Boolean)Settings.getDefault().getSetting("logTaskEvents");
                if (logTaskEvents.booleanValue()) {
                    if (Plan.getDefault().isToday(this.day)) {
                        this.task.addNote("created", true);
                    } else {
                        this.task.setNotes("[" + Plan.getDefault().getDay(new Date()).toString() + " " + Tools.getTime(new Date()) + "] created");
                    }
                }
                if (Plan.getDefault().isToday(this.day)) {
                    System.setProperty("startTaskNow", "" + this.chbStartTask.isSelected());
                    Settings.getDefault().setSetting("startTask", this.chbStartTask.isSelected());
                }
                this.day.addTask(this.task);
            }
            this.firePropertyChange("task_created", null, this.task);
        }
        this.closeDialog(null);
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.firePropertyChange("task_unchanged", this.task, null);
        this.closeDialog(null);
    }

    private void spMinutesStateChanged(ChangeEvent evt) {
        Integer value = (Integer)this.spMinutes.getValue();
        if (value > 59) {
            this.spMinutes.setValue(new Integer(59));
        }
        if (value < 0) {
            this.spMinutes.setValue(new Integer(0));
        }
    }

    private void spHoursStateChanged(ChangeEvent evt) {
        Integer value = (Integer)this.spHours.getValue();
        if (value > 23) {
            this.spHours.setValue(new Integer(23));
        }
        if (value < 0) {
            this.spHours.setValue(new Integer(0));
        }
    }

    private void chbNotificationChanged(ActionEvent evt) {
        boolean value = this.chbNotification.isSelected();
        this.spHours.setEnabled(value);
        this.lblColon.setEnabled(value);
        this.spMinutes.setEnabled(value);
        this.chbAutoStart.setEnabled(value);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    private void chbStartTaskKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void formMouseEntered(MouseEvent evt) {
        Tools.recordActivity();
    }

    public Task getTask() {
        return this.task;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.txtCategory.requestFocusInWindow();
    }
}

