/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.GenericWizard;
import org.cesilko.rachota.gui.ReportWizard;
import org.cesilko.rachota.gui.Tools;
import org.cesilko.rachota.gui.WizardStep;

public class ReportContentWizardStep
extends WizardStep {
    private JCheckBox cbDuration;
    private JCheckBox cbFilters;
    private JCheckBox cbNotes;
    private JCheckBox cbOccurrences;
    private JCheckBox cbProjectsTasks;
    private JCheckBox cbTimesChart;
    private JComboBox cmbSortBy;
    private JLabel lbCurrency;
    private JLabel lbCustomerDetails;
    private JLabel lbDueDate;
    private JLabel lbDueDays;
    private JLabel lbInvoiceInclude;
    private JLabel lbInvoiceTitle;
    private JLabel lbPaymentDetails;
    private JLabel lbPrice;
    private JLabel lbReportInclude;
    private JLabel lbReportTitle;
    private JLabel lbRows;
    private JLabel lbShow;
    private JLabel lbSortBy;
    private JLabel lbTax;
    private JLabel lbTaxPercentage;
    private JLabel lbYourDetails;
    private JPanel pnInvoice;
    private JPanel pnReport;
    private JRadioButton rbInvoiceProjectsTasks;
    private JRadioButton rbInvoiceTasks;
    private JRadioButton rbReportProjects;
    private JRadioButton rbReportTasks;
    private JScrollPane spCustomerDetails;
    private JSpinner spDueDate;
    private JScrollPane spPaymentDetails;
    private JScrollPane spYourDetails;
    private JTextArea taCustomerDetails;
    private JTextArea taPaymentDetails;
    private JTextArea taYourDetails;
    private JTextField txCurrency;
    private JTextField txInvoiceTitle;
    private JTextField txPrice;
    private JTextField txReportTitle;
    private JTextField txTax;
    private Integer previousDueDays = new Integer(14);
    private Vector sortBy = new Vector();

    public ReportContentWizardStep(GenericWizard wizard) {
        super(wizard, Translator.getTranslation("REPORTWIZARD.STEP_CONTENT"));
        this.initComponents();
        this.pnInvoice.setVisible(false);
        this.cbDurationActionPerformed(null);
        String outputFormat = (String)ReportWizard.getWizardProperty("report.output.format_selected");
        this.cbTimesChart.setEnabled(".html".equals(outputFormat));
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        this.pnReport = new JPanel();
        this.lbReportTitle = new JLabel();
        this.txReportTitle = new JTextField();
        this.lbShow = new JLabel();
        this.cbTimesChart = new JCheckBox();
        this.cbFilters = new JCheckBox();
        this.lbRows = new JLabel();
        this.rbReportTasks = new JRadioButton();
        this.rbReportProjects = new JRadioButton();
        this.lbReportInclude = new JLabel();
        this.cbDuration = new JCheckBox();
        this.cbOccurrences = new JCheckBox();
        this.cbProjectsTasks = new JCheckBox();
        this.cbNotes = new JCheckBox();
        this.lbSortBy = new JLabel();
        this.cmbSortBy = new JComboBox();
        this.pnInvoice = new JPanel();
        this.lbInvoiceTitle = new JLabel();
        this.txInvoiceTitle = new JTextField();
        this.lbDueDate = new JLabel();
        this.spDueDate = new JSpinner();
        this.lbDueDays = new JLabel();
        this.lbPrice = new JLabel();
        this.txPrice = new JTextField();
        this.lbCurrency = new JLabel();
        this.txCurrency = new JTextField();
        this.lbTax = new JLabel();
        this.txTax = new JTextField();
        this.lbTaxPercentage = new JLabel();
        this.lbInvoiceInclude = new JLabel();
        this.rbInvoiceProjectsTasks = new JRadioButton();
        this.rbInvoiceTasks = new JRadioButton();
        this.lbCustomerDetails = new JLabel();
        this.spCustomerDetails = new JScrollPane();
        this.taCustomerDetails = new JTextArea();
        this.lbYourDetails = new JLabel();
        this.spYourDetails = new JScrollPane();
        this.taYourDetails = new JTextArea();
        this.lbPaymentDetails = new JLabel();
        this.spPaymentDetails = new JScrollPane();
        this.taPaymentDetails = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.pnReport.setLayout(new GridBagLayout());
        this.lbReportTitle.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_REPORT_TITLE"));
        this.lbReportTitle.setFont(this.getFont());
        this.lbReportTitle.setLabelFor(this.txReportTitle);
        this.lbReportTitle.setText(Translator.getTranslation("REPORTWIZARD.LB_REPORT_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.lbReportTitle, gridBagConstraints);
        this.txReportTitle.setFont(this.getFont());
        this.txReportTitle.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_REPORT_TITLE_TOOLTIP"));
        this.txReportTitle.setPreferredSize(new Dimension(150, 27));
        this.txReportTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.txReportTitle, gridBagConstraints);
        this.lbShow.setFont(this.getFont());
        this.lbShow.setLabelFor(this.cbTimesChart);
        this.lbShow.setText(Translator.getTranslation("REPORTWIZARD.LB_SHOW"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.lbShow, gridBagConstraints);
        this.cbTimesChart.setFont(this.getFont());
        this.cbTimesChart.setMnemonic(Translator.getMnemonic("REPORTWIZARD.CB_TIMES_CHART"));
        this.cbTimesChart.setSelected(true);
        this.cbTimesChart.setText(Translator.getTranslation("REPORTWIZARD.CB_TIMES_CHART"));
        this.cbTimesChart.setToolTipText(Translator.getTranslation("REPORTWIZARD.CB_TIMES_CHART_TOOLTIP"));
        this.cbTimesChart.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.cbTimesChart, gridBagConstraints);
        this.cbFilters.setFont(this.getFont());
        this.cbFilters.setMnemonic(Translator.getMnemonic("REPORTWIZARD.CB_FILTERS"));
        this.cbFilters.setText(Translator.getTranslation("REPORTWIZARD.CB_FILTERS"));
        this.cbFilters.setToolTipText(Translator.getTranslation("REPORTWIZARD.CB_FILTERS_TOOLTIP"));
        this.cbFilters.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.cbFilters, gridBagConstraints);
        this.lbRows.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_ROWS"));
        this.lbRows.setFont(this.getFont());
        this.lbRows.setLabelFor(this.rbReportTasks);
        this.lbRows.setText(Translator.getTranslation("REPORTWIZARD.LB_ROWS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.lbRows, gridBagConstraints);
        this.rbReportTasks.setFont(this.getFont());
        this.rbReportTasks.setMnemonic(Translator.getMnemonic("REPORTWIZARD.RB_TASKS"));
        this.rbReportTasks.setSelected(true);
        this.rbReportTasks.setText(Translator.getTranslation("REPORTWIZARD.RB_TASKS"));
        this.rbReportTasks.setToolTipText(Translator.getTranslation("REPORTWIZARD.RB_TASKS_TOOLTIP"));
        this.rbReportTasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportContentWizardStep.this.rbReportTasksActionPerformed(evt);
            }
        });
        this.rbReportTasks.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.rbReportTasks, gridBagConstraints);
        this.rbReportProjects.setFont(this.getFont());
        this.rbReportProjects.setMnemonic(Translator.getMnemonic("REPORTWIZARD.RB_PROJECTS"));
        this.rbReportProjects.setText(Translator.getTranslation("REPORTWIZARD.RB_PROJECTS"));
        this.rbReportProjects.setToolTipText(Translator.getTranslation("REPORTWIZARD.RB_PROJECTS_TOOLTIP"));
        this.rbReportProjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportContentWizardStep.this.rbReportProjectsActionPerformed(evt);
            }
        });
        this.rbReportProjects.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.rbReportProjects, gridBagConstraints);
        this.lbReportInclude.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_INCLUDE"));
        this.lbReportInclude.setFont(this.getFont());
        this.lbReportInclude.setLabelFor(this.cbDuration);
        this.lbReportInclude.setText(Translator.getTranslation("REPORTWIZARD.LB_INCLUDE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.lbReportInclude, gridBagConstraints);
        this.cbDuration.setFont(this.getFont());
        this.cbDuration.setMnemonic(Translator.getMnemonic("REPORTWIZARD.CB_DURATION"));
        this.cbDuration.setSelected(true);
        this.cbDuration.setText(Translator.getTranslation("REPORTWIZARD.CB_DURATION"));
        this.cbDuration.setToolTipText(Translator.getTranslation("REPORTWIZARD.CB_DURATION_TOOLTIP"));
        this.cbDuration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportContentWizardStep.this.cbDurationActionPerformed(evt);
            }
        });
        this.cbDuration.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.cbDuration, gridBagConstraints);
        this.cbOccurrences.setFont(this.getFont());
        this.cbOccurrences.setMnemonic(Translator.getMnemonic("REPORTWIZARD.CB_OCCURRENCES"));
        this.cbOccurrences.setText(Translator.getTranslation("REPORTWIZARD.CB_OCCURRENCES"));
        this.cbOccurrences.setToolTipText(Translator.getTranslation("REPORTWIZARD.CB_OCCURRENCES_TOOLTIP"));
        this.cbOccurrences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportContentWizardStep.this.cbOccurrencesActionPerformed(evt);
            }
        });
        this.cbOccurrences.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.cbOccurrences, gridBagConstraints);
        this.cbProjectsTasks.setFont(this.getFont());
        this.cbProjectsTasks.setMnemonic(Translator.getMnemonic("REPORTWIZARD.CB_PROJECTS_TASKS"));
        this.cbProjectsTasks.setText(Translator.getTranslation("REPORTWIZARD.CB_PROJECTS_TASKS"));
        this.cbProjectsTasks.setToolTipText(Translator.getTranslation("REPORTWIZARD.CB_PROJECTS_TASKS_TOOLTIP"));
        this.cbProjectsTasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportContentWizardStep.this.cbProjectsTasksActionPerformed(evt);
            }
        });
        this.cbProjectsTasks.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.cbProjectsTasks, gridBagConstraints);
        this.cbNotes.setFont(this.getFont());
        this.cbNotes.setMnemonic(Translator.getMnemonic("REPORTWIZARD.CB_NOTES"));
        this.cbNotes.setText(Translator.getTranslation("REPORTWIZARD.CB_NOTES"));
        this.cbNotes.setToolTipText(Translator.getTranslation("REPORTWIZARD.CB_NOTES_TOOLTIP"));
        this.cbNotes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportContentWizardStep.this.cbNotesActionPerformed(evt);
            }
        });
        this.cbNotes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.cbNotes, gridBagConstraints);
        this.lbSortBy.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_SORTBY"));
        this.lbSortBy.setFont(this.getFont());
        this.lbSortBy.setLabelFor(this.cmbSortBy);
        this.lbSortBy.setText(Translator.getTranslation("REPORTWIZARD.LB_SORTBY"));
        this.lbSortBy.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_SORTBY_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.lbSortBy, gridBagConstraints);
        this.cmbSortBy.setFont(this.getFont());
        this.cmbSortBy.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnReport.add((Component)this.cmbSortBy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnReport, gridBagConstraints);
        this.pnInvoice.setLayout(new GridBagLayout());
        this.lbInvoiceTitle.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_INVOICE_TITLE"));
        this.lbInvoiceTitle.setFont(this.getFont());
        this.lbInvoiceTitle.setLabelFor(this.txInvoiceTitle);
        this.lbInvoiceTitle.setText(Translator.getTranslation("REPORTWIZARD.LB_INVOICE_TITLE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbInvoiceTitle, gridBagConstraints);
        this.txInvoiceTitle.setFont(this.getFont());
        this.txInvoiceTitle.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_INVOICE_TITLE_TOOLTIP"));
        this.txInvoiceTitle.setPreferredSize(new Dimension(150, 27));
        this.txInvoiceTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.txInvoiceTitle, gridBagConstraints);
        this.lbDueDate.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_DUEDATE"));
        this.lbDueDate.setFont(this.getFont());
        this.lbDueDate.setLabelFor(this.spDueDate);
        this.lbDueDate.setText(Translator.getTranslation("REPORTWIZARD.LB_DUEDATE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbDueDate, gridBagConstraints);
        this.spDueDate.setFont(this.getFont());
        this.spDueDate.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_DUEDATE_TOOLTIP"));
        this.spDueDate.setValue(new Integer(14));
        this.spDueDate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReportContentWizardStep.this.spDueDateStateChanged(evt);
            }
        });
        this.spDueDate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.spDueDate, gridBagConstraints);
        this.lbDueDays.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_DUEDAYS"));
        this.lbDueDays.setFont(this.getFont());
        this.lbDueDays.setText(Translator.getTranslation("REPORTWIZARD.LB_DUEDAYS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbDueDays, gridBagConstraints);
        this.lbPrice.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_PRICE"));
        this.lbPrice.setFont(this.getFont());
        this.lbPrice.setLabelFor(this.txPrice);
        this.lbPrice.setText(Translator.getTranslation("REPORTWIZARD.LB_PRICE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbPrice, gridBagConstraints);
        this.txPrice.setFont(this.getFont());
        this.txPrice.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_PRICE_TOOLTIP"));
        this.txPrice.setMinimumSize(new Dimension(50, 27));
        this.txPrice.setPreferredSize(new Dimension(50, 27));
        this.txPrice.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReportContentWizardStep.this.txPriceFocusLost(evt);
            }
        });
        this.txPrice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.txPrice, gridBagConstraints);
        this.lbCurrency.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_CURRENCY"));
        this.lbCurrency.setFont(this.getFont());
        this.lbCurrency.setLabelFor(this.txCurrency);
        this.lbCurrency.setText(Translator.getTranslation("REPORTWIZARD.LB_CURRENCY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbCurrency, gridBagConstraints);
        this.txCurrency.setFont(this.getFont());
        this.txCurrency.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_CURRENCY_TOOLTIP"));
        this.txCurrency.setMinimumSize(new Dimension(50, 27));
        this.txCurrency.setPreferredSize(new Dimension(50, 27));
        this.txCurrency.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReportContentWizardStep.this.txCurrencyFocusLost(evt);
            }
        });
        this.txCurrency.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.txCurrency, gridBagConstraints);
        this.lbTax.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_TAX"));
        this.lbTax.setFont(this.getFont());
        this.lbTax.setLabelFor(this.txTax);
        this.lbTax.setText(Translator.getTranslation("REPORTWIZARD.LB_TAX"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbTax, gridBagConstraints);
        this.txTax.setFont(this.getFont());
        this.txTax.setText("0");
        this.txTax.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_TAX_TOOLTIP"));
        this.txTax.setMinimumSize(new Dimension(50, 27));
        this.txTax.setPreferredSize(new Dimension(50, 27));
        this.txTax.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReportContentWizardStep.this.txTaxFocusLost(evt);
            }
        });
        this.txTax.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.txTax, gridBagConstraints);
        this.lbTaxPercentage.setFont(this.getFont());
        this.lbTaxPercentage.setText(Translator.getTranslation("REPORTWIZARD.LB_TAX_PERCENTAGE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbTaxPercentage, gridBagConstraints);
        this.lbInvoiceInclude.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_INCLUDE"));
        this.lbInvoiceInclude.setFont(this.getFont());
        this.lbInvoiceInclude.setLabelFor(this.rbInvoiceProjectsTasks);
        this.lbInvoiceInclude.setText(Translator.getTranslation("REPORTWIZARD.LB_INCLUDE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbInvoiceInclude, gridBagConstraints);
        this.rbInvoiceProjectsTasks.setFont(this.getFont());
        this.rbInvoiceProjectsTasks.setMnemonic(Translator.getMnemonic("REPORTWIZARD.RB_INVOICE_PROJECTS_TASKS"));
        this.rbInvoiceProjectsTasks.setSelected(true);
        this.rbInvoiceProjectsTasks.setText(Translator.getTranslation("REPORTWIZARD.RB_INVOICE_PROJECTS_TASKS"));
        this.rbInvoiceProjectsTasks.setToolTipText(Translator.getTranslation("REPORTWIZARD.RB_INVOICE_PROJECTS_TASKS_TOOLTIP"));
        this.rbInvoiceProjectsTasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportContentWizardStep.this.rbInvoiceProjectsTasksActionPerformed(evt);
            }
        });
        this.rbInvoiceProjectsTasks.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.rbInvoiceProjectsTasks, gridBagConstraints);
        this.rbInvoiceTasks.setMnemonic(Translator.getMnemonic("REPORTWIZARD.RB_INVOICE_TASKS"));
        this.rbInvoiceTasks.setFont(this.getFont());
        this.rbInvoiceTasks.setText(Translator.getTranslation("REPORTWIZARD.RB_INVOICE_TASKS"));
        this.rbInvoiceTasks.setToolTipText(Translator.getTranslation("REPORTWIZARD.RB_INVOICE_TASKS_TOOLTIP"));
        this.rbInvoiceTasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportContentWizardStep.this.rbInvoiceTasksActionPerformed(evt);
            }
        });
        this.rbInvoiceTasks.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReportContentWizardStep.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.rbInvoiceTasks, gridBagConstraints);
        this.lbCustomerDetails.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_CUSTOMER_DETAILS"));
        this.lbCustomerDetails.setFont(this.getFont());
        this.lbCustomerDetails.setLabelFor(this.spCustomerDetails);
        this.lbCustomerDetails.setText(Translator.getTranslation("REPORTWIZARD.LB_CUSTOMER_DETAILS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbCustomerDetails, gridBagConstraints);
        this.taCustomerDetails.setColumns(20);
        this.taCustomerDetails.setRows(2);
        this.taCustomerDetails.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_CUSTOMER_DETAILS_TOOLTIP"));
        this.spCustomerDetails.setViewportView(this.taCustomerDetails);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.spCustomerDetails, gridBagConstraints);
        this.lbYourDetails.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_YOUR_DETAILS"));
        this.lbYourDetails.setFont(this.getFont());
        this.lbYourDetails.setLabelFor(this.spYourDetails);
        this.lbYourDetails.setText(Translator.getTranslation("REPORTWIZARD.LB_YOUR_DETAILS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbYourDetails, gridBagConstraints);
        this.taYourDetails.setColumns(20);
        this.taYourDetails.setRows(2);
        this.taYourDetails.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_YOUR_DETAILS_TOOLTIP"));
        this.spYourDetails.setViewportView(this.taYourDetails);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.spYourDetails, gridBagConstraints);
        this.lbPaymentDetails.setDisplayedMnemonic(Translator.getMnemonic("REPORTWIZARD.LB_PAYMENT_DETAILS"));
        this.lbPaymentDetails.setFont(this.getFont());
        this.lbPaymentDetails.setLabelFor(this.spPaymentDetails);
        this.lbPaymentDetails.setText(Translator.getTranslation("REPORTWIZARD.LB_PAYMENT_DETAILS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.lbPaymentDetails, gridBagConstraints);
        this.taPaymentDetails.setColumns(20);
        this.taPaymentDetails.setRows(2);
        this.taPaymentDetails.setToolTipText(Translator.getTranslation("REPORTWIZARD.LB_PAYMENT_DETAILS_TOOLTIP"));
        this.spPaymentDetails.setViewportView(this.taPaymentDetails);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInvoice.add((Component)this.spPaymentDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnInvoice, gridBagConstraints);
    }

    private void rbReportTasksActionPerformed(ActionEvent evt) {
        this.rbReportTasks.setSelected(true);
        this.rbReportProjects.setSelected(false);
        this.firePropertyChange("report.rows", null, "tasks");
    }

    private void rbReportProjectsActionPerformed(ActionEvent evt) {
        this.rbReportProjects.setSelected(true);
        this.rbReportTasks.setSelected(false);
        this.firePropertyChange("report.rows", null, "projects");
    }

    private void cbDurationActionPerformed(ActionEvent evt) {
        if (this.cbDuration.isSelected()) {
            this.sortBy.add("duration");
            this.cmbSortBy.addItem(Translator.getTranslation("REPORTWIZARD.CB_DURATION"));
            this.cmbSortBy.setEnabled(true);
        } else {
            this.sortBy.remove("duration");
            this.cmbSortBy.removeItem(Translator.getTranslation("REPORTWIZARD.CB_DURATION"));
            if (this.cmbSortBy.getItemCount() == 0) {
                this.cmbSortBy.setEnabled(false);
            }
        }
        this.firePropertyChange("report.content.duration", null, (Object)this.cbDuration.isSelected());
    }

    private void cbProjectsTasksActionPerformed(ActionEvent evt) {
        if (this.cbProjectsTasks.isSelected()) {
            this.sortBy.add("projects/tasks");
            this.cmbSortBy.addItem(Translator.getTranslation("REPORTWIZARD.CB_PROJECTS_TASKS"));
            this.cmbSortBy.setEnabled(true);
        } else {
            this.sortBy.remove("projects/tasks");
            this.cmbSortBy.removeItem(Translator.getTranslation("REPORTWIZARD.CB_PROJECTS_TASKS"));
            if (this.cmbSortBy.getItemCount() == 0) {
                this.cmbSortBy.setEnabled(false);
            }
        }
        this.firePropertyChange("report.content.projects_tasks", null, (Object)this.cbProjectsTasks.isSelected());
    }

    private void cbOccurrencesActionPerformed(ActionEvent evt) {
        if (this.cbOccurrences.isSelected()) {
            this.sortBy.add("occurrences");
            this.cmbSortBy.addItem(Translator.getTranslation("REPORTWIZARD.CB_OCCURRENCES"));
            this.cmbSortBy.setEnabled(true);
        } else {
            this.sortBy.remove("occurrences");
            this.cmbSortBy.removeItem(Translator.getTranslation("REPORTWIZARD.CB_OCCURRENCES"));
            if (this.cmbSortBy.getItemCount() == 0) {
                this.cmbSortBy.setEnabled(false);
            }
        }
        this.firePropertyChange("report.content.occurrences", null, (Object)this.cbOccurrences.isSelected());
    }

    private void cbNotesActionPerformed(ActionEvent evt) {
        if (this.cbNotes.isSelected()) {
            this.sortBy.add("notes");
            this.cmbSortBy.addItem(Translator.getTranslation("REPORTWIZARD.CB_NOTES"));
            this.cmbSortBy.setEnabled(true);
        } else {
            this.sortBy.remove("notes");
            this.cmbSortBy.removeItem(Translator.getTranslation("REPORTWIZARD.CB_NOTES"));
            if (this.cmbSortBy.getItemCount() == 0) {
                this.cmbSortBy.setEnabled(false);
            }
        }
        this.firePropertyChange("report.content.notes", null, (Object)this.cbNotes.isSelected());
    }

    private void rbInvoiceProjectsTasksActionPerformed(ActionEvent evt) {
        this.rbInvoiceTasks.setSelected(false);
        this.rbInvoiceProjectsTasks.setSelected(true);
        this.firePropertyChange("invoice.content", null, "projects_tasks");
    }

    private void rbInvoiceTasksActionPerformed(ActionEvent evt) {
        this.rbInvoiceTasks.setSelected(true);
        this.rbInvoiceProjectsTasks.setSelected(false);
        this.firePropertyChange("invoice.content", null, "tasks");
    }

    private void txCurrencyFocusLost(FocusEvent evt) {
        String currency = this.txCurrency.getText();
        this.firePropertyChange("invoice.currency", null, currency);
    }

    private void txTaxFocusLost(FocusEvent evt) {
        String tax = this.txTax.getText();
        this.firePropertyChange("invoice.tax", null, tax);
    }

    private void txPriceFocusLost(FocusEvent evt) {
        String price = this.txPrice.getText();
        this.firePropertyChange("invoice.price", null, price);
    }

    private void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.setProperties();
            this.firePropertyChange("wizard.step.next", null, this);
        }
        if (evt.getKeyCode() == 27) {
            this.firePropertyChange("wizard.cancel", null, null);
        }
    }

    private void spDueDateStateChanged(ChangeEvent evt) {
        Integer dueDays = (Integer)this.spDueDate.getValue();
        int value = dueDays;
        if (value < 0) {
            this.spDueDate.setValue(this.previousDueDays);
        } else {
            this.previousDueDays = dueDays;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("report.type")) {
            if (evt.getNewValue().equals("report")) {
                this.pnReport.setVisible(true);
                this.pnInvoice.setVisible(false);
            }
            if (evt.getNewValue().equals("invoice")) {
                this.pnInvoice.setVisible(true);
                this.pnReport.setVisible(false);
            }
        }
        if (evt.getPropertyName().equals("report.output.format_selected")) {
            this.cbTimesChart.setEnabled(".html".equals(evt.getNewValue()));
        }
        if (evt.getPropertyName().equals("wizard_finished")) {
            this.setProperties();
        }
    }

    @Override
    protected boolean isSetCorrectly() {
        if (this.pnReport.isShowing()) {
            this.firePropertyChange("status.error", null, null);
            return true;
        }
        if (this.txPrice == null) {
            this.firePropertyChange("status.error", null, Translator.getTranslation("REPORTWIZARD.STATUS_NO_PRICE"));
            return false;
        }
        String price = this.txPrice.getText();
        if (price.isEmpty()) {
            this.firePropertyChange("status.error", null, Translator.getTranslation("REPORTWIZARD.STATUS_NO_PRICE"));
            return false;
        }
        try {
            Float.parseFloat(price);
        }
        catch (NumberFormatException exception) {
            this.firePropertyChange("status.error", null, Translator.getTranslation("REPORTWIZARD.STATUS_PRICE_NOT_NUMBER"));
            return false;
        }
        if (this.txTax == null) {
            this.firePropertyChange("status.error", null, Translator.getTranslation("REPORTWIZARD.STATUS_NO_TAX"));
            return false;
        }
        String tax = this.txTax.getText();
        if (tax.isEmpty()) {
            this.firePropertyChange("status.error", null, Translator.getTranslation("REPORTWIZARD.STATUS_NO_TAX"));
            return false;
        }
        try {
            Float.parseFloat(tax);
        }
        catch (NumberFormatException exception) {
            this.firePropertyChange("status.error", null, Translator.getTranslation("REPORTWIZARD.STATUS_TAX_NOT_NUMBER"));
            return false;
        }
        this.firePropertyChange("status.error", null, null);
        return true;
    }

    @Override
    protected void setFocus() {
        if (this.pnInvoice.isVisible()) {
            this.txInvoiceTitle.requestFocus();
        } else {
            this.txReportTitle.requestFocus();
        }
    }

    private void setProperties() {
        if (this.pnReport.isVisible()) {
            this.firePropertyChange("report.title", null, this.txReportTitle.getText());
            this.firePropertyChange("report.chart", null, (Object)(this.cbTimesChart.isEnabled() & this.cbTimesChart.isSelected()));
            this.firePropertyChange("report.filters", null, (Object)this.cbFilters.isSelected());
            if (this.rbReportTasks.isSelected()) {
                this.firePropertyChange("report.rows", null, "tasks");
            } else {
                this.firePropertyChange("report.rows", null, "projects");
            }
            this.firePropertyChange("report.content.duration", null, (Object)this.cbDuration.isSelected());
            this.firePropertyChange("report.content.projects_tasks", null, (Object)this.cbProjectsTasks.isSelected());
            this.firePropertyChange("report.content.occurrences", null, (Object)this.cbOccurrences.isSelected());
            this.firePropertyChange("report.content.notes", null, (Object)this.cbNotes.isSelected());
            int selectedIndex = this.cmbSortBy.getSelectedIndex();
            this.firePropertyChange("report.sortby", null, selectedIndex == -1 ? null : this.sortBy.get(selectedIndex));
        } else {
            this.firePropertyChange("invoice.title", null, this.txInvoiceTitle.getText());
            this.firePropertyChange("invoice.details.user", null, this.taYourDetails.getText());
            this.firePropertyChange("invoice.details.customer", null, this.taCustomerDetails.getText());
            this.firePropertyChange("invoice.details.payment", null, this.taPaymentDetails.getText());
            this.firePropertyChange("invoice.due_days", null, this.spDueDate.getValue());
            this.firePropertyChange("invoice.price", null, this.txPrice.getText());
            this.firePropertyChange("invoice.currency", null, this.txCurrency.getText());
            this.firePropertyChange("invoice.tax", null, this.txTax.getText());
            if (this.rbInvoiceProjectsTasks.isSelected()) {
                this.firePropertyChange("invoice.rows", null, "projects_tasks");
            } else {
                this.firePropertyChange("invoice.rows", null, "tasks");
            }
        }
    }
}

