/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;
import org.cesilko.rachota.gui.Tools;

class InvoiceGenerator {
    private File file;
    private String title;
    private String userDetails;
    private String customerDetails;
    private String paymentDetails;
    private Integer dueDays;
    private Double price;
    private String currency;
    private Double tax;
    private String rowsRepresent;
    private Vector days;
    private Vector selectFilters;

    InvoiceGenerator(File outputFile, String title, String userDetails, String customerDetails, String paymentDetails, Integer dueDays, Double price, String currency, Double tax, String rowsRepresent, Vector days, Vector selectFilters) {
        this.file = outputFile;
        this.title = title;
        this.userDetails = userDetails;
        this.customerDetails = customerDetails;
        this.paymentDetails = paymentDetails;
        this.dueDays = dueDays;
        this.price = price;
        this.currency = currency;
        this.tax = tax;
        this.rowsRepresent = rowsRepresent;
        this.days = days;
        this.selectFilters = selectFilters;
    }

    void generateInvoice() {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), (String)Settings.getDefault().getSetting("systemEncoding"));
            this.writeHeader(writer);
            this.writeSubjects(writer);
            if (this.rowsRepresent.equals("projects_tasks")) {
                this.writeProjectsTasks(writer);
            } else {
                this.writeTasks(writer);
            }
            this.writePaymentDetails(writer);
            this.writeFooter(writer);
            writer.flush();
            writer.close();
            JOptionPane.showMessageDialog(null, Translator.getTranslation("INFORMATION.REPORT_CREATED"), Translator.getTranslation("INFORMATION.INFORMATION_TITLE"), 1);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.WRITE_ERROR", new String[]{this.file.getAbsolutePath()}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
        }
    }

    private void writeHeader(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLHeader(writer);
        } else {
            this.writeTXTHeader(writer);
        }
    }

    private void writeSubjects(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLSubjects(writer);
        } else {
            this.writeTXTSubjects(writer);
        }
    }

    private void writeProjectsTasks(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLProjectsTasks(writer);
        } else {
            this.writeTXTProjectsTasks(writer);
        }
    }

    private void writeTasks(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLTasks(writer);
        } else {
            this.writeTXTTasks(writer);
        }
    }

    private void writePaymentDetails(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLPaymentDetails(writer);
        } else {
            this.writeTXTPaymentDetails(writer);
        }
    }

    private void writeFooter(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLFooter(writer);
        } else {
            this.writeTXTFooter(writer);
        }
    }

    private void writeHTMLHeader(OutputStreamWriter writer) throws IOException {
        writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        writer.write("<!--\n");
        writer.write("    Rachota 2.4 report file\n");
        writer.write("    Generated: " + new Date() + "\n");
        writer.write("-->\n");
        writer.write("<html lang=\"" + Locale.getDefault().getLanguage() + "\">\n");
        writer.write("  <head>\n");
        String invoiceNumber = new SimpleDateFormat("yyMMdd-").format(new Date()) + Tools.getRandomID();
        writer.write("    <title>" + Translator.getTranslation("INVOICE.TITLE") + "</title>\n");
        writer.write("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=" + (String)Settings.getDefault().getSetting("systemEncoding") + "\">\n");
        writer.write("  </head>\n");
        writer.write("  <body>\n");
        writer.write("    <table>\n");
        writer.write("      <tr>\n");
        writer.write("        <td>");
        String logoLocation = (String)Settings.getDefault().getSetting("invoice.logo");
        if (logoLocation != null) {
            writer.write("<img src=\"" + logoLocation + "\">");
        }
        writer.write("</td>\n");
        writer.write("        <td width=\"20\">&nbsp;</td>\n");
        writer.write("        <td>\n");
        writer.write("          <h2>" + Translator.getTranslation("INVOICE.TITLE") + "</h2>\n");
        writer.write("          <h3>" + this.title + "</h3>\n");
        writer.write("          <table>\n");
        writer.write("            <tr><td>" + Translator.getTranslation("INVOICE.NUMBER") + "</td>&nbsp;<td></td><td>" + invoiceNumber + "</td></tr>\n");
        writer.write("            <tr><td>" + Translator.getTranslation("INVOICE.DATE") + "</td>&nbsp;<td></td><td>" + new SimpleDateFormat("MMMM dd, yyyy").format(new Date()) + "</td></tr>\n");
        Calendar dueDateCalendar = Calendar.getInstance();
        dueDateCalendar.add(6, this.dueDays);
        writer.write("            <tr><td>" + Translator.getTranslation("INVOICE.DUE") + "</td><td>&nbsp;</td><td>" + new SimpleDateFormat("MMMM dd, yyyy").format(dueDateCalendar.getTime()) + "</td></tr>\n");
        writer.write("          </table>\n");
        writer.write("        </td>\n");
        writer.write("      </tr>\n");
        writer.write("    </table><br>\n\n");
    }

    private void writeHTMLSubjects(OutputStreamWriter writer) throws IOException {
        writer.write("    <table>\n");
        writer.write("      <tr>\n");
        if (!this.userDetails.isEmpty()) {
            writer.write("        <td bgcolor=\"BBBBFF\" align=\"center\"><b>" + Translator.getTranslation("INVOICE.SUPPLIER") + "</b></td>\n");
        }
        writer.write("        <td width=\"50\">&nbsp;</td>\n");
        if (!this.customerDetails.isEmpty()) {
            writer.write("        <td bgcolor=\"BBBBFF\" align=\"center\"><b>" + Translator.getTranslation("INVOICE.CUSTOMER") + "</b></td>\n");
        }
        writer.write("      </tr>\n");
        writer.write("      <tr>\n");
        if (!this.userDetails.isEmpty()) {
            writer.write("        <td>" + Tools.replaceAll(this.userDetails, "\n", "<br>") + "</td>\n");
        }
        writer.write("        <td>&nbsp;</td>\n");
        if (!this.customerDetails.isEmpty()) {
            writer.write("        <td>" + Tools.replaceAll(this.customerDetails, "\n", "<br>") + "</td>\n");
        }
        writer.write("      </tr>\n");
        writer.write("    </table><br>\n\n");
    }

    private void writeHTMLProjectsTasks(OutputStreamWriter writer) throws IOException {
        writer.write("    <table>\n");
        writer.write("      <tr bgcolor=\"CCCCCC\">\n");
        writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.PROJECT") + "</b></td>\n");
        writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("INVOICE.HOURS") + "</b></td>\n");
        writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("INVOICE.COST") + "</b></td>\n");
        writer.write("      </tr>\n");
        ProjectRow[] projectRows = this.getProjectRows();
        for (int i = 0; i < projectRows.length; ++i) {
            writer.write("      <tr><td><b>" + projectRows[i].getProject() + "</b></td>");
            writer.write("<td>" + Tools.getTimeShort(projectRows[i].getDuration()) + "</td>");
            double cost = this.price * (double)projectRows[i].getDuration() / 3600000.0;
            writer.write("<td align=\"right\">" + DecimalFormat.getCurrencyInstance().format(cost) + " " + this.currency + "</td></tr>\n");
            writer.write("      <tr>\n");
            writer.write("        <td colspan=\"2\">\n");
            for (String task : projectRows[i].getTasks()) {
                writer.write("          <li>" + task + "</li>\n");
            }
            writer.write("        </td>\n");
            writer.write("        <td>&nbsp;</td>\n");
            writer.write("      </tr>\n");
            writer.write("      <tr><td colspan=\"3\">&nbsp;</td></tr>\n");
        }
        double totalCost = this.price * (double)Tools.getTotalTime(false, Settings.getDefault().getCountPrivateTasks(), this.days) / 3600000.0;
        double totalTax = this.tax * totalCost / 100.0;
        double total = totalCost + totalTax;
        writer.write("      <tr><td colspan=\"2\">" + Translator.getTranslation("INVOICE.TOTAL_COST") + "</td><td align=\"right\">" + DecimalFormat.getCurrencyInstance().format(totalCost) + " " + this.currency + "</td></tr>\n");
        writer.write("      <tr><td colspan=\"2\">" + Translator.getTranslation("INVOICE.TOTAL_TAX", new String[]{Double.toString(this.tax)}) + "</td><td align=\"right\">" + DecimalFormat.getCurrencyInstance().format(totalTax) + " " + this.currency + "</td></tr>\n");
        writer.write("      <tr><td colspan=\"2\"><b>" + Translator.getTranslation("INVOICE.TOTAL") + "</b></td><td align=\"right\"><b>" + DecimalFormat.getCurrencyInstance().format(total) + " " + this.currency + "</b></td></tr>\n");
        writer.write("    </table><br>\n\n");
    }

    private void writeHTMLTasks(OutputStreamWriter writer) throws IOException {
        writer.write("    <table>\n");
        writer.write("      <tr bgcolor=\"CCCCCC\">\n");
        writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.DESCRIPTION") + "</b></td>\n");
        writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("INVOICE.HOURS") + "</b></td>\n");
        writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("INVOICE.COST") + "</b></td>\n");
        writer.write("      </tr>\n");
        TaskRow[] taskRows = this.getTaskRows();
        for (int i = 0; i < taskRows.length; ++i) {
            writer.write("      <tr><td><i>" + taskRows[i].getTask() + "</i></td>");
            writer.write("<td>" + Tools.getTimeShort(taskRows[i].getDuration()) + "</td>");
            double cost = this.price * (double)taskRows[i].getDuration() / 3600000.0;
            writer.write("<td align=\"right\">" + DecimalFormat.getCurrencyInstance().format(cost) + " " + this.currency + "</td></tr>\n");
        }
        double totalCost = this.price * (double)Tools.getTotalTime(false, Settings.getDefault().getCountPrivateTasks(), this.days) / 3600000.0;
        double totalTax = this.tax * totalCost / 100.0;
        double total = totalCost + totalTax;
        writer.write("      <tr><td colspan=\"3\">&nbsp;</td></tr>\n");
        writer.write("      <tr><td colspan=\"2\">" + Translator.getTranslation("INVOICE.TOTAL_COST") + "</td><td align=\"right\">" + DecimalFormat.getCurrencyInstance().format(totalCost) + " " + this.currency + "</td></tr>\n");
        writer.write("      <tr><td colspan=\"2\">" + Translator.getTranslation("INVOICE.TOTAL_TAX", new String[]{Double.toString(this.tax)}) + "</td><td align=\"right\">" + DecimalFormat.getCurrencyInstance().format(totalTax) + " " + this.currency + "</td></tr>\n");
        writer.write("      <tr><td colspan=\"2\"><b>" + Translator.getTranslation("INVOICE.TOTAL") + "</b></td><td align=\"right\"><b>" + DecimalFormat.getCurrencyInstance().format(total) + " " + this.currency + "</b></td></tr>\n");
        writer.write("    </table><br>\n\n");
    }

    private void writeHTMLPaymentDetails(OutputStreamWriter writer) throws IOException {
        if (this.paymentDetails.isEmpty()) {
            return;
        }
        writer.write("    <table>\n");
        writer.write("      <tr>\n");
        writer.write("        <td bgcolor=\"BBBBFF\"><b>" + Translator.getTranslation("INVOICE.PAYMENT_DETAILS") + "</b></td>\n");
        writer.write("      </tr>\n");
        writer.write("      <tr>\n");
        writer.write("        <td>" + Tools.replaceAll(this.paymentDetails, "\n", "<br>") + "</td>\n");
        writer.write("      </tr>\n");
        writer.write("    </table>\n");
    }

    private void writeHTMLFooter(OutputStreamWriter writer) throws IOException {
        writer.write("\n");
        writer.write("    <hr/><u>" + Translator.getTranslation("REPORT.GENERATED_BY") + "</u> <a href=\"http://rachota.sourceforge.net/\">" + "Rachota 2.4" + "</a> " + "(build " + "#140825" + ")<br/>\n");
        writer.write("    " + new Date() + "\n");
        writer.write("  </body>\n");
        writer.write("</html>");
    }

    private void writeTXTHeader(OutputStreamWriter writer) throws IOException {
        writer.write(Translator.getTranslation("INVOICE.TITLE") + "\n\n");
        writer.write(this.title + "\n");
        for (int i = 0; i < this.title.length(); ++i) {
            writer.write("=");
        }
        writer.write("\n\n");
        String invoiceNumber = new SimpleDateFormat("yyMMdd-").format(new Date()) + Tools.getRandomID();
        writer.write(Translator.getTranslation("INVOICE.NUMBER") + " " + invoiceNumber + "\n");
        writer.write(Translator.getTranslation("INVOICE.DATE") + " " + new SimpleDateFormat("MMMM dd, yyyy").format(new Date()) + "\n");
        Calendar dueDateCalendar = Calendar.getInstance();
        dueDateCalendar.add(6, this.dueDays);
        writer.write(Translator.getTranslation("INVOICE.DUE") + " " + new SimpleDateFormat("MMMM dd, yyyy").format(dueDateCalendar.getTime()) + "\n\n");
    }

    private void writeTXTSubjects(OutputStreamWriter writer) throws IOException {
        int i;
        if (!this.userDetails.isEmpty()) {
            writer.write(Translator.getTranslation("INVOICE.SUPPLIER") + "\n");
            for (i = 0; i < Translator.getTranslation("INVOICE.SUPPLIER").length(); ++i) {
                writer.write("=");
            }
            writer.write("\n" + this.userDetails + "\n\n");
        }
        if (!this.customerDetails.isEmpty()) {
            writer.write(Translator.getTranslation("INVOICE.CUSTOMER") + "\n");
            for (i = 0; i < Translator.getTranslation("INVOICE.CUSTOMER").length(); ++i) {
                writer.write("=");
            }
            writer.write("\n" + this.customerDetails + "\n\n");
        }
    }

    private void writeTXTProjectsTasks(OutputStreamWriter writer) throws IOException {
        writer.write(Translator.getTranslation("REPORT.PROJECTS") + "\n");
        for (int i = 0; i < Translator.getTranslation("REPORT.PROJECTS").length(); ++i) {
            writer.write("=");
        }
        writer.write("\n");
        ProjectRow[] projectRows = this.getProjectRows();
        for (int i = 0; i < projectRows.length; ++i) {
            writer.write(projectRows[i].getProject() + "   ");
            writer.write(Tools.getTimeShort(projectRows[i].getDuration()) + "   ");
            double cost = this.price * (double)projectRows[i].getDuration() / 3600000.0;
            writer.write(DecimalFormat.getCurrencyInstance().format(cost) + " " + this.currency + "\n");
            for (String task : projectRows[i].getTasks()) {
                writer.write("* " + task + "\n");
            }
            writer.write("\n");
        }
        double totalCost = this.price * (double)Tools.getTotalTime(false, Settings.getDefault().getCountPrivateTasks(), this.days) / 3600000.0;
        double totalTax = this.tax * totalCost / 100.0;
        double total = totalCost + totalTax;
        writer.write("\n" + Translator.getTranslation("INVOICE.TOTAL_COST") + " " + DecimalFormat.getCurrencyInstance().format(totalCost) + " " + this.currency + "\n");
        writer.write(Translator.getTranslation("INVOICE.TOTAL_TAX", new String[]{Double.toString(this.tax)}) + " " + DecimalFormat.getCurrencyInstance().format(totalTax) + " " + this.currency + "\n");
        writer.write(Translator.getTranslation("INVOICE.TOTAL") + " " + DecimalFormat.getCurrencyInstance().format(total) + " " + this.currency + "\n\n");
    }

    private void writeTXTPaymentDetails(OutputStreamWriter writer) throws IOException {
        if (this.paymentDetails.isEmpty()) {
            return;
        }
        writer.write(Translator.getTranslation("INVOICE.PAYMENT_DETAILS") + "\n");
        for (int i = 0; i < Translator.getTranslation("INVOICE.PAYMENT_DETAILS").length(); ++i) {
            writer.write("=");
        }
        writer.write("\n" + this.paymentDetails + "\n");
    }

    private void writeTXTFooter(OutputStreamWriter writer) throws IOException {
        writer.write("---------------------------------------------------------------\n");
        writer.write(Translator.getTranslation("REPORT.GENERATED_BY") + " " + "Rachota 2.4" + " (build " + "#140825" + ")\n");
        writer.write("http://rachota.sourceforge.net\n");
        writer.write("" + new Date());
    }

    private void writeTXTTasks(OutputStreamWriter writer) throws IOException {
        writer.write(Translator.getTranslation("REPORT.TASKS") + "\n");
        for (int i = 0; i < Translator.getTranslation("REPORT.TASKS").length(); ++i) {
            writer.write("=");
        }
        writer.write("\n");
        TaskRow[] taskRows = this.getTaskRows();
        for (int i = 0; i < taskRows.length; ++i) {
            writer.write(taskRows[i].getTask() + "   ");
            writer.write(Tools.getTimeShort(taskRows[i].getDuration()) + "   ");
            double cost = this.price * (double)taskRows[i].getDuration() / 3600000.0;
            writer.write(DecimalFormat.getCurrencyInstance().format(cost) + " " + this.currency + "\n");
        }
        double totalCost = this.price * (double)Tools.getTotalTime(false, Settings.getDefault().getCountPrivateTasks(), this.days) / 3600000.0;
        double totalTax = this.tax * totalCost / 100.0;
        double total = totalCost + totalTax;
        writer.write("\n" + Translator.getTranslation("INVOICE.TOTAL_COST") + "   " + DecimalFormat.getCurrencyInstance().format(totalCost) + " " + this.currency + "\n");
        writer.write(Translator.getTranslation("INVOICE.TOTAL_TAX", new String[]{Double.toString(this.tax)}) + "   " + DecimalFormat.getCurrencyInstance().format(totalTax) + " " + this.currency + "\n");
        writer.write(Translator.getTranslation("INVOICE.TOTAL") + "   " + DecimalFormat.getCurrencyInstance().format(total) + " " + this.currency + "\n\n");
    }

    private ProjectRow[] getProjectRows() {
        Hashtable<String, ProjectRow> projectRowsTable = new Hashtable<String, ProjectRow>();
        for (Day day : this.days) {
            Vector filteredTasks = this.filterTasks(day.getTasks());
            for (Task task : filteredTasks) {
                Iterator keywordIterator;
                if (task.isIdleTask()) continue;
                boolean includePrivateTasks = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
                if (task.privateTask() & !includePrivateTasks || !(keywordIterator = task.getKeywordIterator()).hasNext()) continue;
                while (keywordIterator.hasNext()) {
                    ProjectRow projectRow;
                    String project = (String)keywordIterator.next();
                    if (projectRowsTable.containsKey(project)) {
                        projectRow = (ProjectRow)projectRowsTable.get(project);
                        projectRow.includeTask(task);
                        continue;
                    }
                    projectRow = new ProjectRow(project, task, "duration");
                    projectRowsTable.put(project, projectRow);
                }
            }
        }
        int size = projectRowsTable.size();
        Object[] projectRows = new ProjectRow[size];
        Iterator iterator = projectRowsTable.values().iterator();
        for (int i = 0; i < size; ++i) {
            projectRows[i] = (ProjectRow)iterator.next();
        }
        Arrays.sort(projectRows);
        return projectRows;
    }

    private TaskRow[] getTaskRows() {
        Hashtable<String, TaskRow> taskRowsTable = new Hashtable<String, TaskRow>();
        for (Day day : this.days) {
            Vector filteredTasks = this.filterTasks(day.getTasks());
            for (Task task : filteredTasks) {
                TaskRow taskRow;
                if (task.isIdleTask()) continue;
                boolean includePrivateTasks = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
                if (task.privateTask() & !includePrivateTasks) continue;
                if (taskRowsTable.containsKey(task.getDescription())) {
                    taskRow = (TaskRow)taskRowsTable.get(task.getDescription());
                    taskRow.includeTask(task);
                    continue;
                }
                taskRow = new TaskRow(task, "duration");
                taskRowsTable.put(task.getDescription(), taskRow);
            }
        }
        int size = taskRowsTable.size();
        Object[] taskRows = new TaskRow[size];
        Iterator iterator = taskRowsTable.values().iterator();
        for (int i = 0; i < size; ++i) {
            taskRows[i] = (TaskRow)iterator.next();
        }
        Arrays.sort(taskRows);
        return taskRows;
    }

    private Vector filterTasks(Vector tasks) {
        Vector filteredTasks = tasks;
        for (AbstractTaskFilter filter : this.selectFilters) {
            filteredTasks = filter.filterTasks(filteredTasks);
        }
        return filteredTasks;
    }

    class TaskRow
    implements Comparable {
        String task;
        long duration;
        String sortBy;

        TaskRow(Task task, String sortBy) {
            this.task = task.getDescription();
            this.duration = task.getDuration();
            this.sortBy = sortBy;
        }

        void includeTask(Task task) {
            this.duration += task.getDuration();
        }

        String getTask() {
            return this.task;
        }

        long getDuration() {
            return this.duration;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 0;
            }
            TaskRow taskRow = (TaskRow)object;
            if (this.sortBy.equals("projects/tasks")) {
                return this.task.compareTo(taskRow.getTask());
            }
            if (this.duration < taskRow.getDuration()) {
                return 1;
            }
            return -1;
        }
    }

    class ProjectRow
    implements Comparable {
        String project;
        Vector tasks;
        long duration;
        String sortBy;

        ProjectRow(String project, Task task, String sortBy) {
            this.project = project;
            this.tasks = new Vector();
            this.tasks.add(task.getDescription());
            this.duration = task.getDuration();
            this.sortBy = sortBy;
        }

        void includeTask(Task task) {
            String taskDescription = task.getDescription();
            if (!this.tasks.contains(taskDescription)) {
                this.tasks.add(taskDescription);
            }
            this.duration += task.getDuration();
        }

        String getProject() {
            return this.project;
        }

        Vector getTasks() {
            return this.tasks;
        }

        long getDuration() {
            return this.duration;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 0;
            }
            ProjectRow projectRow = (ProjectRow)object;
            if (this.sortBy.equals("projects/tasks")) {
                return this.project.compareTo(projectRow.getProject());
            }
            if (this.duration < projectRow.getDuration()) {
                return 1;
            }
            return -1;
        }
    }
}

