/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import org.cesilko.rachota.core.Clock;
import org.cesilko.rachota.core.ClockListener;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.AdjustTimeDialog;
import org.cesilko.rachota.gui.DateDialog;
import org.cesilko.rachota.gui.DayPlanTable;
import org.cesilko.rachota.gui.DayTableModel;
import org.cesilko.rachota.gui.MoveTimeDialog;
import org.cesilko.rachota.gui.TaskDialog;
import org.cesilko.rachota.gui.Tools;

public class DayView
extends JPanel
implements ClockListener,
PropertyChangeListener {
    private JButton btAdd;
    private JButton btDone;
    private JButton btEdit;
    private JButton btNext;
    private JButton btNextMonth;
    private JButton btNextWeek;
    private JButton btPrevious;
    private JButton btPreviousMonth;
    private JButton btPreviousWeek;
    private JButton btRelax;
    private JButton btRemove;
    private JButton btSelect;
    private JButton btWork;
    private JCheckBox chbShowFinished;
    private JLabel lblDate;
    private JLabel lblEnd;
    private JLabel lblPlan;
    private JLabel lblProgress;
    private JLabel lblStart;
    private JLabel lblTask;
    private JLabel lblWeek;
    private JProgressBar pbProgress;
    private JPanel pnButtons;
    private JPanel pnDayView;
    private JPanel pnWorkButtons;
    private JScrollPane spPlan;
    private JTable tbPlan;
    private JTextField txtDate;
    private JTextField txtEnd;
    private JTextField txtStart;
    private JTextField txtTask;
    private JTextField txtWeek;
    private Day day = null;
    private Task task = null;
    private Point clickedWhere = new Point();
    private Date clickedWhen = new Date();
    private boolean selectButtonEnabled = false;
    private boolean warningConfirmed = false;

    public DayView() {
        this.day = Plan.getDefault().getDay(new Date());
        Plan.getDefault().addRegularTasks(this.day);
        this.task = null;
        this.day.addPropertyChangeListener(this);
        Clock.getDefault().addListener(this);
        this.initComponents();
        this.tbPlan.getSelectionModel().setSelectionMode(0);
        Boolean displayFinishedTasks = (Boolean)Settings.getDefault().getSetting("displayFinishedTasks");
        this.chbShowFinished.setSelected(displayFinishedTasks);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/table.png"));
        final JButton corner = new JButton(icon);
        corner.setToolTipText(Translator.getTranslation("DAYVIEW.TABLE_HEADER_HINT"));
        this.spPlan.setCorner("UPPER_RIGHT_CORNER", corner);
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                final JPopupMenu menu = new JPopupMenu();
                final DayTableModel tableModel = (DayTableModel)DayView.this.tbPlan.getModel();
                String[] columnNames = tableModel.getAllColumnNames();
                final int count = columnNames.length;
                int i = 0;
                while (i < count) {
                    final JCheckBoxMenuItem item = new JCheckBoxMenuItem(columnNames[i]);
                    item.setSelected(tableModel.isSelectedColumn(i));
                    final int columnID = i++;
                    item.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            tableModel.setSelectedColumn(columnID, item.isSelected());
                            tableModel.fireTableStructureChanged();
                            if (tableModel.getColumnCount() == 1) {
                                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menu.getComponent(tableModel.getColumnID(0));
                                menuItem.setEnabled(false);
                            } else {
                                for (int j = 0; j < count; ++j) {
                                    JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menu.getComponent(j);
                                    menuItem.setEnabled(true);
                                }
                            }
                        }
                    });
                    menu.add(item);
                }
                if (tableModel.getColumnCount() == 1) {
                    JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menu.getComponent(tableModel.getColumnID(0));
                    menuItem.setEnabled(false);
                }
                Point point = corner.getLocationOnScreen();
                menu.setLocation(point);
                menu.setVisible(true);
                MouseAdapter listener = new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent e) {
                        menu.setVisible(false);
                        menu.removeMouseListener(this);
                    }
                };
                menu.addMouseListener(listener);
            }
        };
        this.spPlan.getCorner("UPPER_RIGHT_CORNER").addMouseListener(listener);
        this.tbPlan.getTableHeader().addMouseListener(new MouseAdapter(){
            Point pressedPoint;

            @Override
            public void mousePressed(MouseEvent e) {
                this.pressedPoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.getPoint().equals(this.pressedPoint)) {
                    return;
                }
                int column = DayView.this.tbPlan.getTableHeader().columnAtPoint(e.getPoint());
                DayTableModel dayTableModel = (DayTableModel)DayView.this.tbPlan.getModel();
                dayTableModel.setSortedColumn(column, true);
                int columns = DayView.this.tbPlan.getColumnCount();
                for (int i = 0; i < columns; ++i) {
                    DayView.this.tbPlan.getColumnModel().getColumn(i).setHeaderValue(dayTableModel.getColumnName(i));
                }
            }
        });
        this.loadSetup();
        DayTableModel tableModel = (DayTableModel)this.tbPlan.getModel();
        this.updateInformation(false);
        JButton fakeButton = new JButton(Translator.getTranslation("DAYVIEW.BT_VIEW"));
        fakeButton.setFont(this.getFont());
        fakeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/edit.png")));
        double width = fakeButton.getPreferredSize().getWidth();
        fakeButton.setText(Translator.getTranslation("DAYVIEW.BT_EDIT"));
        if (fakeButton.getPreferredSize().getWidth() > width) {
            width = fakeButton.getPreferredSize().getWidth();
        }
        this.btEdit.setPreferredSize(new Dimension((int)width, (int)this.btEdit.getPreferredSize().getHeight()));
        this.loadRunningTask();
        this.checkButtons();
        this.tbPlan.getTableHeader().setForeground(Color.BLUE);
        this.tbPlan.getTableHeader().setBackground(Color.LIGHT_GRAY);
        this.tbPlan.getTableHeader().setFont(this.getFont());
        this.tbPlan.setFont(this.getFont());
        this.tbPlan.setRowHeight(this.getFont().getSize() + 2);
        this.setupEndTimeMouseListener(this.lblEnd, this.txtEnd);
    }

    private void setupEndTimeMouseListener(JComponent ... components) {
        if (components.length == 0) {
            return;
        }
        MouseInputAdapter adapter = new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Settings.getDefault().setUseEstimatedWorkDay(!Settings.getDefault().getUseEstimatedWorkDay());
            }
        };
        for (JComponent component : components) {
            component.addMouseListener(adapter);
        }
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    public void adjustStartTime(Frame parent) {
        Date startTime = this.day.getStartTime();
        if (startTime == null) {
            startTime = new Date();
        }
        int hours = new Integer(Tools.getTime(startTime).substring(0, 2));
        int minutes = new Integer(Tools.getTime(startTime).substring(3, 5));
        AdjustTimeDialog adjustTimeDialog = new AdjustTimeDialog(parent, Translator.getTranslation("ADJUSTTIMEDIALOG.START_TIME"), hours, minutes);
        adjustTimeDialog.addPropertyChangeListener(this);
        adjustTimeDialog.setLocationRelativeTo(this);
        adjustTimeDialog.setVisible(true);
    }

    private void initComponents() {
        this.btPrevious = new JButton();
        this.btPreviousWeek = new JButton();
        this.btPreviousMonth = new JButton();
        this.lblDate = new JLabel();
        this.txtDate = new JTextField();
        this.lblWeek = new JLabel();
        this.txtWeek = new JTextField();
        this.btNext = new JButton();
        this.btNextMonth = new JButton();
        this.btNextWeek = new JButton();
        this.pnDayView = new JPanel();
        this.lblStart = new JLabel();
        this.txtStart = new JTextField();
        this.lblEnd = new JLabel();
        this.txtEnd = new JTextField();
        this.lblProgress = new JLabel();
        this.pbProgress = new JProgressBar();
        this.lblTask = new JLabel();
        this.txtTask = new JTextField();
        this.pnWorkButtons = new JPanel();
        this.btWork = new JButton();
        this.btRelax = new JButton();
        this.btDone = new JButton();
        this.lblPlan = new JLabel();
        this.spPlan = new JScrollPane();
        this.tbPlan = new DayPlanTable();
        this.chbShowFinished = new JCheckBox();
        this.pnButtons = new JPanel();
        this.btSelect = new JButton();
        this.btAdd = new JButton();
        this.btEdit = new JButton();
        this.btRemove = new JButton();
        this.setName(Translator.getTranslation("DAYVIEW.TB_NAME"));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DayView.this.formMouseMoved(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.btPrevious.setFont(this.getFont());
        this.btPrevious.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/previous.png")));
        this.btPrevious.setMnemonic(Translator.getMnemonic("DAYVIEW.BT_PREVIOUS"));
        this.btPrevious.setText(Translator.getTranslation("DAYVIEW.BT_PREVIOUS"));
        this.btPrevious.setToolTipText(Translator.getTranslation("DAYVIEW.BT_PREVIOUS_TOOLTIP"));
        this.btPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btPreviousActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 5);
        this.add((Component)this.btPrevious, gridBagConstraints);
        this.btPreviousWeek.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/previous_week.png")));
        this.btPreviousWeek.setToolTipText(Translator.getTranslation("DAYVIEW.BT_PREVIOUS_WEEK_TOOLTIP"));
        this.btPreviousWeek.setMargin(new Insets(2, 2, 2, 2));
        this.btPreviousWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btPreviousWeekActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.add((Component)this.btPreviousWeek, gridBagConstraints);
        this.btPreviousMonth.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/previous_month.png")));
        this.btPreviousMonth.setToolTipText(Translator.getTranslation("DAYVIEW.BT_PREVIOUS_MONTH_TOOLTIP"));
        this.btPreviousMonth.setMargin(new Insets(2, 2, 2, 2));
        this.btPreviousMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btPreviousMonthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btPreviousMonth, gridBagConstraints);
        this.lblDate.setFont(this.getFont());
        this.lblDate.setText(Translator.getTranslation("DAYVIEW.LBL_DATE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblDate, gridBagConstraints);
        this.txtDate.setEditable(false);
        this.txtDate.setFont(this.getFont());
        this.txtDate.setHorizontalAlignment(0);
        this.txtDate.setToolTipText(Translator.getTranslation("DAYVIEW.TXT_DATE_TOOLTIP"));
        this.txtDate.setDoubleBuffered(true);
        this.txtDate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DayView.this.txtDateMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.txtDate, gridBagConstraints);
        this.lblWeek.setFont(this.getFont());
        this.lblWeek.setText(Translator.getTranslation("DAYVIEW.LBL_WEEK"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblWeek, gridBagConstraints);
        this.txtWeek.setEditable(false);
        this.txtWeek.setFont(this.getFont());
        this.txtWeek.setHorizontalAlignment(0);
        this.txtWeek.setDoubleBuffered(true);
        this.txtWeek.setMinimumSize(new Dimension(40, 19));
        this.txtWeek.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.txtWeek, gridBagConstraints);
        this.btNext.setFont(this.getFont());
        this.btNext.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/next.png")));
        this.btNext.setMnemonic(Translator.getMnemonic("DAYVIEW.BT_NEXT"));
        this.btNext.setText(Translator.getTranslation("DAYVIEW.BT_NEXT"));
        this.btNext.setToolTipText(Translator.getTranslation("DAYVIEW.BT_NEXT_TOOLTIP"));
        this.btNext.setHorizontalTextPosition(10);
        this.btNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 5, 10);
        this.add((Component)this.btNext, gridBagConstraints);
        this.btNextMonth.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/next_month.png")));
        this.btNextMonth.setToolTipText(Translator.getTranslation("DAYVIEW.BT_NEXT_MONTH_TOOLTIP"));
        this.btNextMonth.setHorizontalTextPosition(10);
        this.btNextMonth.setMargin(new Insets(2, 2, 2, 2));
        this.btNextMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btNextMonthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btNextMonth, gridBagConstraints);
        this.btNextWeek.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/next_week.png")));
        this.btNextWeek.setToolTipText(Translator.getTranslation("DAYVIEW.BT_NEXT_WEEK_TOOLTIP"));
        this.btNextWeek.setHorizontalTextPosition(10);
        this.btNextWeek.setMargin(new Insets(2, 2, 2, 2));
        this.btNextWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btNextWeekActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.btNextWeek, gridBagConstraints);
        this.pnDayView.setLayout(new GridBagLayout());
        this.lblStart.setFont(this.getFont());
        this.lblStart.setText(Translator.getTranslation("DAYVIEW.LBL_START"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.lblStart, gridBagConstraints);
        this.txtStart.setColumns(5);
        this.txtStart.setEditable(false);
        this.txtStart.setFont(this.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.txtStart, gridBagConstraints);
        this.lblEnd.setFont(this.getFont());
        this.lblEnd.setText(this.getFinishedAtText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.lblEnd, gridBagConstraints);
        this.txtEnd.setColumns(5);
        this.txtEnd.setEditable(false);
        this.txtEnd.setFont(this.getFont());
        this.txtEnd.setToolTipText(Translator.getTranslation("DAYVIEW.LBL_ESTIMATED_END_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.txtEnd, gridBagConstraints);
        this.lblProgress.setFont(this.getFont());
        this.lblProgress.setText(Translator.getTranslation("DAYVIEW.LBL_PROGRESS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.lblProgress, gridBagConstraints);
        this.pbProgress.setFont(this.getFont().deriveFont(1));
        this.pbProgress.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.pbProgress, gridBagConstraints);
        this.lblTask.setFont(this.getFont());
        this.lblTask.setText(Translator.getTranslation("DAYVIEW.LBL_TASK"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.lblTask, gridBagConstraints);
        this.txtTask.setEditable(false);
        this.txtTask.setFont(this.getFont());
        this.txtTask.setDoubleBuffered(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.txtTask, gridBagConstraints);
        this.btWork.setFont(this.getFont());
        this.btWork.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/work.png")));
        this.btWork.setMnemonic(Translator.getMnemonic("DAYVIEW.BT_WORK"));
        this.btWork.setText(Translator.getTranslation("DAYVIEW.BT_WORK"));
        this.btWork.setToolTipText(Translator.getTranslation("DAYVIEW.BT_WORK_TOOLTIP"));
        this.btWork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btWorkActionPerformed(evt);
            }
        });
        this.pnWorkButtons.add(this.btWork);
        this.btRelax.setFont(this.getFont());
        this.btRelax.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/paint.png")));
        this.btRelax.setMnemonic(Translator.getMnemonic("DAYVIEW.BT_RELAX"));
        this.btRelax.setText(Translator.getTranslation("DAYVIEW.BT_RELAX"));
        this.btRelax.setToolTipText(Translator.getTranslation("DAYVIEW.BT_RELAX_TOOLTIP"));
        this.btRelax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btRelaxActionPerformed(evt);
            }
        });
        this.pnWorkButtons.add(this.btRelax);
        this.btDone.setFont(this.getFont());
        this.btDone.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/done.png")));
        this.btDone.setMnemonic(Translator.getMnemonic("DAYVIEW.BT_DONE"));
        this.btDone.setText(Translator.getTranslation("DAYVIEW.BT_DONE"));
        this.btDone.setToolTipText(Translator.getTranslation("DAYVIEW.BT_DONE_TOOLTIP"));
        this.btDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btDoneActionPerformed(evt);
            }
        });
        this.pnWorkButtons.add(this.btDone);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.pnWorkButtons, gridBagConstraints);
        this.lblPlan.setDisplayedMnemonic(Translator.getMnemonic("DAYVIEW.LBL_PLAN"));
        this.lblPlan.setFont(this.getFont());
        this.lblPlan.setLabelFor(this.tbPlan);
        this.lblPlan.setText(Translator.getTranslation("DAYVIEW.LBL_PLAN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.lblPlan, gridBagConstraints);
        this.spPlan.setToolTipText(Translator.getTranslation("DAYVIEW.TABLE_HINT"));
        this.spPlan.setVerticalScrollBarPolicy(22);
        this.spPlan.setFont(this.getFont());
        this.spPlan.setPreferredSize(new Dimension(400, 200));
        this.spPlan.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DayView.this.spPlanMouseMoved(evt);
            }
        });
        this.tbPlan.setModel(new DayTableModel(this.day));
        this.tbPlan.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DayView.this.tbPlanMouseClicked(evt);
            }
        });
        this.tbPlan.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DayView.this.tbPlanMouseMoved(evt);
            }
        });
        this.tbPlan.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DayView.this.tbPlanKeyReleased(evt);
            }
        });
        this.spPlan.setViewportView(this.tbPlan);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnDayView.add((Component)this.spPlan, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.add((Component)this.pnDayView, gridBagConstraints);
        this.chbShowFinished.setFont(this.getFont());
        this.chbShowFinished.setMnemonic(Translator.getMnemonic("DAYVIEW.CHB_SHOWFINISHED"));
        this.chbShowFinished.setText(Translator.getTranslation("DAYVIEW.CHB_SHOWFINISHED"));
        this.chbShowFinished.setToolTipText(Translator.getTranslation("DAYVIEW.CHB_SHOWFINISHED_TOOLTIP"));
        this.chbShowFinished.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.chbShowFinishedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.add((Component)this.chbShowFinished, gridBagConstraints);
        this.btSelect.setFont(this.getFont());
        this.btSelect.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/select.png")));
        this.btSelect.setMnemonic(Translator.getMnemonic("DAYVIEW.BT_SELECT"));
        this.btSelect.setText(Translator.getTranslation("DAYVIEW.BT_SELECT"));
        this.btSelect.setToolTipText(Translator.getTranslation("DAYVIEW.BT_SELECT_TOOLTIP"));
        this.btSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btSelectActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btSelect);
        this.btAdd.setFont(this.getFont());
        this.btAdd.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/add.png")));
        this.btAdd.setMnemonic(Translator.getMnemonic("DAYVIEW.BT_ADD"));
        this.btAdd.setText(Translator.getTranslation("DAYVIEW.BT_ADD"));
        this.btAdd.setToolTipText(Translator.getTranslation("DAYVIEW.BT_ADD_TOOLTIP"));
        this.btAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btAddActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btAdd);
        this.btEdit.setFont(this.getFont());
        this.btEdit.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/edit.png")));
        this.btEdit.setMnemonic(Translator.getMnemonic("DAYVIEW.BT_EDIT"));
        this.btEdit.setText(Translator.getTranslation("DAYVIEW.BT_EDIT"));
        this.btEdit.setToolTipText(Translator.getTranslation("DAYVIEW.BT_EDIT_TOOLTIP"));
        this.btEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btEditActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btEdit);
        this.btRemove.setFont(this.getFont());
        this.btRemove.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/delete.png")));
        this.btRemove.setMnemonic(Translator.getMnemonic("DAYVIEW.BT_REMOVE"));
        this.btRemove.setText(Translator.getTranslation("DAYVIEW.BT_REMOVE"));
        this.btRemove.setToolTipText(Translator.getTranslation("DAYVIEW.BT_REMOVE_TOOLTIP"));
        this.btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DayView.this.btRemoveActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btRemove);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.add((Component)this.pnButtons, gridBagConstraints);
    }

    private void btNextWeekActionPerformed(ActionEvent evt) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.day.getDate());
        calendar.add(6, 7);
        this.setDay(Plan.getDefault().getDay(calendar.getTime()));
    }

    private void btNextMonthActionPerformed(ActionEvent evt) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.day.getDate());
        calendar.add(2, 1);
        this.setDay(Plan.getDefault().getDay(calendar.getTime()));
    }

    private void btPreviousMonthActionPerformed(ActionEvent evt) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.day.getDate());
        calendar.add(2, -1);
        this.setDay(Plan.getDefault().getDay(calendar.getTime()));
    }

    private void btPreviousWeekActionPerformed(ActionEvent evt) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.day.getDate());
        calendar.add(6, -7);
        this.setDay(Plan.getDefault().getDay(calendar.getTime()));
    }

    private void txtDateMouseClicked(MouseEvent evt) {
        this.setDay(Plan.getDefault().getDay(new Date()));
    }

    private void btRemoveActionPerformed(ActionEvent evt) {
        int row = this.tbPlan.getSelectedRow();
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        Task selectedTask = dayTableModel.getTask(row);
        String description = selectedTask.getDescription();
        Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
        int decision = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.REMOVE_TASK", new String[]{description}), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[1]);
        if (decision == 0) {
            if (selectedTask.getDuration() != 0L && (decision = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.REMOVE_NONZERO_TASK"), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[1])) == 1) {
                return;
            }
            if (this.task == selectedTask) {
                this.btDoneActionPerformed(null);
            }
            this.day.removeTask(selectedTask);
            this.checkButtons();
        }
    }

    private void btEditActionPerformed(ActionEvent evt) {
        int row = this.tbPlan.getSelectedRow();
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        Task selectedTask = dayTableModel.getTask(row);
        boolean readOnly = this.btEdit.getText().equals(Translator.getTranslation("DAYVIEW.BT_VIEW"));
        TaskDialog dialog = new TaskDialog(selectedTask, this.day, readOnly);
        dialog.addPropertyChangeListener(this);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void btAddActionPerformed(ActionEvent evt) {
        TaskDialog dialog = new TaskDialog(this.day);
        dialog.addPropertyChangeListener(this);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void btSelectActionPerformed(ActionEvent evt) {
        int row = this.tbPlan.getSelectedRow();
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        Task selectedTask = dayTableModel.getTask(row);
        Boolean checkPriorities = (Boolean)Settings.getDefault().getSetting("checkPriority");
        if (checkPriorities & this.day.existsMorePriorityTask(selectedTask.getPriority())) {
            Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
            int ignorePriority = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.IGNORE_PRIORITY"), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[0]);
            if (ignorePriority != 0) {
                return;
            }
        }
        this.setTask(selectedTask, false);
        this.checkButtons();
    }

    private void chbShowFinishedActionPerformed(ActionEvent evt) {
        Settings.getDefault().setSetting("displayFinishedTasks", new Boolean(this.chbShowFinished.isSelected()));
        this.updateInformation(false);
    }

    private void btNextActionPerformed(ActionEvent evt) {
        this.setDay(Plan.getDefault().getDayAfter(this.day));
    }

    private void btPreviousActionPerformed(ActionEvent evt) {
        this.setDay(Plan.getDefault().getDayBefore(this.day));
    }

    private void tbPlanKeyReleased(KeyEvent evt) {
        this.checkButtons();
    }

    private void btDoneActionPerformed(ActionEvent evt) {
        this.task.removePropertyChangeListener(this);
        this.task.workDone();
        Settings.getDefault().setSetting("runningTask", null);
        Settings.saveSettings();
        this.txtTask.setText("");
        double dayWorkHours = Settings.getDefault().getWorkingHours();
        double totalTime = (double)this.day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) / 3600000.0;
        int progress = (int)(totalTime * 100.0 / dayWorkHours);
        this.pbProgress.setValue(progress);
        this.pbProgress.setString(Tools.getTime(this.day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks"))));
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        dayTableModel.fireTableDataChanged();
        this.firePropertyChange("task_done", this.task, null);
        this.task = null;
        this.checkButtons();
        Task idleTimeTask = Plan.getDefault().getDay(new Date()).getIdleTask();
        idleTimeTask.startWork();
        idleTimeTask.addPropertyChangeListener(this);
    }

    private void btRelaxActionPerformed(ActionEvent evt) {
        this.task.suspendWork();
        Settings.getDefault().setSetting("runningTask", null);
        Settings.saveSettings();
        this.task.removePropertyChangeListener(this);
        this.firePropertyChange("task_suspended", this.task, null);
        this.checkButtons();
        Task idleTimeTask = Plan.getDefault().getDay(new Date()).getIdleTask();
        idleTimeTask.startWork();
        idleTimeTask.addPropertyChangeListener(this);
    }

    private void btWorkActionPerformed(ActionEvent evt) {
        Task idleTimeTask = this.day.getIdleTask();
        if (idleTimeTask.isRunning()) {
            idleTimeTask.suspendWork();
        }
        idleTimeTask.removePropertyChangeListener(this);
        this.task.startWork();
        this.task.addPropertyChangeListener(this);
        this.firePropertyChange("task_resumed", null, this.task);
        this.checkButtons();
    }

    private void tbPlanMouseClicked(MouseEvent evt) {
        this.checkButtons();
        this.firePropertyChange("plan_clicked", null, null);
        Date now = new Date();
        long delay = 1000L;
        delay = now.getTime() - this.clickedWhen.getTime();
        boolean samePoint = this.clickedWhere.equals(evt.getPoint());
        Plan plan = Plan.getDefault();
        if (samePoint & delay < 250L) {
            int row = this.tbPlan.getSelectedRow();
            DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
            Task selectedTask = dayTableModel.getTask(row);
            if (selectedTask.isIdleTask()) {
                return;
            }
            if (!plan.isFuture(this.day) && !plan.isToday(this.day)) {
                Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
                int ignorePriority = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.MOVE_TASK_TODAY", new String[]{selectedTask.getDescription()}), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[0]);
                if (ignorePriority != 0) {
                    return;
                }
                Day today = plan.getDay(new Date());
                if (today.getTask(selectedTask.getDescription()) == null) {
                    Task clone = selectedTask.cloneTask();
                    if (selectedTask instanceof RegularTask) {
                        clone = new Task(selectedTask.getDescription(), selectedTask.getKeyword(), selectedTask.getNotes(), selectedTask.getPriority(), Task.STATE_NEW, 0L, selectedTask.getNotificationTime(), selectedTask.automaticStart(), selectedTask.privateTask());
                    }
                    today.addTask(clone);
                    return;
                }
            }
            if (!plan.isToday(this.day)) {
                return;
            }
            if (selectedTask.getState() == Task.STATE_DONE) {
                return;
            }
            Boolean checkPriorities = (Boolean)Settings.getDefault().getSetting("checkPriority");
            if (checkPriorities & this.day.existsMorePriorityTask(selectedTask.getPriority())) {
                Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
                int ignorePriority = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.IGNORE_PRIORITY"), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[0]);
                if (ignorePriority != 0) {
                    return;
                }
            }
            this.setTask(selectedTask, false);
            this.checkButtons();
            this.btWorkActionPerformed(null);
        } else {
            this.clickedWhere = evt.getPoint();
            this.clickedWhen = now;
        }
    }

    private void spPlanMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void formMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void tbPlanMouseMoved(MouseEvent evt) {
        int row = this.tbPlan.rowAtPoint(evt.getPoint());
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        Task task = dayTableModel.getTask(row);
        String notes = task.getNotes();
        if (notes != null && notes.isEmpty()) {
            notes = null;
        }
        this.tbPlan.setToolTipText(notes);
        ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this.tbPlan, 0, 0L, 0, 0, 0, 0, false));
    }

    private void updateInformation(boolean taskDurationChanged) {
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        String dayFormat = Translator.getTranslation("FORMAT.DATE");
        sdf.applyPattern(dayFormat);
        this.txtDate.setText(sdf.format(this.day.getDate()));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.day.getDate());
        this.txtWeek.setText("" + calendar.get(3) + ".");
        if (this.day.getStartTime() != null) {
            this.txtStart.setText(Tools.getTime(this.day.getStartTime()));
        } else {
            this.txtStart.setText("");
        }
        if (this.day.getFinishTime() != null) {
            this.txtEnd.setText(this.getFinishedAtTime());
        } else {
            this.txtEnd.setText("");
        }
        this.lblEnd.setText(this.getFinishedAtText());
        double totalTime = (double)this.day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) / 3600000.0;
        if (totalTime != 0.0) {
            double dayWorkHours = Settings.getDefault().getWorkingHours();
            int progress = (int)(totalTime * 100.0 / dayWorkHours);
            this.pbProgress.setValue(progress);
            this.pbProgress.setString(Tools.getTime(this.day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks"))));
        } else {
            this.pbProgress.setValue(0);
            this.pbProgress.setString(Tools.getTime(0.0));
        }
        int row = this.tbPlan.getSelectedRow();
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        if (this.task != null && !this.task.isIdleTask()) {
            this.txtTask.setText(this.task.getDescription());
        }
        boolean today = Plan.getDefault().isToday(this.day);
        if (taskDurationChanged) {
            boolean warnHoursExceeded;
            if (today) {
                row = dayTableModel.getRow(this.task);
                if (row != -1) {
                    dayTableModel.fireTableRowsUpdated(row, row);
                }
                row = dayTableModel.getRow(this.day.getIdleTask());
                dayTableModel.fireTableRowsUpdated(row, row);
            }
            if ((warnHoursExceeded = ((Boolean)Settings.getDefault().getSetting("warnHoursExceeded")).booleanValue()) && !this.warningConfirmed) {
                double dayWorkHours = Settings.getDefault().getWorkingHours();
                totalTime = (double)Plan.getDefault().getDay(new Date()).getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) / 3600000.0;
                if (totalTime > dayWorkHours) {
                    this.warningConfirmed = true;
                    new Thread(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, Translator.getTranslation("WARNING.HOURS_EXCEEDED"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
                        }
                    }.start();
                }
            }
        } else {
            dayTableModel.fireTableDataChanged();
            this.checkButtons();
        }
        this.firePropertyChange("view_updated", null, null);
    }

    private boolean useEstimatedEnd() {
        return Plan.getDefault().isToday(this.day) && Settings.getDefault().getUseEstimatedWorkDay();
    }

    private String getFinishedAtText() {
        String value = "";
        value = this.useEstimatedEnd() ? Translator.getTranslation("DAYVIEW.LBL_ESTIMATED_END") : Translator.getTranslation("DAYVIEW.LBL_END");
        return value;
    }

    private String getFinishedAtTime() {
        String value = "";
        value = this.useEstimatedEnd() ? "~ " + Tools.getTime(new Date(new Date().getTime() + this.day.getRemainingWorkingTime())) : Tools.getTime(this.day.getFinishTime());
        return value;
    }

    private void checkButtons() {
        boolean today = Plan.getDefault().isToday(this.day);
        boolean futureDay = Plan.getDefault().isFuture(this.day);
        boolean editableDay = futureDay | today;
        int row = this.tbPlan.getSelectedRow();
        boolean taskSelected = row != -1;
        boolean taskAlreadySelected = false;
        boolean idleTask = false;
        if (taskSelected) {
            DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
            Task selectedTask = dayTableModel.getTask(row);
            if (selectedTask.isIdleTask()) {
                idleTask = true;
            } else {
                boolean bl = taskAlreadySelected = this.task == selectedTask;
            }
        }
        if (futureDay | idleTask) {
            this.firePropertyChange("enable_menu", "mnCorrectDuration", "false");
        } else {
            this.firePropertyChange("enable_menu", "mnCorrectDuration", "true");
        }
        if (idleTask) {
            this.firePropertyChange("enable_menu", "mnCopyTask", "false");
            this.firePropertyChange("enable_menu", "mnAddNote", "false");
        } else {
            this.firePropertyChange("enable_menu", "mnCopyTask", "true");
            this.firePropertyChange("enable_menu", "mnAddNote", "true");
        }
        this.firePropertyChange("enable_menu", "mnMoveTime", "true");
        if (this.day.getStartTime() == null) {
            this.firePropertyChange("enable_menu", "mnAdjustStart", "false");
        } else {
            this.firePropertyChange("enable_menu", "mnAdjustStart", "true");
        }
        this.btSelect.setEnabled(today & taskSelected & !taskAlreadySelected & !idleTask);
        this.selectButtonEnabled = this.btSelect.isEnabled();
        this.btRemove.setEnabled(taskSelected & !idleTask);
        this.btEdit.setEnabled(taskSelected & !idleTask);
        this.btEdit.setText(Translator.getTranslation("DAYVIEW.BT_VIEW"));
        this.btEdit.setToolTipText(Translator.getTranslation("DAYVIEW.BT_VIEW_TOOLTIP"));
        if (editableDay & taskSelected & !idleTask) {
            this.btEdit.setText(Translator.getTranslation("DAYVIEW.BT_EDIT"));
            this.btEdit.setToolTipText(Translator.getTranslation("DAYVIEW.BT_EDIT_TOOLTIP"));
        }
        taskSelected = this.task != null && !this.task.isIdleTask();
        boolean taskRunning = taskSelected && this.task.isRunning();
        boolean taskStarted = taskSelected && this.task.getState() == Task.STATE_STARTED;
        this.btWork.setEnabled(taskSelected & !taskRunning);
        this.btRelax.setEnabled(taskSelected & taskRunning);
        this.btDone.setEnabled(taskSelected & taskStarted);
    }

    public void switchDate(Frame parent) {
        DateDialog dateDialog = new DateDialog(parent, this.day.getDate(), 0);
        dateDialog.addPropertyChangeListener(this);
        dateDialog.setLocationRelativeTo(this);
        dateDialog.setVisible(true);
    }

    public void moveTime(Frame parent) {
        int row = this.tbPlan.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.NO_TASK_SELECTED"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            return;
        }
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        Task selectedTask = dayTableModel.getTask(row);
        if (selectedTask.getDuration() == 0L) {
            JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.NO_TIME"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            return;
        }
        boolean existsTargetTask = false;
        for (Task anyTask : this.day.getTasks()) {
            if (anyTask == selectedTask) continue;
            existsTargetTask = true;
        }
        if (!existsTargetTask) {
            JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.NO_TARGET_TASK"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            return;
        }
        MoveTimeDialog moveTimeDialog = new MoveTimeDialog(parent, selectedTask, this.day);
        moveTimeDialog.addPropertyChangeListener(this);
        moveTimeDialog.setLocationRelativeTo(this);
        moveTimeDialog.setVisible(true);
    }

    public void copyTask(Frame parent) {
        int row = this.tbPlan.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.NO_TASK_SELECTED"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            return;
        }
        Plan plan = Plan.getDefault();
        boolean futureDay = plan.isFuture(plan.getDayAfter(this.day));
        DateDialog dateDialog = new DateDialog(parent, futureDay ? plan.getDayAfter(this.day).getDate() : plan.getDay(new Date()).getDate(), 1);
        dateDialog.addPropertyChangeListener(this);
        dateDialog.setLocationRelativeTo(this);
        dateDialog.setVisible(true);
    }

    public void correctTaskDuration(Frame parent) {
        if (Plan.getDefault().isFuture(this.day)) {
            JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.ONLY_TODAY"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            return;
        }
        int row = this.tbPlan.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.NO_TASK_SELECTED"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            return;
        }
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        Task selectedTask = dayTableModel.getTask(row);
        AdjustTimeDialog dialog = new AdjustTimeDialog(parent, Translator.getTranslation("ADJUSTTIMEDIALOG.FIX_DURATION", new String[]{selectedTask.getDescription()}), selectedTask);
        dialog.addPropertyChangeListener(this);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public void addNote(Frame parent) {
        int row = this.tbPlan.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.NO_TASK_SELECTED"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            return;
        }
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        Task selectedTask = dayTableModel.getTask(row);
        if (selectedTask.isIdleTask()) {
            JOptionPane.showMessageDialog(this, Translator.getTranslation("WARNING.NO_TASK_SELECTED"), Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            return;
        }
        String note = JOptionPane.showInputDialog(parent, Translator.getTranslation("MAINWINDOW.NEW_NOTE"), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 3);
        if (null == note) {
            return;
        }
        if (Plan.getDefault().isToday(this.day)) {
            selectedTask.addNote(note, true);
        } else {
            selectedTask.setNotes("[" + Plan.getDefault().getDay(new Date()).toString() + " " + Tools.getTime(new Date()) + "] " + note);
        }
    }

    public void setFinishedTasksVisibility(boolean visibility) {
        Settings.getDefault().setSetting("displayFinishedTasks", new Boolean(visibility));
        this.updateInformation(false);
    }

    public String getTitleSuffix() {
        String showTime = (String)Settings.getDefault().getSetting("showTime");
        if (showTime.equals("none")) {
            return "";
        }
        boolean usableTask = this.task != null && !this.task.isIdleTask();
        String taskDescription = usableTask ? this.task.getDescription() + " " : "";
        String taskTime = usableTask ? Tools.getTimeShort(this.task.getDuration()) : "";
        String totalTime = Tools.getTimeShort(Plan.getDefault().getDay(new Date()).getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")));
        if (showTime.equals("both")) {
            String suffix = taskDescription + "[";
            if (usableTask) {
                suffix = suffix + taskTime + " / ";
            }
            suffix = suffix + totalTime + "]";
            return suffix + " - ";
        }
        if (showTime.equals("total")) {
            String suffix = "[" + totalTime + "]";
            if (usableTask) {
                suffix = suffix + " " + taskDescription;
            }
            return suffix + " - ";
        }
        String suffix = "";
        if (usableTask) {
            suffix = taskDescription + "[" + taskTime + "]";
        }
        return suffix + " - ";
    }

    private void loadRunningTask() {
        long restartTime;
        String runningTask = (String)Settings.getDefault().getSetting("runningTask");
        if (runningTask == null || runningTask.equals("null")) {
            return;
        }
        int index = runningTask.indexOf("[");
        String description = runningTask.substring(0, index);
        Task task = Plan.getDefault().getDay(new Date()).getTask(description);
        if (task == null) {
            System.out.println("Error: Task to which restart time should be added does not exist in plan.");
            Settings.getDefault().setSetting("runningTask", null);
            Settings.saveSettings();
            return;
        }
        try {
            restartTime = Long.parseLong(runningTask.substring(index + 1, runningTask.length() - 1));
        }
        catch (NumberFormatException e) {
            System.out.println("Error: Restart time stamp of Rachota was not successfully read.");
            Settings.getDefault().setSetting("runningTask", null);
            Settings.saveSettings();
            return;
        }
        Date now = new Date();
        long duration = now.getTime() - restartTime;
        String time = Tools.getTime(duration);
        Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
        int decision = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.ADD_RUNNING_TASK", new String[]{time, description}), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[0]);
        if (decision != 0) {
            Settings.getDefault().setSetting("runningTask", null);
            Settings.saveSettings();
            return;
        }
        task.addDuration(duration);
        this.setTask(task, true);
        long delayedAnswerTime = new Date().getTime() - now.getTime();
        Plan.getDefault().getDay(now).getIdleTask().addDuration(delayedAnswerTime);
    }

    @Override
    public void tick() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(11) + calendar.get(12) + calendar.get(13) == 0) {
            this.switchAfterNight();
        }
        for (final Task task : Plan.getDefault().getDay(new Date()).getTasks()) {
            String now;
            String notification;
            Date notificationTime;
            if (task.getState() == Task.STATE_DONE || task == this.task && task.isRunning() || (notificationTime = task.getNotificationTime()) == null || !(notification = Tools.getTime(notificationTime)).equals(now = Tools.getTime(new Date()))) continue;
            task.setNotificationTime(null);
            final String description = task.getDescription();
            if (task.automaticStart()) {
                new Thread(){

                    @Override
                    public void run() {
                        DayView.this.setTask(task, true);
                        Tools.beep(1);
                        JOptionPane.showMessageDialog(null, Translator.getTranslation("INFORMATION.AUTOMATIC_START", new String[]{description}), Translator.getTranslation("INFORMATION.INFORMATION_TITLE"), 1);
                    }
                }.start();
                return;
            }
            new Thread(){

                @Override
                public void run() {
                    Tools.beep(0);
                    String message = Translator.getTranslation("QUESTION.SWITCH_TASK", new String[]{description});
                    Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
                    int decision = JOptionPane.showOptionDialog(null, message, Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[0]);
                    if (decision == 0) {
                        DayView.this.setTask(task, true);
                    }
                }
            }.start();
        }
    }

    public void setTask(Task task, boolean startTask) {
        if (this.task != null && this.task.isRunning()) {
            this.btRelaxActionPerformed(null);
        }
        this.task = task;
        if (task.isIdleTask()) {
            task.startWork();
            task.addPropertyChangeListener(this);
            return;
        }
        this.txtTask.setText(task.getDescription());
        DayPlanTable dayPlanTable = (DayPlanTable)this.tbPlan;
        dayPlanTable.setSelectedTask(task);
        this.updateInformation(false);
        if (startTask) {
            this.btWorkActionPerformed(null);
        }
    }

    private void setDay(Day newDay) {
        if (this.day.isModified()) {
            Plan.getDefault().addDay(this.day);
        }
        this.day.removePropertyChangeListener(this);
        this.day = newDay;
        Plan.getDefault().addRegularTasks(this.day);
        this.day.addPropertyChangeListener(this);
        DayTableModel dayTableModel = (DayTableModel)this.tbPlan.getModel();
        dayTableModel.setDay(this.day);
        dayTableModel.resortRows();
        this.updateInformation(false);
        this.checkButtons();
    }

    public Day getDay() {
        return this.day;
    }

    public Task getTask() {
        return this.task;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DayTableModel dayTableModel;
        boolean taskDurationChanged = false;
        if (evt.getPropertyName().startsWith("task_")) {
            TaskDialog taskDialog = (TaskDialog)evt.getSource();
            taskDialog.removePropertyChangeListener(this);
            this.checkButtons();
            String startTaskNow = System.getProperty("startTaskNow");
            if (startTaskNow != null && startTaskNow.equals("true")) {
                Task task = (Task)evt.getNewValue();
                this.setTask(task, true);
                System.getProperties().remove("startTaskNow");
            }
        }
        if (evt.getPropertyName().equals("day")) {
            Day day = (Day)evt.getNewValue();
            this.setDay(day);
            this.firePropertyChange("day", null, day);
        }
        if (evt.getPropertyName().equals("date_selected_switch")) {
            Date date = (Date)evt.getNewValue();
            this.setDay(Plan.getDefault().getDay(date));
        }
        if (evt.getPropertyName().equals("date_selected_copy_task")) {
            dayTableModel = (DayTableModel)this.tbPlan.getModel();
            Task selectedTask = dayTableModel.getTask(this.tbPlan.getSelectedRow());
            Day targetDay = Plan.getDefault().getDay((Date)evt.getNewValue());
            if (targetDay != this.day) {
                Plan plan = Plan.getDefault();
                if (targetDay.getTask(selectedTask.getDescription()) == null) {
                    Boolean logTaskEvents;
                    Task clone = selectedTask.cloneTask();
                    if (selectedTask instanceof RegularTask) {
                        clone = new Task(selectedTask.getDescription(), selectedTask.getKeyword(), "", selectedTask.getPriority(), Task.STATE_NEW, 0L, selectedTask.getNotificationTime(), selectedTask.automaticStart(), selectedTask.privateTask());
                    }
                    if ((logTaskEvents = (Boolean)Settings.getDefault().getSetting("logTaskEvents")).booleanValue()) {
                        clone.setNotes("[" + plan.getDay(new Date()).toString() + " " + Tools.getTime(new Date()) + "] created");
                    }
                    targetDay.addTask(clone);
                    plan.addDay(targetDay);
                    if (plan.isFuture(this.day) | plan.isToday(this.day) && selectedTask.getState() == Task.STATE_NEW) {
                        this.day.removeTask(selectedTask);
                    }
                }
            }
        }
        if (evt.getPropertyName().equals("hibernation") && !Plan.getDefault().isToday(this.day)) {
            this.switchAfterNight();
        }
        if (evt.getPropertyName().equals("settings")) {
            Plan.getDefault().addRegularTasks(this.day);
        }
        if (evt.getPropertyName().equals("duration")) {
            taskDurationChanged = true;
        } else if (evt.getPropertyName().equals("tasks")) {
            Plan.getDefault().addDay(this.day);
            dayTableModel = (DayTableModel)this.tbPlan.getModel();
            dayTableModel.resortRows();
        }
        if (evt.getPropertyName().equals("time_adjusted")) {
            String newTime = (String)evt.getNewValue();
            Date startTime = new Date(Tools.getTime(newTime));
            Calendar newStartTime = Calendar.getInstance();
            newStartTime.setTime(this.day.getStartTime());
            Calendar startTimeAtEpoch = Calendar.getInstance();
            startTimeAtEpoch.setTime(startTime);
            newStartTime.set(11, startTimeAtEpoch.get(11));
            newStartTime.set(12, startTimeAtEpoch.get(12));
            startTime = newStartTime.getTime();
            if (this.day.getStartTime() == null) {
                this.day.setStartTime(startTime);
            }
            if (this.day.getFinishTime() == null) {
                this.day.setFinishTime(startTime);
            }
            if (this.day.getFinishTime().before(startTime)) {
                JOptionPane.showMessageDialog(null, Translator.getTranslation("WARNING.START_AFTER_END"));
                return;
            }
            long difference = this.day.getStartTime().getTime() - startTime.getTime();
            this.day.setStartTime(startTime);
            if (difference > 0L) {
                Task startTask = this.day.getTask(Translator.getTranslation("TASK.STARTTASK"));
                if (startTask == null) {
                    startTask = new Task(Translator.getTranslation("TASK.STARTTASK"), "", null, Task.PRIORITY_LOW, Task.STATE_STARTED, difference, null, false, false);
                    this.day.addTask(startTask);
                } else {
                    startTask.addDuration(difference);
                }
            }
        }
        if (evt.getPropertyName().equals("hibernation")) {
            final String hibernationThreshold = (String)Settings.getDefault().getSetting("hibernationTime");
            Task initiatingTask = (Task)evt.getSource();
            String hibernationAction = (String)Settings.getDefault().getSetting("hibernationAction");
            if (hibernationAction.equals(Settings.ON_HIBERNATION_IGNORE)) {
                if (!initiatingTask.isIdleTask()) {
                    this.pauseTask();
                }
                JOptionPane.showMessageDialog(null, Translator.getTranslation("INFORMATION.HIBERNATION_IGNORED", new String[]{hibernationThreshold}), Translator.getTranslation("INFORMATION.INFORMATION_TITLE"), 1);
                return;
            }
            if (hibernationAction.equals(Settings.ON_HIBERNATION_INCLUDE)) {
                new Thread(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, Translator.getTranslation("INFORMATION.HIBERNATION_INCLUDED", new String[]{hibernationThreshold, DayView.this.getTask().getDescription()}), Translator.getTranslation("INFORMATION.INFORMATION_TITLE"), 1);
                    }
                }.start();
            }
            if (hibernationAction.equals(Settings.ON_HIBERNATION_ASK) && evt.getNewValue().equals(Settings.ON_HIBERNATION_IGNORE)) {
                if (!initiatingTask.isIdleTask()) {
                    this.pauseTask();
                }
                return;
            }
        }
        if (evt.getPropertyName().equals("startTime")) {
            this.checkButtons();
        }
        final boolean taskDurationChangedFinal = taskDurationChanged;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DayView.this.updateInformation(taskDurationChangedFinal);
            }
        });
    }

    void saveSetup() {
        DayTableModel model = (DayTableModel)this.tbPlan.getModel();
        int count = model.getColumnCount();
        String selectedColumns = "";
        for (int i = 0; i < count; ++i) {
            int size = this.tbPlan.getColumnModel().getColumn(i).getWidth();
            selectedColumns = selectedColumns + "[" + model.getColumnID(i) + "," + size + "]";
        }
        Settings.getDefault().setSetting("day.columns", selectedColumns);
        Settings.getDefault().setSetting("day.sortedColumn", "" + model.getSortedColumn() + model.getSortedOrder());
    }

    void loadSetup() {
        DayTableModel model = (DayTableModel)this.tbPlan.getModel();
        String selectedColumns = (String)Settings.getDefault().getSetting("day.columns");
        if (selectedColumns == null) {
            model.setSelectedColumn(0, true);
            model.setSelectedColumn(1, true);
            model.setSelectedColumn(2, true);
            model.setSelectedColumn(3, true);
            model.setSortedColumn(0, false);
            model.setSortedColumn(0, true);
            model.fireTableStructureChanged();
            this.tbPlan.getColumnModel().getColumn(1).setPreferredWidth(240);
            this.tbPlan.getColumnModel().getColumn(3).setPreferredWidth(100);
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(selectedColumns, "[");
        Vector<Integer> widths = new Vector<Integer>();
        while (tokenizer.hasMoreElements()) {
            String columnData = (String)tokenizer.nextElement();
            model.setSelectedColumn(Integer.parseInt(columnData.substring(0, 1)), true);
            widths.add(Integer.valueOf(columnData.substring(2, columnData.length() - 1)));
        }
        model.fireTableStructureChanged();
        String sortedColumn = (String)Settings.getDefault().getSetting("day.sortedColumn");
        if (sortedColumn != null) {
            model.setSortedColumn(Integer.parseInt(sortedColumn.substring(0, 1)), false);
            if (sortedColumn.substring(1).indexOf("-") != -1) {
                model.setSortedColumn(Integer.parseInt(sortedColumn.substring(0, 1)), true);
            }
            model.fireTableStructureChanged();
        }
        int count = widths.size();
        for (int i = 0; i < count; ++i) {
            Integer width = (Integer)widths.get(i);
            this.tbPlan.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
    }

    public void pauseTask() {
        this.btRelaxActionPerformed(null);
    }

    public void startTask() {
        this.btWorkActionPerformed(null);
    }

    public void finishTask() {
        this.btDoneActionPerformed(null);
    }

    public void selectTask(Task task) {
        Boolean checkPriorities = (Boolean)Settings.getDefault().getSetting("checkPriority");
        if (checkPriorities & this.day.existsMorePriorityTask(task.getPriority())) {
            Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
            int ignorePriority = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.IGNORE_PRIORITY"), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[0]);
            if (ignorePriority != 0) {
                return;
            }
        }
        this.setTask(task, true);
        this.checkButtons();
    }

    private void switchAfterNight() {
        class NightSwitch
        extends Thread {
            DayView dayView = null;

            public NightSwitch(DayView dayView) {
                this.dayView = dayView;
            }

            @Override
            public void run() {
                Task newTask;
                boolean runningTask;
                try {
                    NightSwitch.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Clock.getDefault().suspendClock();
                boolean bl = runningTask = DayView.this.task != null && DayView.this.task.isRunning();
                if (runningTask) {
                    DayView.this.task.suspendWork();
                    DayView.this.task.removePropertyChangeListener(this.dayView);
                } else {
                    DayView.this.day.getIdleTask().suspendWork();
                    DayView.this.day.getIdleTask().removePropertyChangeListener(this.dayView);
                }
                Boolean moveUnfinishedTasks = (Boolean)Settings.getDefault().getSetting("moveUnfinished");
                if (moveUnfinishedTasks.booleanValue()) {
                    Plan.getDefault().copyUnfinishedTasks();
                }
                DayView.this.setDay(Plan.getDefault().getDayAfter(DayView.this.day));
                Task task = newTask = DayView.this.task != null ? DayView.this.day.getTask(DayView.this.task.getDescription()) : null;
                if (newTask != null) {
                    DayView.this.setTask(newTask, runningTask);
                } else {
                    DayView.this.task = null;
                }
                if (!runningTask) {
                    DayView.this.checkButtons();
                    DayView.this.txtTask.setText(null);
                    Task idleTimeTask = DayView.this.day.getIdleTask();
                    idleTimeTask.startWork();
                    idleTimeTask.addPropertyChangeListener(this.dayView);
                }
                Clock.getDefault().resumeClock();
                System.setProperty("ignoreInactivity", "false");
            }
        }
        NightSwitch nightSwitch = new NightSwitch(this);
        nightSwitch.start();
    }
}

