/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class DayTableModel
extends AbstractTableModel {
    public static final int TASK_PRIORITY = 0;
    public static final int TASK_DESCRIPTION = 1;
    public static final int TASK_DURATION = 2;
    public static final int TASK_STATE = 3;
    public static final int TASK_REGULAR = 4;
    public static final int TASK_NOTIFICATION = 5;
    public static final int TASK_KEYWORD = 6;
    public static final int TASK_PRIVATE = 7;
    public static final int TASK_NONE = -1;
    private int sortedColumn;
    private boolean sortedAscending;
    Hashtable columns;
    private Day day;
    String[] columnNames = new String[]{Translator.getTranslation("TASK_PRIORITY"), Translator.getTranslation("TASK_DESCRIPTION"), Translator.getTranslation("TASK_DURATION"), Translator.getTranslation("TASK_STATE"), Translator.getTranslation("TASK_REGULAR"), Translator.getTranslation("TASK_NOTIFICATION"), Translator.getTranslation("TASK_KEYWORD"), Translator.getTranslation("TASK_PRIVATE")};

    public DayTableModel(Day day) {
        this.setDay(day);
        this.columns = new Hashtable();
        this.setSelectedColumn(0, false);
        this.setSelectedColumn(1, false);
        this.setSelectedColumn(2, false);
        this.setSelectedColumn(3, false);
        this.setSelectedColumn(4, false);
        this.setSelectedColumn(5, false);
        this.setSelectedColumn(6, false);
        this.setSelectedColumn(7, false);
        this.sortedColumn = -1;
        this.sortedAscending = false;
    }

    public void setDay(Day day) {
        this.day = day;
    }

    @Override
    public int getColumnCount() {
        int length = this.columnNames.length;
        int count = 0;
        for (int i = 0; i < length; ++i) {
            Boolean state = (Boolean)this.columns.get(new Integer(i));
            if (!state.booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public String[] getAllColumnNames() {
        return this.columnNames;
    }

    @Override
    public int getRowCount() {
        Boolean displayFinishedTasks = (Boolean)Settings.getDefault().getSetting("displayFinishedTasks");
        Vector tasks = this.day.getTasks();
        int count = tasks.size();
        if (displayFinishedTasks.booleanValue()) {
            return count;
        }
        int openTasks = 0;
        for (int i = 0; i < count; ++i) {
            Task task = (Task)tasks.get(i);
            if (task.getState() == Task.STATE_DONE) continue;
            ++openTasks;
        }
        return openTasks;
    }

    public Class getColumnClass(int column) {
        switch (this.getColumnID(column)) {
            case 4: {
                return Boolean.class;
            }
            case 7: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Task task = this.getTask(row);
        switch (this.getColumnID(column)) {
            case 0: {
                return Task.getPriority(task.getPriority());
            }
            case 1: {
                return task.getDescription();
            }
            case 2: {
                return Tools.getTime(task.getDuration());
            }
            case 3: {
                return Task.getState(task.getState());
            }
            case 4: {
                return new Boolean(task instanceof RegularTask);
            }
            case 5: {
                Date notification = task.getNotificationTime();
                return notification == null ? "N/A" : Tools.getTime(notification);
            }
            case 6: {
                return task.getKeyword();
            }
            case 7: {
                return new Boolean(task.privateTask());
            }
        }
        return "N/A";
    }

    @Override
    public String getColumnName(int column) {
        int columnID = this.getColumnID(column);
        String name = this.columnNames[columnID];
        if (columnID == this.sortedColumn) {
            name = name + (this.sortedAscending ? " [+]" : " [-]");
        }
        return name;
    }

    public int getColumnID(int column) {
        int length = this.columnNames.length;
        int selectedColumns = 0;
        for (int i = 0; i < length; ++i) {
            if (!this.isSelectedColumn(i)) continue;
            if (selectedColumns == column) {
                selectedColumns = i;
                break;
            }
            ++selectedColumns;
        }
        return selectedColumns;
    }

    public boolean isSelectedColumn(int columnID) {
        Boolean state = (Boolean)this.columns.get(new Integer(columnID));
        return state;
    }

    public void setSelectedColumn(int columnID, boolean state) {
        this.columns.remove(new Integer(columnID));
        this.columns.put(new Integer(columnID), new Boolean(state));
    }

    public int getAllColumnsCount() {
        return this.columns.size();
    }

    public void setSortedColumn(int column, boolean changeOrder) {
        if ((column = this.getColumnID(column)) == this.sortedColumn) {
            if (changeOrder) {
                this.sortedAscending = !this.sortedAscending;
            }
        } else {
            this.sortedColumn = column;
            this.sortedAscending = true;
        }
        this.day.sortTasks(this.sortedColumn, this.sortedAscending);
    }

    public void resortRows() {
        this.setSortedColumn(this.sortedColumn, false);
    }

    public Task getTask(int row) {
        Boolean displayFinishedTasks = (Boolean)Settings.getDefault().getSetting("displayFinishedTasks");
        Vector tasks = this.day.getTasks();
        Vector visibleTasks = new Vector();
        if (displayFinishedTasks.booleanValue()) {
            visibleTasks = tasks;
        } else {
            int count = tasks.size();
            for (int i = 0; i < count; ++i) {
                Task task = (Task)tasks.get(i);
                if (task.getState() == Task.STATE_DONE) continue;
                visibleTasks.add(task);
            }
        }
        return (Task)visibleTasks.get(row);
    }

    public int getRow(Task task) {
        Boolean displayFinishedTasks = (Boolean)Settings.getDefault().getSetting("displayFinishedTasks");
        Vector tasks = this.day.getTasks();
        Vector visibleTasks = new Vector();
        if (displayFinishedTasks.booleanValue()) {
            visibleTasks = tasks;
        } else {
            int count = tasks.size();
            for (int i = 0; i < count; ++i) {
                Task indexedTask = (Task)tasks.get(i);
                if (indexedTask.getState() == Task.STATE_DONE) continue;
                visibleTasks.add(indexedTask);
            }
        }
        return visibleTasks.indexOf(task);
    }

    public int getSortedColumn() {
        int length = this.columnNames.length;
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (i == this.sortedColumn) {
                return count;
            }
            if (!this.isSelectedColumn(i)) continue;
            ++count;
        }
        return 0;
    }

    public String getSortedOrder() {
        return this.sortedAscending ? "+" : "-";
    }
}

