/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core;

import java.util.Vector;
import org.cesilko.rachota.core.ClockListener;

public class Clock
extends Thread {
    private long tick;
    private Vector listeners = new Vector();
    private boolean ticking;
    private static Clock clock;

    public static Clock getDefault() {
        if (clock == null) {
            clock = new Clock(1000L);
        }
        return clock;
    }

    private Clock(long tick) {
        this.setTick(tick);
        this.resumeClock();
    }

    public void setTick(long tick) {
        this.tick = tick;
    }

    public synchronized void addListener(ClockListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeListener(ClockListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Clock.sleep(this.tick);
            }
            catch (InterruptedException e) {
                System.out.println("Warning: System clock terminated by user.");
                e.printStackTrace();
            }
            if (!this.ticking) continue;
            Clock clock = this;
            synchronized (clock) {
                for (ClockListener listener : this.listeners) {
                    listener.tick();
                }
            }
        }
    }

    public void suspendClock() {
        this.ticking = false;
    }

    public void resumeClock() {
        this.ticking = true;
    }

    public boolean isTicking() {
        return this.ticking;
    }
}

