/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.RegularTasksTableModel;
import org.cesilko.rachota.gui.TaskDialog;
import org.cesilko.rachota.gui.Tools;

public class SettingsDialog
extends JDialog
implements PropertyChangeListener {
    private static final Logger log = Logger.getLogger(SettingsDialog.class.getName());
    private JButton btAdd;
    private JButton btCancel;
    private JButton btEdit;
    private JButton btOK;
    private JButton btRemove;
    private JCheckBox chbArchiveNotStarted;
    private JCheckBox chbCheckPriority;
    private JCheckBox chbCountPrivate;
    private JCheckBox chbDetectInactivity;
    private JCheckBox chbHoursExceeded;
    private JCheckBox chbHoursNotReached;
    private JCheckBox chbLogEvents;
    private JCheckBox chbMoveUnfinished;
    private JCheckBox chbPopupGroupByKeyword;
    private JCheckBox chbReportActivity;
    private JCheckBox chbUploadDiary;
    private JComboBox cmbHibernationAction;
    private JComboBox cmbInactivityAction;
    private JComboBox cmbOnExitAction;
    private JLabel lbOnExit;
    private JLabel lblHibernationAction;
    private JLabel lblHibernationTime;
    private JLabel lblHours;
    private JLabel lblInactivityAction;
    private JLabel lblInactivityTime;
    private JLabel lblProxyHost;
    private JLabel lblProxyPort;
    private JLabel lblUploadURL;
    private JLabel lblUploadUsername;
    private JLabel lblWarn;
    private JLabel lblWorkingHours;
    private JPanel pnButtons;
    private JPanel pnGeneral;
    private JPanel pnInteraction;
    private JPanel pnNetwork;
    private JPanel pnRegularTasks;
    private JScrollPane spRegularTasks;
    private JTable tbRegularTasks;
    private JTabbedPane tpPanels;
    private JFormattedTextField txtHibernationTime;
    private JFormattedTextField txtHours;
    private JFormattedTextField txtInactivityTime;
    private JTextField txtProxyHost;
    private JFormattedTextField txtProxyPort;
    private JTextField txtUploadURL;
    private JTextField txtUploadUsername;
    private Vector regularTasks = (Vector)Plan.getDefault().getRegularTasks().clone();

    public SettingsDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.txtHours.setValue(Settings.getDefault().getWorkingHours());
        this.chbHoursNotReached.setSelected((Boolean)Settings.getDefault().getSetting("warnHoursNotReached"));
        this.chbHoursExceeded.setSelected((Boolean)Settings.getDefault().getSetting("warnHoursExceeded"));
        this.chbMoveUnfinished.setSelected((Boolean)Settings.getDefault().getSetting("moveUnfinished"));
        this.chbArchiveNotStarted.setSelected((Boolean)Settings.getDefault().getSetting("archiveNotStarted"));
        this.chbCheckPriority.setSelected((Boolean)Settings.getDefault().getSetting("checkPriority"));
        this.chbCountPrivate.setSelected((Boolean)Settings.getDefault().getSetting("countPrivateTasks"));
        this.chbReportActivity.setSelected((Boolean)Settings.getDefault().getSetting("reportActivity"));
        this.chbDetectInactivity.setSelected((Boolean)Settings.getDefault().getSetting("detectInactivity"));
        this.chbPopupGroupByKeyword.setSelected((Boolean)Settings.getDefault().getSetting("popupGroupByKeyword"));
        this.cmbInactivityAction.addItem(Translator.getTranslation("SETTINGSDIALOG.INACTIVITY_ACTION_NOTIFY"));
        this.cmbInactivityAction.addItem(Translator.getTranslation("SETTINGSDIALOG.INACTIVITY_ACTION_ASK"));
        this.cmbInactivityAction.addItem(Translator.getTranslation("SETTINGSDIALOG.INACTIVITY_ACTION_STOP"));
        int selectedInactivityAction = Integer.parseInt((String)Settings.getDefault().getSetting("inactivityAction"));
        this.cmbInactivityAction.setSelectedIndex(selectedInactivityAction);
        String[] hibernationActionKeys = new String[]{"SETTINGSDIALOG.HIBERNATION_ACTION_IGNORE", "SETTINGSDIALOG.HIBERNATION_ACTION_INCLUDE", "SETTINGSDIALOG.HIBERNATION_ACTION_ASK"};
        for (int i = 0; i < hibernationActionKeys.length; ++i) {
            String item = Translator.getTranslation(hibernationActionKeys[i]);
            this.cmbHibernationAction.addItem(item);
        }
        int selectedHibernationAction = Integer.parseInt((String)Settings.getDefault().getSetting("hibernationAction"));
        this.cmbHibernationAction.setSelectedIndex(selectedHibernationAction);
        this.cmbOnExitAction.addItem(Translator.getTranslation("SETTINGSDIALOG.ON_EXIT_ACTION_ASK_USER"));
        this.cmbOnExitAction.addItem(Translator.getTranslation("SETTINGSDIALOG.ON_EXIT_ACTION_STOP"));
        int selectedOnExitAction = Integer.parseInt((String)Settings.getDefault().getSetting("onExitAction"));
        this.cmbOnExitAction.setSelectedIndex(selectedOnExitAction);
        this.txtProxyHost.setText("" + Settings.getDefault().getSetting("proxyHost"));
        this.txtProxyPort.setText("" + Settings.getDefault().getSetting("proxyPort"));
        this.txtInactivityTime.setValue(Integer.valueOf(Settings.getDefault().getSetting("inactivityTime").toString()));
        this.chbDetectInactivityActionPerformed(null);
        this.txtHibernationTime.setValue(Integer.valueOf(Settings.getDefault().getSetting("hibernationTime").toString()));
        this.chbLogEvents.setSelected((Boolean)Settings.getDefault().getSetting("logTaskEvents"));
        String uploadDiary = (String)Settings.getDefault().getSetting("uploadDiary");
        this.chbUploadDiary.setSelected(uploadDiary.equals(Settings.UPLOAD_ON));
        this.txtUploadURL.setText((String)Settings.getDefault().getSetting("uploadDiaryURL"));
        this.txtUploadUsername.setText((String)Settings.getDefault().getSetting("uploadDiaryUsername"));
        this.chbUploadDiaryActionPerformed(null);
        this.tbRegularTasks.setSelectionMode(0);
        this.tbRegularTasks.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.tbRegularTasks.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.tbRegularTasks.getTableHeader().setForeground(Color.BLUE);
        this.tbRegularTasks.getTableHeader().setBackground(Color.LIGHT_GRAY);
        this.tbRegularTasks.getTableHeader().setFont(this.getFont());
        this.tbRegularTasks.setFont(this.getFont());
        this.tbRegularTasks.setRowHeight(this.getFont().getSize() + 2);
        this.tbRegularTasks.getTableHeader().addMouseListener(new MouseAdapter(){
            Point pressedPoint;

            @Override
            public void mousePressed(MouseEvent e) {
                this.pressedPoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.getPoint().equals(this.pressedPoint)) {
                    return;
                }
                int column = SettingsDialog.this.tbRegularTasks.getTableHeader().columnAtPoint(e.getPoint());
                RegularTasksTableModel regularTasksTableModel = (RegularTasksTableModel)SettingsDialog.this.tbRegularTasks.getModel();
                SettingsDialog.this.regularTasks = regularTasksTableModel.sortTable(column);
                int columns = SettingsDialog.this.tbRegularTasks.getColumnCount();
                for (int i = 0; i < columns; ++i) {
                    SettingsDialog.this.tbRegularTasks.getColumnModel().getColumn(i).setHeaderValue(regularTasksTableModel.getColumnName(i));
                }
            }
        });
        this.getRootPane().setDefaultButton(this.btOK);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        this.tpPanels = new JTabbedPane();
        this.pnGeneral = new JPanel();
        this.lblWorkingHours = new JLabel();
        this.txtHours = new JFormattedTextField();
        this.lblHours = new JLabel();
        this.lblWarn = new JLabel();
        this.chbHoursNotReached = new JCheckBox();
        this.chbHoursExceeded = new JCheckBox();
        this.chbMoveUnfinished = new JCheckBox();
        this.chbArchiveNotStarted = new JCheckBox();
        this.chbCheckPriority = new JCheckBox();
        this.chbCountPrivate = new JCheckBox();
        this.chbLogEvents = new JCheckBox();
        this.chbPopupGroupByKeyword = new JCheckBox();
        this.pnRegularTasks = new JPanel();
        this.spRegularTasks = new JScrollPane();
        this.tbRegularTasks = new JTable();
        this.pnButtons = new JPanel();
        this.btAdd = new JButton();
        this.btEdit = new JButton();
        this.btRemove = new JButton();
        this.pnInteraction = new JPanel();
        this.chbDetectInactivity = new JCheckBox();
        this.lblInactivityTime = new JLabel();
        this.txtInactivityTime = new JFormattedTextField();
        this.lblInactivityAction = new JLabel();
        this.cmbInactivityAction = new JComboBox();
        this.lblHibernationTime = new JLabel();
        this.txtHibernationTime = new JFormattedTextField();
        this.lblHibernationAction = new JLabel();
        this.cmbHibernationAction = new JComboBox();
        this.lbOnExit = new JLabel();
        this.lbOnExit.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_ON_EXIT"));
        this.lbOnExit.setFont(this.getFont());
        this.cmbOnExitAction = new JComboBox();
        this.pnNetwork = new JPanel();
        this.chbReportActivity = new JCheckBox();
        this.lblProxyHost = new JLabel();
        this.txtProxyHost = new JTextField();
        this.lblProxyPort = new JLabel();
        this.txtProxyPort = new JFormattedTextField();
        this.chbUploadDiary = new JCheckBox();
        this.lblUploadUsername = new JLabel();
        this.txtUploadUsername = new JTextField();
        this.lblUploadURL = new JLabel();
        this.txtUploadURL = new JTextField();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(Translator.getTranslation("SETTINGSDIALOG.TITLE"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SettingsDialog.this.formMouseEntered(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.tpPanels.setFont(this.getFont());
        this.pnGeneral.setLayout(new GridBagLayout());
        this.lblWorkingHours.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_WORKING_HOURS"));
        this.lblWorkingHours.setFont(this.getFont());
        this.lblWorkingHours.setLabelFor(this.txtHours);
        this.lblWorkingHours.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_WORKING_HOURS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.lblWorkingHours, gridBagConstraints);
        this.txtHours.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0"))));
        this.txtHours.setText("8.5");
        this.txtHours.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.TXT_HOURS_TOOLTIP"));
        this.txtHours.setFont(this.getFont());
        this.txtHours.setMinimumSize(new Dimension(30, 20));
        this.txtHours.setPreferredSize(new Dimension(30, 20));
        this.txtHours.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.txtHoursKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.txtHours, gridBagConstraints);
        this.lblHours.setFont(this.getFont());
        this.lblHours.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_HOURS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.lblHours, gridBagConstraints);
        this.lblWarn.setFont(this.getFont());
        this.lblWarn.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_WARN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.lblWarn, gridBagConstraints);
        this.chbHoursNotReached.setFont(this.getFont());
        this.chbHoursNotReached.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_HOURS_NOT_REACHED"));
        this.chbHoursNotReached.setSelected(true);
        this.chbHoursNotReached.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_HOURS_NOT_REACHED"));
        this.chbHoursNotReached.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_HOURS_NOT_REACHED_TOOLTIP"));
        this.chbHoursNotReached.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbHoursNotReachedKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.chbHoursNotReached, gridBagConstraints);
        this.chbHoursExceeded.setFont(this.getFont());
        this.chbHoursExceeded.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_HOURS_EXCEEDED"));
        this.chbHoursExceeded.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_HOURS_EXCEEDED"));
        this.chbHoursExceeded.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_HOURS_EXCEEDED_TOOLTIP"));
        this.chbHoursExceeded.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbHoursExceededKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.chbHoursExceeded, gridBagConstraints);
        this.chbMoveUnfinished.setFont(this.getFont());
        this.chbMoveUnfinished.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_MOVE_UNFINISHED"));
        this.chbMoveUnfinished.setSelected(true);
        this.chbMoveUnfinished.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_MOVE_UNFINISHED"));
        this.chbMoveUnfinished.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_MOVE_UNFINISHED_TOOLTIP"));
        this.chbMoveUnfinished.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbMoveUnfinishedKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.chbMoveUnfinished, gridBagConstraints);
        this.chbArchiveNotStarted.setFont(this.getFont());
        this.chbArchiveNotStarted.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_ARCHIVE_NOT_STARTED"));
        this.chbArchiveNotStarted.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_ARCHIVE_NOT_STARTED"));
        this.chbArchiveNotStarted.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_ARCHIVE_NOT_STARTED_TOOLTIP"));
        this.chbArchiveNotStarted.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbArchiveNotStartedKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.chbArchiveNotStarted, gridBagConstraints);
        this.chbCheckPriority.setFont(this.getFont());
        this.chbCheckPriority.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_CHECK_PRIORITY"));
        this.chbCheckPriority.setSelected(true);
        this.chbCheckPriority.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_CHECK_PRIORITY"));
        this.chbCheckPriority.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_CHECK_PRIORITY_TOOLTIP"));
        this.chbCheckPriority.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbCheckPriorityKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.chbCheckPriority, gridBagConstraints);
        this.chbCountPrivate.setFont(this.getFont());
        this.chbCountPrivate.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_COUNT_PRIVATE"));
        this.chbCountPrivate.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_COUNT_PRIVATE"));
        this.chbCountPrivate.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_COUNT_PRIVATE_TOOLTIP"));
        this.chbCountPrivate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbCountPrivateKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.chbCountPrivate, gridBagConstraints);
        this.chbLogEvents.setFont(this.getFont());
        this.chbLogEvents.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_LOG_EVENTS"));
        this.chbLogEvents.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_LOG_EVENTS"));
        this.chbLogEvents.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_LOG_EVENTS_TOOLTIP"));
        this.chbLogEvents.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbLogEventsKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.chbLogEvents, gridBagConstraints);
        this.chbPopupGroupByKeyword.setFont(this.getFont());
        this.chbPopupGroupByKeyword.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_POPUP_GROUPBY_KEYWORD"));
        this.chbPopupGroupByKeyword.setSelected((Boolean)Settings.getDefault().getSetting("popupGroupByKeyword"));
        this.chbPopupGroupByKeyword.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_POPUP_GROUPBY_KEYWORD"));
        this.chbPopupGroupByKeyword.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_POPUP_GROUPBY_KEYWORD_TOOLTIP"));
        this.chbPopupGroupByKeyword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbPopupGroupByKeywordKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnGeneral.add((Component)this.chbPopupGroupByKeyword, gridBagConstraints);
        this.tpPanels.addTab(Translator.getTranslation("SETTINGSDIALOG.BORDER_GENERAL"), this.pnGeneral);
        this.pnRegularTasks.setLayout(new GridBagLayout());
        this.spRegularTasks.setPreferredSize(new Dimension(300, 100));
        this.spRegularTasks.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.spRegularTasksKeyPressed(evt);
            }
        });
        this.tbRegularTasks.setFont(this.getFont());
        this.tbRegularTasks.setModel(new RegularTasksTableModel(this.regularTasks));
        this.tbRegularTasks.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SettingsDialog.this.tbRegularTasksKeyReleased(evt);
            }
        });
        this.tbRegularTasks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SettingsDialog.this.tbRegularTasksMouseClicked(evt);
            }
        });
        this.spRegularTasks.setViewportView(this.tbRegularTasks);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnRegularTasks.add((Component)this.spRegularTasks, gridBagConstraints);
        this.btAdd.setFont(this.getFont());
        this.btAdd.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.BT_ADD"));
        this.btAdd.setText(Translator.getTranslation("SETTINGSDIALOG.BT_ADD"));
        this.btAdd.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.BT_ADD_TOOLTIP"));
        this.btAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.btAddActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btAdd);
        this.btEdit.setFont(this.getFont());
        this.btEdit.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.BT_EDIT"));
        this.btEdit.setText(Translator.getTranslation("SETTINGSDIALOG.BT_EDIT"));
        this.btEdit.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.BT_EDIT_TOOLTIP"));
        this.btEdit.setEnabled(false);
        this.btEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.btEditActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btEdit);
        this.btRemove.setFont(this.getFont());
        this.btRemove.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.BT_REMOVE"));
        this.btRemove.setText(Translator.getTranslation("SETTINGSDIALOG.BT_REMOVE"));
        this.btRemove.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.BT_REMOVE_TOOLTIP"));
        this.btRemove.setEnabled(false);
        this.btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.btRemoveActionPerformed(evt);
            }
        });
        this.pnButtons.add(this.btRemove);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnRegularTasks.add((Component)this.pnButtons, gridBagConstraints);
        this.tpPanels.addTab(Translator.getTranslation("SETTINGSDIALOG.BORDER_REGULAR_TASKS"), this.pnRegularTasks);
        this.pnInteraction.setLayout(new GridBagLayout());
        this.chbDetectInactivity.setFont(this.getFont());
        this.chbDetectInactivity.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_DETECT_INACTIVITY"));
        this.chbDetectInactivity.setSelected(true);
        this.chbDetectInactivity.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_DETECT_INACTIVITY"));
        this.chbDetectInactivity.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_DETECT_INACTIVITY_TOOLTIP"));
        this.chbDetectInactivity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.chbDetectInactivityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.chbDetectInactivity, gridBagConstraints);
        this.lblInactivityTime.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_INACTIVITY_TIME"));
        this.lblInactivityTime.setFont(this.getFont());
        this.lblInactivityTime.setLabelFor(this.txtInactivityTime);
        this.lblInactivityTime.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_INACTIVITY_TIME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.lblInactivityTime, gridBagConstraints);
        this.txtInactivityTime.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtInactivityTime.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.TXT_INACTIVITY_TIME_TOOLTIP"));
        this.txtInactivityTime.setFont(this.getFont());
        this.txtInactivityTime.setMinimumSize(new Dimension(40, 20));
        this.txtInactivityTime.setPreferredSize(new Dimension(40, 20));
        this.txtInactivityTime.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.txtInactivityTimeKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.txtInactivityTime, gridBagConstraints);
        this.lblInactivityAction.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_INACTIVITY_ACTION"));
        this.lblInactivityAction.setFont(this.getFont());
        this.lblInactivityAction.setLabelFor(this.cmbInactivityAction);
        this.lblInactivityAction.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_INACTIVITY_ACTION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.lblInactivityAction, gridBagConstraints);
        this.cmbInactivityAction.setFont(this.getFont());
        this.cmbInactivityAction.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CMB_INACTIVITY_ACTION_TOOLTIP"));
        this.cmbInactivityAction.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.cmbInactivityActionKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.cmbInactivityAction, gridBagConstraints);
        this.lblHibernationTime.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_HIBERNATION_TIME"));
        this.lblHibernationTime.setFont(this.getFont());
        this.lblHibernationTime.setLabelFor(this.txtHibernationTime);
        this.lblHibernationTime.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_HIBERNATION_TIME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.lblHibernationTime, gridBagConstraints);
        this.txtHibernationTime.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtHibernationTime.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.TXT_HIBERNATION_TIME_TOOLTIP"));
        this.txtHibernationTime.setFont(this.getFont());
        this.txtHibernationTime.setMinimumSize(new Dimension(40, 20));
        this.txtHibernationTime.setPreferredSize(new Dimension(40, 20));
        this.txtHibernationTime.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.txtHibernationTimeKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.txtHibernationTime, gridBagConstraints);
        this.lblHibernationAction.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_HIBERNATION_ACTION"));
        this.lblHibernationAction.setFont(this.getFont());
        this.lblHibernationAction.setLabelFor(this.cmbHibernationAction);
        this.lblHibernationAction.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_HIBERNATION_ACTION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.lblHibernationAction, gridBagConstraints);
        this.cmbHibernationAction.setFont(this.getFont());
        this.cmbHibernationAction.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CMB_HIBERNATION_ACTION_TOOLTIP"));
        this.cmbHibernationAction.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.cmbHibernationActionKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.cmbHibernationAction, gridBagConstraints);
        this.lbOnExit.setFont(this.getFont());
        this.lbOnExit.setLabelFor(this.cmbOnExitAction);
        this.lbOnExit.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_ON_EXIT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.lbOnExit, gridBagConstraints);
        this.cmbOnExitAction.setFont(this.getFont());
        this.cmbOnExitAction.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CMB_ON_EXIT_ACTION_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnInteraction.add((Component)this.cmbOnExitAction, gridBagConstraints);
        this.tpPanels.addTab(Translator.getTranslation("SETTINGSDIALOG.BORDER_INTERACTION"), this.pnInteraction);
        this.pnNetwork.setLayout(new GridBagLayout());
        this.chbReportActivity.setFont(this.getFont());
        this.chbReportActivity.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_REPORT_ACTIVITY"));
        this.chbReportActivity.setSelected(true);
        this.chbReportActivity.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_REPORT_ACTIVITY"));
        this.chbReportActivity.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_REPORT_ACTIVITY_TOOLTIP"));
        this.chbReportActivity.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbReportActivityKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.chbReportActivity, gridBagConstraints);
        this.lblProxyHost.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_PROXY_HOST"));
        this.lblProxyHost.setFont(this.getFont());
        this.lblProxyHost.setLabelFor(this.txtProxyHost);
        this.lblProxyHost.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_PROXY_HOST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.lblProxyHost, gridBagConstraints);
        this.txtProxyHost.setFont(this.getFont());
        this.txtProxyHost.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.TXT_PROXY_HOST_TOOLTIP"));
        this.txtProxyHost.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.txtProxyHostKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.txtProxyHost, gridBagConstraints);
        this.lblProxyPort.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_PROXY_PORT"));
        this.lblProxyPort.setFont(this.getFont());
        this.lblProxyPort.setLabelFor(this.txtProxyPort);
        this.lblProxyPort.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_PROXY_PORT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.lblProxyPort, gridBagConstraints);
        this.txtProxyPort.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtProxyPort.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.TXT_PROXY_PORT_TOOLTIP"));
        this.txtProxyPort.setFont(this.getFont());
        this.txtProxyPort.setMinimumSize(new Dimension(40, 20));
        this.txtProxyPort.setPreferredSize(new Dimension(40, 20));
        this.txtProxyPort.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.txtProxyPortKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.txtProxyPort, gridBagConstraints);
        this.chbUploadDiary.setFont(this.getFont());
        this.chbUploadDiary.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.CHB_UPLOAD_DIARIES"));
        this.chbUploadDiary.setText(Translator.getTranslation("SETTINGSDIALOG.CHB_UPLOAD_DIARIES"));
        this.chbUploadDiary.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.CHB_UPLOAD_DIARIES_TOOLTIP"));
        this.chbUploadDiary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.chbUploadDiaryActionPerformed(evt);
            }
        });
        this.chbUploadDiary.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chbUploadDiaryKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.chbUploadDiary, gridBagConstraints);
        this.lblUploadUsername.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_USERNAME"));
        this.lblUploadUsername.setFont(this.getFont());
        this.lblUploadUsername.setLabelFor(this.txtUploadUsername);
        this.lblUploadUsername.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_USERNAME"));
        this.lblUploadUsername.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.lblUploadUsername, gridBagConstraints);
        this.txtUploadUsername.setFont(this.getFont());
        this.txtUploadUsername.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.LBL_USERNAME_TOOLTIP"));
        this.txtUploadUsername.setEnabled(false);
        this.txtUploadUsername.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.txtUploadUsernameKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.txtUploadUsername, gridBagConstraints);
        this.lblUploadURL.setDisplayedMnemonic(Translator.getMnemonic("SETTINGSDIALOG.LBL_UPLOAD_URL"));
        this.lblUploadURL.setFont(this.getFont());
        this.lblUploadURL.setLabelFor(this.txtUploadURL);
        this.lblUploadURL.setText(Translator.getTranslation("SETTINGSDIALOG.LBL_UPLOAD_URL"));
        this.lblUploadURL.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.lblUploadURL, gridBagConstraints);
        this.txtUploadURL.setFont(this.getFont());
        this.txtUploadURL.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.LBL_UPLOAD_URL_TOOLTIP"));
        this.txtUploadURL.setEnabled(false);
        this.txtUploadURL.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.txtUploadURLKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnNetwork.add((Component)this.txtUploadURL, gridBagConstraints);
        this.tpPanels.addTab(Translator.getTranslation("SETTINGSDIALOG.BORDER_NETWORK"), this.pnNetwork);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.tpPanels, gridBagConstraints);
        this.btOK.setFont(this.getFont());
        this.btOK.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.BT_OK"));
        this.btOK.setText(Translator.getTranslation("SETTINGSDIALOG.BT_OK"));
        this.btOK.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.BT_OK_TOOLTIP"));
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.btOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btOK, gridBagConstraints);
        this.btCancel.setFont(this.getFont());
        this.btCancel.setMnemonic(Translator.getMnemonic("SETTINGSDIALOG.BT_CANCEL"));
        this.btCancel.setText(Translator.getTranslation("SETTINGSDIALOG.BT_CANCEL"));
        this.btCancel.setToolTipText(Translator.getTranslation("SETTINGSDIALOG.BT_CANCEL_TOOLTIP"));
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.btCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btCancel, gridBagConstraints);
        this.pack();
    }

    private void spRegularTasksKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbCountPrivateKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbCheckPriorityKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbArchiveNotStartedKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbMoveUnfinishedKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbHoursExceededKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbHoursNotReachedKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void tbRegularTasksKeyReleased(KeyEvent evt) {
        this.checkButtons();
    }

    private void btRemoveActionPerformed(ActionEvent evt) {
        int row = this.tbRegularTasks.getSelectedRow();
        RegularTask regularTask = (RegularTask)this.regularTasks.get(row);
        String description = regularTask.getDescription();
        Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO")};
        int decision = JOptionPane.showOptionDialog(this, Translator.getTranslation("QUESTION.REMOVE_REGULAR_TASK", new String[]{description}), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[0]);
        if (decision != 0) {
            return;
        }
        this.regularTasks.remove(regularTask);
        RegularTasksTableModel regularTasksTableModel = (RegularTasksTableModel)this.tbRegularTasks.getModel();
        regularTasksTableModel.fireTableDataChanged();
        this.checkButtons();
    }

    private void btEditActionPerformed(ActionEvent evt) {
        int row = this.tbRegularTasks.getSelectedRow();
        RegularTask regularTask = (RegularTask)this.regularTasks.get(row);
        TaskDialog taskDialog = new TaskDialog(regularTask);
        taskDialog.addPropertyChangeListener(this);
        taskDialog.setLocationRelativeTo(this);
        taskDialog.setVisible(true);
    }

    private void btAddActionPerformed(ActionEvent evt) {
        TaskDialog taskDialog = new TaskDialog();
        taskDialog.addPropertyChangeListener(this);
        taskDialog.setLocationRelativeTo(this);
        taskDialog.setVisible(true);
    }

    private void tbRegularTasksMouseClicked(MouseEvent evt) {
        this.checkButtons();
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
    }

    private void btOKActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
        try {
            this.txtHours.commitEdit();
            Settings.getDefault().setWorkingHours(((Number)this.txtHours.getValue()).doubleValue());
        }
        catch (ParseException ex) {
            log.log(Level.WARNING, "Unable to read the value of the working hours field as a double value, resetting value to currently saved.", ex);
            this.txtHours.setValue(Settings.getDefault().getWorkingHours());
        }
        Settings.getDefault().setSetting("warnHoursNotReached", new Boolean(this.chbHoursNotReached.isSelected()));
        Settings.getDefault().setSetting("warnHoursExceeded", new Boolean(this.chbHoursExceeded.isSelected()));
        Settings.getDefault().setSetting("moveUnfinished", new Boolean(this.chbMoveUnfinished.isSelected()));
        Settings.getDefault().setSetting("archiveNotStarted", new Boolean(this.chbArchiveNotStarted.isSelected()));
        Settings.getDefault().setSetting("checkPriority", new Boolean(this.chbCheckPriority.isSelected()));
        Settings.getDefault().setSetting("countPrivateTasks", new Boolean(this.chbCountPrivate.isSelected()));
        Settings.getDefault().setSetting("reportActivity", new Boolean(this.chbReportActivity.isSelected()));
        Settings.getDefault().setSetting("logTaskEvents", new Boolean(this.chbLogEvents.isSelected()));
        Settings.getDefault().setSetting("detectInactivity", new Boolean(this.chbDetectInactivity.isSelected()));
        try {
            this.txtInactivityTime.commitEdit();
        }
        catch (ParseException ex) {
            log.log(Level.WARNING, "Unable to parse the text in the inactivity time field, will use last valid value.", ex);
        }
        Settings.getDefault().setSetting("inactivityTime", Integer.toString(((Number)this.txtInactivityTime.getValue()).intValue()));
        Settings.getDefault().setSetting("inactivityAction", "" + this.cmbInactivityAction.getSelectedIndex());
        try {
            this.txtHibernationTime.commitEdit();
        }
        catch (ParseException ex) {
            log.log(Level.WARNING, "Unable to parse the text in the hibernation time field, will use last valid value.", ex);
        }
        Settings.getDefault().setSetting("hibernationTime", Integer.toString(((Number)this.txtHibernationTime.getValue()).intValue()));
        Settings.getDefault().setSetting("hibernationAction", "" + this.cmbHibernationAction.getSelectedIndex());
        Settings.getDefault().setSetting("onExitAction", "" + this.cmbOnExitAction.getSelectedIndex());
        Settings.getDefault().setSetting("popupGroupByKeyword", new Boolean(this.chbPopupGroupByKeyword.isSelected()));
        String proxyHost = this.txtProxyHost.getText();
        String proxyPort = this.txtProxyPort.getText();
        Settings.getDefault().setSetting("proxyHost", proxyHost);
        Settings.getDefault().setSetting("proxyPort", proxyPort);
        if (proxyHost.length() > 0) {
            System.setProperty("http.proxyHost", proxyHost);
        } else {
            System.clearProperty("http.proxyHost");
        }
        if (proxyPort.length() > 0) {
            System.setProperty("http.proxyPort", proxyPort);
        } else {
            System.clearProperty("http.proxyPort");
        }
        Settings.getDefault().setSetting("uploadDiary", this.chbUploadDiary.isSelected() ? Settings.UPLOAD_ON : Settings.UPLOAD_OFF);
        Settings.getDefault().setSetting("uploadDiaryUsername", this.txtUploadUsername.getText());
        Settings.getDefault().setSetting("uploadDiaryURL", this.txtUploadURL.getText());
        Plan.getDefault().getRegularTasks().clear();
        for (RegularTask regularTask : this.regularTasks) {
            Plan.getDefault().addRegularTask(regularTask);
        }
        this.firePropertyChange("settings", null, Settings.getDefault());
        Plan.saveRegularTasks();
        Settings.saveSettings();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    private void chbReportActivityKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtProxyHostKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbLogEventsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void formMouseEntered(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void txtInactivityTimeKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbDetectInactivityActionPerformed(ActionEvent evt) {
        this.lblInactivityTime.setEnabled(this.chbDetectInactivity.isSelected());
        this.txtInactivityTime.setEnabled(this.chbDetectInactivity.isSelected());
        this.lblInactivityAction.setEnabled(this.chbDetectInactivity.isSelected());
        this.cmbInactivityAction.setEnabled(this.chbDetectInactivity.isSelected());
    }

    private void txtHibernationTimeKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void cmbInactivityActionKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void cmbHibernationActionKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbPopupGroupByKeywordKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtHoursKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtProxyPortKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void chbUploadDiaryActionPerformed(ActionEvent evt) {
        boolean uploadDiaries = this.chbUploadDiary.isSelected();
        this.lblUploadURL.setEnabled(uploadDiaries);
        this.txtUploadURL.setEnabled(uploadDiaries);
        this.lblUploadUsername.setEnabled(uploadDiaries);
        this.txtUploadUsername.setEnabled(uploadDiaries);
    }

    private void chbUploadDiaryKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtUploadUsernameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void txtUploadURLKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.btCancelActionPerformed(null);
        }
    }

    private void checkButtons() {
        int row = this.tbRegularTasks.getSelectedRow();
        this.btEdit.setEnabled(row != -1);
        this.btRemove.setEnabled(row != -1);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().startsWith("task_")) {
            TaskDialog taskDialog = (TaskDialog)evt.getSource();
            taskDialog.removePropertyChangeListener(this);
            this.checkButtons();
        }
        if (evt.getPropertyName().equals("task_created")) {
            Task task = (Task)evt.getNewValue();
            this.regularTasks.add(task);
        }
        RegularTasksTableModel regularTasksTableModel = (RegularTasksTableModel)this.tbRegularTasks.getModel();
        regularTasksTableModel.fireTableDataChanged();
    }
}

