/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.DayView;
import org.cesilko.rachota.gui.Tools;

public class InactivityReminderDialog
extends JDialog {
    private final DayView dayView;
    private JButton btOK;
    private JCheckBox chbIgnore;
    private JComboBox cmbOtherTask;
    private JLabel lbColumn1;
    private JLabel lbColumn2;
    private JLabel lblInactivityMessage;
    private JLabel lblInactivityQuestion;
    private JLabel lblOtherTaskTime;
    private JRadioButton rbContinue;
    private JRadioButton rbNothing;
    private JRadioButton rbOtherTask;
    private JSpinner spHours;
    private JSpinner spMinutes;
    private JSpinner spSeconds;
    private Task currentTask;
    private Integer previousHours = new Integer(0);
    private Integer previousMinutes = new Integer(0);
    private Integer previousSeconds = new Integer(0);

    public InactivityReminderDialog(DayView dayView) {
        String inactivityAction;
        this.dayView = dayView;
        this.currentTask = dayView.getTask();
        if (this.currentTask == null) {
            this.currentTask = dayView.getDay().getIdleTask();
        } else if (!this.currentTask.isRunning()) {
            this.currentTask = dayView.getDay().getIdleTask();
        }
        this.initComponents();
        Day today = Plan.getDefault().getDay(new Date());
        if (today.getTasks().size() > 1) {
            for (Task task : today.getTasks()) {
                if (task == this.currentTask || task.isIdleTask() || task.getState() == Task.STATE_DONE) continue;
                this.cmbOtherTask.addItem(task);
                this.rbOtherTask.setEnabled(true);
            }
        }
        if (this.currentTask.isIdleTask()) {
            this.rbNothing.setVisible(false);
            this.rbContinue.setText(Translator.getTranslation("INACTIVITYDIALOG.RB_CONTINUE_IDLE"));
        }
        if ((inactivityAction = (String)Settings.getDefault().getSetting("inactivityAction")).equals("2")) {
            this.currentTask.suspendWork();
        }
        this.setLocationRelativeTo(null);
        this.requestFocus();
        System.setProperty("inactivityReminderOpen", "true");
    }

    private void checkAccess() {
        this.cmbOtherTask.setEnabled(this.rbOtherTask.isSelected());
        this.lblOtherTaskTime.setEnabled(this.rbOtherTask.isSelected());
        this.spHours.setEnabled(this.rbOtherTask.isSelected());
        this.lbColumn1.setEnabled(this.rbOtherTask.isSelected());
        this.spMinutes.setEnabled(this.rbOtherTask.isSelected());
        this.lbColumn2.setEnabled(this.rbOtherTask.isSelected());
        this.spSeconds.setEnabled(this.rbOtherTask.isSelected());
    }

    private void initComponents() {
        this.lblInactivityMessage = new JLabel();
        this.lblInactivityQuestion = new JLabel();
        this.rbContinue = new JRadioButton();
        this.rbOtherTask = new JRadioButton();
        this.cmbOtherTask = new JComboBox();
        this.lblOtherTaskTime = new JLabel();
        this.spHours = new JSpinner();
        this.lbColumn1 = new JLabel();
        this.spMinutes = new JSpinner();
        this.lbColumn2 = new JLabel();
        this.spSeconds = new JSpinner();
        this.rbNothing = new JRadioButton();
        this.chbIgnore = new JCheckBox();
        this.btOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(Translator.getTranslation("INACTIVITYDIALOG.TITLE"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                InactivityReminderDialog.this.formMouseEntered(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InactivityReminderDialog.this.formKeyPressed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblInactivityMessage.setFont(this.getFont());
        this.lblInactivityMessage.setForeground(Color.blue);
        this.lblInactivityMessage.setText(Translator.getTranslation("INACTIVITYDIALOG.LBL_INACTIVITY_MESSAGE", new String[]{(String)Settings.getDefault().getSetting("inactivityTime")}));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(20, 5, 5, 5);
        this.getContentPane().add((Component)this.lblInactivityMessage, gridBagConstraints);
        this.lblInactivityQuestion.setFont(this.getFont());
        this.lblInactivityQuestion.setText(Translator.getTranslation("INACTIVITYDIALOG.LBL_INACTIVITY_QUESTION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(5, 5, 20, 5);
        this.getContentPane().add((Component)this.lblInactivityQuestion, gridBagConstraints);
        this.rbContinue.setFont(this.getFont());
        this.rbContinue.setMnemonic(Translator.getMnemonic("INACTIVITYDIALOG.RB_CONTINUE"));
        this.rbContinue.setSelected(true);
        this.rbContinue.setText(Translator.getTranslation("INACTIVITYDIALOG.RB_CONTINUE", new String[]{this.currentTask.getDescription()}));
        this.rbContinue.setToolTipText(Translator.getTranslation("INACTIVITYDIALOG.RB_CONTINUE_TOOLTIP"));
        this.rbContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InactivityReminderDialog.this.rbContinueActionPerformed(evt);
            }
        });
        this.rbContinue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InactivityReminderDialog.this.rbContinueKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.rbContinue, gridBagConstraints);
        this.rbOtherTask.setFont(this.getFont());
        this.rbOtherTask.setMnemonic(Translator.getMnemonic("INACTIVITYDIALOG.RB_OTHER_TASK"));
        this.rbOtherTask.setText(Translator.getTranslation("INACTIVITYDIALOG.RB_OTHER_TASK"));
        this.rbOtherTask.setToolTipText(Translator.getTranslation("INACTIVITYDIALOG.RB_OTHER_TASK_TOOLTIP"));
        this.rbOtherTask.setEnabled(false);
        this.rbOtherTask.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InactivityReminderDialog.this.rbOtherTaskActionPerformed(evt);
            }
        });
        this.rbOtherTask.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InactivityReminderDialog.this.rbOtherTaskKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.rbOtherTask, gridBagConstraints);
        this.cmbOtherTask.setFont(this.getFont());
        this.cmbOtherTask.setEnabled(false);
        this.cmbOtherTask.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InactivityReminderDialog.this.cmbOtherTaskKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmbOtherTask, gridBagConstraints);
        this.lblOtherTaskTime.setFont(this.getFont());
        this.lblOtherTaskTime.setLabelFor(this.spHours);
        this.lblOtherTaskTime.setText(Translator.getTranslation("INACTIVITYDIALOG.LBL_OTHERTASK_TIME"));
        this.lblOtherTaskTime.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblOtherTaskTime, gridBagConstraints);
        this.spHours.setFont(this.getFont());
        this.spHours.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.HOURS_TOOLTIP"));
        this.spHours.setEnabled(false);
        this.spHours.setMinimumSize(new Dimension(40, 20));
        this.spHours.setPreferredSize(new Dimension(40, 20));
        this.spHours.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                InactivityReminderDialog.this.spHoursStateChanged(evt);
            }
        });
        this.spHours.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InactivityReminderDialog.this.spHoursKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spHours, gridBagConstraints);
        this.lbColumn1.setFont(this.getFont());
        this.lbColumn1.setText(":");
        this.lbColumn1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.lbColumn1, gridBagConstraints);
        this.spMinutes.setFont(this.getFont());
        this.spMinutes.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.MINUTES_TOOLTIP"));
        this.spMinutes.setEnabled(false);
        this.spMinutes.setMinimumSize(new Dimension(40, 20));
        this.spMinutes.setPreferredSize(new Dimension(40, 20));
        this.spMinutes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                InactivityReminderDialog.this.spMinutesStateChanged(evt);
            }
        });
        this.spMinutes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InactivityReminderDialog.this.spMinutesKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spMinutes, gridBagConstraints);
        this.lbColumn2.setFont(this.getFont());
        this.lbColumn2.setText(":");
        this.lbColumn2.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.lbColumn2, gridBagConstraints);
        this.spSeconds.setFont(this.getFont());
        this.spSeconds.setToolTipText(Translator.getTranslation("MOVETIMEDIALOG.SECONDS_TOOLTIP"));
        this.spSeconds.setEnabled(false);
        this.spSeconds.setMinimumSize(new Dimension(40, 20));
        this.spSeconds.setPreferredSize(new Dimension(40, 20));
        this.spSeconds.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                InactivityReminderDialog.this.spSecondsStateChanged(evt);
            }
        });
        this.spSeconds.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InactivityReminderDialog.this.spSecondsKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spSeconds, gridBagConstraints);
        this.rbNothing.setFont(this.getFont());
        this.rbNothing.setMnemonic(Translator.getMnemonic("INACTIVITYDIALOG.RB_NOTHING"));
        this.rbNothing.setText(Translator.getTranslation("INACTIVITYDIALOG.RB_NOTHING"));
        this.rbNothing.setToolTipText(Translator.getTranslation("INACTIVITYDIALOG.RB_NOTHING_TOOLTIP"));
        this.rbNothing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InactivityReminderDialog.this.rbNothingActionPerformed(evt);
            }
        });
        this.rbNothing.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InactivityReminderDialog.this.rbNothingKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.rbNothing, gridBagConstraints);
        this.chbIgnore.setFont(this.getFont());
        this.chbIgnore.setMnemonic(Translator.getMnemonic("INACTIVITYDIALOG.CHB_IGNORE"));
        this.chbIgnore.setText(Translator.getTranslation("INACTIVITYDIALOG.CHB_IGNORE"));
        this.chbIgnore.setToolTipText(Translator.getTranslation("INACTIVITYDIALOG.CHB_IGNORE_TOOLTIP"));
        this.chbIgnore.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InactivityReminderDialog.this.chbIgnoreKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.chbIgnore, gridBagConstraints);
        this.btOK.setFont(this.getFont());
        this.btOK.setMnemonic(Translator.getMnemonic("ADJUSTTIMEDIALOG.BT_OK"));
        this.btOK.setText(Translator.getTranslation("ADJUSTTIMEDIALOG.BT_OK"));
        this.btOK.setToolTipText(Translator.getTranslation("INACTIVITYDIALOG.BT_OK_TOOLTIP"));
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InactivityReminderDialog.this.btOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btOK, gridBagConstraints);
        this.pack();
    }

    private void btOKActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        System.clearProperty("inactivityReminderOpen");
        Tools.recordActivity();
        String inactivityAction = (String)Settings.getDefault().getSetting("inactivityAction");
        if (inactivityAction.equals("2")) {
            this.currentTask.startWork();
        }
        if (this.chbIgnore.isSelected()) {
            Settings.getDefault().setSetting("detectInactivity", new Boolean(false));
        }
        if (this.rbNothing.isSelected()) {
            this.dayView.pauseTask();
        }
        if (this.rbOtherTask.isSelected()) {
            long duration = this.previousHours * 1000 * 60 * 60 + this.previousMinutes * 1000 * 60 + this.previousSeconds * 1000;
            Task targetTask = (Task)this.cmbOtherTask.getSelectedItem();
            targetTask.addDuration(duration);
            targetTask.setState(Task.STATE_STARTED);
            this.currentTask.addDuration(-duration);
            this.dayView.selectTask(targetTask);
            this.addPropertyChangeListener(this.dayView);
            this.firePropertyChange("time_changed", null, null);
        }
    }

    private void spHoursStateChanged(ChangeEvent evt) {
        Integer hours = (Integer)this.spHours.getValue();
        int value = hours;
        if (value < 0 || value > 23) {
            this.spHours.setValue(this.previousHours);
        } else {
            this.checkDuration();
        }
    }

    private void spHoursKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    private void spMinutesStateChanged(ChangeEvent evt) {
        Integer minutes = (Integer)this.spMinutes.getValue();
        int value = minutes;
        if (value < 0 || value > 59) {
            this.spMinutes.setValue(this.previousMinutes);
        } else {
            this.checkDuration();
        }
    }

    private void spMinutesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    private void spSecondsStateChanged(ChangeEvent evt) {
        Integer seconds = (Integer)this.spSeconds.getValue();
        int value = seconds;
        if (value < 0 || value > 59) {
            this.spSeconds.setValue(this.previousSeconds);
        } else {
            this.checkDuration();
        }
    }

    private void spSecondsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    private void formMouseEntered(MouseEvent evt) {
        Tools.recordActivity();
    }

    private void rbContinueActionPerformed(ActionEvent evt) {
        this.rbContinue.setSelected(true);
        this.rbOtherTask.setSelected(false);
        this.rbNothing.setSelected(false);
        this.checkAccess();
    }

    private void rbOtherTaskActionPerformed(ActionEvent evt) {
        this.rbContinue.setSelected(false);
        this.rbOtherTask.setSelected(true);
        this.rbNothing.setSelected(false);
        this.checkAccess();
    }

    private void rbNothingActionPerformed(ActionEvent evt) {
        this.rbContinue.setSelected(false);
        this.rbOtherTask.setSelected(false);
        this.rbNothing.setSelected(true);
        this.checkAccess();
    }

    private void formKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    private void rbOtherTaskKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    private void cmbOtherTaskKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    private void rbNothingKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    private void chbIgnoreKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    private void rbContinueKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    private void checkDuration() {
        Integer seconds = (Integer)this.spSeconds.getValue();
        Integer minutes = (Integer)this.spMinutes.getValue();
        Integer hours = (Integer)this.spHours.getValue();
        long duration = seconds * 1000 + minutes * 1000 * 60 + hours * 1000 * 60 * 60;
        if (duration > this.currentTask.getDuration()) {
            this.spSeconds.setValue(this.previousSeconds);
            this.spMinutes.setValue(this.previousMinutes);
            this.spHours.setValue(this.previousHours);
        } else {
            this.previousSeconds = (Integer)this.spSeconds.getValue();
            this.previousMinutes = (Integer)this.spMinutes.getValue();
            this.previousHours = (Integer)this.spHours.getValue();
        }
    }
}

