/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;
import org.cesilko.rachota.gui.WizardStep;

public class GenericWizard
extends JDialog
implements PropertyChangeListener {
    private Vector steps = null;
    private int selectedStep = 0;
    private static HashMap properties = new HashMap();
    private JButton btCancel;
    private JButton btFinish;
    private JButton btNext;
    private JButton btPrevious;
    private JLabel lbLogo;
    private JLabel lbPreview;
    private JLabel lbStatus;
    private JPanel pnButtons;
    private JPanel pnOverview;
    private JPanel pnStep;
    private JPanel pnSteps;
    private JSeparator spSeparator;

    public GenericWizard(String wizardTitle) {
        this.initComponents();
        this.setTitle(wizardTitle);
        this.setModal(true);
        this.steps = new Vector();
    }

    public void addWizardStep(WizardStep wizardStep) {
        this.steps.add(wizardStep);
        this.addPropertyChangeListener(wizardStep);
        String stepDescription = wizardStep.getDescription();
        JLabel lbStep = new JLabel("" + this.steps.size() + ". " + stepDescription);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = this.steps.size();
        gridBagConstraints.anchor = 17;
        this.pnSteps.add((Component)lbStep, gridBagConstraints);
        this.selectStep(0);
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        this.pnOverview = new JPanel();
        this.lbLogo = new JLabel();
        this.pnSteps = new JPanel();
        this.lbPreview = new JLabel();
        this.spSeparator = new JSeparator();
        this.pnStep = new JPanel();
        this.lbStatus = new JLabel();
        this.pnButtons = new JPanel();
        this.btPrevious = new JButton();
        this.btNext = new JButton();
        this.btFinish = new JButton();
        this.btCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnOverview.setMaximumSize(new Dimension(200, 83));
        this.pnOverview.setMinimumSize(new Dimension(200, 83));
        this.pnOverview.setPreferredSize(new Dimension(200, 83));
        this.pnOverview.setLayout(new GridBagLayout());
        this.lbLogo.setIcon(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_name_48.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnOverview.add((Component)this.lbLogo, gridBagConstraints);
        this.pnSteps.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 5, 5, 5);
        this.pnOverview.add((Component)this.pnSteps, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnOverview.add((Component)this.lbPreview, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnOverview, gridBagConstraints);
        this.spSeparator.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.spSeparator, gridBagConstraints);
        this.pnStep.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnStep, gridBagConstraints);
        this.lbStatus.setFont(this.getFont());
        this.lbStatus.setForeground(Color.red);
        this.lbStatus.setMinimumSize(new Dimension(20, 20));
        this.lbStatus.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.getContentPane().add((Component)this.lbStatus, gridBagConstraints);
        this.pnButtons.setForeground(Color.red);
        this.pnButtons.setLayout(new GridBagLayout());
        this.btPrevious.setFont(this.getFont());
        this.btPrevious.setMnemonic(Translator.getMnemonic("WIZARD.BT_PREVIOUS"));
        this.btPrevious.setText(Translator.getTranslation("WIZARD.BT_PREVIOUS"));
        this.btPrevious.setToolTipText(Translator.getTranslation("WIZARD.BT_PREVIOUS_TOOLTIP"));
        this.btPrevious.setEnabled(false);
        this.btPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericWizard.this.btPreviousActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnButtons.add((Component)this.btPrevious, gridBagConstraints);
        this.btNext.setFont(this.getFont());
        this.btNext.setMnemonic(Translator.getMnemonic("WIZARD.BT_NEXT"));
        this.btNext.setText(Translator.getTranslation("WIZARD.BT_NEXT"));
        this.btNext.setToolTipText(Translator.getTranslation("WIZARD.BT_NEXT_TOOLTIP"));
        this.btNext.setEnabled(false);
        this.btNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericWizard.this.btNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnButtons.add((Component)this.btNext, gridBagConstraints);
        this.btFinish.setFont(this.getFont());
        this.btFinish.setMnemonic(Translator.getMnemonic("WIZARD.BT_FINISH"));
        this.btFinish.setText(Translator.getTranslation("WIZARD.BT_FINISH"));
        this.btFinish.setToolTipText(Translator.getTranslation("WIZARD.BT_FINISH_TOOLTIP"));
        this.btFinish.setEnabled(false);
        this.btFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericWizard.this.btFinishActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnButtons.add((Component)this.btFinish, gridBagConstraints);
        this.btCancel.setFont(this.getFont());
        this.btCancel.setMnemonic(Translator.getMnemonic("WIZARD.BT_CANCEL"));
        this.btCancel.setText(Translator.getTranslation("WIZARD.BT_CANCEL"));
        this.btCancel.setToolTipText(Translator.getTranslation("WIZARD.BT_CANCEL_TOOLTIP"));
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericWizard.this.btCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnButtons.add((Component)this.btCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnButtons, gridBagConstraints);
        this.pack();
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.firePropertyChange("wizard_canceled", null, null);
        this.setVisible(false);
    }

    private void btFinishActionPerformed(ActionEvent evt) {
        this.firePropertyChange("wizard_finished", null, null);
        this.finishWizard();
    }

    private void btNextActionPerformed(ActionEvent evt) {
        this.selectStep(this.selectedStep + 1);
    }

    private void btPreviousActionPerformed(ActionEvent evt) {
        this.selectStep(this.selectedStep - 1);
    }

    private void selectStep(int index) {
        this.selectedStep = index;
        this.pnStep.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        WizardStep step = (WizardStep)this.steps.get(this.selectedStep);
        this.pnStep.add((Component)step, gridBagConstraints);
        for (int i = 0; i < this.steps.size(); ++i) {
            JLabel lbStep = (JLabel)this.pnSteps.getComponent(i);
            if (i == this.selectedStep) {
                lbStep.setFont(this.getFont().deriveFont(1));
                continue;
            }
            lbStep.setFont(this.getFont());
        }
        this.checkButtons();
        this.repaint();
        step.setFocus();
    }

    public void checkButtons() {
        this.btPrevious.setEnabled(this.selectedStep != 0);
        WizardStep step = (WizardStep)this.steps.get(this.selectedStep);
        if (this.selectedStep == this.steps.size() - 1) {
            this.btNext.setEnabled(false);
        } else {
            this.btNext.setEnabled(step.isSetCorrectly());
        }
        if (this.selectedStep != this.steps.size() - 1) {
            this.btFinish.setEnabled(false);
        } else {
            this.btFinish.setEnabled(step.isSetCorrectly());
        }
    }

    public void setPreview(ImageIcon preview) {
        this.lbPreview.setIcon(preview);
    }

    public static void setWizardProperty(String propertyName, Object property) {
        properties.put(propertyName, property);
    }

    public static Object getWizardProperty(String propertyName) {
        return properties.get(propertyName);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object property = evt.getNewValue();
        GenericWizard.setWizardProperty(propertyName, property);
    }

    public void setStatus(String status) {
        this.lbStatus.setText(status);
    }

    protected void goNextStep() {
        this.btNextActionPerformed(null);
    }

    protected void cancelWizard() {
        this.btCancelActionPerformed(null);
    }

    protected void finishWizard() {
        this.setVisible(false);
    }
}

