/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.text.html.HTMLDocument;
import net.sf.memoranda.Note;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.htmleditor.AltHTMLWriter;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.HTMLFileExport;
import net.sf.memoranda.util.Local;

public class ProjectExporter {
    static boolean _chunked = false;
    static boolean _num = false;
    static boolean _xhtml = false;
    static boolean _copyImages = false;
    static File output = null;
    static String _charset = null;
    static boolean _titlesAsHeaders = false;
    static boolean _navigation = false;
    static String charsetString = "\n";

    public static void export(Project project, File file, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        OutputStreamWriter outputStreamWriter;
        _num = bl4;
        _chunked = bl2;
        _charset = string;
        _xhtml = bl;
        _titlesAsHeaders = bl5;
        _copyImages = bl6;
        _navigation = bl3;
        output = file.isDirectory() ? new File(file.getPath() + "/index.html") : file;
        NoteList noteList = CurrentStorage.get().openNoteList(project);
        Vector vector = (Vector)noteList.getAllNotes();
        Collections.sort(vector);
        if (output.getName().indexOf(".htm") == -1) {
            String string2 = output.getPath();
            String string3 = ".html";
            String string4 = string2 + string3;
            output = new File(string4);
        }
        try {
            if (string != null) {
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(output), string);
                charsetString = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + string + "\" />";
            } else {
                outputStreamWriter = new FileWriter(output);
            }
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to write to " + output, "");
            return;
        }
        ProjectExporter.write(outputStreamWriter, "<html>\n<head>\n" + charsetString + "<title>" + project.getTitle() + "</title>\n</head>\n<body>\n<h1 class=\"projecttitle\">" + project.getTitle() + "</h1><br/>\n");
        ProjectExporter.generateToc(outputStreamWriter, vector);
        ProjectExporter.generateChunks(outputStreamWriter, vector);
        ProjectExporter.write(outputStreamWriter, "\n<hr><a href=\"http://memoranda.sf.net\">Memoranda</a> 1.0-rc3.1\n<br>\n" + new Date().toString() + "\n</body>\n</html>");
        try {
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to write to " + output, "");
        }
    }

    private static void generateToc(Writer writer, Vector vector) {
        ProjectExporter.write(writer, "<div class=\"toc\"><ul>\n");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Note note = (Note)iterator.next();
            String string = "";
            CalendarDate calendarDate = note.getDate();
            String string2 = note.getId();
            string = !_chunked ? "#" + string2 : string2 + ".html";
            ProjectExporter.write(writer, "<li><a href=\"" + string + "\">" + note.getDate().getMediumDateString() + " " + note.getTitle() + "</a></li>\n");
        }
        ProjectExporter.write(writer, "</ul></div>\n");
    }

    private static String getNoteHTML(Note note) {
        String string = "";
        StringWriter stringWriter = new StringWriter();
        AltHTMLWriter altHTMLWriter = new AltHTMLWriter((Writer)stringWriter, (HTMLDocument)CurrentStorage.get().openNote(note), _charset, _num);
        try {
            altHTMLWriter.write();
            stringWriter.flush();
            stringWriter.close();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
        string = stringWriter.toString();
        if (_xhtml) {
            string = HTMLFileExport.convertToXHTML(string);
        }
        string = Pattern.compile("<body(.*?)>", 34).split(string)[1];
        string = Pattern.compile("</body>", 34).split(string)[0];
        string = "<div class=\"note\">" + string + "</div>";
        if (_titlesAsHeaders) {
            string = "\n\n<div class=\"date\">" + note.getDate().getFullDateString() + ":</div>\n<h1 class=\"title\">" + note.getTitle() + "</h1>\n" + string;
        }
        return string;
    }

    private static String generateNav(Note note, Note note2) {
        String string = "<hr/><div class=\"navigation\"><table border=\"0\" width=\"100%\" cellpadding=\"2\"><tr><td width=\"33%\">";
        string = note != null ? string + "<div class=\"navitem\"><a href=\"" + note.getId() + ".html\">" + Local.getString("Previous") + "</a><br/>" + note.getDate().getMediumDateString() + " " + note.getTitle() + "</div>" : string + "&nbsp;";
        string = string + "</td><td width=\"34%\" align=\"center\"><a href=\"" + output.getName() + "\">Up</a></td><td width=\"33%\" align=\"right\">";
        string = note2 != null ? string + "<div class=\"navitem\"><a href=\"" + note2.getId() + ".html\">" + Local.getString("Next") + "</a><br/>" + note2.getDate().getMediumDateString() + " " + note2.getTitle() + "</div>" : string + "&nbsp;";
        string = string + "</td></tr></table></div>\n";
        return string;
    }

    private static void generateChunks(Writer writer, Vector vector) {
        Object[] objectArray = vector.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Note note = (Note)objectArray[i];
            CalendarDate calendarDate = note.getDate();
            if (_chunked) {
                File file = new File(output.getParentFile().getPath() + "/" + note.getId() + ".html");
                OutputStreamWriter outputStreamWriter = null;
                try {
                    outputStreamWriter = _charset != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), _charset) : new FileWriter(file);
                    String string = "<html>\n<head>\n" + charsetString + "<title>" + note.getTitle() + "</title>\n</head>\n<body>\n" + ProjectExporter.getNoteHTML(note);
                    if (_navigation) {
                        Note note2 = null;
                        if (i > 0) {
                            note2 = (Note)objectArray[i - 1];
                        }
                        Note note3 = null;
                        if (i < objectArray.length - 1) {
                            note3 = (Note)objectArray[i + 1];
                        }
                        string = string + ProjectExporter.generateNav(note2, note3);
                    }
                    string = string + "\n</body>\n</html>";
                    outputStreamWriter.write(string);
                    ((Writer)outputStreamWriter).flush();
                    ((Writer)outputStreamWriter).close();
                }
                catch (Exception exception) {
                    new ExceptionDialog(exception, "Failed to write to " + output, "");
                }
                continue;
            }
            ProjectExporter.write(writer, "<a name=\"" + note.getId() + "\"/>" + ProjectExporter.getNoteHTML(note) + "\n");
        }
    }

    private static void write(Writer writer, String string) {
        try {
            writer.write(string);
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to write to " + output, "");
        }
    }
}

