/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.util.Configuration;
import net.sf.memoranda.util.LoadableProperties;

public class Local {
    static Locale currentLocale = Locale.getDefault();
    static LoadableProperties messages = new LoadableProperties();
    static boolean disabled = false;
    static String[] monthnames;
    static String[] weekdaynames;

    public static Hashtable getMessages() {
        return messages;
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static String getString(String string) {
        if (messages == null || disabled) {
            return string;
        }
        String string2 = (String)messages.get(string.trim().toUpperCase());
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return string;
    }

    public static String[] getMonthNames() {
        String[] stringArray = new String[12];
        for (int i = 0; i < 12; ++i) {
            stringArray[i] = Local.getString(monthnames[i]);
        }
        return stringArray;
    }

    public static String[] getWeekdayNames() {
        String[] stringArray = new String[7];
        String[] stringArray2 = weekdaynames;
        if (Configuration.get("FIRST_DAY_OF_WEEK").equals("mon")) {
            stringArray2 = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        }
        for (int i = 0; i < 7; ++i) {
            stringArray[i] = Local.getString(stringArray2[i]);
        }
        return stringArray;
    }

    public static String getMonthName(int n) {
        return Local.getString(monthnames[n]);
    }

    public static String getWeekdayName(int n) {
        return Local.getString(weekdaynames[n - 1]);
    }

    public static String getDateString(Date date, int n) {
        DateFormat dateFormat = DateFormat.getDateInstance(n, currentLocale);
        return dateFormat.format(date);
    }

    public static String getDateString(Calendar calendar, int n) {
        return Local.getDateString(calendar.getTime(), n);
    }

    public static String getDateString(CalendarDate calendarDate, int n) {
        return Local.getDateString(calendarDate.getDate(), n);
    }

    public static String getDateString(int n, int n2, int n3, int n4) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, n);
        calendar.set(5, n2);
        calendar.set(1, n3);
        return Local.getDateString(calendar.getTime(), n4);
    }

    public static String getTimeString(Date date) {
        DateFormat dateFormat = DateFormat.getTimeInstance(3, currentLocale);
        return dateFormat.format(date);
    }

    public static String getTimeString(Calendar calendar) {
        return Local.getTimeString(calendar.getTime());
    }

    public static String getTimeString(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, n);
        calendar.set(12, n2);
        return Local.getTimeString(calendar.getTime());
    }

    public static int[] parseTimeString(String string) {
        string = string.trim();
        String string2 = "";
        String string3 = "";
        if (string.indexOf(":") > 0) {
            string2 = string.substring(0, string.indexOf(":"));
            string3 = string.substring(string.indexOf(":") + 1);
        } else if (string.indexOf(":") == 0) {
            string2 = "0";
            string3 = string;
        } else {
            string2 = string;
            string3 = "0";
        }
        int[] nArray = new int[2];
        try {
            nArray[0] = new Integer(string2);
            if (nArray[0] < 0 || nArray[0] > 23) {
                nArray[0] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        try {
            nArray[1] = new Integer(string3);
            if (nArray[1] < 0 || nArray[1] > 59) {
                nArray[1] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return nArray;
    }

    static {
        if (!Configuration.get("DISABLE_L10N").equals("yes")) {
            String string = "messages_" + currentLocale.getLanguage() + ".properties";
            if (Configuration.get("LOCALES_DIR") != "") {
                System.out.print("Look " + string + " at: " + Configuration.get("LOCALES_DIR") + " ");
                try {
                    messages.load(new FileInputStream(Configuration.get("LOCALES_DIR") + File.separator + string));
                    System.out.println(" - found");
                }
                catch (IOException iOException) {
                    System.out.println(" - not found");
                    iOException.printStackTrace();
                }
            }
            if (messages.size() == 0) {
                try {
                    messages.load(Local.class.getResourceAsStream("localmessages/" + string));
                }
                catch (Exception exception) {}
            }
        } else {
            currentLocale = new Locale("en", "US");
            System.out.println("* DEBUG: Locales are disabled");
        }
        if (messages.size() == 0) {
            messages = null;
        }
        System.out.println("Default locale: " + currentLocale.getDisplayName());
        if (messages != null) {
            System.out.println("Use local messages: messages_" + currentLocale.getLanguage() + ".properties");
        } else {
            System.out.println("* DEBUG: Locales are disabled or not found: messages_" + currentLocale.getLanguage() + ".properties");
        }
        monthnames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        weekdaynames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    }
}

