/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui.htmleditor;

import java.awt.Dimension;
import java.awt.Point;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import net.sf.memoranda.ui.htmleditor.ContinueSearchDialog;
import net.sf.memoranda.ui.htmleditor.HTMLEditor;
import net.sf.memoranda.ui.htmleditor.ReplaceOptionsDialog;
import net.sf.memoranda.ui.htmleditor.util.Local;

public class Finder
extends Thread {
    Pattern pattern;
    String _find = null;
    String dispText = "";
    String _replace = null;
    HTMLEditor editor;

    public Finder(HTMLEditor hTMLEditor, String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        this.editor = hTMLEditor;
        this.dispText = string;
        int n = 32;
        if (!bl2) {
            n = n + 2 + 64;
        }
        this._find = string;
        if (!bl3) {
            this._find = "\\Q" + this._find + "\\E";
        }
        if (bl) {
            this._find = "[\\s\\p{Punct}]" + this._find + "[\\s\\p{Punct}]";
        }
        try {
            this.pattern = Pattern.compile(this._find, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.pattern = null;
        }
        this._replace = string2;
    }

    public Finder(HTMLEditor hTMLEditor, String string, boolean bl, boolean bl2, boolean bl3) {
        this(hTMLEditor, string, bl, bl2, bl3, null);
    }

    public void findAll() {
        if (this.pattern == null) {
            return;
        }
        String string = "";
        try {
            string = this.editor.editor.getDocument().getText(0, this.editor.editor.getDocument().getLength() - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        ContinueSearchDialog continueSearchDialog = new ContinueSearchDialog(this, this.dispText);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        Matcher matcher = this.pattern.matcher(string);
        while (matcher.find(n)) {
            this.editor.editor.requestFocus();
            this.editor.editor.setCaretPosition(matcher.end());
            this.editor.editor.select(matcher.start(), matcher.end());
            if (this._replace != null) {
                if (!bl) {
                    ReplaceOptionsDialog replaceOptionsDialog = new ReplaceOptionsDialog(Local.getString("Replace this occurence?"));
                    Dimension dimension = new Dimension(400, 150);
                    replaceOptionsDialog.setSize(400, 150);
                    Dimension dimension2 = this.editor.getParent().getSize();
                    Point point = this.editor.getLocationOnScreen();
                    replaceOptionsDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
                    replaceOptionsDialog.setModal(true);
                    replaceOptionsDialog.setVisible(true);
                    int n2 = replaceOptionsDialog.option;
                    if (n2 == 0) {
                        this.editor.editor.replaceSelection(this._replace);
                        n = matcher.start() + this._replace.length();
                    } else if (n2 == 1) {
                        this.editor.editor.replaceSelection(this._replace);
                        n = matcher.start() + this._replace.length();
                        bl = true;
                    } else {
                        if (n2 == 3) {
                            return;
                        }
                        n = matcher.end();
                    }
                } else {
                    this.editor.editor.replaceSelection(this._replace);
                    n = matcher.start() + this._replace.length();
                }
            } else {
                continueSearchDialog.cont = false;
                continueSearchDialog.cancel = false;
                if (!bl2) {
                    this.editor.showToolsPanel();
                    this.editor.toolsPanel.addTab(Local.getString("Find"), continueSearchDialog);
                    bl2 = true;
                }
                this.suspend();
                if (continueSearchDialog.cancel) {
                    this.editor.toolsPanel.remove(continueSearchDialog);
                    if (this.editor.toolsPanel.getTabCount() == 0) {
                        this.editor.hideToolsPanel();
                    }
                    return;
                }
                n = matcher.end();
            }
            try {
                string = this.editor.editor.getDocument().getText(0, this.editor.editor.getDocument().getLength() - 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            matcher = this.pattern.matcher(string);
        }
        JOptionPane.showMessageDialog(null, Local.getString("Search complete") + ".");
        if (bl2) {
            this.editor.toolsPanel.remove(continueSearchDialog);
            if (this.editor.toolsPanel.getTabCount() == 0) {
                this.editor.hideToolsPanel();
            }
        }
    }

    public void run() {
        this.findAll();
    }
}

