/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import net.sf.memoranda.Project;
import net.sf.memoranda.Task;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.TaskProgressLabel;
import net.sf.memoranda.ui.TaskTable;

public class TaskTreeTableCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer,
TableCellRenderer {
    static ImageIcon PR_HIGHEST_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/pr_highest.png"));
    static ImageIcon PR_HIGH_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/pr_high.png"));
    static ImageIcon PR_NORMAL_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/pr_normal.png"));
    static ImageIcon PR_LOW_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/pr_low.png"));
    static ImageIcon PR_LOWEST_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/pr_lowest.png"));
    static ImageIcon TASK_ACTIVE_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/task_active.png"));
    static ImageIcon TASK_SCHEDULED_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/task_scheduled.png"));
    static ImageIcon TASK_DEADLINE_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/task_deadline.png"));
    static ImageIcon TASK_FAILED_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/task_failed.png"));
    static ImageIcon TASK_COMPLETED_ICON = new ImageIcon(AppFrame.class.getResource("resources/icons/task_completed.png"));
    JLabel label = new JLabel();
    TaskProgressLabel progressLabel;
    JPanel empty_panel = new JPanel();
    TaskTable table;
    DateFormat dateFormat = DateFormat.getDateInstance(3);

    public TaskTreeTableCellRenderer(TaskTable taskTable) {
        this.table = taskTable;
        this.progressLabel = new TaskProgressLabel(taskTable);
        this.label.setOpaque(true);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (object instanceof Project) {
            return this.empty_panel;
        }
        if (!(object instanceof Task)) {
            return this.empty_panel;
        }
        Task task = (Task)object;
        this.setText(task.getText());
        this.setToolTipText(task.getDescription());
        this.setIcon(TaskTreeTableCellRenderer.getStatusIcon(task));
        this.applyFont(task, this);
        return this;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Task task = (Task)this.table.getValueAt(n, 1);
        if (n2 == 1) {
            return this.table.getTree();
        }
        this.label.setForeground(Color.BLACK);
        this.label.setIcon(null);
        this.applyFont(task, this.label);
        this.applySelectionStyle(bl, this.label);
        this.applyFocus(bl2, this.label);
        if (object == null) {
            this.label.setText("");
            return this.label;
        }
        if (n2 == 6) {
            return this.getProgressCellRenderer(task, bl, bl2, n2);
        }
        if (n2 == 0) {
            return this.getPriorityIconCellRenderer(task, bl, bl2);
        }
        if (n2 == 2 || n2 == 3) {
            this.label.setText(this.dateFormat.format((Date)object));
            return this.label;
        }
        if (n2 == 5) {
            this.label.setText(object.toString());
            this.label.setForeground(TaskTreeTableCellRenderer.getColorForTaskStatus(task, false));
            return this.label;
        }
        this.label.setText(object.toString());
        return this.label;
    }

    private Component getTaskTreeCellRenderer(Task task, boolean bl, boolean bl2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(task.getText());
        jLabel.setIcon(TaskTreeTableCellRenderer.getStatusIcon(task));
        this.applyFont(task, jLabel);
        return jLabel;
    }

    private Component getProgressCellRenderer(Task task, boolean bl, boolean bl2, int n) {
        this.progressLabel.setTask(task);
        this.progressLabel.setColumn(n);
        this.applyFocus(bl2, this.progressLabel);
        return this.progressLabel;
    }

    private Component getPriorityIconCellRenderer(Task task, boolean bl, boolean bl2) {
        this.applyFocus(false, this.label);
        this.label.setIcon(TaskTreeTableCellRenderer.getPriorityIcon(task));
        this.label.setToolTipText(task.getDescription());
        return this.label;
    }

    private void applySelectionStyle(boolean bl, JComponent jComponent) {
        if (bl) {
            jComponent.setBackground(this.table.getSelectionBackground());
        } else {
            jComponent.setBackground(this.table.getBackground());
        }
    }

    private void applyFocus(boolean bl, JComponent jComponent) {
        if (bl) {
            jComponent.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.table.getSelectionBackground().darker()));
        } else if (jComponent.getBorder() != null) {
            jComponent.setBorder(null);
        }
    }

    private void applyFont(Task task, JComponent jComponent) {
        if (task.getStatus(CurrentDate.get()) == 1 || task.getStatus(CurrentDate.get()) == 7) {
            jComponent.setFont(jComponent.getFont().deriveFont(1));
        } else {
            jComponent.setFont(jComponent.getFont().deriveFont(0));
        }
    }

    public static Color getColorForTaskStatus(Task task, boolean bl) {
        if (bl) {
            switch (task.getStatus(CurrentDate.get())) {
                case 1: {
                    return new Color(192, 255, 192);
                }
                case 0: {
                    return new Color(192, 230, 255);
                }
                case 7: {
                    return new Color(255, 240, 160);
                }
                case 5: {
                    return new Color(255, 192, 192);
                }
                case 2: {
                    return new Color(230, 255, 230);
                }
            }
        } else {
            switch (task.getStatus(CurrentDate.get())) {
                case 1: {
                    return new Color(0, 180, 0);
                }
                case 0: {
                    return new Color(0, 120, 255);
                }
                case 7: {
                    return new Color(160, 90, 0);
                }
                case 5: {
                    return new Color(255, 0, 0);
                }
                case 2: {
                    return new Color(0, 120, 0);
                }
            }
        }
        System.err.println("Problem finding color for task status");
        return null;
    }

    public static ImageIcon getStatusIcon(Task task) {
        switch (task.getStatus(CurrentDate.get())) {
            case 1: {
                return TASK_ACTIVE_ICON;
            }
            case 0: {
                return TASK_SCHEDULED_ICON;
            }
            case 7: {
                return TASK_DEADLINE_ICON;
            }
            case 5: {
                return TASK_FAILED_ICON;
            }
            case 2: {
                return TASK_COMPLETED_ICON;
            }
        }
        System.err.println("Problem finding status icon");
        return null;
    }

    public static ImageIcon getPriorityIcon(Task task) {
        switch (task.getPriority()) {
            case 2: {
                return PR_NORMAL_ICON;
            }
            case 4: {
                return PR_HIGHEST_ICON;
            }
            case 3: {
                return PR_HIGH_ICON;
            }
            case 1: {
                return PR_LOW_ICON;
            }
            case 0: {
                return PR_LOWEST_ICON;
            }
        }
        System.err.println("Problem finding priority icon");
        return null;
    }
}

