/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.sf.memoranda.Task;
import net.sf.memoranda.ui.TaskProgressLabel;

public class TaskProgressEditor
extends JPanel
implements TableCellEditor {
    JTable table;
    Task current;
    boolean isSelected;
    int row;
    int column;
    List listeners = new ArrayList();
    JLabel label = new JLabel();

    public TaskProgressEditor() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MouseEvent mouseEvent2;
                if (mouseEvent instanceof MouseEvent && (mouseEvent2 = mouseEvent).getButton() != 1) {
                    TaskProgressEditor.this.stopEditing();
                    return;
                }
                int n = TaskProgressEditor.this.getWidth() / 2;
                if (mouseEvent.getX() > n) {
                    TaskProgressEditor.this.current.setProgress(TaskProgressEditor.this.current.getProgress() + 5);
                } else {
                    TaskProgressEditor.this.current.setProgress(TaskProgressEditor.this.current.getProgress() - 5);
                }
                TaskProgressEditor.this.repaint();
            }
        });
        this.setLayout(new BorderLayout());
        this.label.setOpaque(false);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.current = (Task)object;
        this.table = jTable;
        this.isSelected = bl;
        this.row = n;
        this.column = n2;
        return this;
    }

    public void paint(Graphics graphics) {
        this.paintComponent(graphics);
    }

    public void paintComponent(Graphics graphics) {
        TableCellRenderer tableCellRenderer = this.table.getCellRenderer(this.row, this.column);
        ((TaskProgressLabel)tableCellRenderer.getTableCellRendererComponent(this.table, this.current, this.isSelected, true, this.row, this.column)).paintComponent(graphics);
        this.label.setSize(this.getSize());
        this.label.setText("-");
        this.label.setHorizontalAlignment(2);
        this.label.paint(graphics);
        this.label.setText("+");
        this.label.setHorizontalAlignment(4);
        this.label.paint(graphics);
    }

    private void stopEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener cellEditorListener = (CellEditorListener)this.listeners.get(i);
            cellEditorListener.editingStopped(null);
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isCellEditable(EventObject eventObject) {
        MouseEvent mouseEvent;
        return eventObject instanceof MouseEvent && (mouseEvent = (MouseEvent)eventObject).getButton() == 1;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }
}

