/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.ui.JNCalendarCellRenderer;
import net.sf.memoranda.util.Configuration;
import net.sf.memoranda.util.Local;

public class JNCalendar
extends JTable {
    private CalendarDate _date = null;
    private boolean ignoreChange = false;
    private Vector selectionListeners = new Vector();
    CalendarDate startPeriod = null;
    CalendarDate endPeriod = null;
    public JNCalendarCellRenderer renderer = new JNCalendarCellRenderer();
    int firstDay;
    int daysInMonth;

    public JNCalendar() {
        this(CurrentDate.get());
    }

    public JNCalendar(CalendarDate calendarDate) {
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.set(calendarDate);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (JNCalendar.this.ignoreChange) {
                    return;
                }
                int n = JNCalendar.this.getSelRow();
                int n2 = JNCalendar.this.getSelCol();
                Object object = JNCalendar.this.getModel().getValueAt(n, n2);
                if (object != null) {
                    if (object.toString().equals(new Integer(JNCalendar.this._date.getDay()).toString())) {
                        return;
                    }
                    JNCalendar.this._date = new CalendarDate(new Integer(object.toString()), JNCalendar.this._date.getMonth(), JNCalendar.this._date.getYear());
                    JNCalendar.this.notifyListeners();
                } else {
                    JNCalendar.this.doSelection();
                }
            }
        };
        listSelectionModel.addListSelectionListener(listSelectionListener);
        listSelectionModel2.addListSelectionListener(listSelectionListener);
    }

    int getSelRow() {
        return this.getSelectedRow();
    }

    int getSelCol() {
        return this.getSelectedColumn();
    }

    public JNCalendar(CalendarDate calendarDate, CalendarDate calendarDate2, CalendarDate calendarDate3) {
        this(calendarDate);
        this.setSelectablePeriod(calendarDate2, calendarDate3);
    }

    public void set(CalendarDate calendarDate) {
        this._date = calendarDate;
        this.setCalendarParameters();
        this.ignoreChange = true;
        this.setModel(new JNCalendarModel());
        this.ignoreChange = false;
        this.doSelection();
    }

    public CalendarDate get() {
        return this._date;
    }

    public void addSelectionListener(ActionListener actionListener) {
        this.selectionListeners.add(actionListener);
    }

    public void setSelectablePeriod(CalendarDate calendarDate, CalendarDate calendarDate2) {
        this.startPeriod = calendarDate;
        this.endPeriod = calendarDate2;
    }

    private void notifyListeners() {
        for (int i = 0; i < this.selectionListeners.size(); ++i) {
            ((ActionListener)this.selectionListeners.get(i)).actionPerformed(new ActionEvent(this, 0, "Calendar event"));
        }
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        Object object = this.getModel().getValueAt(n, n2);
        if (object != null) {
            this.renderer.setDate(new CalendarDate(new Integer(object.toString()), this._date.getMonth(), this._date.getYear()));
        } else {
            this.renderer.setDate(null);
        }
        return this.renderer;
    }

    void doSelection() {
        this.ignoreChange = true;
        int n = this.getRow(this._date.getDay());
        int n2 = this.getCol(this._date.getDay());
        this.setRowSelectionInterval(n, n);
        this.setColumnSelectionInterval(n2, n2);
        this.ignoreChange = false;
    }

    int getRow(int n) {
        return (n - 1 + this.firstDay) / 7;
    }

    int getCol(int n) {
        return (n - 1 + this.firstDay) % 7;
    }

    void setCalendarParameters() {
        int n = 1;
        Calendar calendar = this._date.getCalendar();
        if (Configuration.get("FIRST_DAY_OF_WEEK").equals("mon")) {
            calendar.setFirstDayOfWeek(2);
            n = 2;
        } else {
            calendar.setFirstDayOfWeek(1);
        }
        calendar.set(5, 1);
        calendar.getTime();
        this.firstDay = calendar.get(7) - n;
        if (this.firstDay == -1) {
            this.firstDay = 6;
        }
        this.daysInMonth = calendar.getActualMaximum(5);
    }

    public class JNCalendarModel
    extends AbstractTableModel {
        private String[] dayNames = Local.getWeekdayNames();

        public int getColumnCount() {
            return 7;
        }

        public Object getValueAt(int n, int n2) {
            int n3 = n * 7 + (n2 + 1) - JNCalendar.this.firstDay;
            if (n3 > 0 && n3 <= JNCalendar.this.daysInMonth) {
                return new Integer(n3);
            }
            return null;
        }

        public int getRowCount() {
            return 6;
        }

        public String getColumnName(int n) {
            return this.dayNames[n];
        }
    }
}

