/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.sf.memoranda.Event;
import net.sf.memoranda.EventsManager;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.date.DateListener;
import net.sf.memoranda.util.Local;

public class EventsTable
extends JTable {
    public static final int EVENT = 100;
    public static final int EVENT_ID = 101;
    Vector events = new Vector();

    public EventsTable() {
        this.setModel(new EventsTableModel());
        this.initTable(CurrentDate.get());
        this.setShowGrid(false);
        CurrentDate.addDateListener(new DateListener(){

            public void dateChange(CalendarDate calendarDate) {
                EventsTable.this.initTable(calendarDate);
            }
        });
    }

    public void initTable(CalendarDate calendarDate) {
        this.events = (Vector)EventsManager.getEventsForDate(calendarDate);
        this.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.getColumnModel().getColumn(0).setMaxWidth(60);
        this.clearSelection();
        this.updateUI();
    }

    public void refresh() {
        this.initTable(CurrentDate.get());
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                Event event = (Event)EventsTable.this.getModel().getValueAt(n, 100);
                component.setForeground(Color.gray);
                if (event.isRepeatable()) {
                    component.setFont(component.getFont().deriveFont(2));
                }
                if (CurrentDate.get().after(CalendarDate.today())) {
                    component.setForeground(Color.black);
                } else if (CurrentDate.get().equals(CalendarDate.today()) && event.getTime().after(new Date())) {
                    component.setForeground(Color.black);
                    component.setFont(component.getFont().deriveFont(1));
                }
                return component;
            }
        };
    }

    class EventsTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{Local.getString("Time"), Local.getString("Text")};

        EventsTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            int n;
            try {
                n = EventsTable.this.events.size();
            }
            catch (NullPointerException nullPointerException) {
                n = 1;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            Event event = (Event)EventsTable.this.events.get(n);
            if (n2 == 0) {
                return event.getTimeString();
            }
            if (n2 == 1) {
                return event.getText();
            }
            if (n2 == 101) {
                return event.getId();
            }
            return event;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }
    }
}

