/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.io.File;
import java.util.Vector;
import net.sf.memoranda.Project;
import net.sf.memoranda.Resource;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.util.Util;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public class ResourcesListImpl
implements ResourcesList {
    private Project _project = null;
    private Document _doc = null;
    private Element _root = null;

    public ResourcesListImpl(Document document, Project project) {
        this._doc = document;
        this._root = this._doc.getRootElement();
        this._project = project;
    }

    public ResourcesListImpl(Project project) {
        this._root = new Element("resources-list");
        this._doc = new Document(this._root);
        this._project = project;
    }

    public Vector getAllResources() {
        Vector<Resource> vector = new Vector<Resource>();
        Elements elements = this._root.getChildElements("resource");
        for (int i = 0; i < elements.size(); ++i) {
            vector.add(new Resource(elements.get(i).getAttribute("path").getValue(), elements.get(i).getAttribute("isInetShortcut") != null, elements.get(i).getAttribute("isProjectFile") != null));
        }
        return vector;
    }

    public Resource getResource(String string) {
        Elements elements = this._root.getChildElements("resource");
        for (int i = 0; i < elements.size(); ++i) {
            if (!elements.get(i).getAttribute("path").getValue().equals(string)) continue;
            return new Resource(elements.get(i).getAttribute("path").getValue(), elements.get(i).getAttribute("isInetShortcut") != null, elements.get(i).getAttribute("isProjectFile") != null);
        }
        return null;
    }

    public void addResource(String string, boolean bl, boolean bl2) {
        Element element = new Element("resource");
        element.addAttribute(new Attribute("id", Util.generateId()));
        element.addAttribute(new Attribute("path", string));
        if (bl) {
            element.addAttribute(new Attribute("isInetShortcut", "true"));
        }
        if (bl2) {
            element.addAttribute(new Attribute("isProjectFile", "true"));
        }
        this._root.appendChild((Node)element);
    }

    public void addResource(String string) {
        this.addResource(string, false, false);
    }

    public void removeResource(String string) {
        Elements elements = this._root.getChildElements("resource");
        for (int i = 0; i < elements.size(); ++i) {
            if (!elements.get(i).getAttribute("path").getValue().equals(string)) continue;
            if (this.getResource(string).isProjectFile()) {
                File file = new File(string);
                System.out.println("[DEBUG] Removing file " + string);
                file.delete();
            }
            this._root.removeChild((Node)elements.get(i));
        }
    }

    public int getAllResourcesCount() {
        return this._root.getChildElements("resource").size();
    }

    public Document getXMLContent() {
        return this._doc;
    }
}

