/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.util.Vector;
import net.sf.memoranda.History;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectImpl;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.Util;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public class ProjectManager {
    public static Document _doc = null;
    static Element _root = null;

    public static void init() {
        CurrentStorage.get().openProjectManager();
        if (_doc == null) {
            _root = new Element("projects-list");
            _doc = new Document(_root);
            ProjectManager.createProject("__default", Local.getString("Default project"), CalendarDate.today(), null);
        } else {
            _root = _doc.getRootElement();
        }
    }

    public static Project getProject(String string) {
        Elements elements = _root.getChildElements("project");
        for (int i = 0; i < elements.size(); ++i) {
            String string2 = elements.get(i).getAttribute("id").getValue();
            if (!string2.equals(string)) continue;
            return new ProjectImpl(elements.get(i));
        }
        return null;
    }

    public static Vector getAllProjects() {
        Elements elements = _root.getChildElements("project");
        Vector<ProjectImpl> vector = new Vector<ProjectImpl>();
        for (int i = 0; i < elements.size(); ++i) {
            vector.add(new ProjectImpl(elements.get(i)));
        }
        return vector;
    }

    public static int getAllProjectsNumber() {
        int n;
        try {
            n = _root.getChildElements("project").size();
        }
        catch (NullPointerException nullPointerException) {
            n = 1;
        }
        return n;
    }

    public static Vector getActiveProjects() {
        Elements elements = _root.getChildElements("project");
        Vector<ProjectImpl> vector = new Vector<ProjectImpl>();
        for (int i = 0; i < elements.size(); ++i) {
            ProjectImpl projectImpl = new ProjectImpl(elements.get(i));
            if (projectImpl.getStatus() != 1) continue;
            vector.add(projectImpl);
        }
        return vector;
    }

    public static int getActiveProjectsNumber() {
        Elements elements = _root.getChildElements("project");
        int n = 0;
        for (int i = 0; i < elements.size(); ++i) {
            ProjectImpl projectImpl = new ProjectImpl(elements.get(i));
            if (projectImpl.getStatus() != 1) continue;
            ++n;
        }
        return n;
    }

    public static Project createProject(String string, String string2, CalendarDate calendarDate, CalendarDate calendarDate2) {
        Element element = new Element("project");
        element.addAttribute(new Attribute("id", string));
        _root.appendChild((Node)element);
        ProjectImpl projectImpl = new ProjectImpl(element);
        projectImpl.setTitle(string2);
        projectImpl.setStartDate(calendarDate);
        projectImpl.setEndDate(calendarDate2);
        CurrentStorage.get().createProjectStorage(projectImpl);
        return projectImpl;
    }

    public static Project createProject(String string, CalendarDate calendarDate, CalendarDate calendarDate2) {
        return ProjectManager.createProject(Util.generateId(), string, calendarDate, calendarDate2);
    }

    public static void removeProject(String string) {
        Project project = ProjectManager.getProject(string);
        if (project == null) {
            return;
        }
        History.removeProjectHistory(project);
        CurrentStorage.get().removeProjectStorage(project);
        Elements elements = _root.getChildElements("project");
        for (int i = 0; i < elements.size(); ++i) {
            String string2 = elements.get(i).getAttribute("id").getValue();
            if (!string2.equals(string)) continue;
            _root.removeChild((Node)elements.get(i));
            return;
        }
    }

    static {
        ProjectManager.init();
    }
}

