/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.msproject;

import com.tapsterrock.mpx.ConstraintType;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.ProjectHeader;
import com.tapsterrock.mpx.Relation;
import com.tapsterrock.mpx.RelationType;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.ResourceAssignment;
import com.tapsterrock.mpx.Task;
import com.tapsterrock.mpx.TimeUnit;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.ganttproject.GanttResourcePanel;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;

public class GanttMPXJSaver {
    private HumanResourceManager myHrManager;
    private TaskManager myTaskManager;
    private final IGanttProject m_project;
    private GanttResourcePanel m_resources;
    private MPXFile m_mpx;
    private HashMap m_ganttMpxTaskMap = new HashMap();
    private HashMap m_ganttMpxResourceMap = new HashMap();

    protected GanttMPXJSaver(IGanttProject project) {
        this.myHrManager = (HumanResourceManager)project.getHumanResourceManager();
        this.myTaskManager = project.getTaskManager();
        this.m_project = project;
    }

    private void processResources() {
        try {
            List resources = this.myHrManager.getResources();
            for (int i = 0; i < resources.size(); ++i) {
                HumanResource ganttResource = (HumanResource)resources.get(i);
                Resource mpxResource = this.m_mpx.addResource();
                mpxResource.setName(ganttResource.getName());
                mpxResource.setEmailAddress(ganttResource.getMail());
                this.m_ganttMpxResourceMap.put(new Integer(ganttResource.getId()), mpxResource.getUniqueID());
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private void processTasks() {
        net.sourceforge.ganttproject.task.Task[] children = this.myTaskManager.getTaskHierarchy().getNestedTasks(this.myTaskManager.getTaskHierarchy().getRootTask());
        for (int i = 0; i < children.length; ++i) {
            this.processTask(children[i], null);
        }
    }

    private void processTask(net.sourceforge.ganttproject.task.Task ganttTask, Task parent) {
        try {
            int percentageComplete = ganttTask.getCompletionPercentage();
            boolean milestone = ganttTask.isMilestone();
            long taskLength = !milestone ? ganttTask.getDuration().getLength() : 0L;
            Task mpxTask = parent == null ? this.m_mpx.addTask() : parent.addTask();
            mpxTask.setName(ganttTask.getName());
            mpxTask.setMilestone(ganttTask.isMilestone());
            mpxTask.setStart(ganttTask.getStart().getTime());
            mpxTask.setConstraintDate(ganttTask.getStart().getTime());
            mpxTask.setConstraintType(ConstraintType.MUST_START_ON);
            mpxTask.setDuration(MPXDuration.getInstance((double)taskLength, (TimeUnit)TimeUnit.DAYS));
            mpxTask.setPercentageComplete((double)percentageComplete);
            mpxTask.setHyperlink(((GanttTask)ganttTask).getWebLink());
            mpxTask.setNotes(ganttTask.getNotes());
            if (percentageComplete != 0) {
                mpxTask.setActualStart(mpxTask.getStart());
            }
            this.m_ganttMpxTaskMap.put(new Integer(ganttTask.getTaskID()), mpxTask.getUniqueID());
            net.sourceforge.ganttproject.task.Task[] children = this.myTaskManager.getTaskHierarchy().getNestedTasks(ganttTask);
            for (int i = 0; i < children.length; ++i) {
                this.processTask(children[i], mpxTask);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void processRelationships() {
        net.sourceforge.ganttproject.task.Task[] children = this.myTaskManager.getTaskHierarchy().getNestedTasks(this.myTaskManager.getTaskHierarchy().getRootTask());
        for (int i = 0; i < children.length; ++i) {
            this.processRelationships(children[i]);
        }
    }

    private void processRelationships(net.sourceforge.ganttproject.task.Task ganttTask) {
        TaskDependency[] dependencies = ganttTask.getDependencies().toArray();
        block6: for (int loop = 0; loop < dependencies.length; ++loop) {
            TaskDependency relationship = dependencies[loop];
            Integer mpxSuccessorTaskID = (Integer)this.m_ganttMpxTaskMap.get(new Integer(relationship.getDependant().getTaskID()));
            Integer mpxPredecessorTaskID = (Integer)this.m_ganttMpxTaskMap.get(new Integer(relationship.getDependee().getTaskID()));
            if (mpxSuccessorTaskID == null || mpxPredecessorTaskID == null) continue;
            Task mpxSuccessorTask = this.m_mpx.getTaskByUniqueID(mpxSuccessorTaskID.intValue());
            Task mpxPredecessorTask = this.m_mpx.getTaskByUniqueID(mpxPredecessorTaskID.intValue());
            Relation mpxRelation = mpxSuccessorTask.addPredecessor(mpxPredecessorTask);
            TaskDependencyConstraint constraint = relationship.getConstraint();
            switch (constraint.getID()) {
                case 1: {
                    mpxRelation.setType(RelationType.START_START);
                    continue block6;
                }
                case 4: {
                    mpxRelation.setType(RelationType.START_FINISH);
                    continue block6;
                }
                case 2: {
                    mpxRelation.setType(RelationType.FINISH_START);
                    continue block6;
                }
                case 3: {
                    mpxRelation.setType(RelationType.FINISH_FINISH);
                }
            }
        }
        net.sourceforge.ganttproject.task.Task[] children = this.myTaskManager.getTaskHierarchy().getNestedTasks(ganttTask);
        for (int i = 0; i < children.length; ++i) {
            this.processRelationships(children[i]);
        }
    }

    private void processAssignments() {
        net.sourceforge.ganttproject.task.Task[] children = this.myTaskManager.getTaskHierarchy().getNestedTasks(this.myTaskManager.getTaskHierarchy().getRootTask());
        for (int i = 0; i < children.length; ++i) {
            this.processAssignments(children[i]);
        }
    }

    private void processAssignments(net.sourceforge.ganttproject.task.Task ganttTask) {
        try {
            net.sourceforge.ganttproject.task.ResourceAssignment[] assignments = ganttTask.getAssignments();
            for (int loop = 0; loop < assignments.length; ++loop) {
                this.processAssignment(ganttTask, assignments[loop]);
            }
            net.sourceforge.ganttproject.task.Task[] children = this.myTaskManager.getTaskHierarchy().getNestedTasks(ganttTask);
            for (int i = 0; i < children.length; ++i) {
                this.processAssignments(children[i]);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void processAssignment(net.sourceforge.ganttproject.task.Task ganttTask, net.sourceforge.ganttproject.task.ResourceAssignment ganttAssignment) throws Exception {
        Integer mpxTaskID = (Integer)this.m_ganttMpxTaskMap.get(new Integer(ganttTask.getTaskID()));
        Integer mpxResourceID = (Integer)this.m_ganttMpxResourceMap.get(new Integer(ganttAssignment.getResource().getId()));
        if (mpxTaskID != null && mpxResourceID != null) {
            Task mpxTask = this.m_mpx.getTaskByUniqueID(mpxTaskID.intValue());
            Resource mpxResource = this.m_mpx.getResourceByUniqueID(mpxResourceID.intValue());
            MPXDuration taskWork = mpxTask.getDuration();
            MPXDuration resourceWork = MPXDuration.getInstance((double)(taskWork.getDuration() * (double)ganttAssignment.getLoad() / 100.0), (TimeUnit)taskWork.getUnits());
            MPXDuration resourceActualWork = MPXDuration.getInstance((double)(resourceWork.getDuration() * mpxTask.getPercentageCompleteValue() / 100.0), (TimeUnit)resourceWork.getUnits());
            ResourceAssignment mpxResourceAssignment = mpxTask.addResourceAssignment(mpxResource);
            mpxResourceAssignment.setUnits((double)ganttAssignment.getLoad());
            mpxResourceAssignment.setWork(resourceWork);
            mpxResourceAssignment.setActualWork(resourceActualWork);
        }
    }

    protected void save(File file, MPXFile mpx) throws Exception {
        this.m_mpx = mpx;
        this.m_mpx.setAutoCalendarUniqueID(true);
        this.m_mpx.setAutoOutlineLevel(true);
        this.m_mpx.setAutoOutlineNumber(true);
        this.m_mpx.setAutoResourceID(true);
        this.m_mpx.setAutoResourceUniqueID(true);
        this.m_mpx.setAutoTaskID(true);
        this.m_mpx.setAutoTaskUniqueID(true);
        this.m_mpx.setAutoWBS(true);
        this.m_mpx.addDefaultBaseCalendar();
        ProjectHeader header = this.m_mpx.getProjectHeader();
        header.setProjectTitle(this.m_project.getProjectName());
        header.setCompany(this.m_project.getOrganization());
        header.setComments(this.m_project.getDescription());
        this.processResources();
        this.processTasks();
        this.processRelationships();
        this.processAssignments();
        header.setStartDate(mpx.getStartDate());
        mpx.write(file);
    }
}

