/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.chart.pert;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencySlice;

public class PertChartAbstraction {
    private TaskManager myTaskManager;
    private List myTaskGraph;

    public PertChartAbstraction(TaskManager taskManager) {
        this.myTaskManager = taskManager;
        this.myTaskGraph = new ArrayList();
        this.load();
    }

    private void load() {
        Task[] tasks = this.myTaskManager.getTasks();
        for (int i = 0; i < tasks.length; ++i) {
            Task task = tasks[i];
            TaskGraphNode tgn = this.getTaskGraphNode(task);
            TaskDependencySlice dependencies = task.getDependenciesAsDependee();
            TaskDependency[] relationship = dependencies.toArray();
            for (int j = 0; j < relationship.length; ++j) {
                Task successor = relationship[j].getDependant();
                tgn.addSuccessor(this.getTaskGraphNode(successor));
            }
        }
    }

    private TaskGraphNode getTaskGraphNode(Task task) {
        TaskGraphNode res = this.getTaskGraphNodeByID(task.getTaskID());
        if (res == null) {
            res = new TaskGraphNode(task);
            if (task.isMilestone()) {
                res.setType(2);
            } else if (this.myTaskManager.getTaskHierarchy().getNestedTasks(task).length == 0) {
                res.setType(0);
            } else {
                res.setType(1);
            }
            this.myTaskGraph.add(res);
        }
        return res;
    }

    public List getTaskGraphNodes() {
        return this.myTaskGraph;
    }

    public TaskGraphNode getTaskGraphNodeByID(int id) {
        TaskGraphNode res = null;
        Iterator it = this.myTaskGraph.iterator();
        while (it.hasNext()) {
            TaskGraphNode tgn = (TaskGraphNode)it.next();
            if (tgn.getID() != id) continue;
            res = tgn;
            break;
        }
        return res;
    }

    static class Type {
        public static final int NORMAL = 0;
        public static final int SUPER = 1;
        public static final int MILESTONE = 2;

        Type() {
        }
    }

    static class TaskGraphNode {
        private List successors = new ArrayList();
        private int type;
        private Task myTask;

        TaskGraphNode(Task task) {
            this.myTask = task;
        }

        void setType(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }

        void addSuccessor(TaskGraphNode successor) {
            this.successors.add(successor);
        }

        List getSuccessors() {
            return this.successors;
        }

        String getName() {
            return this.myTask.getName();
        }

        TaskLength getDuration() {
            return this.myTask.getDuration();
        }

        int getID() {
            return this.myTask.getTaskID();
        }

        boolean isCritical() {
            return this.myTask.isCritical();
        }

        public String toString() {
            return "{" + this.getName() + ", " + this.getDuration() + "}";
        }

        GregorianCalendar getEndDate() {
            return this.myTask.getEnd();
        }

        GregorianCalendar getStartDate() {
            return this.myTask.getStart();
        }
    }
}

