/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ScriptingEnvironment
extends BaseScriptingEnvironment {
    protected static final String FRAGMENT_PREFIX = "<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink'>";
    protected Timer timer = new Timer(true);
    protected UpdateManager updateManager;
    protected RunnableQueue updateRunnableQueue;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener svgAbortListener = new ScriptingEventListener("onabort");
    protected EventListener svgErrorListener = new ScriptingEventListener("onerror");
    protected EventListener svgResizeListener = new ScriptingEventListener("onresize");
    protected EventListener svgScrollListener = new ScriptingEventListener("onscroll");
    protected EventListener svgUnloadListener = new ScriptingEventListener("onunload");
    protected EventListener svgZoomListener = new ScriptingEventListener("onzoom");
    protected EventListener beginListener = new ScriptingEventListener("onbegin");
    protected EventListener endListener = new ScriptingEventListener("onend");
    protected EventListener repeatListener = new ScriptingEventListener("onrepeat");
    protected EventListener focusinListener = new ScriptingEventListener("onfocusin");
    protected EventListener focusoutListener = new ScriptingEventListener("onfocusout");
    protected EventListener activateListener = new ScriptingEventListener("onactivate");
    protected EventListener clickListener = new ScriptingEventListener("onclick");
    protected EventListener mousedownListener = new ScriptingEventListener("onmousedown");
    protected EventListener mouseupListener = new ScriptingEventListener("onmouseup");
    protected EventListener mouseoverListener = new ScriptingEventListener("onmouseover");
    protected EventListener mouseoutListener = new ScriptingEventListener("onmouseout");
    protected EventListener mousemoveListener = new ScriptingEventListener("onmousemove");
    protected EventListener keypressListener = new ScriptingEventListener("onkeypress");
    protected EventListener keydownListener = new ScriptingEventListener("onkeydown");
    protected EventListener keyupListener = new ScriptingEventListener("onkeyup");

    public ScriptingEnvironment(BridgeContext ctx) {
        super(ctx);
        this.updateManager = ctx.getUpdateManager();
        this.updateRunnableQueue = this.updateManager.getUpdateRunnableQueue();
        this.addScriptingListeners(this.document.getDocumentElement());
        EventTarget et = (EventTarget)((Object)this.document);
        this.domNodeInsertedListener = new DOMNodeInsertedListener();
        et.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
        this.domNodeRemovedListener = new DOMNodeRemovedListener();
        et.addEventListener("DOMAttrRemoved", this.domNodeRemovedListener, false);
    }

    public org.apache.batik.script.Window createWindow(Interpreter interp, String lang) {
        return new Window(interp, lang);
    }

    public void runEventHandler(String script, Event evt, String lang) {
        Interpreter interpreter = this.bridgeContext.getInterpreter(lang);
        if (interpreter == null && this.userAgent != null) {
            this.userAgent.displayError(new Exception("unknow language: " + lang));
        }
        interpreter.bindObject("event", (Object)evt);
        interpreter.bindObject("evt", (Object)evt);
        try {
            this.checkCompatibleScriptURL(lang, this.docPURL);
            interpreter.evaluate(script);
        }
        catch (InterpreterException ie) {
            this.handleInterpreterException(ie);
        }
        catch (SecurityException se) {
            this.handleSecurityException(se);
        }
    }

    public void interrupt() {
        this.timer.cancel();
        this.removeScriptingListeners(this.document.getDocumentElement());
        EventTarget et = (EventTarget)((Object)this.document);
        et.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
        et.removeEventListener("DOMAttrRemoved", this.domNodeRemovedListener, false);
    }

    protected void addScriptingListeners(Node node) {
        if (node.getNodeType() == 1) {
            Element elt = (Element)node;
            EventTarget target = (EventTarget)((Object)elt);
            if ("http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
                if ("svg".equals(elt.getLocalName())) {
                    if (elt.hasAttributeNS(null, "onabort")) {
                        target.addEventListener("SVGAbort", this.svgAbortListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onerror")) {
                        target.addEventListener("SVGError", this.svgErrorListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onresize")) {
                        target.addEventListener("SVGResize", this.svgResizeListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onscroll")) {
                        target.addEventListener("SVGScroll", this.svgScrollListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onunload")) {
                        target.addEventListener("SVGUnload", this.svgUnloadListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onzoom")) {
                        target.addEventListener("SVGZoom", this.svgZoomListener, false);
                    }
                } else {
                    String name = elt.getLocalName();
                    if (name.equals("set") || name.startsWith("animate")) {
                        if (elt.hasAttributeNS(null, "onbegin")) {
                            target.addEventListener("beginEvent", this.beginListener, false);
                        }
                        if (elt.hasAttributeNS(null, "onend")) {
                            target.addEventListener("endEvent", this.endListener, false);
                        }
                        if (elt.hasAttributeNS(null, "onrepeat")) {
                            target.addEventListener("repeatEvent", this.repeatListener, false);
                        }
                        return;
                    }
                }
            }
            if (elt.hasAttributeNS(null, "onfocusin")) {
                target.addEventListener("DOMFocusIn", this.focusinListener, false);
            }
            if (elt.hasAttributeNS(null, "onfocusout")) {
                target.addEventListener("DOMFocusOut", this.focusoutListener, false);
            }
            if (elt.hasAttributeNS(null, "onactivate")) {
                target.addEventListener("DOMActivate", this.activateListener, false);
            }
            if (elt.hasAttributeNS(null, "onclick")) {
                target.addEventListener("click", this.clickListener, false);
            }
            if (elt.hasAttributeNS(null, "onmousedown")) {
                target.addEventListener("mousedown", this.mousedownListener, false);
            }
            if (elt.hasAttributeNS(null, "onmouseup")) {
                target.addEventListener("mouseup", this.mouseupListener, false);
            }
            if (elt.hasAttributeNS(null, "onmouseover")) {
                target.addEventListener("mouseover", this.mouseoverListener, false);
            }
            if (elt.hasAttributeNS(null, "onmouseout")) {
                target.addEventListener("mouseout", this.mouseoutListener, false);
            }
            if (elt.hasAttributeNS(null, "onmousemove")) {
                target.addEventListener("mousemove", this.mousemoveListener, false);
            }
            if (elt.hasAttributeNS(null, "onkeypress")) {
                target.addEventListener("keypress", this.keypressListener, false);
            }
            if (elt.hasAttributeNS(null, "onkeydown")) {
                target.addEventListener("keydown", this.keydownListener, false);
            }
            if (elt.hasAttributeNS(null, "onkeyup")) {
                target.addEventListener("keyup", this.keyupListener, false);
            }
        }
        Node n = node.getFirstChild();
        while (n != null) {
            this.addScriptingListeners(n);
            n = n.getNextSibling();
        }
    }

    protected void removeScriptingListeners(Node node) {
        if (node.getNodeType() == 1) {
            Element elt = (Element)node;
            EventTarget target = (EventTarget)((Object)elt);
            if ("http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
                if ("svg".equals(elt.getLocalName())) {
                    target.removeEventListener("SVGAbort", this.svgAbortListener, false);
                    target.removeEventListener("SVGError", this.svgErrorListener, false);
                    target.removeEventListener("SVGResize", this.svgResizeListener, false);
                    target.removeEventListener("SVGScroll", this.svgScrollListener, false);
                    target.removeEventListener("SVGUnload", this.svgUnloadListener, false);
                    target.removeEventListener("SVGZoom", this.svgZoomListener, false);
                } else {
                    String name = elt.getLocalName();
                    if (name.equals("set") || name.startsWith("animate")) {
                        target.removeEventListener("beginEvent", this.beginListener, false);
                        target.removeEventListener("endEvent", this.endListener, false);
                        target.removeEventListener("repeatEvent", this.repeatListener, false);
                        return;
                    }
                }
            }
            target.removeEventListener("DOMFocusIn", this.focusinListener, false);
            target.removeEventListener("DOMFocusOut", this.focusoutListener, false);
            target.removeEventListener("DOMActivate", this.activateListener, false);
            target.removeEventListener("click", this.clickListener, false);
            target.removeEventListener("mousedown", this.mousedownListener, false);
            target.removeEventListener("mouseup", this.mouseupListener, false);
            target.removeEventListener("mouseover", this.mouseoverListener, false);
            target.removeEventListener("mouseout", this.mouseoutListener, false);
            target.removeEventListener("mousemove", this.mousemoveListener, false);
            target.removeEventListener("keypress", this.keypressListener, false);
            target.removeEventListener("keydown", this.keydownListener, false);
            target.removeEventListener("keyup", this.keyupListener, false);
        }
        Node n = node.getFirstChild();
        while (n != null) {
            this.removeScriptingListeners(n);
            n = n.getNextSibling();
        }
    }

    static {
        FRAGMENT_PREFIX = FRAGMENT_PREFIX;
    }

    protected class ScriptingEventListener
    implements EventListener {
        protected String attribute;

        public ScriptingEventListener(String attr) {
            this.attribute = attr;
        }

        public void handleEvent(Event evt) {
            Element elt;
            Element e = elt = (Element)((Object)evt.getCurrentTarget());
            while (!(e == null || "http://www.w3.org/2000/svg".equals(e.getNamespaceURI()) && "svg".equals(e.getLocalName()))) {
                e = SVGUtilities.getParentElement(e);
            }
            if (e == null) {
                return;
            }
            String lang = e.getAttributeNS(null, "contentScriptType");
            String script = elt.getAttributeNS(null, this.attribute);
            if (script.length() > 0) {
                ScriptingEnvironment.this.runEventHandler(script, evt, lang);
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event evt) {
            ScriptingEnvironment.this.removeScriptingListeners((Node)((Object)evt.getTarget()));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event evt) {
            ScriptingEnvironment.this.addScriptingListeners((Node)((Object)evt.getTarget()));
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;

        public Window(Interpreter interp, String lang) {
            this.interpreter = interp;
            this.language = lang;
        }

        public Object setInterval(String script, long interval) {
            TimerTask tt = new TimerTask(this, script){
                EvaluateIntervalRunnable eir;
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$script = val$script;
                    this.eir = Window.access$000(this.this$1).new EvaluateIntervalRunnable(this.val$script, this.this$1.interpreter);
                }

                public void run() {
                    if (this.eir.count > 1) {
                        return;
                    }
                    ++this.eir.count;
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(this.eir);
                    if (this.eir.error) {
                        this.cancel();
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, interval, interval);
            return tt;
        }

        public Object setInterval(Runnable r, long interval) {
            TimerTask tt = new TimerTask(this, r){
                EvaluateRunnableRunnable eihr;
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$r = val$r;
                    this.eihr = Window.access$000(this.this$1).new EvaluateRunnableRunnable(this.val$r);
                }

                public void run() {
                    if (this.eihr.count > 1) {
                        return;
                    }
                    ++this.eihr.count;
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(this.eihr);
                    if (this.eihr.error) {
                        this.cancel();
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, interval, interval);
            return tt;
        }

        public void clearInterval(Object interval) {
            ((TimerTask)interval).cancel();
        }

        public Object setTimeout(String script, long timeout) {
            TimerTask tt = new TimerTask(this, script){
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$script = val$script;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(Window.access$000(this.this$1).new EvaluateRunnable(this.val$script, this.this$1.interpreter));
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, timeout);
            return tt;
        }

        public Object setTimeout(Runnable r, long timeout) {
            TimerTask tt = new TimerTask(this, r){
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$r = val$r;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                        private final /* synthetic */ 4 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void run() {
                            block2: {
                                try {
                                    4.access$100(this.this$2).run();
                                }
                                catch (Exception e) {
                                    if (Window.access$000((Window)4.access$200(this.this$2)).userAgent == null) break block2;
                                    Window.access$000((Window)4.access$200(this.this$2)).userAgent.displayError(e);
                                }
                            }
                        }
                    });
                }

                static /* synthetic */ Runnable access$100(4 x0) {
                    return x0.val$r;
                }

                static /* synthetic */ Window access$200(4 x0) {
                    return x0.this$1;
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, timeout);
            return tt;
        }

        public void clearTimeout(Object timeout) {
            ((TimerTask)timeout).cancel();
        }

        public DocumentFragment parseXML(String text, Document doc) {
            DocumentFragment result;
            block8: {
                SAXSVGDocumentFactory df = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
                String uri = ((SVGOMDocument)ScriptingEnvironment.this.bridgeContext.getDocument()).getURLObject().toString();
                result = null;
                try {
                    Document d = df.createDocument(uri, new StringReader(text));
                    result = doc.createDocumentFragment();
                    result.appendChild(doc.importNode(d.getDocumentElement(), true));
                }
                catch (Exception ex) {
                    StringBuffer sb = new StringBuffer(text.length() + ScriptingEnvironment.FRAGMENT_PREFIX.length() + "</svg>".length());
                    sb.append(ScriptingEnvironment.FRAGMENT_PREFIX);
                    sb.append(text);
                    sb.append("</svg>");
                    String newText = sb.toString();
                    try {
                        Document d = df.createDocument(uri, new StringReader(newText));
                        Node n = d.getDocumentElement().getFirstChild();
                        while (n != null) {
                            if (n.getNodeType() == 1) {
                                n = doc.importNode(n, true);
                                result = doc.createDocumentFragment();
                                result.appendChild(n);
                            }
                            n = n.getNextSibling();
                        }
                    }
                    catch (Exception exc) {
                        SAXDocumentFactory sdf = new SAXDocumentFactory(doc.getImplementation(), XMLResourceDescriptor.getXMLParserClassName());
                        try {
                            Document d = sdf.createDocument(uri, (Reader)new StringReader(text));
                            result = doc.createDocumentFragment();
                            result.appendChild(doc.importNode(d.getDocumentElement(), true));
                        }
                        catch (Exception ext) {
                            if (ScriptingEnvironment.this.userAgent == null) break block8;
                            ScriptingEnvironment.this.userAgent.displayError(ext);
                        }
                    }
                }
            }
            return result;
        }

        public void getURL(String uri, Window.GetURLHandler h) {
            this.getURL(uri, h, "UTF8");
        }

        public void getURL(String uri, Window.GetURLHandler h, String enc) {
            Thread t = new Thread(this, uri, enc, h){
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$enc;
                private final /* synthetic */ Window.GetURLHandler val$h;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$uri = val$uri;
                    this.val$enc = val$enc;
                    this.val$h = val$h;
                }

                /*
                 * WARNING - void declaration
                 */
                public void run() {
                    try {
                        int read;
                        URL burl = ((SVGOMDocument)Window.access$000((Window)this.this$1).document).getURLObject();
                        ParsedURL purl = new ParsedURL(burl, this.val$uri);
                        String e = EncodingUtilities.javaEncoding(this.val$enc);
                        e = e == null ? this.val$enc : e;
                        Reader r = new InputStreamReader(purl.openStream(), e);
                        r = new BufferedReader(r);
                        StringWriter sw = new StringWriter();
                        char[] buf = new char[4096];
                        while ((read = r.read(buf, 0, buf.length)) != -1) {
                            void var6_8;
                            sw.write(buf, 0, (int)var6_8);
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this, purl, sw){
                            private final /* synthetic */ ParsedURL val$purl;
                            private final /* synthetic */ StringWriter val$sw;
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$purl = val$purl;
                                this.val$sw = val$sw;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        6.access$300(this.this$2).getURLDone(true, this.val$purl.getContentType(), this.val$sw.toString());
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)6.access$400(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)6.access$400(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (e instanceof SecurityException) {
                            Window.access$000((Window)this.this$1).userAgent.displayError(e);
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        6.access$300(this.this$2).getURLDone(false, null, null);
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)6.access$400(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)6.access$400(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ Window.GetURLHandler access$300(6 x0) {
                    return x0.val$h;
                }

                static /* synthetic */ Window access$400(6 x0) {
                    return x0.this$1;
                }
            };
            t.setPriority(1);
            t.start();
        }

        public void alert(String message) {
            if (ScriptingEnvironment.this.userAgent != null) {
                ScriptingEnvironment.this.userAgent.showAlert(message);
            }
        }

        public boolean confirm(String message) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showConfirm(message);
            }
            return false;
        }

        public String prompt(String message) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(message);
            }
            return null;
        }

        public String prompt(String message, String defVal) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(message, defVal);
            }
            return null;
        }

        public BridgeContext getBridgeContext() {
            return ScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }

        static /* synthetic */ ScriptingEnvironment access$000(Window x0) {
            return x0.ScriptingEnvironment.this;
        }
    }

    protected class EvaluateRunnableRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Runnable runnable;

        public EvaluateRunnableRunnable(Runnable r) {
            this.runnable = r;
        }

        public void run() {
            if (this.error) {
                return;
            }
            --this.count;
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(e);
                }
                this.error = true;
            }
        }
    }

    protected class EvaluateIntervalRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Interpreter interpreter;
        protected String script;

        public EvaluateIntervalRunnable(String s, Interpreter interp) {
            this.interpreter = interp;
            this.script = s;
        }

        public void run() {
            if (this.error) {
                return;
            }
            --this.count;
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException ie) {
                ScriptingEnvironment.this.handleInterpreterException(ie);
                this.error = true;
            }
            catch (Exception e) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(e);
                }
                this.error = true;
            }
        }
    }

    protected class EvaluateRunnable
    implements Runnable {
        protected Interpreter interpreter;
        protected String script;

        public EvaluateRunnable(String s, Interpreter interp) {
            this.interpreter = interp;
            this.script = s;
        }

        public void run() {
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException ie) {
                ScriptingEnvironment.this.handleInterpreterException(ie);
            }
        }
    }
}

