/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.htmlpdf;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.ganttproject.GanttExportSettings;
import net.sourceforge.ganttproject.export.ExportException;
import net.sourceforge.ganttproject.export.Exporter;
import net.sourceforge.ganttproject.export.TaskVisitor;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskManager;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;
import org.apache.fop.image.FopImageFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.ganttproject.impex.htmlpdf.ExportJob;
import org.ganttproject.impex.htmlpdf.ExporterBase;
import org.ganttproject.impex.htmlpdf.PDFStylesheet;
import org.ganttproject.impex.htmlpdf.Stylesheet;
import org.ganttproject.impex.htmlpdf.StylesheetFactoryImpl;
import org.ganttproject.impex.htmlpdf.StylesheetImpl;
import org.ganttproject.impex.htmlpdf.fonts.FontRecord;
import org.ganttproject.impex.htmlpdf.fonts.FontTriplet;
import org.ganttproject.impex.htmlpdf.fonts.JDKFontLocator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ExporterToPDF
extends ExporterBase
implements Exporter {
    private static final String JPG_FORMAT_NAME = "jpg";
    private PDFStylesheet myStylesheet;
    static /* synthetic */ Class class$org$ganttproject$impex$htmlpdf$ExporterToPDF;

    public String getFileTypeDescription() {
        return GanttLanguage.getInstance().getText("impex.pdf.description");
    }

    public GPOptionGroup[] getSecondaryOptions() {
        return null;
    }

    public String getFileNamePattern() {
        return "pdf";
    }

    public String proposeFileExtension() {
        return "pdf";
    }

    public String[] getFileExtensions() {
        return new String[]{"pdf"};
    }

    protected Job[] createJobs(File outputFile, List resultFiles) {
        ExportState state = new ExportState(outputFile);
        Job generateGanttChart = this.createGenerateGanttChartJob(state);
        Job generateResourceChart = this.createGenerateResourcechartJob(state);
        Job initializeFOP = this.createFOPInitializationJob(state);
        Job runTransormation = this.createTransformationJob(state);
        return new Job[]{generateGanttChart, generateResourceChart, initializeFOP, runTransormation};
    }

    private Job createGenerateGanttChartJob(final ExportState state) {
        ExportJob result = new ExportJob("generate gantt chart"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    Platform.getJobManager().cancel(ExporterBase.EXPORT_JOB_FAMILY);
                    return Status.CANCEL_STATUS;
                }
                try {
                    RenderedImage ganttChartImage = ExporterToPDF.this.getGanttChart().getRenderedImage(new GanttExportSettings(true, true, true, true));
                    state.ganttChartImageFile = File.createTempFile("ganttchart", ".jpg");
                    ImageIO.write(ganttChartImage, ExporterToPDF.JPG_FORMAT_NAME, state.ganttChartImageFile);
                    monitor.worked(1);
                }
                catch (Exception e) {
                    this.cancel();
                    ExporterToPDF.this.getUIFacade().showErrorDialog((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                catch (OutOfMemoryError e) {
                    this.cancel();
                    ExporterToPDF.this.getUIFacade().showErrorDialog((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        return result;
    }

    private Job createGenerateResourcechartJob(final ExportState state) {
        ExportJob result = new ExportJob("Generate resource chart"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    Platform.getJobManager().cancel(ExporterBase.EXPORT_JOB_FAMILY);
                    return Status.CANCEL_STATUS;
                }
                try {
                    File outputFile;
                    RenderedImage resourceChartImage = ExporterToPDF.this.getResourceChart().getRenderedImage(new GanttExportSettings(true, true, true, true));
                    state.resourceChartImageFile = outputFile = File.createTempFile("resourcechart", ".jpg");
                    ImageIO.write(resourceChartImage, ExporterToPDF.JPG_FORMAT_NAME, outputFile);
                    monitor.worked(1);
                }
                catch (Exception e) {
                    this.cancel();
                    ExporterToPDF.this.getUIFacade().showErrorDialog((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                catch (OutOfMemoryError e) {
                    this.cancel();
                    ExporterToPDF.this.getUIFacade().showErrorDialog((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        return result;
    }

    private Job createFOPInitializationJob(final ExportState state) {
        ExportJob result = new ExportJob("Initializing FOP"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    Platform.getJobManager().cancel(ExporterBase.EXPORT_JOB_FAMILY);
                    return Status.CANCEL_STATUS;
                }
                try {
                    Driver driver = new Driver();
                    driver.setRenderer(1);
                    Options options = ExporterToPDF.this.createOptions();
                    FopImageFactory.resetCache();
                    state.driver = driver;
                    monitor.worked(1);
                }
                catch (Exception e) {
                    this.cancel();
                    ExporterToPDF.this.getUIFacade().showErrorDialog((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        return result;
    }

    private Job createTransformationJob(final ExportState state) {
        ExportJob result = new ExportJob("Generating PDF"){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                block14: {
                    if (monitor.isCanceled()) {
                        Platform.getJobManager().cancel(ExporterBase.EXPORT_JOB_FAMILY);
                        return Status.CANCEL_STATUS;
                    }
                    if (!$assertionsDisabled && ExporterToPDF.this.myStylesheet == null) {
                        throw new AssertionError();
                    }
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(state.outputFile);
                        state.driver.setOutputStream((OutputStream)out);
                        TransformerHandler stylesheetHandler = ExporterToPDF.this.createHandler(ExporterToPDF.this.myStylesheet.getUrl().toString());
                        stylesheetHandler.setResult(new SAXResult(state.driver.getContentHandler()));
                        ExporterToPDF.this.exportProject(state, stylesheetHandler);
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        monitor.worked(1);
                        if (out != null) {
                            try {
                                out.flush();
                                ((OutputStream)out).close();
                            }
                            catch (IOException e2) {
                                ExporterToPDF.this.getUIFacade().showErrorDialog((Throwable)e2);
                            }
                        }
                        throw throwable;
                    }
                    monitor.worked(1);
                    if (out != null) {
                        try {
                            out.flush();
                            ((OutputStream)out).close();
                        }
                        catch (IOException e2) {
                            ExporterToPDF.this.getUIFacade().showErrorDialog((Throwable)e2);
                        }
                    }
                    break block14;
                    {
                        catch (Exception e) {
                            this.cancel();
                            ExporterToPDF.this.getUIFacade().showErrorDialog((Throwable)e);
                            IStatus iStatus = Status.CANCEL_STATUS;
                            Object var6_6 = null;
                            monitor.worked(1);
                            if (out != null) {
                                try {
                                    out.flush();
                                    ((OutputStream)out).close();
                                }
                                catch (IOException e2) {
                                    ExporterToPDF.this.getUIFacade().showErrorDialog((Throwable)e2);
                                }
                            }
                            return iStatus;
                        }
                    }
                }
                return Status.OK_STATUS;
            }

            static {
                $assertionsDisabled = !(class$org$ganttproject$impex$htmlpdf$ExporterToPDF == null ? (class$org$ganttproject$impex$htmlpdf$ExporterToPDF = ExporterToPDF.class$("org.ganttproject.impex.htmlpdf.ExporterToPDF")) : class$org$ganttproject$impex$htmlpdf$ExporterToPDF).desiredAssertionStatus();
            }
        };
        return result;
    }

    private String i18n(String key) {
        String text = GanttLanguage.getInstance().getText(key);
        return GanttLanguage.getInstance().correctLabel(text);
    }

    protected void exportProject(ExportState state, TransformerHandler handler) throws SAXException, ExportException {
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        handler.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("xmlns:xsl", "http://www.w3.org/1999/XSL/Transform", attrs);
        this.addAttribute("xmlns:ganttproject", "http://ganttproject.sf.net/", attrs);
        this.addAttribute("version", "1.0", attrs);
        this.startElement("xsl:stylesheet", attrs, handler);
        this.addAttribute("xslfo-path", this.myStylesheet.getUrl().getPath(), attrs);
        this.startPrefixedElement("report", attrs, handler);
        this.addAttribute("xslfo-path", this.myStylesheet.getUrl().getPath(), attrs);
        this.addAttribute("title", this.i18n("ganttReport"), attrs);
        this.addAttribute("name", this.i18n("project"), attrs);
        this.addAttribute("nameValue", this.getProject().getProjectName(), attrs);
        this.addAttribute("organisation", this.i18n("organization"), attrs);
        this.addAttribute("organisationValue", this.getProject().getOrganization(), attrs);
        this.addAttribute("webLink", this.i18n("webLink"), attrs);
        this.addAttribute("webLinkValue", this.getProject().getWebLink(), attrs);
        this.addAttribute("currentDateTimeValue", df.format(new Date()), attrs);
        this.addAttribute("description", this.i18n("shortDescription"), attrs);
        this.startPrefixedElement("project", attrs, handler);
        this.textElement("descriptionValue", attrs, this.getProject().getDescription(), handler);
        this.endPrefixedElement("project", handler);
        this.writeCharts(state, handler);
        this.writeTasks(this.getProject().getTaskManager(), handler);
        this.writeResources(this.getProject().getHumanResourceManager(), handler);
        this.endPrefixedElement("report", handler);
        this.endElement("xsl:stylesheet", handler);
        handler.endDocument();
    }

    private void writeCharts(ExportState state, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("title", this.i18n("ganttChart"), attrs);
        this.addAttribute("src", state.ganttChartImageFile.getAbsolutePath(), attrs);
        this.startPrefixedElement("ganttchart", attrs, handler);
        this.endPrefixedElement("ganttchart", handler);
        this.addAttribute("title", this.i18n("resourcesChart"), attrs);
        this.addAttribute("src", state.resourceChartImageFile.getAbsolutePath(), attrs);
        this.startPrefixedElement("resourceschart", attrs, handler);
        this.endPrefixedElement("resourceschart", handler);
    }

    private void writeTasks(TaskManager taskManager, final TransformerHandler handler) throws ExportException, SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("xslfo-path", "", attrs);
        this.addAttribute("title", this.i18n("tasksList"), attrs);
        this.addAttribute("name", this.i18n("name"), attrs);
        this.addAttribute("begin", this.i18n("start"), attrs);
        this.addAttribute("end", this.i18n("end"), attrs);
        this.addAttribute("milestone", this.i18n("meetingPoint"), attrs);
        this.addAttribute("progress", "%", attrs);
        this.addAttribute("assigned-to", "Res.", attrs);
        this.addAttribute("notes", this.i18n("notes"), attrs);
        this.startPrefixedElement("tasks", attrs, handler);
        TaskVisitor visitor = new TaskVisitor(){
            AttributesImpl myAttrs = new AttributesImpl();

            protected String serializeTask(Task t, int depth) throws Exception {
                ExporterToPDF.this.startPrefixedElement("task", this.myAttrs, handler);
                ExporterToPDF.this.textElement("name", this.myAttrs, t.getName(), handler);
                ExporterToPDF.this.textElement("begin", this.myAttrs, t.getStart().toString(), handler);
                ExporterToPDF.this.textElement("end", this.myAttrs, t.getEnd().toString(), handler);
                ExporterToPDF.this.textElement("milestone", this.myAttrs, Boolean.valueOf(t.isMilestone()).toString(), handler);
                ExporterToPDF.this.textElement("progress", this.myAttrs, String.valueOf(t.getCompletionPercentage()), handler);
                StringBuffer usersS = new StringBuffer();
                ResourceAssignment[] assignments = t.getAssignments();
                if (assignments.length > 0) {
                    for (int j = 0; j < assignments.length; ++j) {
                        usersS.append(assignments[j].getResource().getName() + "\n");
                    }
                } else {
                    usersS.append("&#160;");
                }
                ExporterToPDF.this.textElement("assigned-to", this.myAttrs, usersS.toString(), handler);
                ExporterToPDF.this.textElement("notes", this.myAttrs, t.getNotes() == null || t.getNotes().length() == 0 ? " " : t.getNotes(), handler);
                if (t.getColor() != null) {
                    ExporterToPDF.this.textElement("color", this.myAttrs, ExporterToPDF.getHexaColor(t.getColor()), handler);
                }
                ExporterToPDF.this.endPrefixedElement("task", handler);
                return "";
            }
        };
        try {
            visitor.visit(taskManager);
        }
        catch (Exception e) {
            throw new ExportException("Failed to write tasks", (Throwable)e);
        }
        this.endPrefixedElement("tasks", handler);
    }

    private void writeResources(ResourceManager resourceManager, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute("title", this.i18n("resourcesList"), attrs);
        this.addAttribute("name", this.i18n("colName"), attrs);
        this.addAttribute("role", this.i18n("colRole"), attrs);
        this.addAttribute("mail", this.i18n("colMail"), attrs);
        this.addAttribute("phone", this.i18n("colPhone"), attrs);
        this.startPrefixedElement("resources", attrs, handler);
        List resources = resourceManager.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            HumanResource p = (HumanResource)resources.get(i);
            this.startPrefixedElement("resource", attrs, handler);
            this.textElement("name", attrs, p.getName(), handler);
            this.textElement("role", attrs, p.getRole().getName(), handler);
            this.textElement("mail", attrs, p.getMail(), handler);
            this.textElement("phone", attrs, p.getPhone(), handler);
            this.endPrefixedElement("resource", handler);
        }
        this.endPrefixedElement("resources", handler);
    }

    private Options createOptions() throws ExportException {
        Options result;
        JDKFontLocator locator = new JDKFontLocator();
        FontRecord[] fontRecords = locator.getFontRecords();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult output = new StreamResult(outputStream);
        try {
            TransformerHandler handler = this.getTransformerFactory().newTransformerHandler();
            handler.setResult(output);
            this.createConfiguration(handler, fontRecords);
        }
        catch (TransformerConfigurationException e) {
            throw new ExportException("Failed to create FOP options", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ExportException("Failed to create FOP options", (Throwable)e);
        }
        try {
            result = new Options((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        }
        catch (FOPException e) {
            throw new ExportException("Failed to create FOP options", (Throwable)e);
        }
        return result;
    }

    private void createConfiguration(TransformerHandler handler, FontRecord[] fontRecords) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        handler.startDocument();
        handler.startElement("", "configuration", "configuration", attrs);
        handler.startElement("", "fonts", "fonts", attrs);
        for (int i = 0; i < fontRecords.length; ++i) {
            FontRecord nextRecord = fontRecords[i];
            attrs.clear();
            attrs.addAttribute("", "metrics-file", "metrics-file", "CDATA", nextRecord.getMetricsLocation().toString());
            attrs.addAttribute("", "kerning", "kerning", "CDATA", "yes");
            attrs.addAttribute("", "embed-file", "embed-file", "CDATA", nextRecord.getFontLocation().getPath());
            handler.startElement("", "font", "font", attrs);
            this.writeTriplets(handler, nextRecord.getFontTriplets());
            handler.endElement("", "font", "font");
        }
        handler.endElement("", "fonts", "fonts");
        handler.endElement("", "configuration", "configuration");
        handler.endDocument();
    }

    private void writeTriplets(TransformerHandler handler, FontTriplet[] fontTriplets) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        for (int i = 0; i < fontTriplets.length; ++i) {
            FontTriplet next = fontTriplets[i];
            attrs.clear();
            attrs.addAttribute("", "name", "name", "CDATA", next.getName());
            attrs.addAttribute("", "style", "style", "CDATA", next.isItalic() ? "italic" : "normal");
            attrs.addAttribute("", "weight", "weight", "CDATA", next.isBold() ? "bold" : "normal");
            handler.startElement("", "font-triplet", "font-triplet", attrs);
            handler.endElement("", "font-triplet", "font-triplet");
        }
    }

    protected void setSelectedStylesheet(Stylesheet stylesheet) {
        this.myStylesheet = (PDFStylesheet)stylesheet;
    }

    protected String getStylesheetOptionID() {
        return "impex.pdf.stylesheet";
    }

    protected Stylesheet[] getStylesheets() {
        StylesheetFactoryImpl factory = new StylesheetFactoryImpl(){

            protected Stylesheet newStylesheet(URL resolvedUrl, String localizedName) {
                return new PDFStylesheetImpl(resolvedUrl, localizedName);
            }
        };
        return factory.createStylesheets(PDFStylesheet.class);
    }

    private static String getHexaColor(Color color) {
        StringBuffer out = new StringBuffer();
        out.append("#");
        if (color.getRed() <= 15) {
            out.append("0");
        }
        out.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() <= 15) {
            out.append("0");
        }
        out.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() <= 15) {
            out.append("0");
        }
        out.append(Integer.toHexString(color.getBlue()));
        return out.toString();
    }

    private class PDFStylesheetImpl
    extends StylesheetImpl
    implements PDFStylesheet {
        PDFStylesheetImpl(URL stylesheetURL, String localizedName) {
            super(stylesheetURL, localizedName);
        }
    }

    private static class ExportState {
        final File outputFile;
        Driver driver;
        File ganttChartImageFile;
        File resourceChartImageFile;

        public ExportState(File outputFile) {
            this.outputFile = outputFile;
        }
    }
}

