/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.AccrueType;
import com.tapsterrock.mpx.ConstraintType;
import com.tapsterrock.mpx.EarnedValueMethod;
import com.tapsterrock.mpx.ExtendedAttributeContainer;
import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXCalendar;
import com.tapsterrock.mpx.MPXCurrency;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXPercentage;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.Priority;
import com.tapsterrock.mpx.Record;
import com.tapsterrock.mpx.RecurringTask;
import com.tapsterrock.mpx.Relation;
import com.tapsterrock.mpx.RelationList;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.ResourceAssignment;
import com.tapsterrock.mpx.TaskModel;
import com.tapsterrock.mpx.TaskNotes;
import com.tapsterrock.mpx.TaskType;
import com.tapsterrock.mpx.TimeUnit;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class Task
extends MPXRecord
implements Comparable,
ExtendedAttributeContainer {
    private Task m_parent;
    private LinkedList m_children = new LinkedList();
    private TaskModel m_model;
    private LinkedList m_assignments = new LinkedList();
    private TaskNotes m_notes;
    private RecurringTask m_recurringTask;
    private boolean m_estimated;
    private Date m_deadline;
    private TaskType m_type = TaskType.FIXED_UNITS;
    private boolean m_effortDriven;
    private Number m_overtimeCost;
    private Number m_actualOvertimeCost;
    private MPXDuration m_actualOvertimeWork;
    private AccrueType m_fixedCostAccrual;
    private String m_hyperlink;
    private String m_hyperlinkAddress;
    private String m_hyperlinkSubAddress;
    private boolean m_levelAssignments;
    private boolean m_levelingCanSplit;
    private MPXDuration m_levelingDelay;
    private MPXDuration m_overtimeWork;
    private Date m_preleveledStart;
    private Date m_preleveledFinish;
    private MPXDuration m_remainingOvertimeWork;
    private Number m_remainingOvertimeCost;
    private String m_calendarName;
    private boolean m_null;
    private String m_wbsLevel;
    private TimeUnit m_durationFormat;
    private boolean m_resumeValid;
    private boolean m_recurring;
    private boolean m_overAllocated;
    private boolean m_subproject;
    private boolean m_subprojectReadOnly;
    private Integer m_subprojectTaskUniqueID;
    private boolean m_externalTask;
    private String m_externalTaskProject;
    private Number m_acwp;
    private TimeUnit m_levelingDelayFormat;
    private boolean m_ignoreResourceCalendar;
    private Integer m_physicalPercentComplete;
    private EarnedValueMethod m_earnedValueMethod;
    private MPXDuration m_actualWorkProtected;
    private MPXDuration m_actualOvertimeWorkProtected;
    private MPXDuration m_regularWork;
    private static final int PERCENTAGE_COMPLETE = 44;
    private static final int PERCENTAGE_WORK_COMPLETE = 25;
    private static final int ACTUAL_COST = 32;
    private static final int ACTUAL_DURATION = 42;
    private static final int ACTUAL_FINISH = 59;
    private static final int ACTUAL_START = 58;
    private static final int ACTUAL_WORK = 22;
    private static final int BASELINE_COST = 31;
    private static final int BASELINE_DURATION = 41;
    private static final int BASELINE_FINISH = 57;
    private static final int BASELINE_START = 56;
    private static final int BASELINE_WORK = 21;
    private static final int BCWP = 86;
    private static final int BCWS = 85;
    private static final int CONFIRMED = 135;
    private static final int CONSTRAINT_DATE = 68;
    private static final int CONSTRAINT_TYPE = 91;
    private static final int CONTACT = 15;
    private static final int COST = 30;
    public static final int COST1 = 36;
    public static final int COST2 = 37;
    public static final int COST3 = 38;
    private static final int COST_VARIANCE = 34;
    private static final int CREATE_DATE = 125;
    private static final int CRITICAL = 82;
    private static final int CV = 88;
    private static final int DELAY = 92;
    private static final int DURATION = 40;
    public static final int DURATION1 = 46;
    public static final int DURATION2 = 47;
    public static final int DURATION3 = 48;
    private static final int DURATION_VARIANCE = 45;
    private static final int EARLY_FINISH = 53;
    private static final int EARLY_START = 52;
    private static final int FINISH = 51;
    public static final int FINISH1 = 61;
    public static final int FINISH2 = 63;
    public static final int FINISH3 = 65;
    public static final int FINISH4 = 127;
    public static final int FINISH5 = 129;
    private static final int FINISH_VARIANCE = 67;
    private static final int FIXED = 80;
    private static final int FIXED_COST = 35;
    public static final int FLAG1 = 110;
    public static final int FLAG2 = 111;
    public static final int FLAG3 = 112;
    public static final int FLAG4 = 113;
    public static final int FLAG5 = 114;
    public static final int FLAG6 = 115;
    public static final int FLAG7 = 116;
    public static final int FLAG8 = 117;
    public static final int FLAG9 = 118;
    public static final int FLAG10 = 119;
    private static final int FREE_SLACK = 93;
    private static final int HIDE_BAR = 123;
    private static final int ID = 90;
    private static final int LATE_FINISH = 55;
    private static final int LATE_START = 54;
    private static final int LINKED_FIELDS = 122;
    private static final int MARKED = 83;
    private static final int MILESTONE = 81;
    private static final int NAME = 1;
    public static final int NUMBER1 = 140;
    public static final int NUMBER2 = 141;
    public static final int NUMBER3 = 142;
    public static final int NUMBER4 = 143;
    public static final int NUMBER5 = 144;
    private static final int OBJECTS = 121;
    private static final int OUTLINE_LEVEL = 3;
    private static final int OUTLINE_NUMBER = 99;
    private static final int PREDECESSORS = 70;
    private static final int PRIORITY = 95;
    private static final int PROJECT = 97;
    private static final int REMAINING_COST = 33;
    private static final int REMAINING_DURATION = 43;
    private static final int REMAINING_WORK = 23;
    private static final int RESOURCE_GROUP = 16;
    private static final int RESOURCE_INITIALS = 73;
    private static final int RESOURCE_NAMES = 72;
    private static final int RESUME = 151;
    private static final int RESUME_NO_EARLIER_THAN = 152;
    private static final int ROLLUP = 84;
    private static final int START = 50;
    public static final int START1 = 60;
    public static final int START2 = 62;
    public static final int START3 = 64;
    public static final int START4 = 126;
    public static final int START5 = 128;
    private static final int START_VARIANCE = 66;
    private static final int STOP = 150;
    private static final int SUBPROJECT_NAME = 96;
    private static final int SUCCESSORS = 71;
    private static final int SUMMARY = 120;
    private static final int SV = 87;
    public static final int TEXT1 = 4;
    public static final int TEXT2 = 5;
    public static final int TEXT3 = 6;
    public static final int TEXT4 = 7;
    public static final int TEXT5 = 8;
    public static final int TEXT6 = 9;
    public static final int TEXT7 = 10;
    public static final int TEXT8 = 11;
    public static final int TEXT9 = 12;
    public static final int TEXT10 = 13;
    private static final int TOTAL_SLACK = 94;
    private static final int UNIQUE_ID = 98;
    private static final int UNIQUE_ID_PREDECESSORS = 76;
    private static final int UNIQUE_ID_SUCCESSORS = 75;
    private static final int UPDATE_NEEDED = 136;
    private static final int WBS = 2;
    private static final int WORK = 20;
    private static final int WORK_VARIANCE = 24;
    static final int MAX_FIELDS = 153;
    private static final int MAX_EXTENDED_FIELDS = 89;
    public static final int TEXT11 = 1000;
    public static final int TEXT12 = 1001;
    public static final int TEXT13 = 1002;
    public static final int TEXT14 = 1003;
    public static final int TEXT15 = 1004;
    public static final int TEXT16 = 1005;
    public static final int TEXT17 = 1006;
    public static final int TEXT18 = 1007;
    public static final int TEXT19 = 1008;
    public static final int TEXT20 = 1009;
    public static final int TEXT21 = 1010;
    public static final int TEXT22 = 1011;
    public static final int TEXT23 = 1012;
    public static final int TEXT24 = 1013;
    public static final int TEXT25 = 1014;
    public static final int TEXT26 = 1015;
    public static final int TEXT27 = 1016;
    public static final int TEXT28 = 1017;
    public static final int TEXT29 = 1018;
    public static final int TEXT30 = 1019;
    public static final int START6 = 1020;
    public static final int START7 = 1021;
    public static final int START8 = 1022;
    public static final int START9 = 1023;
    public static final int START10 = 1024;
    public static final int FINISH6 = 1025;
    public static final int FINISH7 = 1026;
    public static final int FINISH8 = 1027;
    public static final int FINISH9 = 1028;
    public static final int FINISH10 = 1029;
    public static final int COST4 = 1030;
    public static final int COST5 = 1031;
    public static final int COST6 = 1032;
    public static final int COST7 = 1033;
    public static final int COST8 = 1034;
    public static final int COST9 = 1035;
    public static final int COST10 = 1036;
    public static final int DATE1 = 1037;
    public static final int DATE2 = 1038;
    public static final int DATE3 = 1039;
    public static final int DATE4 = 1040;
    public static final int DATE5 = 1041;
    public static final int DATE6 = 1042;
    public static final int DATE7 = 1043;
    public static final int DATE8 = 1044;
    public static final int DATE9 = 1045;
    public static final int DATE10 = 1046;
    public static final int FLAG11 = 1047;
    public static final int FLAG12 = 1048;
    public static final int FLAG13 = 1049;
    public static final int FLAG14 = 1050;
    public static final int FLAG15 = 1051;
    public static final int FLAG16 = 1052;
    public static final int FLAG17 = 1053;
    public static final int FLAG18 = 1054;
    public static final int FLAG19 = 1055;
    public static final int FLAG20 = 1056;
    public static final int NUMBER6 = 1057;
    public static final int NUMBER7 = 1058;
    public static final int NUMBER8 = 1059;
    public static final int NUMBER9 = 1060;
    public static final int NUMBER10 = 1061;
    public static final int NUMBER11 = 1062;
    public static final int NUMBER12 = 1063;
    public static final int NUMBER13 = 1064;
    public static final int NUMBER14 = 1065;
    public static final int NUMBER15 = 1066;
    public static final int NUMBER16 = 1067;
    public static final int NUMBER17 = 1068;
    public static final int NUMBER18 = 1069;
    public static final int NUMBER19 = 1070;
    public static final int NUMBER20 = 1071;
    public static final int DURATION4 = 1072;
    public static final int DURATION5 = 1073;
    public static final int DURATION6 = 1074;
    public static final int DURATION7 = 1075;
    public static final int DURATION8 = 1076;
    public static final int DURATION9 = 1077;
    public static final int DURATION10 = 1078;
    public static final int OUTLINECODE1 = 1079;
    public static final int OUTLINECODE2 = 1080;
    public static final int OUTLINECODE3 = 1081;
    public static final int OUTLINECODE4 = 1082;
    public static final int OUTLINECODE5 = 1083;
    public static final int OUTLINECODE6 = 1084;
    public static final int OUTLINECODE7 = 1085;
    public static final int OUTLINECODE8 = 1086;
    public static final int OUTLINECODE9 = 1087;
    public static final int OUTLINECODE10 = 1088;
    static final int RECORD_NUMBER = 70;

    Task(MPXFile file, Task parent) {
        super(file, 153, 89);
        this.m_model = this.getParentFile().getTaskModel();
        this.m_parent = parent;
        if (file.getAutoWBS()) {
            this.generateWBS(parent);
        }
        if (file.getAutoOutlineNumber()) {
            this.generateOutlineNumber(parent);
        }
        if (file.getAutoOutlineLevel()) {
            this.setOutlineLevel(parent.getOutlineLevelValue() + 1);
        }
        if (file.getAutoTaskUniqueID()) {
            this.setUniqueID(file.getTaskUniqueID());
        }
        if (file.getAutoTaskID()) {
            this.setID(file.getTaskID());
        }
    }

    Task(MPXFile file, Record record) throws MPXException {
        super(file, 153, 89);
        String falseText = LocaleData.getString(this.getParentFile().getLocale(), "NO");
        this.m_model = this.getParentFile().getTaskModel();
        int x = 0;
        int i = 0;
        int length = record.getLength();
        int[] model = this.m_model.getModel();
        block14: while (i < length && (x = model[i]) != -1) {
            String field;
            if ((field = record.getString(i++)) == null || field.length() == 0) continue;
            switch (x) {
                case 70: 
                case 71: 
                case 75: 
                case 76: {
                    this.set(x, new RelationList(field, this.getParentFile()));
                    continue block14;
                }
                case 25: 
                case 44: {
                    this.set(x, MPXPercentage.getInstance(field, this.getParentFile().getPercentageDecimalFormat()));
                    continue block14;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 85: 
                case 86: 
                case 87: 
                case 88: {
                    this.set(x, MPXCurrency.getInstance(this.getParentFile(), field));
                    continue block14;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 66: 
                case 67: 
                case 92: 
                case 93: 
                case 94: {
                    this.set(x, MPXDuration.getInstance(field, this.getParentFile().getDurationDecimalFormat(), this.getParentFile().getLocale()));
                    continue block14;
                }
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 68: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 150: 
                case 151: 
                case 152: {
                    this.set(x, this.getParentFile().getDateTimeFormat().parse(field));
                    continue block14;
                }
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 122: 
                case 123: 
                case 135: 
                case 136: {
                    this.set(x, field.equalsIgnoreCase(falseText) ? Boolean.FALSE : Boolean.TRUE);
                    continue block14;
                }
                case 91: {
                    this.set(x, ConstraintType.getInstance(this.getParentFile().getLocale(), field));
                    continue block14;
                }
                case 3: 
                case 121: {
                    this.set(x, Integer.valueOf(field));
                    continue block14;
                }
                case 90: {
                    this.setID(Integer.valueOf(field));
                    continue block14;
                }
                case 98: {
                    this.setUniqueID(Integer.valueOf(field));
                    continue block14;
                }
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: {
                    this.set(x, this.getParentFile().getDecimalFormat().parse(field));
                    continue block14;
                }
                case 95: {
                    this.set(x, Priority.getInstance(this.getParentFile().getLocale(), field));
                    continue block14;
                }
            }
            this.set(x, field);
        }
        if (file.getAutoWBS()) {
            this.generateWBS(null);
        }
        if (file.getAutoOutlineNumber()) {
            this.generateOutlineNumber(null);
        }
        if (file.getAutoOutlineLevel()) {
            this.setOutlineLevel(1);
        }
        if (file.getAutoTaskUniqueID()) {
            this.setUniqueID(file.getTaskUniqueID());
        }
        if (file.getAutoTaskID()) {
            this.setID(file.getTaskID());
        }
        if (this.getFixedValue()) {
            this.setType(TaskType.FIXED_DURATION);
        } else {
            this.setType(TaskType.FIXED_UNITS);
        }
    }

    void generateWBS(Task parent) {
        String wbs;
        if (parent == null) {
            wbs = Integer.toString(this.getParentFile().getChildTaskCount() + 1) + ".0";
        } else {
            wbs = parent.getWBS();
            int index = wbs.lastIndexOf(".0");
            if (index != -1) {
                wbs = wbs.substring(0, index);
            }
            wbs = wbs + "." + (parent.getChildTaskCount() + 1);
        }
        this.setWBS(wbs);
    }

    void generateOutlineNumber(Task parent) {
        String outline;
        if (parent == null) {
            outline = Integer.toString(this.getParentFile().getChildTaskCount() + 1) + ".0";
        } else {
            outline = parent.getOutlineNumber();
            int index = outline.lastIndexOf(".0");
            if (index != -1) {
                outline = outline.substring(0, index);
            }
            outline = outline + "." + (parent.getChildTaskCount() + 1);
        }
        this.setOutlineNumber(outline);
    }

    public TaskNotes setNotes(String notes) {
        if (this.m_notes == null) {
            this.m_notes = new TaskNotes(this.getParentFile());
        }
        this.m_notes.setNotes(notes);
        return this.m_notes;
    }

    TaskNotes addTaskNotes(Record record) throws MPXException {
        if (this.m_notes != null) {
            throw new MPXException("Maximum number of records of this type exist");
        }
        this.m_notes = new TaskNotes(this.getParentFile(), record);
        return this.m_notes;
    }

    public Task addTask() throws MPXException {
        MPXFile parent = this.getParentFile();
        Task task = new Task(parent, this);
        this.m_children.add(task);
        parent.addTask(task);
        this.setSummary(true);
        return task;
    }

    void addChildTask(Task child, int childOutlineLevel) throws MPXException {
        int outlineLevel = this.getOutlineLevelValue();
        if (outlineLevel + 1 == childOutlineLevel) {
            this.m_children.add(child);
        } else if (!this.m_children.isEmpty()) {
            ((Task)this.m_children.getLast()).addChildTask(child, childOutlineLevel);
        }
    }

    void addChildTask(Task child) {
        child.m_parent = this;
        this.m_children.add(child);
    }

    void clearChildTasks() {
        this.m_children.clear();
    }

    public RecurringTask addRecurringTask() throws MPXException {
        if (this.m_recurringTask != null) {
            throw new MPXException("Maximum number of records of this type exist");
        }
        this.m_recurringTask = new RecurringTask(this.getParentFile());
        return this.m_recurringTask;
    }

    RecurringTask addRecurringTask(Record record) throws MPXException {
        if (this.m_recurringTask != null) {
            throw new MPXException("Maximum number of records of this type exist");
        }
        this.m_recurringTask = new RecurringTask(this.getParentFile(), record);
        return this.m_recurringTask;
    }

    public RecurringTask getRecurringTask() {
        return this.m_recurringTask;
    }

    public ResourceAssignment addResourceAssignment(Resource resource) throws MPXException {
        int uniqueID;
        Iterator iter = this.m_assignments.iterator();
        ResourceAssignment assignment = null;
        int resourceUniqueID = resource.getUniqueIDValue();
        while (iter.hasNext() && (uniqueID = (assignment = (ResourceAssignment)iter.next()).getResourceUniqueIDValue()) != resourceUniqueID) {
            assignment = null;
        }
        if (assignment == null) {
            assignment = new ResourceAssignment(this.getParentFile(), this);
            this.m_assignments.add(assignment);
            this.getParentFile().addResourceAssignment(assignment);
            assignment.setResourceID(resource.getID());
            assignment.setResourceUniqueID(resourceUniqueID);
            assignment.setWork(this.getDuration());
            assignment.setUnits(ResourceAssignment.DEFAULT_UNITS);
            resource.addAssignment(assignment);
        }
        return assignment;
    }

    ResourceAssignment addResourceAssignment(Record record) throws MPXException {
        ResourceAssignment assignment = new ResourceAssignment(this.getParentFile(), record, this);
        this.m_assignments.add(assignment);
        Resource resource = assignment.getResource();
        if (resource != null) {
            resource.addAssignment(assignment);
        }
        return assignment;
    }

    public LinkedList getResourceAssignments() {
        return this.m_assignments;
    }

    public Relation addPredecessor() {
        return this.addPredecessor(null);
    }

    public Relation addPredecessor(Task task) {
        RelationList list = (RelationList)this.get(70);
        if (list == null) {
            list = new RelationList();
            this.set(70, list);
        }
        Relation rel = null;
        if (task != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext() && (rel = (Relation)iter.next()).getTaskIDValue() != task.getIDValue()) {
                rel = null;
            }
        }
        if (rel == null) {
            rel = new Relation(this.getParentFile());
            if (task != null) {
                rel.setTaskIDValue(task.getIDValue());
                rel.setTaskUniqueIDValue(task.getUniqueIDValue());
            }
            list.add(rel);
        }
        return rel;
    }

    public Relation addUniqueIdPredecessor() {
        return this.addUniqueIdPredecessor(null);
    }

    public Relation addUniqueIdPredecessor(Task task) {
        RelationList list = (RelationList)this.get(76);
        if (list == null) {
            list = new RelationList();
            this.set(76, list);
        }
        Relation rel = null;
        if (task != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext() && (rel = (Relation)iter.next()).getTaskIDValue() != task.getUniqueIDValue()) {
                rel = null;
            }
        }
        if (rel == null) {
            rel = new Relation(this.getParentFile());
            if (task != null) {
                rel.setTaskIDValue(task.getIDValue());
                rel.setTaskUniqueIDValue(task.getUniqueIDValue());
            }
            list.add(rel);
        }
        return rel;
    }

    public Relation addSuccessor() {
        return this.addSuccessor(null);
    }

    public Relation addSuccessor(Task task) {
        RelationList list = (RelationList)this.get(71);
        if (list == null) {
            list = new RelationList();
            this.set(71, list);
        }
        Relation rel = new Relation(this.getParentFile());
        if (task != null) {
            rel.setTaskIDValue(task.getIDValue());
            rel.setTaskUniqueIDValue(task.getUniqueIDValue());
        }
        list.add(rel);
        return rel;
    }

    public Relation addUniqueIdSuccessor() {
        return this.addUniqueIdSuccessor(null);
    }

    public Relation addUniqueIdSuccessor(Task task) {
        RelationList list = (RelationList)this.get(75);
        if (list == null) {
            list = new RelationList();
            this.set(75, list);
        }
        Relation rel = new Relation(this.getParentFile());
        if (task != null) {
            rel.setTaskIDValue(task.getIDValue());
            rel.setTaskUniqueIDValue(task.getUniqueIDValue());
        }
        list.add(rel);
        return rel;
    }

    public void set(int field, Object val) {
        this.m_model.add(field);
        this.put(field, val);
    }

    private void set(int field, int val) {
        this.m_model.add(field);
        this.put(field, val);
    }

    private void set(int field, boolean val) {
        this.m_model.add(field);
        this.put(field, val);
    }

    public void setDate(int field, Date val) {
        this.m_model.add(field);
        this.putDate(field, val);
    }

    private void setPercentage(int field, Number val) {
        this.m_model.add(field);
        this.putPercentage(field, val);
    }

    public void setCurrency(int field, Number val) {
        this.m_model.add(field);
        this.putCurrency(field, val);
    }

    public void setPercentageComplete(double val) {
        this.setPercentage(44, MPXPercentage.getInstance(val));
    }

    public void setPercentageComplete(Number val) {
        this.setPercentage(44, val);
    }

    public void setPercentageWorkComplete(double val) {
        this.setPercentage(25, MPXPercentage.getInstance(val));
    }

    public void setPercentageWorkComplete(Number val) {
        this.setPercentage(25, val);
    }

    public void setActualCost(Number val) {
        this.setCurrency(32, val);
    }

    public void setActualDuration(MPXDuration val) {
        this.set(42, val);
    }

    public void setActualFinish(Date val) {
        this.setDate(59, val);
    }

    public void setActualStart(Date val) {
        this.setDate(58, val);
    }

    public void setActualWork(MPXDuration val) {
        this.set(22, val);
    }

    public void setBaselineCost(Number val) {
        this.setCurrency(31, val);
    }

    public void setBaselineDuration(MPXDuration val) {
        this.set(41, val);
    }

    public void setBaselineFinish(Date val) {
        this.setDate(57, val);
    }

    public void setBaselineStart(Date val) {
        this.setDate(56, val);
    }

    public void setBaselineWork(MPXDuration val) {
        this.set(21, val);
    }

    public void setBCWP(Number val) {
        this.setCurrency(86, val);
    }

    public void setBCWS(Number val) {
        this.setCurrency(85, val);
    }

    public void setConfirmed(Boolean val) {
        this.set(135, val);
    }

    public void setConfirmed(boolean val) {
        this.set(135, val);
    }

    public void setConstraintDate(Date val) {
        this.setDate(68, val);
    }

    public void setConstraintType(ConstraintType type) {
        this.set(91, type);
    }

    public void setContact(String val) {
        this.set(15, val);
    }

    public void setCost(Number val) {
        this.setCurrency(30, val);
    }

    public void setCost1(Number val) {
        this.setCurrency(36, val);
    }

    public void setCost2(Number val) {
        this.setCurrency(37, val);
    }

    public void setCost3(Number val) {
        this.setCurrency(38, val);
    }

    public void setCostVariance(Number val) {
        this.setCurrency(34, val);
    }

    public void setCreateDate(Date val) {
        this.setDate(125, val);
    }

    public void setCritical(boolean val) {
        this.set(82, val);
    }

    public void setCritical(Boolean val) {
        this.set(82, val);
    }

    public void setCV(Number val) {
        this.setCurrency(88, val);
    }

    public void setDelay(MPXDuration val) {
        this.set(92, val);
    }

    public void setDuration(MPXDuration val) {
        this.set(40, val);
    }

    public void setDuration1(MPXDuration duration) {
        this.set(46, duration);
    }

    public void setDuration2(MPXDuration duration) {
        this.set(47, duration);
    }

    public void setDuration3(MPXDuration duration) {
        this.set(48, duration);
    }

    public void setDurationVariance(MPXDuration duration) {
        this.set(45, duration);
    }

    public void setEarlyFinish(Date date) {
        this.setDate(53, date);
    }

    public void setEarlyStart(Date date) {
        this.setDate(52, date);
    }

    public void setFinish(Date date) {
        this.setDate(51, date);
    }

    public void setFinish1(Date date) {
        this.setDate(61, date);
    }

    public void setFinish2(Date date) {
        this.setDate(63, date);
    }

    public void setFinish3(Date date) {
        this.setDate(65, date);
    }

    public void setFinish4(Date date) {
        this.setDate(127, date);
    }

    public void setFinish5(Date date) {
        this.setDate(129, date);
    }

    public void setFinishVariance(MPXDuration duration) {
        this.set(67, duration);
    }

    public void setFixed(boolean val) {
        this.set(80, val);
    }

    public void setFixed(Boolean val) {
        this.set(80, val);
    }

    public void setFixedCost(Number val) {
        this.setCurrency(35, val);
    }

    public void setFlag1(boolean val) {
        this.set(110, val);
    }

    public void setFlag1(Boolean val) {
        this.set(110, val);
    }

    public void setFlag2(boolean val) {
        this.set(111, val);
    }

    public void setFlag2(Boolean val) {
        this.set(111, val);
    }

    public void setFlag3(boolean val) {
        this.set(112, val);
    }

    public void setFlag3(Boolean val) {
        this.set(112, val);
    }

    public void setFlag4(boolean val) {
        this.set(113, val);
    }

    public void setFlag4(Boolean val) {
        this.set(113, val);
    }

    public void setFlag5(boolean val) {
        this.set(114, val);
    }

    public void setFlag5(Boolean val) {
        this.set(114, val);
    }

    public void setFlag6(boolean val) {
        this.set(115, val);
    }

    public void setFlag6(Boolean val) {
        this.set(115, val);
    }

    public void setFlag7(boolean val) {
        this.set(116, val);
    }

    public void setFlag7(Boolean val) {
        this.set(116, val);
    }

    public void setFlag8(boolean val) {
        this.set(117, val);
    }

    public void setFlag8(Boolean val) {
        this.set(117, val);
    }

    public void setFlag9(boolean val) {
        this.set(118, val);
    }

    public void setFlag9(Boolean val) {
        this.set(118, val);
    }

    public void setFlag10(boolean val) {
        this.set(119, val);
    }

    public void setFlag10(Boolean val) {
        this.set(119, val);
    }

    public void setFreeSlack(MPXDuration duration) {
        this.set(93, duration);
    }

    public void setHideBar(boolean flag) {
        this.set(123, flag);
    }

    public void setHideBar(Boolean flag) {
        this.set(123, flag);
    }

    public void setID(int val) {
        this.setID(new Integer(val));
    }

    public void setID(Integer val) {
        MPXFile parent = this.getParentFile();
        Integer previous = this.getID();
        if (previous != null) {
            parent.unmapTaskID(previous);
        }
        parent.mapTaskID(val, this);
        this.set(90, val);
    }

    public void setLateFinish(Date date) {
        this.setDate(55, date);
    }

    public void setLateStart(Date date) {
        this.setDate(54, date);
    }

    public void setLinkedFields(boolean flag) {
        this.set(122, flag);
    }

    public void setLinkedFields(Boolean flag) {
        this.set(122, flag);
    }

    public void setMarked(boolean flag) {
        this.set(83, flag);
    }

    public void setMarked(Boolean flag) {
        this.set(83, flag);
    }

    public void setMilestone(boolean flag) {
        this.set(81, flag);
    }

    public void setMilestone(Boolean flag) {
        this.set(81, flag);
    }

    public void setName(String name) {
        this.set(1, name);
    }

    public void setNumber1(Double val) {
        this.set(140, val);
    }

    public void setNumber2(Double val) {
        this.set(141, val);
    }

    public void setNumber3(Double val) {
        this.set(142, val);
    }

    public void setNumber4(Double val) {
        this.set(143, val);
    }

    public void setNumber5(Double val) {
        this.set(144, val);
    }

    public void setObjects(int val) {
        this.set(121, val);
    }

    public void setOutlineLevel(int val) {
        this.set(3, val);
    }

    public void setOutlineLevel(Integer val) {
        this.set(3, val);
    }

    public void setOutlineNumber(String val) {
        this.set(99, val);
    }

    public void setPredecessors(RelationList list) {
        this.set(70, list);
    }

    public void setPriority(Priority priority) {
        this.set(95, priority);
    }

    public void setProject(String val) {
        this.set(97, val);
    }

    public void setRemainingCost(Number val) {
        this.setCurrency(33, val);
    }

    public void setRemainingDuration(MPXDuration val) {
        this.set(43, val);
    }

    public void setRemainingWork(MPXDuration val) {
        this.set(23, val);
    }

    public void setResourceGroup(String val) {
        this.set(16, val);
    }

    public void setResourceInitials(String val) {
        this.set(73, val);
    }

    public void setResourceNames(String val) {
        this.set(72, val);
    }

    public void setResume(Date val) {
        this.setDate(151, val);
    }

    public void setResumeNoEarlierThan(Date val) {
        this.setDate(152, val);
    }

    public void setRollup(boolean val) {
        this.set(84, val);
    }

    public void setRollup(Boolean val) {
        this.set(84, val);
    }

    public void setStart(Date val) {
        this.setDate(50, val);
    }

    public void setStart1(Date val) {
        this.setDate(60, val);
    }

    public void setStart2(Date val) {
        this.setDate(62, val);
    }

    public void setStart3(Date val) {
        this.setDate(64, val);
    }

    public void setStart4(Date val) {
        this.setDate(126, val);
    }

    public void setStart5(Date val) {
        this.setDate(128, val);
    }

    public void setStartVariance(MPXDuration val) {
        this.set(66, val);
    }

    public void setStop(Date val) {
        this.setDate(150, val);
    }

    public void setSubprojectName(String val) {
        this.set(96, val);
    }

    public void setSuccessors(RelationList list) {
        this.set(71, list);
    }

    public void setSummary(boolean val) {
        this.set(120, val);
    }

    public void setSummary(Boolean val) {
        this.set(120, val);
    }

    public void setSV(Number val) {
        this.setCurrency(87, val);
    }

    public void setText1(String val) {
        this.set(4, val);
    }

    public void setText2(String val) {
        this.set(5, val);
    }

    public void setText3(String val) {
        this.set(6, val);
    }

    public void setText4(String val) {
        this.set(7, val);
    }

    public void setText5(String val) {
        this.set(8, val);
    }

    public void setText6(String val) {
        this.set(9, val);
    }

    public void setText7(String val) {
        this.set(10, val);
    }

    public void setText8(String val) {
        this.set(11, val);
    }

    public void setText9(String val) {
        this.set(12, val);
    }

    public void setText10(String val) {
        this.set(13, val);
    }

    public void setTotalSlack(MPXDuration val) {
        this.set(94, val);
    }

    public void setUniqueID(int val) {
        this.setUniqueID(new Integer(val));
    }

    public void setUniqueID(Integer val) {
        MPXFile parent = this.getParentFile();
        Integer previous = this.getUniqueID();
        if (previous != null) {
            parent.unmapTaskUniqueID(previous);
        }
        parent.mapTaskUniqueID(val, this);
        this.set(98, val);
    }

    public void setUniqueIDPredecessors(RelationList list) {
        this.set(76, list);
    }

    public void setUniqueIDSuccessors(RelationList list) {
        this.set(75, list);
    }

    public void setUpdateNeeded(boolean val) {
        this.set(136, val);
    }

    public void setUpdateNeeded(Boolean val) {
        this.set(136, val);
    }

    public void setWBS(String val) {
        this.set(2, val);
    }

    public void setWork(MPXDuration val) {
        this.set(20, val);
    }

    public void setWorkVariance(MPXDuration val) {
        this.set(24, val);
    }

    public double getPercentageCompleteValue() {
        return this.getDoubleValue(44);
    }

    public Number getPercentageComplete() {
        return (Number)this.get(44);
    }

    public double getPercentageWorkCompleteValue() {
        return this.getDoubleValue(25);
    }

    public Number getPercentageWorkComplete() {
        return (Number)this.get(25);
    }

    public Number getActualCost() {
        return (Number)this.get(32);
    }

    public MPXDuration getActualDuration() {
        return (MPXDuration)this.get(42);
    }

    public Date getActualFinish() {
        return (Date)this.get(59);
    }

    public Date getActualStart() {
        return (Date)this.get(58);
    }

    public MPXDuration getActualWork() {
        return (MPXDuration)this.get(22);
    }

    public Number getBaselineCost() {
        return (Number)this.get(31);
    }

    public MPXDuration getBaselineDuration() {
        return (MPXDuration)this.get(41);
    }

    public Date getBaselineFinish() {
        return (Date)this.get(57);
    }

    public Date getBaselineStart() {
        return (Date)this.get(56);
    }

    public MPXDuration getBaselineWork() {
        return (MPXDuration)this.get(21);
    }

    public double getBCWPValue() {
        return this.getDoubleValue(86);
    }

    public Number getBCWP() {
        return (Number)this.get(86);
    }

    public double getBCWSValue() {
        return this.getDoubleValue(85);
    }

    public Number getBCWS() {
        return (Number)this.get(85);
    }

    public boolean getConfirmedValue() {
        return this.getBooleanValue(135);
    }

    public Boolean getConfirmed() {
        return (Boolean)this.get(135);
    }

    public Date getConstraintDate() {
        return (Date)this.get(68);
    }

    public ConstraintType getConstraintType() {
        return (ConstraintType)this.get(91);
    }

    public String getContact() {
        return (String)this.get(15);
    }

    public Number getCost() {
        return (Number)this.get(30);
    }

    public Number getCost1() {
        return (Number)this.get(36);
    }

    public Number getCost2() {
        return (Number)this.get(37);
    }

    public Number getCost3() {
        return (Number)this.get(38);
    }

    public Number getCostVariance() {
        return (Number)this.get(34);
    }

    public Date getCreateDate() {
        return (Date)this.get(125);
    }

    public boolean getCriticalValue() {
        return this.getBooleanValue(82);
    }

    public Boolean getCritical() {
        return (Boolean)this.get(82);
    }

    public double getCVValue() {
        return this.getDoubleValue(88);
    }

    public Number getCV() {
        return (Number)this.get(88);
    }

    public MPXDuration getDelay() {
        return (MPXDuration)this.get(92);
    }

    public MPXDuration getDuration() {
        return (MPXDuration)this.get(40);
    }

    public MPXDuration getDuration1() {
        return (MPXDuration)this.get(46);
    }

    public MPXDuration getDuration2() {
        return (MPXDuration)this.get(47);
    }

    public MPXDuration getDuration3() {
        return (MPXDuration)this.get(48);
    }

    public MPXDuration getDurationVariance() {
        return (MPXDuration)this.get(45);
    }

    public Date getEarlyFinish() {
        return (Date)this.get(53);
    }

    public Date getEarlyStart() {
        return (Date)this.get(52);
    }

    public Date getFinish() {
        return (Date)this.get(51);
    }

    public Date getFinish1() {
        return (Date)this.get(61);
    }

    public Date getFinish2() {
        return (Date)this.get(63);
    }

    public Date getFinish3() {
        return (Date)this.get(65);
    }

    public Date getFinish4() {
        return (Date)this.get(127);
    }

    public Date getFinish5() {
        return (Date)this.get(129);
    }

    public MPXDuration getFinishVariance() {
        return (MPXDuration)this.get(67);
    }

    public boolean getFixedValue() {
        return this.getBooleanValue(80);
    }

    public Boolean getFixed() {
        return (Boolean)this.get(80);
    }

    public double getFixedCostValue() {
        return this.getDoubleValue(35);
    }

    public Number getFixedCost() {
        return (Number)this.get(35);
    }

    public boolean getFlag1Value() {
        return this.getBooleanValue(110);
    }

    public Boolean getFlag1() {
        return (Boolean)this.get(110);
    }

    public boolean getFlag2Value() {
        return this.getBooleanValue(111);
    }

    public Boolean getFlag2() {
        return (Boolean)this.get(111);
    }

    public boolean getFlag3Value() {
        return this.getBooleanValue(112);
    }

    public Boolean getFlag3() {
        return (Boolean)this.get(112);
    }

    public boolean getFlag4Value() {
        return this.getBooleanValue(113);
    }

    public Boolean getFlag4() {
        return (Boolean)this.get(113);
    }

    public boolean getFlag5Value() {
        return this.getBooleanValue(114);
    }

    public Boolean getFlag5() {
        return (Boolean)this.get(114);
    }

    public boolean getFlag6Value() {
        return this.getBooleanValue(115);
    }

    public Boolean getFlag6() {
        return (Boolean)this.get(115);
    }

    public boolean getFlag7Value() {
        return this.getBooleanValue(116);
    }

    public Boolean getFlag7() {
        return (Boolean)this.get(116);
    }

    public boolean getFlag8Value() {
        return this.getBooleanValue(117);
    }

    public Boolean getFlag8() {
        return (Boolean)this.get(117);
    }

    public boolean getFlag9Value() {
        return this.getBooleanValue(118);
    }

    public Boolean getFlag9() {
        return (Boolean)this.get(118);
    }

    public boolean getFlag10Value() {
        return this.getBooleanValue(119);
    }

    public Boolean getFlag10() {
        return (Boolean)this.get(119);
    }

    public MPXDuration getFreeSlack() {
        return (MPXDuration)this.get(93);
    }

    public boolean getHideBarValue() {
        return this.getBooleanValue(123);
    }

    public Boolean getHideBar() {
        return (Boolean)this.get(123);
    }

    public int getIDValue() {
        return this.getIntValue(90);
    }

    public Integer getID() {
        return (Integer)this.get(90);
    }

    public Date getLateFinish() {
        return (Date)this.get(55);
    }

    public Date getLateStart() {
        return (Date)this.get(54);
    }

    public boolean getLinkedFieldsValue() {
        return this.getBooleanValue(122);
    }

    public Boolean getLinkedFields() {
        return (Boolean)this.get(122);
    }

    public boolean getMarkedValue() {
        return this.getBooleanValue(83);
    }

    public Boolean getMarked() {
        return (Boolean)this.get(83);
    }

    public boolean getMilestoneValue() {
        return this.getBooleanValue(81);
    }

    public Boolean getMilestone() {
        return (Boolean)this.get(81);
    }

    public String getName() {
        return (String)this.get(1);
    }

    public String getNotes() {
        String result = this.m_notes != null ? this.m_notes.getNotes() : "";
        return result;
    }

    public double getNumber1Value() {
        return this.getDoubleValue(140);
    }

    public Double getNumber1() {
        return (Double)this.get(140);
    }

    public double getNumber2Value() {
        return this.getDoubleValue(141);
    }

    public Double getNumber2() {
        return (Double)this.get(141);
    }

    public double getNumber3Value() {
        return this.getDoubleValue(142);
    }

    public Double getNumber3() {
        return (Double)this.get(142);
    }

    public double getNumber4Value() {
        return this.getDoubleValue(143);
    }

    public Double getNumber4() {
        return (Double)this.get(143);
    }

    public double getNumber5Value() {
        return this.getDoubleValue(144);
    }

    public Double getNumber5() {
        return (Double)this.get(144);
    }

    public int getObjectsValue() {
        return this.getIntValue(121);
    }

    public Integer getObjects() {
        return (Integer)this.get(121);
    }

    public int getOutlineLevelValue() {
        return this.getIntValue(3);
    }

    public Integer getOutlineLevel() {
        return (Integer)this.get(3);
    }

    public String getOutlineNumber() {
        return (String)this.get(99);
    }

    public List getPredecessors() {
        return (List)this.get(70);
    }

    public Priority getPriority() {
        return (Priority)this.get(95);
    }

    public String getProject() {
        return (String)this.get(97);
    }

    public Number getRemainingCost() {
        return (Number)this.get(33);
    }

    public MPXDuration getRemainingDuration() {
        return (MPXDuration)this.get(43);
    }

    public MPXDuration getRemainingWork() {
        return (MPXDuration)this.get(23);
    }

    public String getResourceGroup() {
        return (String)this.get(16);
    }

    public String getResourceInitials() {
        return (String)this.get(73);
    }

    public String getResourceNames() {
        return (String)this.get(72);
    }

    public Date getResume() {
        return (Date)this.get(151);
    }

    public Date getResumeNoEarlierThan() {
        return (Date)this.get(152);
    }

    public boolean getRollupValue() {
        return this.getBooleanValue(84);
    }

    public Boolean getRollup() {
        return (Boolean)this.get(84);
    }

    public Date getStart() {
        return (Date)this.get(50);
    }

    public Date getStart1() {
        return (Date)this.get(60);
    }

    public Date getStart2() {
        return (Date)this.get(62);
    }

    public Date getStart3() {
        return (Date)this.get(64);
    }

    public Date getStart4() {
        return (Date)this.get(126);
    }

    public Date getStart5() {
        return (Date)this.get(128);
    }

    public MPXDuration getStartVariance() {
        return (MPXDuration)this.get(66);
    }

    public Date getStop() {
        return (Date)this.get(150);
    }

    public String getSubprojectName() {
        return (String)this.get(96);
    }

    public RelationList getSuccessors() {
        return (RelationList)this.get(71);
    }

    public boolean getSummaryValue() {
        return this.getBooleanValue(120);
    }

    public Boolean getSummary() {
        return (Boolean)this.get(120);
    }

    public Number getSV() {
        return (Number)this.get(87);
    }

    public String getText1() {
        return (String)this.get(4);
    }

    public String getText2() {
        return (String)this.get(5);
    }

    public String getText3() {
        return (String)this.get(6);
    }

    public String getText4() {
        return (String)this.get(7);
    }

    public String getText5() {
        return (String)this.get(8);
    }

    public String getText6() {
        return (String)this.get(9);
    }

    public String getText7() {
        return (String)this.get(10);
    }

    public String getText8() {
        return (String)this.get(11);
    }

    public String getText9() {
        return (String)this.get(12);
    }

    public String getText10() {
        return (String)this.get(13);
    }

    public MPXDuration getTotalSlack() {
        return (MPXDuration)this.get(94);
    }

    public int getUniqueIDValue() {
        return this.getIntValue(98);
    }

    public Integer getUniqueID() {
        return (Integer)this.get(98);
    }

    public RelationList getUniqueIDPredecessors() {
        return (RelationList)this.get(76);
    }

    public RelationList getUniqueIDSuccessors() {
        return (RelationList)this.get(75);
    }

    public boolean getUpdateNeededValue() {
        return this.getBooleanValue(136);
    }

    public Boolean getUpdateNeeded() {
        return (Boolean)this.get(136);
    }

    public String getWBS() {
        return (String)this.get(2);
    }

    public MPXDuration getWork() {
        return (MPXDuration)this.get(20);
    }

    public MPXDuration getWorkVariance() {
        return (MPXDuration)this.get(24);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (!this.m_model.getWritten()) {
            buf.append(this.m_model.toString());
            this.m_model.setWritten(true);
        }
        buf.append(this.toString(70, this.m_model.getModel()));
        if (this.m_notes != null) {
            buf.append(this.m_notes.toString());
        }
        if (this.m_recurringTask != null) {
            buf.append(this.m_recurringTask.toString());
        }
        if (!this.m_assignments.isEmpty()) {
            Iterator list = this.m_assignments.iterator();
            while (list.hasNext()) {
                buf.append(((ResourceAssignment)list.next()).toString());
            }
        }
        return buf.toString();
    }

    int getChildTaskCount() {
        return this.m_children.size();
    }

    public Task getParentTask() {
        return this.m_parent;
    }

    public LinkedList getChildTasks() {
        return this.m_children;
    }

    public int compareTo(Object o) {
        int id2;
        int id1 = this.getIDValue();
        return id1 < (id2 = ((Task)o).getIDValue()) ? -1 : (id1 == id2 ? 0 : 1);
    }

    public boolean getEstimated() {
        return this.m_estimated;
    }

    public void setEstimated(boolean estimated) {
        this.m_estimated = estimated;
    }

    public Date getDeadline() {
        return this.m_deadline;
    }

    public void setDeadline(Date deadline) {
        this.m_deadline = deadline;
    }

    public TaskType getType() {
        return this.m_type;
    }

    public void setType(TaskType type) {
        this.m_type = type;
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setNull(boolean isNull) {
        this.m_null = isNull;
    }

    public String getWBSLevel() {
        return this.m_wbsLevel;
    }

    public void setWBSLevel(String wbsLevel) {
        this.m_wbsLevel = wbsLevel;
    }

    public TimeUnit getDurationFormat() {
        return this.m_durationFormat;
    }

    public void setDurationFormat(TimeUnit durationFormat) {
        this.m_durationFormat = durationFormat;
    }

    public boolean getResumeValid() {
        return this.m_resumeValid;
    }

    public void setResumeValid(boolean resumeValid) {
        this.m_resumeValid = resumeValid;
    }

    public boolean getRecurring() {
        return this.m_recurring;
    }

    public void setRecurring(boolean recurring) {
        this.m_recurring = recurring;
    }

    public boolean getOverAllocated() {
        return this.m_overAllocated;
    }

    public void setOverAllocated(boolean overAllocated) {
        this.m_overAllocated = overAllocated;
    }

    public boolean getSubproject() {
        return this.m_subproject;
    }

    public void setSubproject(boolean subproject) {
        this.m_subproject = subproject;
    }

    public Integer getSubprojectTaskUniqueID() {
        return this.m_subprojectTaskUniqueID;
    }

    public void setSubprojectTaskUniqueID(Integer subprojectUniqueTaskID) {
        this.m_subprojectTaskUniqueID = subprojectUniqueTaskID;
    }

    public boolean getSubprojectReadOnly() {
        return this.m_subprojectReadOnly;
    }

    public void setSubprojectReadOnly(boolean subprojectReadOnly) {
        this.m_subprojectReadOnly = subprojectReadOnly;
    }

    public boolean getExternalTask() {
        return this.m_externalTask;
    }

    public void setExternalTask(boolean externalTask) {
        this.m_externalTask = externalTask;
    }

    public String getExternalTaskProject() {
        return this.m_externalTaskProject;
    }

    public void setExternalTaskProject(String externalTaskProject) {
        this.m_externalTaskProject = externalTaskProject;
    }

    public Number getACWP() {
        return this.m_acwp;
    }

    public void setACWP(Number acwp) {
        this.m_acwp = acwp;
    }

    public TimeUnit getLevelingDelayFormat() {
        return this.m_levelingDelayFormat;
    }

    public void setLevelingDelayFormat(TimeUnit levelingDelayFormat) {
        this.m_levelingDelayFormat = levelingDelayFormat;
    }

    public boolean getIgnoreResourceCalendar() {
        return this.m_ignoreResourceCalendar;
    }

    public void setIgnoreResourceCalendar(boolean ignoreResourceCalendar) {
        this.m_ignoreResourceCalendar = ignoreResourceCalendar;
    }

    public Integer getPhysicalPercentComplete() {
        return this.m_physicalPercentComplete;
    }

    public void setPhysicalPercentComplete(Integer physicalPercentComplete) {
        this.m_physicalPercentComplete = physicalPercentComplete;
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return this.m_earnedValueMethod;
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.m_earnedValueMethod = earnedValueMethod;
    }

    public MPXDuration getActualWorkProtected() {
        return this.m_actualWorkProtected;
    }

    public void setActualWorkProtected(MPXDuration actualWorkProtected) {
        this.m_actualWorkProtected = actualWorkProtected;
    }

    public MPXDuration getActualOvertimeWorkProtected() {
        return this.m_actualOvertimeWorkProtected;
    }

    public void setActualOvertimeWorkProtected(MPXDuration actualOvertimeWorkProtected) {
        this.m_actualOvertimeWorkProtected = actualOvertimeWorkProtected;
    }

    public MPXDuration getRegularWork() {
        return this.m_regularWork;
    }

    public void setRegularWork(MPXDuration regularWork) {
        this.m_regularWork = regularWork;
    }

    public boolean getFlag11() {
        return this.getBooleanValue(1047);
    }

    public boolean getFlag12() {
        return this.getBooleanValue(1048);
    }

    public boolean getFlag13() {
        return this.getBooleanValue(1049);
    }

    public boolean getFlag14() {
        return this.getBooleanValue(1050);
    }

    public boolean getFlag15() {
        return this.getBooleanValue(1051);
    }

    public boolean getFlag16() {
        return this.getBooleanValue(1052);
    }

    public boolean getFlag17() {
        return this.getBooleanValue(1053);
    }

    public boolean getFlag18() {
        return this.getBooleanValue(1054);
    }

    public boolean getFlag19() {
        return this.getBooleanValue(1055);
    }

    public boolean getFlag20() {
        return this.getBooleanValue(1056);
    }

    public void setFlag11(boolean b) {
        this.set(1047, b);
    }

    public void setFlag12(boolean b) {
        this.set(1048, b);
    }

    public void setFlag13(boolean b) {
        this.set(1049, b);
    }

    public void setFlag14(boolean b) {
        this.set(1050, b);
    }

    public void setFlag15(boolean b) {
        this.set(1051, b);
    }

    public void setFlag16(boolean b) {
        this.set(1052, b);
    }

    public void setFlag17(boolean b) {
        this.set(1053, b);
    }

    public void setFlag18(boolean b) {
        this.set(1054, b);
    }

    public void setFlag19(boolean b) {
        this.set(1055, b);
    }

    public void setFlag20(boolean b) {
        this.set(1056, b);
    }

    public void setEffortDriven(boolean flag) {
        this.m_effortDriven = flag;
    }

    public boolean getEffortDriven() {
        return this.m_effortDriven;
    }

    public String getText11() {
        return (String)this.get(1000);
    }

    public String getText12() {
        return (String)this.get(1001);
    }

    public String getText13() {
        return (String)this.get(1002);
    }

    public String getText14() {
        return (String)this.get(1003);
    }

    public String getText15() {
        return (String)this.get(1004);
    }

    public String getText16() {
        return (String)this.get(1005);
    }

    public String getText17() {
        return (String)this.get(1006);
    }

    public String getText18() {
        return (String)this.get(1007);
    }

    public String getText19() {
        return (String)this.get(1008);
    }

    public String getText20() {
        return (String)this.get(1009);
    }

    public String getText21() {
        return (String)this.get(1010);
    }

    public String getText22() {
        return (String)this.get(1011);
    }

    public String getText23() {
        return (String)this.get(1012);
    }

    public String getText24() {
        return (String)this.get(1013);
    }

    public String getText25() {
        return (String)this.get(1014);
    }

    public String getText26() {
        return (String)this.get(1015);
    }

    public String getText27() {
        return (String)this.get(1016);
    }

    public String getText28() {
        return (String)this.get(1017);
    }

    public String getText29() {
        return (String)this.get(1018);
    }

    public String getText30() {
        return (String)this.get(1019);
    }

    public void setText11(String string) {
        this.set(1000, string);
    }

    public void setText12(String string) {
        this.set(1001, string);
    }

    public void setText13(String string) {
        this.set(1002, string);
    }

    public void setText14(String string) {
        this.set(1003, string);
    }

    public void setText15(String string) {
        this.set(1004, string);
    }

    public void setText16(String string) {
        this.set(1005, string);
    }

    public void setText17(String string) {
        this.set(1006, string);
    }

    public void setText18(String string) {
        this.set(1007, string);
    }

    public void setText19(String string) {
        this.set(1008, string);
    }

    public void setText20(String string) {
        this.set(1009, string);
    }

    public void setText21(String string) {
        this.set(1010, string);
    }

    public void setText22(String string) {
        this.set(1011, string);
    }

    public void setText23(String string) {
        this.set(1012, string);
    }

    public void setText24(String string) {
        this.set(1013, string);
    }

    public void setText25(String string) {
        this.set(1014, string);
    }

    public void setText26(String string) {
        this.set(1015, string);
    }

    public void setText27(String string) {
        this.set(1016, string);
    }

    public void setText28(String string) {
        this.set(1017, string);
    }

    public void setText29(String string) {
        this.set(1018, string);
    }

    public void setText30(String string) {
        this.set(1019, string);
    }

    public void setNumber6(Double val) {
        this.set(1057, val);
    }

    public double getNumber6Value() {
        return this.getDoubleValue(1057);
    }

    public Double getNumber6() {
        return (Double)this.get(1057);
    }

    public void setNumber7(Double val) {
        this.set(1058, val);
    }

    public double getNumber7Value() {
        return this.getDoubleValue(1058);
    }

    public Double getNumber7() {
        return (Double)this.get(1058);
    }

    public void setNumber8(Double val) {
        this.set(1059, val);
    }

    public double getNumber8Value() {
        return this.getDoubleValue(1059);
    }

    public Double getNumber8() {
        return (Double)this.get(1059);
    }

    public void setNumber9(Double val) {
        this.set(1060, val);
    }

    public double getNumber9Value() {
        return this.getDoubleValue(1060);
    }

    public Double getNumber9() {
        return (Double)this.get(1060);
    }

    public void setNumber10(Double val) {
        this.set(1061, val);
    }

    public double getNumber10Value() {
        return this.getDoubleValue(1061);
    }

    public Double getNumber10() {
        return (Double)this.get(1061);
    }

    public void setNumber11(Double val) {
        this.set(1062, val);
    }

    public double getNumber11Value() {
        return this.getDoubleValue(1062);
    }

    public Double getNumber11() {
        return (Double)this.get(1062);
    }

    public void setNumber12(Double val) {
        this.set(1063, val);
    }

    public double getNumber12Value() {
        return this.getDoubleValue(1063);
    }

    public Double getNumber12() {
        return (Double)this.get(1063);
    }

    public void setNumber13(Double val) {
        this.set(1064, val);
    }

    public double getNumber13Value() {
        return this.getDoubleValue(1064);
    }

    public Double getNumber13() {
        return (Double)this.get(1064);
    }

    public void setNumber14(Double val) {
        this.set(1065, val);
    }

    public double getNumber14Value() {
        return this.getDoubleValue(1065);
    }

    public Double getNumber14() {
        return (Double)this.get(1065);
    }

    public void setNumber15(Double val) {
        this.set(1066, val);
    }

    public double getNumber15Value() {
        return this.getDoubleValue(1066);
    }

    public Double getNumber15() {
        return (Double)this.get(1066);
    }

    public void setNumber16(Double val) {
        this.set(1067, val);
    }

    public double getNumber16Value() {
        return this.getDoubleValue(1067);
    }

    public Double getNumber16() {
        return (Double)this.get(1067);
    }

    public void setNumber17(Double val) {
        this.set(1068, val);
    }

    public double getNumber17Value() {
        return this.getDoubleValue(1068);
    }

    public Double getNumber17() {
        return (Double)this.get(1068);
    }

    public void setNumber18(Double val) {
        this.set(1069, val);
    }

    public double getNumber18Value() {
        return this.getDoubleValue(1069);
    }

    public Double getNumber18() {
        return (Double)this.get(1069);
    }

    public void setNumber19(Double val) {
        this.set(1070, val);
    }

    public double getNumber19Value() {
        return this.getDoubleValue(1070);
    }

    public Double getNumber19() {
        return (Double)this.get(1070);
    }

    public void setNumber20(Double val) {
        this.set(1071, val);
    }

    public double getNumber20Value() {
        return this.getDoubleValue(1071);
    }

    public Double getNumber20() {
        return (Double)this.get(1071);
    }

    public MPXDuration getDuration10() {
        return (MPXDuration)this.get(1078);
    }

    public MPXDuration getDuration4() {
        return (MPXDuration)this.get(1072);
    }

    public MPXDuration getDuration5() {
        return (MPXDuration)this.get(1073);
    }

    public MPXDuration getDuration6() {
        return (MPXDuration)this.get(1074);
    }

    public MPXDuration getDuration7() {
        return (MPXDuration)this.get(1075);
    }

    public MPXDuration getDuration8() {
        return (MPXDuration)this.get(1076);
    }

    public MPXDuration getDuration9() {
        return (MPXDuration)this.get(1077);
    }

    public void setDuration10(MPXDuration duration) {
        this.set(1078, duration);
    }

    public void setDuration4(MPXDuration duration) {
        this.set(1072, duration);
    }

    public void setDuration5(MPXDuration duration) {
        this.set(1073, duration);
    }

    public void setDuration6(MPXDuration duration) {
        this.set(1074, duration);
    }

    public void setDuration7(MPXDuration duration) {
        this.set(1075, duration);
    }

    public void setDuration8(MPXDuration duration) {
        this.set(1076, duration);
    }

    public void setDuration9(MPXDuration duration) {
        this.set(1077, duration);
    }

    public Date getDate1() {
        return (Date)this.get(1037);
    }

    public Date getDate10() {
        return (Date)this.get(1046);
    }

    public Date getDate2() {
        return (Date)this.get(1038);
    }

    public Date getDate3() {
        return (Date)this.get(1039);
    }

    public Date getDate4() {
        return (Date)this.get(1040);
    }

    public Date getDate5() {
        return (Date)this.get(1041);
    }

    public Date getDate6() {
        return (Date)this.get(1042);
    }

    public Date getDate7() {
        return (Date)this.get(1043);
    }

    public Date getDate8() {
        return (Date)this.get(1044);
    }

    public Date getDate9() {
        return (Date)this.get(1045);
    }

    public void setDate1(Date date) {
        this.setDate(1037, date);
    }

    public void setDate10(Date date) {
        this.setDate(1046, date);
    }

    public void setDate2(Date date) {
        this.setDate(1038, date);
    }

    public void setDate3(Date date) {
        this.setDate(1039, date);
    }

    public void setDate4(Date date) {
        this.setDate(1040, date);
    }

    public void setDate5(Date date) {
        this.setDate(1041, date);
    }

    public void setDate6(Date date) {
        this.setDate(1042, date);
    }

    public void setDate7(Date date) {
        this.setDate(1043, date);
    }

    public void setDate8(Date date) {
        this.setDate(1044, date);
    }

    public void setDate9(Date date) {
        this.setDate(1045, date);
    }

    public Number getCost10() {
        return (Number)this.get(1036);
    }

    public Number getCost4() {
        return (Number)this.get(1030);
    }

    public Number getCost5() {
        return (Number)this.get(1031);
    }

    public Number getCost6() {
        return (Number)this.get(1032);
    }

    public Number getCost7() {
        return (Number)this.get(1033);
    }

    public Number getCost8() {
        return (Number)this.get(1034);
    }

    public Number getCost9() {
        return (Number)this.get(1035);
    }

    public void setCost10(Number number) {
        this.setCurrency(1036, number);
    }

    public void setCost4(Number number) {
        this.setCurrency(1030, number);
    }

    public void setCost5(Number number) {
        this.setCurrency(1031, number);
    }

    public void setCost6(Number number) {
        this.setCurrency(1032, number);
    }

    public void setCost7(Number number) {
        this.setCurrency(1033, number);
    }

    public void setCost8(Number number) {
        this.setCurrency(1034, number);
    }

    public void setCost9(Number number) {
        this.setCurrency(1035, number);
    }

    public Date getStart10() {
        return (Date)this.get(1024);
    }

    public Date getStart6() {
        return (Date)this.get(1020);
    }

    public Date getStart7() {
        return (Date)this.get(1021);
    }

    public Date getStart8() {
        return (Date)this.get(1022);
    }

    public Date getStart9() {
        return (Date)this.get(1023);
    }

    public void setStart10(Date date) {
        this.setDate(1024, date);
    }

    public void setStart6(Date date) {
        this.setDate(1020, date);
    }

    public void setStart7(Date date) {
        this.setDate(1021, date);
    }

    public void setStart8(Date date) {
        this.setDate(1022, date);
    }

    public void setStart9(Date date) {
        this.setDate(1023, date);
    }

    public Date getFinish10() {
        return (Date)this.get(1029);
    }

    public Date getFinish6() {
        return (Date)this.get(1025);
    }

    public Date getFinish7() {
        return (Date)this.get(1026);
    }

    public Date getFinish8() {
        return (Date)this.get(1027);
    }

    public Date getFinish9() {
        return (Date)this.get(1028);
    }

    public void setFinish10(Date date) {
        this.setDate(1029, date);
    }

    public void setFinish6(Date date) {
        this.setDate(1025, date);
    }

    public void setFinish7(Date date) {
        this.setDate(1026, date);
    }

    public void setFinish8(Date date) {
        this.setDate(1027, date);
    }

    public void setFinish9(Date date) {
        this.setDate(1028, date);
    }

    public Number getOvertimeCost() {
        return this.m_overtimeCost;
    }

    public void setOvertimeCost(Number number) {
        this.m_overtimeCost = number;
    }

    public void setOutlineCode1(String value) {
        this.set(1079, value);
    }

    public String getOutlineCode1() {
        return (String)this.get(1079);
    }

    public void setOutlineCode2(String value) {
        this.set(1080, value);
    }

    public String getOutlineCode2() {
        return (String)this.get(1080);
    }

    public void setOutlineCode3(String value) {
        this.set(1081, value);
    }

    public String getOutlineCode3() {
        return (String)this.get(1081);
    }

    public void setOutlineCode4(String value) {
        this.set(1082, value);
    }

    public String getOutlineCode4() {
        return (String)this.get(1082);
    }

    public void setOutlineCode5(String value) {
        this.set(1083, value);
    }

    public String getOutlineCode5() {
        return (String)this.get(1083);
    }

    public void setOutlineCode6(String value) {
        this.set(1084, value);
    }

    public String getOutlineCode6() {
        return (String)this.get(1084);
    }

    public void setOutlineCode7(String value) {
        this.set(1085, value);
    }

    public String getOutlineCode7() {
        return (String)this.get(1085);
    }

    public void setOutlineCode8(String value) {
        this.set(1086, value);
    }

    public String getOutlineCode8() {
        return (String)this.get(1086);
    }

    public void setOutlineCode9(String value) {
        this.set(1087, value);
    }

    public String getOutlineCode9() {
        return (String)this.get(1087);
    }

    public void setOutlineCode10(String value) {
        this.set(1088, value);
    }

    public String getOutlineCode10() {
        return (String)this.get(1088);
    }

    public Number getActualOvertimeCost() {
        return this.m_actualOvertimeCost;
    }

    public void setActualOvertimeCost(Number cost) {
        this.m_actualOvertimeCost = cost;
    }

    public MPXDuration getActualOvertimeWork() {
        return this.m_actualOvertimeWork;
    }

    public void setActualOvertimeWork(MPXDuration work) {
        this.m_actualOvertimeWork = work;
    }

    public AccrueType getFixedCostAccrual() {
        return this.m_fixedCostAccrual;
    }

    public void setFixedCostAccrual(AccrueType type) {
        this.m_fixedCostAccrual = type;
    }

    public String getHyperlink() {
        return this.m_hyperlink;
    }

    public String getHyperlinkAddress() {
        return this.m_hyperlinkAddress;
    }

    public String getHyperlinkSubAddress() {
        return this.m_hyperlinkSubAddress;
    }

    public void setHyperlink(String text) {
        this.m_hyperlink = text;
    }

    public void setHyperlinkAddress(String text) {
        this.m_hyperlinkAddress = text;
    }

    public void setHyperlinkSubAddress(String text) {
        this.m_hyperlinkSubAddress = text;
    }

    public boolean getLevelAssignments() {
        return this.m_levelAssignments;
    }

    public void setLevelAssignments(boolean flag) {
        this.m_levelAssignments = flag;
    }

    public boolean getLevelingCanSplit() {
        return this.m_levelingCanSplit;
    }

    public void setLevelingCanSplit(boolean flag) {
        this.m_levelingCanSplit = flag;
    }

    public MPXDuration getLevelingDelay() {
        return this.m_levelingDelay;
    }

    public void setLevelingDelay(MPXDuration delay) {
        this.m_levelingDelay = delay;
    }

    public MPXDuration getOvertimeWork() {
        return this.m_overtimeWork;
    }

    public void setOvertimeWork(MPXDuration work) {
        this.m_overtimeWork = work;
    }

    public Date getPreleveledStart() {
        return this.m_preleveledStart;
    }

    public Date getPreleveledFinish() {
        return this.m_preleveledFinish;
    }

    public void setPreleveledStart(Date date) {
        this.m_preleveledStart = date;
    }

    public void setPreleveledFinish(Date date) {
        this.m_preleveledFinish = date;
    }

    public MPXDuration getRemainingOvertimeWork() {
        return this.m_remainingOvertimeWork;
    }

    public void setRemainingOvertimeWork(MPXDuration work) {
        this.m_remainingOvertimeWork = work;
    }

    public Number getRemainingOvertimeCost() {
        return this.m_remainingOvertimeCost;
    }

    public void setRemainingOvertimeCost(Number cost) {
        this.m_remainingOvertimeCost = cost;
    }

    public MPXCalendar getCalendar() {
        return this.getParentFile().getBaseCalendar(this.m_calendarName);
    }

    public String getCalendarName() {
        return this.m_calendarName;
    }

    public void setCalendarName(String name) {
        this.m_calendarName = name;
    }

    public Object getFieldByAlias(String alias) {
        Object result = null;
        int field = this.getParentFile().getAliasTaskField(alias);
        if (field != -1) {
            result = this.get(field);
        }
        return result;
    }

    public void setFieldByAlias(String alias, Object value) {
        int field = this.getParentFile().getAliasTaskField(alias);
        if (field != -1) {
            this.set(field, value);
        }
    }
}

