/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.ToStringRequiresFile;
import java.util.Locale;

public final class ConstraintType
implements ToStringRequiresFile {
    public static final int AS_SOON_AS_POSSIBLE_VALUE = 0;
    public static final int AS_LATE_AS_POSSIBLE_VALUE = 1;
    public static final int MUST_START_ON_VALUE = 2;
    public static final int MUST_FINISH_ON_VALUE = 3;
    public static final int START_NO_EARLIER_THAN_VALUE = 4;
    public static final int START_NO_LATER_THAN_VALUE = 5;
    public static final int FINISH_NO_EARLIER_THAN_VALUE = 6;
    public static final int FINISH_NO_LATER_THAN_VALUE = 7;
    public static final ConstraintType AS_SOON_AS_POSSIBLE = new ConstraintType(0);
    public static final ConstraintType AS_LATE_AS_POSSIBLE = new ConstraintType(1);
    public static final ConstraintType MUST_START_ON = new ConstraintType(2);
    public static final ConstraintType MUST_FINISH_ON = new ConstraintType(3);
    public static final ConstraintType START_NO_EARLIER_THAN = new ConstraintType(4);
    public static final ConstraintType START_NO_LATER_THAN = new ConstraintType(5);
    public static final ConstraintType FINISH_NO_EARLIER_THAN = new ConstraintType(6);
    public static final ConstraintType FINISH_NO_LATER_THAN = new ConstraintType(7);
    private static final ConstraintType[] TYPE_VALUES = new ConstraintType[]{AS_SOON_AS_POSSIBLE, AS_LATE_AS_POSSIBLE, MUST_START_ON, MUST_FINISH_ON, START_NO_EARLIER_THAN, START_NO_LATER_THAN, FINISH_NO_EARLIER_THAN, FINISH_NO_LATER_THAN};
    private int m_type;

    private ConstraintType(int type) {
        String[] constraintTypes = LocaleData.getStringArray(Locale.ENGLISH, "CONSTRAINT_TYPES");
        this.m_type = type < 0 || type >= constraintTypes.length ? 0 : type;
    }

    public static ConstraintType getInstance(Locale locale, String type) {
        int index = 0;
        String[] constraintTypes = LocaleData.getStringArray(locale, "CONSTRAINT_TYPES");
        for (int loop = 0; loop < constraintTypes.length; ++loop) {
            if (!constraintTypes[loop].equalsIgnoreCase(type)) continue;
            index = loop;
            break;
        }
        return TYPE_VALUES[index];
    }

    public static ConstraintType getInstance(int type) {
        String[] constraintTypes = LocaleData.getStringArray(Locale.ENGLISH, "CONSTRAINT_TYPES");
        if (type < 0 || type >= constraintTypes.length) {
            type = 0;
        }
        return TYPE_VALUES[type];
    }

    public static ConstraintType getInstance(Number type) {
        int index = 0;
        if (type != null) {
            index = type.intValue();
        }
        return ConstraintType.getInstance(index);
    }

    public int getType() {
        return this.m_type;
    }

    public String toString(MPXFile mpx) {
        String[] typeNames = LocaleData.getStringArray(mpx.getLocale(), "CONSTRAINT_TYPES");
        return typeNames[this.m_type];
    }
}

