/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpp;

import com.tapsterrock.mpp.CompObj;
import com.tapsterrock.mpp.FontBase;
import com.tapsterrock.mpp.MPP8File;
import com.tapsterrock.mpp.MPP9File;
import com.tapsterrock.mpp.SubProject;
import com.tapsterrock.mpp.Table;
import com.tapsterrock.mpp.View;
import com.tapsterrock.mpx.MPXCalendar;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.Task;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MPPFile
extends MPXFile {
    private boolean m_preserveNoteFormatting;
    private int m_fileType;
    private ArrayList m_views;
    private ArrayList m_tables;
    private HashMap m_taskTablesByName;
    private HashMap m_resourceTablesByName;
    private HashMap m_subProjectsByTaskUniqueID;
    private SubProject m_resourceSubProject;
    private HashMap m_fontBases;

    public MPPFile() {
    }

    public MPPFile(InputStream is) throws MPXException {
        super(is);
    }

    public MPPFile(File file) throws MPXException {
        super(file);
    }

    public MPPFile(String name) throws MPXException {
        super(name);
    }

    protected void configure() {
        super.configure();
        this.m_views = new ArrayList();
        this.m_tables = new ArrayList();
        this.m_taskTablesByName = new HashMap();
        this.m_resourceTablesByName = new HashMap();
        this.m_subProjectsByTaskUniqueID = new HashMap();
        this.m_fontBases = new HashMap();
    }

    public void read(InputStream is) throws MPXException {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            DirectoryEntry root = fs.getRoot();
            CompObj compObj = new CompObj((InputStream)new DocumentInputStream((DocumentEntry)root.getEntry("\u0001CompObj")));
            String format = compObj.getFileFormat();
            if (format.equals("MSProject.MPP9")) {
                MPP9File.process(this, root);
                this.m_fileType = 9;
            } else if (format.equals("MSProject.MPP8")) {
                MPP8File.process(this, root);
                this.m_fileType = 8;
            } else {
                throw new MPXException("Invalid file format: " + format);
            }
            this.setAutoOutlineNumber(true);
            this.updateStructure();
            this.setAutoOutlineNumber(false);
            LinkedList tasks = this.getAllTasks();
            Iterator iter = tasks.iterator();
            while (iter.hasNext()) {
                Task task;
                task.setSummary((task = (Task)iter.next()).getChildTasks().size() != 0);
            }
        }
        catch (IOException ex) {
            throw new MPXException("Error reading file", ex);
        }
    }

    public boolean getPreserveNoteFormatting() {
        return this.m_preserveNoteFormatting;
    }

    public void setPreserveNoteFormatting(boolean preserveNoteFormatting) {
        this.m_preserveNoteFormatting = preserveNoteFormatting;
    }

    public int getFileType() {
        return this.m_fileType;
    }

    void addView(View view) {
        this.m_views.add(view);
    }

    public ArrayList getViews() {
        return this.m_views;
    }

    void addTable(Table table) {
        this.m_tables.add(table);
        if (!table.getResourceFlag()) {
            this.m_taskTablesByName.put(table.getName(), table);
        } else {
            this.m_resourceTablesByName.put(table.getName(), table);
        }
    }

    public ArrayList getTables() {
        return this.m_tables;
    }

    public Table getTaskTableByName(String name) {
        return (Table)this.m_taskTablesByName.get(name);
    }

    public Table getResourceTableByName(String name) {
        return (Table)this.m_resourceTablesByName.get(name);
    }

    MPXCalendar mppAddResourceCalendar() {
        return this.addResourceCalendar();
    }

    MPXCalendar mppAddDefaultResourceCalendar() {
        return this.addDefaultResourceCalendar();
    }

    void mppAttachResourceCalendar(Resource resource, MPXCalendar calendar) {
        this.attachResourceCalendar(resource, calendar);
    }

    void addTaskSubProject(SubProject project) {
        this.m_subProjectsByTaskUniqueID.put(project.getUniqueID(), project);
    }

    void addResourceSubProject(SubProject project) {
        this.m_resourceSubProject = project;
    }

    public SubProject getTaskSubProject(Integer taskUniqueID) {
        return (SubProject)this.m_subProjectsByTaskUniqueID.get(taskUniqueID);
    }

    public SubProject getResourceSubProject() {
        return this.m_resourceSubProject;
    }

    void addFontBase(FontBase fontBase) {
        this.m_fontBases.put(fontBase.getIndex(), fontBase);
    }

    public FontBase getFontBase(Integer index) {
        return (FontBase)this.m_fontBases.get(index);
    }
}

