/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.util;

import java.io.File;
import java.io.IOException;

public abstract class FileUtil {
    private static final char FILE_EXTENSION_SEPARATOR = '.';

    public static String getExtension(File file) {
        int lastDot = file.getName().lastIndexOf(46);
        return lastDot >= 0 ? file.getName().substring(lastDot + 1) : file.getName();
    }

    public static File replaceExtension(File f, String newExtension) throws IOException {
        File result;
        String filename = f.getName();
        int i = filename.lastIndexOf(46);
        File containingFolder = f.getParentFile();
        if (i > 0 && i < filename.length() - 1) {
            String withoutExtension = filename.substring(0, i);
            result = new File(containingFolder, withoutExtension + '.' + newExtension);
        } else {
            result = new File(containingFolder, filename + '.' + newExtension);
        }
        return result;
    }

    public static File appendSuffixBeforeExtension(File f, String suffix) throws IOException {
        File result;
        String filename = f.getName();
        int i = filename.lastIndexOf(46);
        File containingFolder = f.getParentFile();
        if (i > 0 && i < filename.length() - 1) {
            String withoutExtension = filename.substring(0, i);
            String extension = filename.substring(i);
            result = new File(containingFolder, withoutExtension + suffix + extension);
        } else {
            result = new File(containingFolder, filename + suffix);
        }
        if (!result.exists()) {
            result.createNewFile();
        }
        return result;
    }

    public static String getFilenameWithoutExtension(File f) {
        String filename = f.getName();
        int i = filename.lastIndexOf(46);
        return i >= 0 ? filename.substring(0, i) : filename;
    }
}

