/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.undo;

import java.io.File;
import java.io.IOException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.io.GPSaver;
import net.sourceforge.ganttproject.undo.UndoManagerImpl;

class UndoableEditImpl
extends AbstractUndoableEdit {
    private String myPresentationName;
    private Runnable myEditImpl;
    private Document myDocumentBefore;
    private Document myDocumentAfter;
    private UndoManagerImpl myManager;

    UndoableEditImpl(String localizedName, Runnable editImpl, UndoManagerImpl manager) throws IOException {
        this.myManager = manager;
        this.myPresentationName = localizedName;
        this.myEditImpl = editImpl;
        this.myDocumentBefore = this.saveFile();
        editImpl.run();
        this.myDocumentAfter = this.saveFile();
    }

    private Document saveFile() throws IOException {
        File tempFile = this.createTemporaryFile();
        tempFile.deleteOnExit();
        Document doc = this.myManager.getDocumentManager().getDocument(tempFile.getAbsolutePath());
        GPSaver saver = this.myManager.getParserFactory().newSaver();
        saver.save(doc.getOutputStream());
        return doc;
    }

    public boolean canUndo() {
        return this.myDocumentBefore.canRead();
    }

    public boolean canRedo() {
        return this.myDocumentAfter.canRead();
    }

    public void redo() throws CannotRedoException {
        try {
            this.restoreDocument(this.myDocumentAfter);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CannotRedoException();
        }
    }

    public void undo() throws CannotUndoException {
        try {
            this.restoreDocument(this.myDocumentBefore);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CannotRedoException();
        }
    }

    private void restoreDocument(Document document) throws IOException {
        Document projectDocument = this.myManager.getProject().getDocument();
        this.myManager.getProject().close();
        document.read();
        this.myManager.getProject().setDocument(projectDocument);
    }

    public String getPresentationName() {
        return this.myPresentationName;
    }

    File createTemporaryFile() throws IOException {
        return File.createTempFile("_GanttProject_qSave", ".gan");
    }
}

