/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.resource;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;

public abstract class ProjectResource {
    private int id = -1;
    protected String name;
    private double costsPerUnit;
    private int maximumUnitsPerDay;
    private String unitMeasure;
    private String description;
    private List myAssignments = new ArrayList();

    protected ProjectResource() {
        this(-1);
    }

    protected ProjectResource(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setUnitMeasure(String unitMeasure) {
        this.unitMeasure = unitMeasure;
    }

    public String getUnitMeasure() {
        return this.unitMeasure;
    }

    public void setCostsPerUnit(double costsPerUnit) {
        this.costsPerUnit = costsPerUnit;
    }

    public double getCostsPerUnit() {
        return this.costsPerUnit;
    }

    public void setMaximumUnitsPerDay(int maximumUnitsPerDay) {
        this.maximumUnitsPerDay = maximumUnitsPerDay;
    }

    public int getMaximumUnitsPerDay() {
        return this.maximumUnitsPerDay;
    }

    public void setId(int id) {
        if (this.id == -1) {
            this.id = id;
        }
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        boolean res = false;
        if (obj instanceof ProjectResource) {
            ProjectResource pr = (ProjectResource)obj;
            res = pr.id == this.id;
        }
        return res;
    }

    public String toString() {
        return this.name;
    }

    public abstract ProjectResource unpluggedClone();

    public ResourceAssignment createAssignment(ResourceAssignment assignmentToTask) {
        for (int i = 0; i < this.myAssignments.size(); ++i) {
            if (!((ResourceAssignment)this.myAssignments.get(i)).getTask().equals(assignmentToTask.getTask())) continue;
        }
        ResourceAssignmentImpl result = new ResourceAssignmentImpl(assignmentToTask);
        this.myAssignments.add(result);
        return result;
    }

    private void removeAllAssignments() {
        ArrayList copy = new ArrayList(this.myAssignments);
        for (int i = 0; i < copy.size(); ++i) {
            ResourceAssignmentImpl next = (ResourceAssignmentImpl)copy.get(i);
            next.myAssignmentToTask.delete();
        }
    }

    public void delete() {
        this.removeAllAssignments();
    }

    protected abstract void fireAssignmentsChanged();

    public ResourceAssignment[] getAssignments() {
        return this.myAssignments.toArray(new ResourceAssignment[0]);
    }

    private class ResourceAssignmentImpl
    implements ResourceAssignment {
        private final ResourceAssignment myAssignmentToTask;
        private float myLoad;
        private boolean myCoordinator;
        private Role myRoleForAssignment;

        private ResourceAssignmentImpl(ResourceAssignment assignmentToTask) {
            this.myAssignmentToTask = assignmentToTask;
        }

        public Task getTask() {
            return this.myAssignmentToTask.getTask();
        }

        public ProjectResource getResource() {
            return ProjectResource.this;
        }

        public float getLoad() {
            return this.myLoad;
        }

        public void setLoad(float load) {
            this.myLoad = load;
        }

        public void delete() {
            ProjectResource.this.myAssignments.remove(this);
            ProjectResource.this.fireAssignmentsChanged();
        }

        public void setCoordinator(boolean responsible) {
            this.myCoordinator = responsible;
        }

        public boolean isCoordinator() {
            return this.myCoordinator;
        }

        public Role getRoleForAssignment() {
            return this.myRoleForAssignment;
        }

        public void setRoleForAssignment(Role role) {
            this.myRoleForAssignment = role;
        }

        public String toString() {
            return this.getResource().getName() + " -> " + this.getTask().getName();
        }
    }
}

