/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.plugins;

import java.lang.reflect.Array;
import java.util.ArrayList;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.export.Exporter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class PluginManager {
    private static final String EXTENSION_POINT_ID_CHART = "net.sourceforge.ganttproject.chart";
    private static final String EXTENSION_POINT_ID_EXPORTER = "net.sourceforge.ganttproject.exporter";
    private Chart[] myCharts;
    private Exporter[] myExporters;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Object[] getExtensions(Class extensionPointInterface) {
        String extensionPointID = extensionPointInterface.getName();
        return this.getExtensions(extensionPointID, extensionPointInterface);
    }

    public Object[] getExtensions(String extensionPointID, Class extensionPointInterface) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = extensionRegistry.getConfigurationElementsFor(extensionPointID);
        ArrayList<Object> extensions = new ArrayList<Object>();
        for (int i = 0; i < configElements.length; ++i) {
            try {
                Object nextExtension = configElements[i].createExecutableExtension("class");
                if (!($assertionsDisabled || nextExtension != null && extensionPointInterface.isAssignableFrom(nextExtension.getClass()))) {
                    throw new AssertionError();
                }
                extensions.add(nextExtension);
                continue;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return extensions.toArray((Object[])Array.newInstance(extensionPointInterface, 0));
    }

    public Chart[] getCharts() {
        if (this.myCharts == null) {
            this.myCharts = (Chart[])this.getExtensions(EXTENSION_POINT_ID_CHART, Chart.class);
        }
        return this.myCharts;
    }

    public Exporter[] getExporters() {
        if (this.myExporters == null) {
            this.myExporters = (Exporter[])this.getExtensions(EXTENSION_POINT_ID_EXPORTER, Exporter.class);
        }
        return this.myExporters;
    }

    static {
        $assertionsDisabled = !PluginManager.class.desiredAssertionStatus();
    }
}

