/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.sourceforge.ganttproject.action.CancelAction;
import net.sourceforge.ganttproject.font.Fonts;
import net.sourceforge.ganttproject.gui.DialogAligner;
import net.sourceforge.ganttproject.language.GanttLanguage;
import org.eclipse.core.runtime.IProgressMonitor;

public class GanttStatusBar
extends JPanel
implements Runnable {
    protected MessagePanel message0;
    protected MessagePanel message1;
    protected MessagePanel message2;
    private static final int NO_MESSAGE = 1;
    private static final int MESSAGE_1 = 0;
    private static final int MESSAGE_2 = 1;
    private static final int PROGRESS_FINISH = 2;
    int mode = 1;
    boolean bRunning = false;
    private JFrame myMainFrame;
    private Runnable myErrorNotifier;
    private ErrorNotificationPanel myErrorNotificationPanel;

    public GanttStatusBar(JFrame mainFrame) {
        super(new BorderLayout());
        this.myMainFrame = mainFrame;
        this.message0 = new MessagePanel(215, false);
        this.message1 = new MessagePanel(400, true);
        this.message2 = new MessagePanel(250, true);
        this.myErrorNotificationPanel = new ErrorNotificationPanel();
        this.add((Component)this.myErrorNotificationPanel, "West");
        this.add((Component)this.message1, "Center");
        this.add((Component)this.message2, "East");
        this.message0.setText("GanttProject.Org (2.0.1)");
        this.setFirstText(GanttLanguage.getInstance().getText("welcome"), 500);
    }

    public IProgressMonitor createProgressMonitor() {
        return new ProgressMonitorImpl();
    }

    public void setFirstText(String text) {
        this.message1.setText(text);
    }

    public void setSecondText(String text) {
        this.message2.setText(text);
    }

    public void setFirstText(String text, int mlTimer) {
        if (!this.isVisible()) {
            return;
        }
        this.message1.setText(text, mlTimer);
        this.mode = 0;
        if (!this.bRunning) {
            this.bRunning = true;
            new Thread(this).start();
        }
    }

    public void setSecondText(String text, int mlTimer) {
        if (!this.isVisible()) {
            return;
        }
        this.message2.setText(text, mlTimer);
        this.mode = 1;
        if (!this.bRunning) {
            this.bRunning = true;
            new Thread(this).start();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), 24);
    }

    public void run() {
        try {
            switch (this.mode) {
                case 0: {
                    Thread.sleep(this.message1.getTimer());
                    this.message1.hideText();
                    this.message1.setText("");
                    break;
                }
                case 1: {
                    Thread.sleep(this.message2.getTimer());
                    this.message2.hideText();
                    this.message2.setText("");
                }
            }
            this.mode = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bRunning = false;
    }

    public void setErrorNotifier(Runnable notifier) {
        if (notifier == null && this.myErrorNotifier != null) {
            this.clearErrorNotification();
            return;
        }
        if (this.myErrorNotifier == null) {
            this.createErrorNotification(notifier);
        }
        this.myErrorNotifier = notifier;
    }

    private void clearErrorNotification() {
        this.myErrorNotificationPanel.disableNotifier();
    }

    private void createErrorNotification(Runnable notifier) {
        this.myErrorNotificationPanel.enableNotifier(notifier);
    }

    private class ProgressMonitorImpl
    implements IProgressMonitor {
        private int myWorked;
        ProgressBarDialog myProgressDialog;
        String myTaskName;
        private int myTotalWork;
        private boolean isCanceled;

        ProgressMonitorImpl() {
            this.myProgressDialog = new ProgressBarDialog(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginTask(String name, int totalWork) {
            SwingUtilities.invokeLater(new Runnable(this, name, totalWork){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ int val$totalWork;
                private final /* synthetic */ ProgressMonitorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$name = val$name;
                    this.val$totalWork = val$totalWork;
                }

                public void run() {
                    this.this$1.myTaskName = this.val$name;
                    ProgressMonitorImpl.access$302(this.this$1, this.val$totalWork);
                    this.this$1.myProgressDialog.start(this.val$name, this.val$totalWork);
                    System.err.println("[ProgressMonitorImpl] beginTask: name=" + this.val$name);
                }
            });
        }

        public void done() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ ProgressMonitorImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.myProgressDialog.done();
                }
            });
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void setCanceled(boolean value) {
            this.myProgressDialog.done();
            this.isCanceled = value;
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void worked(int work) {
            SwingUtilities.invokeLater(new Runnable(this, work){
                private final /* synthetic */ int val$work;
                private final /* synthetic */ ProgressMonitorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$work = val$work;
                }

                public void run() {
                    ProgressMonitorImpl.access$412(this.this$1, this.val$work);
                    this.this$1.myProgressDialog.setProgress(ProgressMonitorImpl.access$400(this.this$1));
                }
            });
        }

        static /* synthetic */ int access$302(ProgressMonitorImpl x0, int x1) {
            x0.myTotalWork = x1;
            return x0.myTotalWork;
        }

        static /* synthetic */ int access$412(ProgressMonitorImpl x0, int x1) {
            return x0.myWorked += x1;
        }

        static /* synthetic */ int access$400(ProgressMonitorImpl x0) {
            return x0.myWorked;
        }
    }

    private class ProgressBarDialog
    extends JDialog {
        private JProgressBar myProgressBar;
        private JLabel myLabel;
        private String myTask;
        private IProgressMonitor myProgressMonitor;

        private ProgressBarDialog(IProgressMonitor progressMonitor) {
            super((Frame)GanttStatusBar.this.myMainFrame, true);
            this.myProgressMonitor = progressMonitor;
        }

        protected void dialogInit() {
            super.dialogInit();
            this.myProgressBar = new JProgressBar();
            this.myProgressBar.setMinimumSize(new Dimension(400, 50));
            this.myProgressBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.myLabel = new JLabel();
            this.myLabel.setFont(Fonts.GENERAL_DIALOG_FONT.deriveFont(14));
            this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.myProgressBar, "Center");
            JPanel labelAndButton = new JPanel(new BorderLayout());
            labelAndButton.add((Component)this.myLabel, "Center");
            JButton cancelButton = new JButton(new CancelAction(this){
                private final /* synthetic */ ProgressBarDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ProgressBarDialog.access$100(this.this$1).setCanceled(true);
                }
            });
            labelAndButton.add((Component)cancelButton, "East");
            this.getContentPane().add((Component)labelAndButton, "South");
            this.setResizable(false);
            this.setUndecorated(true);
        }

        void start(String task, int totalWork) {
            this.myProgressBar.setMaximum(totalWork);
            this.myProgressBar.setMinimum(0);
            this.myTask = task;
            this.myLabel.setText(this.getLabelText());
            this.pack();
            this.setSize(400, 60);
            DialogAligner.center(this, GanttStatusBar.this.myMainFrame);
            this.setVisible(true);
        }

        void setProgress(int work) {
            this.myProgressBar.setValue(work);
            this.myLabel.setText(this.getLabelText());
        }

        void done() {
            this.dispose();
        }

        private String getLabelText() {
            return "<html><body><b>" + this.myTask + " ... " + this.myProgressBar.getValue() * 100 / this.myProgressBar.getMaximum() + "%</b></body></html>";
        }

        static /* synthetic */ IProgressMonitor access$100(ProgressBarDialog x0) {
            return x0.myProgressMonitor;
        }
    }

    private static class ErrorNotificationPanel
    extends JPanel {
        private JLabel myLabel;

        ErrorNotificationPanel() {
            super(new BorderLayout());
        }

        void enableNotifier(Runnable notifier) {
            this.myLabel = new JLabel("<html><body><b>Errors happened. Click here to see the details</b></body></html>");
            this.myLabel.addMouseListener(new MouseAdapter(this, notifier){
                private final /* synthetic */ Runnable val$notifier;
                private final /* synthetic */ ErrorNotificationPanel this$0;
                {
                    this.this$0 = this$0;
                    this.val$notifier = val$notifier;
                }

                public void mouseClicked(MouseEvent e) {
                    this.val$notifier.run();
                }
            });
            this.add(this.myLabel);
            this.revalidate();
        }

        void disableNotifier() {
            this.remove(this.myLabel);
            this.revalidate();
        }
    }

    private class MessagePanel
    extends JPanel {
        JLabel message;
        Color textColor;
        int timer;

        public MessagePanel(int size, boolean separator) {
            super(new FlowLayout());
            this.textColor = Color.BLACK;
            this.timer = 0;
            this.message = new JLabel(this){
                private final /* synthetic */ MessagePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setColor(this.this$1.textColor);
                    g2.drawString(this.getText(), 0, 12);
                }
            };
            if (size != -1) {
                this.message.setPreferredSize(new Dimension(size, 16));
                this.message.setMaximumSize(new Dimension(size, 16));
                this.message.setMaximumSize(new Dimension(size, 16));
            }
            if (separator) {
                this.add(new JLabel("|"));
            }
            this.add(this.message);
        }

        public void setText(String text) {
            this.message.setText(text);
            this.timer = 0;
        }

        public void setText(String text, int mltimer) {
            this.message.setText(text);
            this.timer = mltimer;
        }

        public void clear() {
            this.message.setText("");
        }

        public void hideText() {
            try {
                Color cPanel = this.getBackground();
                Color cBlack = Color.BLACK;
                int step = 50;
                float dRed = (float)cPanel.getRed() / (float)step;
                float dGreen = (float)cPanel.getGreen() / (float)step;
                float dBlue = (float)cPanel.getBlue() / (float)step;
                for (int i = 0; i < step; ++i) {
                    this.textColor = new Color((int)(dRed * (float)i), (int)(dGreen * (float)i), (int)(dBlue * (float)i));
                    this.repaint();
                    Thread.sleep(20L);
                }
                this.textColor = Color.BLACK;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getTimer() {
            return this.timer;
        }
    }
}

