/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.gui.DialogAligner;
import net.sourceforge.ganttproject.gui.GanttPanelDate;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class GanttDialogDate
extends JDialog {
    private GanttLanguage language = GanttLanguage.getInstance();
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private int value = 1;
    private GanttPanelDate panel;
    private JButton jbPrevMonth;
    private JButton jbNextMonth;
    private JFormattedTextField jtDate;
    private JButton jbPrevYear;
    private JButton jbNextYear;
    private boolean myFixedDate;

    public GanttDialogDate(JDialog parent, GanttCalendar date) {
        this(parent, date, false);
    }

    public GanttDialogDate(JDialog parent, GanttCalendar date, boolean showFixedDateCheckBox) {
        super(parent, GanttLanguage.getInstance().getText("chooseDate"), true);
        this.myFixedDate = date.isFixed();
        this.setResizable(false);
        this.panel = new GanttPanelDate(date);
        Box contentPane = Box.createVerticalBox();
        JPanel p = new JPanel();
        JButton ok = new JButton(this.language.getText("ok"));
        this.getRootPane().setDefaultButton(ok);
        p.add(ok);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GanttDialogDate.this.setVisible(false);
                GanttDialogDate.this.value = 0;
            }
        });
        JButton cancel = new JButton(this.language.getText("cancel"));
        p.add(cancel);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GanttDialogDate.this.setVisible(false);
                GanttDialogDate.this.panel.cancel();
            }
        });
        contentPane.add(this.panel);
        if (showFixedDateCheckBox) {
            final JCheckBox fixedDate = new JCheckBox(this.language.getText("fixedDate"));
            fixedDate.setSelected(this.myFixedDate);
            fixedDate.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    GanttDialogDate.this.myFixedDate = fixedDate.isSelected();
                }
            });
            contentPane.add(fixedDate);
        }
        contentPane.add(p);
        this.getContentPane().add(contentPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                GanttDialogDate.this.panel.cancel();
            }
        });
        this.pack();
        this.setResizable(false);
        DialogAligner.center(this, this.getParent());
        this.applyComponentOrientation(this.language.getComponentOrientation());
    }

    public GanttCalendar getDate() {
        GanttCalendar result = this.panel.getDate();
        result.setFixed(this.myFixedDate);
        return result;
    }

    public int getValue() {
        return this.value;
    }
}

