/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.export;

import java.io.File;
import javax.swing.SwingUtilities;
import net.sourceforge.ganttproject.GanttOptions;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.export.ExportFinalizationJob;
import net.sourceforge.ganttproject.export.Exporter;
import net.sourceforge.ganttproject.export.ExporterChooserPage;
import net.sourceforge.ganttproject.export.FileChooserPage;
import net.sourceforge.ganttproject.export.WebPublisher;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.BooleanOption;
import net.sourceforge.ganttproject.gui.options.model.DefaultBooleanOption;
import net.sourceforge.ganttproject.gui.projectwizard.WizardImpl;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class ExportFileWizardImpl
extends WizardImpl {
    private UIFacade myUIFacade;
    private IGanttProject myProject;
    private Chart myGanttChart;
    private Chart myResourceChart;
    private Chart myVisibleChart;
    private GanttOptions myOptions;
    private State myState;
    private static Exporter ourLastSelectedExporter;
    private static Exporter[] ourExporters;

    public ExportFileWizardImpl(UIFacade uiFacade, IGanttProject project, GanttOptions options) {
        this(uiFacade, project, uiFacade.getGanttChart(), uiFacade.getResourceChart(), uiFacade.getActiveChart(), options);
    }

    public ExportFileWizardImpl(UIFacade uiFacade, IGanttProject project, Chart ganttChart, Chart resourceChart, Chart visibleChart, GanttOptions options) {
        super(uiFacade, GanttLanguage.getInstance().getText("exportWizard.dialog.title"));
        this.myUIFacade = uiFacade;
        this.myProject = project;
        this.myGanttChart = ganttChart;
        this.myResourceChart = resourceChart;
        this.myVisibleChart = visibleChart;
        this.myOptions = options;
        this.myState = new State(project.getDocument());
        if (ourExporters == null) {
            ourExporters = Mediator.getPluginManager().getExporters();
        }
        Exporter[] exporters = ourExporters;
        this.myState.setExporter(ourLastSelectedExporter == null ? exporters[0] : ourLastSelectedExporter);
        for (int i = 0; i < exporters.length; ++i) {
            exporters[i].setContext(project, uiFacade);
            if (!(exporters[i] instanceof LegacyOptionsClient)) continue;
            ((LegacyOptionsClient)((Object)exporters[i])).setOptions(this.myOptions);
        }
        this.addPage(new ExporterChooserPage(exporters, this.myState));
        this.addPage(new FileChooserPage(this.myState, this.myProject));
    }

    protected boolean canFinish() {
        return this.myState.getExporter() != null && this.myState.myFile != null;
    }

    protected void onOkPressed() {
        super.onOkPressed();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ExportFinalizationJobImpl finalizationJob = new ExportFinalizationJobImpl();
                    ExportFileWizardImpl.this.myState.getExporter().run(ExportFileWizardImpl.this.myState.getFile(), finalizationJob);
                }
                catch (Exception e) {
                    ExportFileWizardImpl.this.getUIFacade().showErrorDialog(e);
                }
            }
        });
    }

    private GanttLanguage getLanguage() {
        return GanttLanguage.getInstance();
    }

    private void setStatusText(String text) {
        this.getUIFacade().setStatusText(text);
    }

    static interface LegacyOptionsClient {
        public void setOptions(GanttOptions var1);
    }

    class State {
        private Exporter myExporter;
        File myFile;
        private final BooleanOption myPublishInWebOption = new DefaultBooleanOption("exporter.publishInWeb");

        State(Document projectDocument) {
        }

        public void setFile(File file) {
            this.myFile = file;
            ExportFileWizardImpl.this.adjustButtonState();
        }

        public File getFile() {
            return this.myFile;
        }

        void setExporter(Exporter exporter) {
            this.myExporter = exporter;
            ourLastSelectedExporter = exporter;
        }

        Exporter getExporter() {
            return this.myExporter;
        }

        BooleanOption getPublishInWebOption() {
            return this.myPublishInWebOption;
        }
    }

    private class ExportFinalizationJobImpl
    implements ExportFinalizationJob {
        private ExportFinalizationJobImpl() {
        }

        public void run(File[] exportedFiles) {
            if (ExportFileWizardImpl.this.myState.getPublishInWebOption().isChecked()) {
                WebPublisher publisher = new WebPublisher();
                publisher.run(exportedFiles, ExportFileWizardImpl.this.myOptions, ExportFileWizardImpl.this.getUIFacade());
            }
        }
    }
}

