/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.chart;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.chart.BackgroundRendererImpl;
import net.sourceforge.ganttproject.chart.BottomUnitLineRendererImpl;
import net.sourceforge.ganttproject.chart.CachingOffsetCalculatorImpl;
import net.sourceforge.ganttproject.chart.ChartGridImpl;
import net.sourceforge.ganttproject.chart.ChartHeader;
import net.sourceforge.ganttproject.chart.ChartHeaderImpl;
import net.sourceforge.ganttproject.chart.ChartUIConfiguration;
import net.sourceforge.ganttproject.chart.ChartViewState;
import net.sourceforge.ganttproject.chart.DayTypeAlternance;
import net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import net.sourceforge.ganttproject.chart.Painter;
import net.sourceforge.ganttproject.chart.StyledPainterImpl;
import net.sourceforge.ganttproject.chart.TimeUnitVisitor;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.gui.options.model.GPOptionChangeListener;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.zoom.ZoomEvent;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.time.TimeFrame;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.TimeUnitFunctionOfDate;
import net.sourceforge.ganttproject.time.TimeUnitStack;

public class ChartModelBase
implements ChartViewState.Listener {
    public static final Object STATIC_MUTEX = new Object();
    private final OptionEventDispatcher myOptionEventDispatcher = new OptionEventDispatcher();
    private final ChartHeaderImpl myChartHeader;
    private final ChartGridImpl myChartGrid;
    private Dimension myBounds;
    private Date myStartDate;
    protected int myAtomUnitPixels;
    private TimeFrame[] myTimeFrames;
    protected final TimeUnitStack myTimeUnitStack;
    private TimeUnit myTopUnit;
    protected TimeUnit myBottomUnit;
    protected List myTimeUnitVisitors = new ArrayList();
    protected final BottomUnitLineRendererImpl myBottomUnitLineRenderer;
    protected TimeFrameWidthFunction myFrameWidthFunction;
    private RegularFramesWithFunction myRegularFrameWidthFunction = new RegularFramesWithFunction();
    private SkewedFramesWidthFunction mySkewedFrameWidthFunction = new SkewedFramesWidthFunction();
    private final BackgroundRendererImpl myBackgroundRenderer;
    private final StyledPainterImpl myPainter;
    private final List myOptionListeners = new ArrayList();
    private final UIConfiguration myProjectConfig;
    private CachingOffsetCalculatorImpl myCachingOffsetCalculator;
    protected final ChartUIConfiguration myChartUIConfiguration;
    protected final TaskManager myTaskManager;
    private int myVerticalOffset;

    public ChartModelBase(TaskManager taskManager, TimeUnitStack timeUnitStack, UIConfiguration projectConfig) {
        this.myTaskManager = taskManager;
        this.myProjectConfig = projectConfig;
        this.myChartUIConfiguration = new ChartUIConfiguration(projectConfig);
        this.myPainter = new StyledPainterImpl(this.myChartUIConfiguration);
        this.myTimeUnitStack = timeUnitStack;
        this.myChartHeader = new ChartHeaderImpl(this);
        this.myChartGrid = new ChartGridImpl(this, projectConfig);
        this.myBottomUnitLineRenderer = new BottomUnitLineRendererImpl(this);
        this.myBackgroundRenderer = new BackgroundRendererImpl(this);
        this.myTimeUnitVisitors.add(this.myChartHeader);
        this.myTimeUnitVisitors.add(this.myChartGrid);
        this.myTimeUnitVisitors.add(this.myBottomUnitLineRenderer);
        this.myCachingOffsetCalculator = new CachingOffsetCalculatorImpl(this.myTimeUnitStack);
    }

    public void paint(Graphics g) {
        int height = (int)this.getBounds().getHeight() - this.getChartUIConfiguration().getHeaderHeight();
        this.myChartGrid.setHeight(height);
        this.myBackgroundRenderer.setHeight(height);
        if (this.getTopUnit().isConstructedFrom(this.myBottomUnit)) {
            this.myFrameWidthFunction = this.myRegularFrameWidthFunction;
            for (int i = 0; i < this.myTimeUnitVisitors.size(); ++i) {
                ((TimeUnitVisitor)this.myTimeUnitVisitors.get(i)).setEnabled(true);
            }
            this.paintRegularTimeFrames(g, this.getTimeFrames(null));
        } else {
            this.myFrameWidthFunction = this.mySkewedFrameWidthFunction;
            this.mySkewedFrameWidthFunction.initialize();
            this.paintSkewedTimeFrames(g);
        }
    }

    protected void enableRenderers1() {
        this.myChartHeader.setEnabled(false);
        this.myBottomUnitLineRenderer.setEnabled(true);
        this.myChartGrid.setEnabled(true);
    }

    protected void enableRenderers2() {
        this.myChartHeader.setEnabled(true);
        this.myBottomUnitLineRenderer.setEnabled(false);
        this.myChartGrid.setEnabled(false);
    }

    private void paintSkewedTimeFrames(Graphics g) {
        TimeUnit savedBottomUnit = this.myBottomUnit;
        TimeUnit topUnit = this.getTopUnit();
        this.setTopUnit(this.myBottomUnit);
        this.myTimeFrames = null;
        this.enableRenderers1();
        TimeFrame[] timeFrames = this.getTimeFrames(null);
        this.paintRegularTimeFrames(g, timeFrames);
        Date exactStart = timeFrames[0].getStartDate();
        this.myTimeFrames = null;
        this.setTopUnit(topUnit);
        this.myBottomUnit = topUnit;
        this.enableRenderers2();
        timeFrames = this.getTimeFrames(exactStart);
        this.paintRegularTimeFrames(g, timeFrames);
        this.myBottomUnit = savedBottomUnit;
    }

    protected void paintMainArea(Graphics mainArea, Painter p) {
        this.myChartGrid.getPrimitiveContainer().paint(p, mainArea);
    }

    private void paintRegularTimeFrames(Graphics g, TimeFrame[] timeFrames) {
        this.fireBeforeProcessingTimeFrames();
        for (int i = 0; i < timeFrames.length; ++i) {
            TimeFrame next = timeFrames[i];
            this.fireFrameStarted(next);
            TimeUnit topUnit = next.getTopUnit();
            this.fireUnitLineStarted(topUnit);
            this.fireUnitLineFinished(topUnit);
            TimeUnit bottomUnit = this.myBottomUnit;
            this.fireUnitLineStarted(bottomUnit);
            this.visitTimeUnits(next, bottomUnit);
            this.fireUnitLineFinished(bottomUnit);
            this.fireFrameFinished(next);
        }
        this.fireAfterProcessingTimeFrames();
        this.myPainter.setGraphics(g);
        this.myChartHeader.getPrimitiveContainer().paint(this.myPainter, g);
        this.myBottomUnitLineRenderer.getPrimitiveContainer().paint(this.myPainter, g);
        Graphics mainArea = g.create(0, this.getChartUIConfiguration().getHeaderHeight(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight());
        this.myPainter.setGraphics(mainArea);
        this.myBackgroundRenderer.getPrimitiveContainer().paint(this.myPainter, g);
        this.paintMainArea(mainArea, this.myPainter);
    }

    void fireBeforeProcessingTimeFrames() {
        this.myBackgroundRenderer.beforeProcessingTimeFrames();
        for (int i = 0; i < this.myTimeUnitVisitors.size(); ++i) {
            TimeUnitVisitor nextVisitor = (TimeUnitVisitor)this.myTimeUnitVisitors.get(i);
            if (!nextVisitor.isEnabled()) continue;
            nextVisitor.beforeProcessingTimeFrames();
        }
    }

    void fireAfterProcessingTimeFrames() {
        for (int i = 0; i < this.myTimeUnitVisitors.size(); ++i) {
            TimeUnitVisitor nextVisitor = (TimeUnitVisitor)this.myTimeUnitVisitors.get(i);
            if (!nextVisitor.isEnabled()) continue;
            nextVisitor.afterProcessingTimeFrames();
        }
    }

    void fireFrameStarted(TimeFrame timeFrame) {
        for (int i = 0; i < this.myTimeUnitVisitors.size(); ++i) {
            TimeUnitVisitor nextVisitor = (TimeUnitVisitor)this.myTimeUnitVisitors.get(i);
            if (!nextVisitor.isEnabled()) continue;
            nextVisitor.startTimeFrame(timeFrame);
        }
    }

    void fireFrameFinished(TimeFrame timeFrame) {
        for (int i = 0; i < this.myTimeUnitVisitors.size(); ++i) {
            TimeUnitVisitor nextVisitor = (TimeUnitVisitor)this.myTimeUnitVisitors.get(i);
            if (!nextVisitor.isEnabled()) continue;
            nextVisitor.endTimeFrame(timeFrame);
        }
    }

    void fireUnitLineStarted(TimeUnit timeUnit) {
        for (int i = 0; i < this.myTimeUnitVisitors.size(); ++i) {
            TimeUnitVisitor nextVisitor = (TimeUnitVisitor)this.myTimeUnitVisitors.get(i);
            if (!nextVisitor.isEnabled()) continue;
            nextVisitor.startUnitLine(timeUnit);
        }
    }

    void fireUnitLineFinished(TimeUnit timeUnit) {
        for (int i = 0; i < this.myTimeUnitVisitors.size(); ++i) {
            TimeUnitVisitor nextVisitor = (TimeUnitVisitor)this.myTimeUnitVisitors.get(i);
            if (!nextVisitor.isEnabled()) continue;
            nextVisitor.endUnitLine(timeUnit);
        }
    }

    void visitTimeUnits(TimeFrame timeFrame, TimeUnit timeUnit) {
        for (int j = 0; j < timeFrame.getUnitCount(timeUnit); ++j) {
            for (int i = 0; i < this.myTimeUnitVisitors.size(); ++i) {
                TimeUnitVisitor nextVisitor = (TimeUnitVisitor)this.myTimeUnitVisitors.get(i);
                if (!nextVisitor.isEnabled()) continue;
                nextVisitor.nextTimeUnit(j);
            }
        }
    }

    public void setBounds(Dimension bounds) {
        this.myBounds = bounds;
    }

    public void setStartDate(Date startDate) {
        if (!startDate.equals(this.myStartDate)) {
            this.myStartDate = startDate;
            this.myTimeFrames = null;
        }
    }

    public Date getStartDate() {
        return this.myStartDate;
    }

    public Date getEndDate() {
        TimeFrame[] timeFrames = this.getTimeFrames(null);
        TimeFrame last = timeFrames[timeFrames.length - 1];
        return last.getFinishDate();
    }

    public void setBottomUnitWidth(int pixelsWidth) {
        if (this.myAtomUnitPixels != pixelsWidth) {
            this.myCachingOffsetCalculator.reset();
        }
        this.myAtomUnitPixels = pixelsWidth;
    }

    public void setRowHeight(int rowHeight) {
        this.getChartUIConfiguration().setRowHeight(rowHeight);
    }

    public void setTopTimeUnit(TimeUnit topTimeUnit) {
        this.setTopUnit(topTimeUnit);
        this.myTimeFrames = null;
    }

    public void setBottomTimeUnit(TimeUnit bottomTimeUnit) {
        this.myBottomUnit = bottomTimeUnit;
        this.myTimeFrames = null;
    }

    protected UIConfiguration getProjectConfig() {
        return this.myProjectConfig;
    }

    protected Dimension getBounds() {
        return this.myBounds;
    }

    TimeFrame[] getTimeFrames(Date exactDate) {
        if (this.myTimeFrames == null) {
            this.myTimeFrames = this.calculateTimeFrames(exactDate);
        }
        return this.myTimeFrames;
    }

    protected int getBottomUnitWidth() {
        return this.myAtomUnitPixels;
    }

    private TimeFrame[] calculateTimeFrames(Date exactDate) {
        int frameWidth;
        ArrayList<TimeFrame> result = new ArrayList<TimeFrame>();
        int totalFramesWidth = 0;
        Date currentDate = this.myStartDate;
        do {
            TimeFrame currentFrame = this.myTimeUnitStack.createTimeFrame(currentDate, this.getTopUnit(currentDate), this.myBottomUnit);
            if (exactDate != null && currentFrame.getStartDate().before(exactDate)) {
                currentFrame.trimLeft(exactDate);
            }
            if (currentFrame.getStartDate().after(currentFrame.getFinishDate())) {
                throw new IllegalStateException("Frame is invalid:\n" + currentFrame + "\n date=" + exactDate);
            }
            result.add(currentFrame);
            frameWidth = this.myFrameWidthFunction.getTimeFrameWidth(currentFrame);
            currentDate = currentFrame.getFinishDate();
        } while ((double)(totalFramesWidth += frameWidth) <= this.getBounds().getWidth());
        return result.toArray(new TimeFrame[0]);
    }

    public GPCalendar.DayType getDayType(TimeFrame timeFrame, TimeUnit timeUnit, int unitIndex) {
        Date startDate = timeFrame.getUnitStart(timeUnit, unitIndex);
        Date endDate = timeFrame.getUnitFinish(timeUnit, unitIndex);
        Calendar c = (Calendar)Calendar.getInstance().clone();
        c.setTime(startDate);
        int startDayOfWeek = c.get(7);
        c.setTime(endDate);
        int endDayOfWeek = c.get(7);
        return this.getTaskManager().getCalendar().getDayTypeDate(startDate);
    }

    public void startDateChanged(ChartViewState.ViewStateEvent e) {
        this.setStartDate((Date)e.getNewValue());
    }

    public void zoomChanged(ZoomEvent e) {
    }

    protected TimeUnit getBottomUnit() {
        return this.myBottomUnit;
    }

    protected TimeUnitStack getTimeUnitStack() {
        return this.myTimeUnitStack;
    }

    /*
     * WARNING - void declaration
     */
    protected DayTypeAlternance[] getDayTypeAlternance(TimeFrame timeFrame, TimeUnit timeUnit, int unitIndex) {
        void var5_7;
        DayTypeAlternance[] result;
        class AlternanceFactory {
            private Calendar c = (Calendar)Calendar.getInstance().clone();

            AlternanceFactory() {
            }

            DayTypeAlternance createAlternance(TimeUnit timeUnit, Date startDate, Date endDate) {
                this.c.setTime(startDate);
                int startDayOfWeek = this.c.get(7);
                this.c.setTime(endDate);
                int endDayOfWeek = this.c.get(7);
                TaskLength duration = ChartModelBase.this.myTaskManager.createLength(timeUnit, startDate, endDate);
                GPCalendar.DayType dayType = ChartModelBase.this.getTaskManager().getCalendar().getWeekDayType(startDayOfWeek);
                dayType = ChartModelBase.this.getTaskManager().getCalendar().getDayTypeDate(startDate);
                return new DayTypeAlternance(dayType, duration, endDate);
            }

            void createAlternance(TimeUnit timeUnit, TimeFrame timeFrame, List output) {
                GPCalendar.DayType startType = null;
                Date startDate = null;
                int unitCount = timeFrame.getUnitCount(timeUnit);
                for (int i = 0; i < unitCount; ++i) {
                    Date start = timeFrame.getUnitStart(timeUnit, i);
                    this.c.setTime(start);
                    int startDayOfWeek = this.c.get(7);
                    GPCalendar.DayType dayType = ChartModelBase.this.getTaskManager().getCalendar().getWeekDayType(startDayOfWeek);
                    if (startType == null) {
                        startType = dayType;
                        startDate = start;
                    }
                    if (startType == dayType) continue;
                    Date end = timeFrame.getUnitFinish(timeUnit, i - 1);
                    TaskLength duration = ChartModelBase.this.myTaskManager.createLength(timeUnit, startDate, end);
                    output.add(new DayTypeAlternance(startType, duration, end));
                    startType = dayType;
                    startDate = start;
                }
                Date end = timeFrame.getUnitFinish(timeUnit, unitCount - 1);
                TaskLength duration = ChartModelBase.this.myTaskManager.createLength(timeUnit, startDate, end);
                output.add(new DayTypeAlternance(startType, duration, end));
            }
        }
        AlternanceFactory f = new AlternanceFactory();
        Date startDate = timeFrame.getUnitStart(timeUnit, unitIndex);
        Date endDate = timeFrame.getUnitFinish(timeUnit, unitIndex);
        if (timeUnit.equals(this.myTimeUnitStack.getDefaultTimeUnit())) {
            result = new DayTypeAlternance[]{f.createAlternance(timeUnit, startDate, endDate)};
        } else if (timeUnit.isConstructedFrom(this.myTimeUnitStack.getDefaultTimeUnit())) {
            ArrayList buf = new ArrayList();
            TimeUnit defaultUnit = this.myTimeUnitStack.getDefaultTimeUnit();
            TimeFrame innerFrame = this.myTimeUnitStack.createTimeFrame(startDate, timeUnit, defaultUnit);
            f.createAlternance(defaultUnit, innerFrame, buf);
            result = buf.toArray(new DayTypeAlternance[buf.size()]);
        } else {
            throw new RuntimeException("We should not be here");
        }
        return var5_7;
    }

    Offset[] calculateOffsets(TimeFrame timeFrame, TimeUnit frameBottomUnit, Date bottomUnitStartDate, TimeUnit offsetUnit, int frameBottomUnitWidth) {
        return this.myCachingOffsetCalculator.calculateOffsets(timeFrame, frameBottomUnit, bottomUnitStartDate, offsetUnit, frameBottomUnitWidth);
    }

    public ChartUIConfiguration getChartUIConfiguration() {
        return this.myChartUIConfiguration;
    }

    int getBottomUnitWidth(TimeFrame nextFrame) {
        int frameWidth = this.myFrameWidthFunction.getTimeFrameWidth(nextFrame);
        int bottomUnitsCount = nextFrame.getUnitCount(nextFrame.getBottomUnit());
        return frameWidth / bottomUnitsCount;
    }

    protected TaskManager getTaskManager() {
        return this.myTaskManager;
    }

    public ChartHeader getChartHeader() {
        return this.myChartHeader;
    }

    protected ChartGridImpl getChartGrid() {
        return this.myChartGrid;
    }

    public float calculateLength(int fromX, int toX, int y) {
        int curX = fromX;
        int totalPixels = toX - fromX;
        int holidayPixels = 0;
        while (curX < toX) {
            GraphicPrimitiveContainer.GraphicPrimitive nextPrimitive = this.getChartGrid().getPrimitiveContainer().getPrimitive(curX, y - this.getChartUIConfiguration().getHeaderHeight());
            if (nextPrimitive instanceof GraphicPrimitiveContainer.Rectangle && GPCalendar.DayType.WEEKEND == nextPrimitive.getModelObject()) {
                GraphicPrimitiveContainer.Rectangle nextRect = (GraphicPrimitiveContainer.Rectangle)nextPrimitive;
                holidayPixels += nextRect.getRightX() - curX;
                if (nextRect.myLeftX < curX) {
                    holidayPixels -= curX - nextRect.myLeftX;
                }
                if (nextRect.myLeftX < fromX) {
                    holidayPixels -= fromX - nextRect.myLeftX;
                }
                if (nextRect.getRightX() > toX) {
                    holidayPixels -= nextRect.getRightX() - toX;
                }
                curX = nextRect.getRightX() + 1;
                continue;
            }
            curX += this.getBottomUnitWidth();
        }
        float workPixels = (float)totalPixels - (float)holidayPixels;
        return workPixels / (float)this.getBottomUnitWidth();
    }

    public float calculateLengthNoWeekends(int fromX, int toX) {
        int totalPixels = toX - fromX;
        return (float)totalPixels / (float)this.getBottomUnitWidth();
    }

    public TaskLength getVisibleLength() {
        double pixelsLength = this.getBounds().getWidth();
        float unitsLength = (float)(pixelsLength / (double)this.getBottomUnitWidth());
        TaskLength result = this.getTaskManager().createLength(this.getBottomUnit(), unitsLength);
        return result;
    }

    public void setHeaderHeight(int i) {
        this.getChartUIConfiguration().setHeaderHeight(i);
    }

    public void setVerticalOffset(int offset) {
        this.myVerticalOffset = offset;
    }

    protected int getVerticalOffset() {
        return this.myVerticalOffset;
    }

    private void setTopUnit(TimeUnit myTopUnit) {
        this.myTopUnit = myTopUnit;
    }

    private TimeUnit getTopUnit() {
        return this.getTopUnit(this.myStartDate);
    }

    private TimeUnit getTopUnit(Date startDate) {
        TimeUnit result = this.myTopUnit;
        if (this.myTopUnit instanceof TimeUnitFunctionOfDate) {
            if (startDate == null) {
                throw new RuntimeException("No date is set");
            }
            result = ((TimeUnitFunctionOfDate)this.myTopUnit).createTimeUnit(startDate);
        }
        return result;
    }

    public GPOptionGroup[] getChartOptionGroups() {
        return new GPOptionGroup[]{this.myChartGrid.getOptions()};
    }

    public void addOptionChangeListener(GPOptionChangeListener listener) {
        this.myOptionListeners.add(listener);
    }

    protected void fireOptionsChanged() {
        for (int i = 0; i < this.myOptionListeners.size(); ++i) {
            GPOptionChangeListener next = (GPOptionChangeListener)this.myOptionListeners.get(i);
            next.optionsChanged();
        }
    }

    public ChartModelBase createCopy() {
        return new ChartModelBase(this.getTaskManager(), this.getTimeUnitStack(), this.myProjectConfig);
    }

    public OptionEventDispatcher getOptionEventDispatcher() {
        return this.myOptionEventDispatcher;
    }

    public static class Offset {
        private TaskLength myOffsetLength;
        private Date myOffsetAnchor;
        private Date myOffsetEnd;
        private int myOffsetPixels;
        private TimeUnit myOffsetUnit;

        Offset(TimeUnit offsetUnit, Date offsetAnchor, Date offsetEnd, int offsetPixels) {
            this.myOffsetAnchor = offsetAnchor;
            this.myOffsetEnd = offsetEnd;
            this.myOffsetPixels = offsetPixels;
            this.myOffsetUnit = offsetUnit;
        }

        Date getOffsetAnchor() {
            return this.myOffsetAnchor;
        }

        public Date getOffsetEnd() {
            return this.myOffsetEnd;
        }

        public int getOffsetPixels() {
            return this.myOffsetPixels;
        }

        TimeUnit getOffsetUnit() {
            return this.myOffsetUnit;
        }
    }

    public class OptionEventDispatcher {
        void optionsChanged() {
            ChartModelBase.this.fireOptionsChanged();
        }
    }

    private class SkewedFramesWidthFunction
    implements TimeFrameWidthFunction {
        private float myWidthPerDefaultUnit;

        private SkewedFramesWidthFunction() {
        }

        void initialize() {
            int defaultUnitsPerBottomUnit = ChartModelBase.this.myBottomUnit.getAtomCount(ChartModelBase.this.myTimeUnitStack.getDefaultTimeUnit());
            this.myWidthPerDefaultUnit = (float)ChartModelBase.this.myAtomUnitPixels / (float)defaultUnitsPerBottomUnit;
        }

        public int getTimeFrameWidth(TimeFrame timeFrame) {
            int defaultUnitsPerTopUnit = timeFrame.getUnitCount(ChartModelBase.this.myTimeUnitStack.getDefaultTimeUnit());
            return (int)((float)defaultUnitsPerTopUnit * this.myWidthPerDefaultUnit);
        }
    }

    private class RegularFramesWithFunction
    implements TimeFrameWidthFunction {
        private RegularFramesWithFunction() {
        }

        public int getTimeFrameWidth(TimeFrame timeFrame) {
            return timeFrame.getUnitCount(ChartModelBase.this.myBottomUnit) * ChartModelBase.this.myAtomUnitPixels;
        }
    }

    private static interface TimeFrameWidthFunction {
        public int getTimeFrameWidth(TimeFrame var1);
    }
}

