/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.ganttproject.GPTreeTableBase;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.ResourceTreeTableModel;
import net.sourceforge.ganttproject.gui.ResourceDialogCustomColumn;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.resource.ResourceColumn;
import net.sourceforge.ganttproject.resource.ResourceNode;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleManager;
import org.jdesktop.swing.decorator.AlternateRowHighlighter;
import org.jdesktop.swing.decorator.HierarchicalColumnHighlighter;
import org.jdesktop.swing.decorator.Highlighter;
import org.jdesktop.swing.decorator.HighlighterPipeline;
import org.jdesktop.swing.table.TableColumnExt;
import org.jdesktop.swing.treetable.TreeTableModel;

public class ResourceTreeTable
extends GPTreeTableBase {
    private RoleManager myRoleManager;
    private static GanttLanguage language = GanttLanguage.getInstance();
    private ResourceTreeTableModel ttModel;
    private JPopupMenu popupMenu = null;
    JMenuItem delColumnItem = null;
    private Point clickPoint = null;
    private static int colCount = 0;

    public ResourceTreeTable(TreeTableModel model) {
        super(model);
        this.ttModel = (ResourceTreeTableModel)model;
        this.setTreeTableModel(model);
        this.initTreeTable();
    }

    public boolean isVisible(DefaultMutableTreeNode node) {
        return this.getTreeTable().getTree().isVisible(new TreePath(node.getPath()));
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
    }

    public void initTreeTable() {
        Enumeration<TableColumn> enumeration = this.getTable().getColumnModel().getColumns();
        ArrayList<TableColumnExt> lToDel = new ArrayList<TableColumnExt>();
        while (enumeration.hasMoreElements()) {
            TableColumnExt tc = (TableColumnExt)enumeration.nextElement();
            lToDel.add(tc);
        }
        Iterator it = lToDel.iterator();
        while (it.hasNext()) {
            this.getTable().removeColumn((TableColumn)it.next());
        }
        this.getTable().setAutoCreateColumnsFromModel(false);
        this.getTable().setAutoResizeMode(2);
        TableColumnExt tce1 = this.newTableColumnExt(0);
        tce1.setTitle(ResourceTreeTableModel.strResourceName);
        TableColumnExt tce2 = this.newTableColumnExt(1);
        tce2.setTitle(ResourceTreeTableModel.strResourceRole);
        TableColumnExt tce3 = this.newTableColumnExt(2);
        tce3.setTitle(ResourceTreeTableModel.strResourceEMail);
        TableColumnExt tce4 = this.newTableColumnExt(3);
        tce4.setTitle(ResourceTreeTableModel.strResourcePhone);
        TableColumnExt tce5 = this.newTableColumnExt(4);
        tce5.setTitle(ResourceTreeTableModel.strResourceRoleForTask);
        this.addMandatoryColumn(new ResourceColumn(tce1, this.ttModel.useNextIndex(), String.class));
        this.addMandatoryColumn(new ResourceColumn(tce2, this.ttModel.useNextIndex(), String.class));
        this.addMandatoryColumn(new ResourceColumn(tce3, this.ttModel.useNextIndex(), String.class));
        this.addMandatoryColumn(new ResourceColumn(tce4, this.ttModel.useNextIndex(), String.class));
        this.addMandatoryColumn(new ResourceColumn(tce5, this.ttModel.useNextIndex(), String.class));
        this.initColumnsAlignements();
        ArrayList cols = this.ttModel.getColumns();
        for (int i = 2; i < cols.size(); ++i) {
            this.hideColumn((ResourceColumn)cols.get(i));
        }
        this.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.quickSilver, new HierarchicalColumnHighlighter()}));
        this.setShowHorizontalLines(true);
        this.setHasColumnControl(true);
        ImageIcon icon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/simple_task.gif"));
        this.setOpenIcon(icon);
        this.setClosedIcon(icon);
        this.setCollapsedIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/plus.gif")));
        this.setExpandedIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/minus.gif")));
        this.setLeafIcon(icon);
        this.getTreeTable().getParent().setBackground(Color.WHITE);
        this.setUpRolesRenderer();
        this.setUpAssignementRolesRenderer();
        this.getTreeTable().getTree().addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent arg0) {
                Mediator.getGanttProjectSingleton().repaint2();
            }

            public void treeCollapsed(TreeExpansionEvent arg0) {
                Mediator.getGanttProjectSingleton().repaint2();
            }
        });
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 0));
        this.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.handlePopupTrigger(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.handlePopupTrigger(e);
            }

            private void handlePopupTrigger(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ResourceTreeTable.this.clickPoint = e.getPoint();
                    String name = ResourceTreeTable.this.getTable().getColumnName(ResourceTreeTable.this.getTable().columnAtPoint(ResourceTreeTable.this.clickPoint));
                    ResourceTreeTable.this.createPopup();
                    if (ResourceTreeTable.this.ttModel.checkRemovableCol(name)) {
                        ResourceTreeTable.this.delColumnItem.setEnabled(true);
                    } else {
                        ResourceTreeTable.this.delColumnItem.setEnabled(false);
                    }
                    Component c = (Component)e.getSource();
                    ResourceTreeTable.this.popupMenu.show(c, e.getX(), e.getY());
                }
            }
        });
    }

    private void createPopup() {
        this.popupMenu = new JPopupMenu();
        ArrayList cols = this.ttModel.getColumns();
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            ResourceColumn col = (ResourceColumn)cols.get(i);
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(col.getTitle(), col.isVisible());
            item.addActionListener(new ColumnHandler(col));
            this.popupMenu.add(item);
        }
        this.popupMenu.addSeparator();
        JMenuItem showAllItem = new JMenuItem(language.getText("displayAll"));
        showAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mediator.getGanttProjectSingleton().getUndoManager().undoableEdit("displayAllColumns", new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ArrayList cols = ResourceTreeTable.access$200(3.access$400(this.this$1)).getColumns();
                        int size = cols.size();
                        for (int i = 0; i < size; ++i) {
                            ResourceColumn col = (ResourceColumn)cols.get(i);
                            if (col.isVisible()) continue;
                            col.setVisible(true);
                            3.access$400(this.this$1).showColumn(col);
                        }
                        Mediator.getGanttProjectSingleton().setAskForSave(true);
                    }
                });
            }

            static /* synthetic */ ResourceTreeTable access$400(3 x0) {
                return x0.ResourceTreeTable.this;
            }
        });
        this.popupMenu.add(showAllItem);
        this.popupMenu.addSeparator();
        JMenuItem addColumnItem = new JMenuItem(language.getText("addCustomColumn"));
        addColumnItem.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/addCol_16.gif")));
        addColumnItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mediator.getGanttProjectSingleton().getUndoManager().undoableEdit("addCustomColumn", new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ResourceColumn column = null;
                        5.access$500(this.this$1).addCustomColumn(column);
                    }
                });
            }

            static /* synthetic */ ResourceTreeTable access$500(5 x0) {
                return x0.ResourceTreeTable.this;
            }
        });
        this.popupMenu.add(addColumnItem);
        this.delColumnItem = new JMenuItem(language.getText("deleteCustomColumn"));
        this.delColumnItem.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/removeCol_16.gif")));
        this.delColumnItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mediator.getGanttProjectSingleton().getUndoManager().undoableEdit("deleteCustomColumn", new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        int ind = 7.access$600(this.this$1).getTable().columnAtPoint(ResourceTreeTable.access$000(7.access$600(this.this$1)));
                        if (ind >= 0) {
                            7.access$600(this.this$1).deleteCustomColumn(7.access$600(this.this$1).getTable().getColumnName(ind));
                            7.access$600(this.this$1).delColumnItem.setEnabled(false);
                        }
                    }
                });
            }

            static /* synthetic */ ResourceTreeTable access$600(7 x0) {
                return x0.ResourceTreeTable.this;
            }
        });
        this.popupMenu.add(this.delColumnItem);
    }

    void showColumn(ResourceColumn col) {
        col.setVisible(true);
        this.addColumn(col.getColumn());
        ++colCount;
        try {
            this.getTable().moveColumn(colCount - 1, col.getIndex());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void hideColumn(ResourceColumn col) {
        col.setVisible(false);
        this.removeColumn(col.getColumn());
        --colCount;
    }

    public void addMandatoryColumn(ResourceColumn column) {
        this.addColumn(column.getColumn());
        ++colCount;
        this.ttModel.addMandatoryColumn(column);
    }

    public void addCustomColumn(ResourceColumn column) {
        if (column == null) {
            int index = this.ttModel.useNextIndex();
            TableColumnExt col = this.newTableColumnExt(index);
            column = new ResourceColumn(col, index);
            ResourceDialogCustomColumn d = new ResourceDialogCustomColumn(Mediator.getGanttProjectSingleton().getUIFacade(), column);
            d.setVisible(true);
            column = d.getColumn();
        }
        if (column.getTitle() != null) {
            try {
                this.ttModel.addCustomColumn(column.getTitle(), column);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), "Column add", 0);
                return;
            }
            this.addColumn(column.getColumn());
            ++colCount;
            String colClass = column.getType().getName();
            if (colClass.equals("java.lang.Integer") || colClass.equals("java.lang.Double")) {
                int align = 4;
                this.setColumnHorizontalAlignment(column.getTitle(), align);
            } else if (colClass.equals("java.util.GregorianCalendar")) {
                int align = 0;
                this.setColumnHorizontalAlignment(column.getTitle(), align);
                column.getColumn().setCellEditor(this.newDateCellEditor());
            } else {
                int align = 2;
                this.setColumnHorizontalAlignment(column.getTitle(), align);
            }
        }
    }

    public void deleteCustomColumn(String name) {
        ResourceColumn col = null;
        col = this.ttModel.deleteCustomColumn(name);
        this.removeColumn(col.getColumn());
        --colCount;
    }

    void setUpRolesRenderer() {
        Role[] roles = this.getRoleManager().getEnabledRoles();
        JComboBox<Role> comboBox = new JComboBox<Role>();
        for (int i = 0; i < roles.length; ++i) {
            comboBox.addItem(roles[i]);
        }
        try {
            TableColumnExt roleColumn = this.getColumn(ResourceTreeTableModel.strResourceRole);
            comboBox.setEditable(false);
            roleColumn.setCellEditor(new DefaultCellEditor(comboBox));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private RoleManager getRoleManager() {
        if (this.myRoleManager == null) {
            this.myRoleManager = Mediator.getRoleManager();
            this.myRoleManager.addRoleListener(new RoleManager.Listener(){

                public void rolesChanged(RoleManager.RoleEvent e) {
                    ResourceTreeTable.this.setUpRolesRenderer();
                    ResourceTreeTable.this.setUpAssignementRolesRenderer();
                }
            });
        }
        return this.myRoleManager;
    }

    void setUpAssignementRolesRenderer() {
        JComboBox<Role> comboBox = new JComboBox<Role>(this.getRoleManager().getEnabledRoles());
        try {
            TableColumnExt roleColumn = this.getColumn(ResourceTreeTableModel.strResourceRoleForTask);
            comboBox.setEditable(false);
            roleColumn.setCellEditor(new DefaultCellEditor(comboBox));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void initColumnsAlignements() {
        this.setColumnHorizontalAlignment(ResourceTreeTableModel.strResourceRole, 2);
        this.setColumnHorizontalAlignment(ResourceTreeTableModel.strResourceEMail, 2);
        this.setColumnHorizontalAlignment(ResourceTreeTableModel.strResourcePhone, 4);
        this.setColumnHorizontalAlignment(ResourceTreeTableModel.strResourceRoleForTask, 2);
        this.getTable().getColumnExt((Object)ResourceTreeTableModel.strResourceName).setPreferredWidth(150);
        this.getTable().getColumnExt((Object)ResourceTreeTableModel.strResourceRole).setPreferredWidth(120);
        this.getTable().getColumnExt((Object)ResourceTreeTableModel.strResourceEMail).setPreferredWidth(100);
        this.getTable().getColumnExt((Object)ResourceTreeTableModel.strResourcePhone).setPreferredWidth(100);
        this.getTable().getColumnExt((Object)ResourceTreeTableModel.strResourceRoleForTask).setPreferredWidth(100);
    }

    public DefaultMutableTreeNode[] getSelectedNodes() {
        TreePath[] currentSelection = this.getTreeTable().getTree().getSelectionPaths();
        if (currentSelection == null || currentSelection.length == 0) {
            return new DefaultMutableTreeNode[0];
        }
        DefaultMutableTreeNode[] dmtnselected = new DefaultMutableTreeNode[currentSelection.length];
        for (int i = 0; i < currentSelection.length; ++i) {
            dmtnselected[i] = (DefaultMutableTreeNode)currentSelection[i].getLastPathComponent();
        }
        return dmtnselected;
    }

    public boolean isExpanded(ProjectResource pr) {
        ResourceNode node = ((ResourceTreeTableModel)this.getTreeTableModel()).exists(pr);
        if (node != null) {
            return this.getTreeTable().isExpanded(new TreePath(node.getPath()));
        }
        return false;
    }

    public void addKeyListener(KeyListener listener) {
        super.addKeyListener(listener);
        this.getTable().addKeyListener(listener);
        this.getTree().addKeyListener(listener);
    }

    public JTree getTree() {
        return this.getTreeTable().getTree();
    }

    public void setAction(Action action) {
        InputMap inputMap = new InputMap();
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action.getValue("Name"));
        inputMap.setParent(this.getTreeTable().getInputMap(0));
        this.getTreeTable().setInputMap(0, inputMap);
        this.getTreeTable().getActionMap().put(action.getValue("Name"), action);
    }

    public void addMouseListener(MouseListener listener) {
        this.getTreeTable().addMouseListener(listener);
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane.getVerticalScrollBar();
    }

    class ColumnHandler
    implements ActionListener {
        private ResourceColumn column;

        public ColumnHandler(ResourceColumn c) {
            this.column = c;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.column.isVisible()) {
                ResourceTreeTable.this.hideColumn(this.column);
            } else {
                ResourceTreeTable.this.showColumn(this.column);
            }
        }
    }
}

