/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.delay.Delay;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.CustomColumnsException;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskInfo;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskNode;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import org.jdesktop.swing.treetable.DefaultTreeTableModel;

public class GanttTreeTableModel
extends DefaultTreeTableModel
implements TableColumnModelListener,
TaskContainmentHierarchyFacade,
GanttLanguage.Listener {
    private static GanttLanguage language = GanttLanguage.getInstance();
    public static String strColType = null;
    public static String strColPriority = null;
    public static String strColInfo = null;
    public static String strColName = null;
    public static String strColBegDate = null;
    public static String strColEndDate = null;
    public static String strColDuration = null;
    public static String strColCompletion = null;
    public static String strColCoordinator = null;
    public static String strColPredecessors = null;
    public static String strColID = null;
    public List titles = null;
    private Vector customColumns = null;
    private int nbCol;
    private int nbColTot = this.nbCol = 11;

    public GanttTreeTableModel(TreeNode root) {
        super(root);
        this.titles = new ArrayList();
        this.customColumns = new Vector();
        this.changeLanguage(language);
    }

    public void changeLanguage(GanttLanguage ganttLanguage) {
        strColType = language.getText("tableColType");
        strColPriority = language.getText("tableColPriority");
        strColInfo = language.getText("tableColInfo");
        strColName = language.getText("tableColName");
        strColBegDate = language.getText("tableColBegDate");
        strColEndDate = language.getText("tableColEndDate");
        strColDuration = language.getText("tableColDuration");
        strColCompletion = language.getText("tableColCompletion");
        strColCoordinator = language.getText("tableColCoordinator");
        strColPredecessors = language.getText("tableColPredecessors");
        strColID = language.getText("tableColID");
        this.titles.clear();
        String[] cols = new String[]{strColType, strColPriority, strColInfo, strColName, strColBegDate, strColEndDate, strColDuration, strColCompletion, strColCoordinator, strColPredecessors, strColID};
        for (int i = 0; i < cols.length; ++i) {
            this.titles.add(new String(cols[i]));
        }
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        parent.insert(newChild, index);
        int[] newIndexs = new int[]{index};
        this.nodesWereInserted(parent, newIndexs);
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(childIndex[0]);
        removedArray[0] = node;
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    public void addCustomColumn(String title) {
        this.customColumns.add(title);
        ++this.nbColTot;
    }

    public void deleteCustomColumn(String title) {
        this.customColumns.remove(title);
        this.columnRemoved(null);
        --this.nbColTot;
    }

    public void renameCustomColumn(String oldName, String newName) {
        this.customColumns.set(this.customColumns.indexOf(oldName), newName);
    }

    public int getColumnCount() {
        return this.nbCol;
    }

    public int getColumnCountTotal() {
        return this.nbColTot;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: 
            case 1: 
            case 2: {
                return Icon.class;
            }
            case 3: {
                return hierarchicalColumnClass;
            }
            case 4: 
            case 5: {
                return GregorianCalendar.class;
            }
            case 6: 
            case 7: {
                return Integer.class;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return Integer.class;
            }
        }
        TaskNode tn = (TaskNode)this.getRoot();
        Object o = this.getValueAt(tn, column);
        if (o == null) {
            o = "erreur";
            System.err.println("!!!!!!!!!!!!!!!!!");
        }
        return o.getClass();
    }

    public String getColumnName(int column) {
        if (column < this.titles.size()) {
            return (String)this.titles.get(column);
        }
        try {
            return (String)this.customColumns.get(column - this.titles.size());
        }
        catch (IndexOutOfBoundsException e) {
            return (String)this.customColumns.get(column - this.titles.size() - 1);
        }
    }

    public boolean isCellEditable(Object node, int column) {
        if (node instanceof TaskNode) {
            return column != 8 && column != 9 && column != 10 && column != 2;
        }
        return false;
    }

    public Object getValueAt(Object node, int column) {
        Object res = null;
        if (!(node instanceof TaskNode)) {
            return null;
        }
        TaskNode tn = (TaskNode)node;
        Task t = (Task)tn.getUserObject();
        switch (column) {
            case 0: {
                if (((Task)tn.getUserObject()).isProjectTask()) {
                    res = new ImageIcon(this.getClass().getResource("/icons/mproject.gif"));
                    break;
                }
                if (!tn.isLeaf()) {
                    res = new ImageIcon(this.getClass().getResource("/icons/mtask.gif"));
                    break;
                }
                if (t.isMilestone()) {
                    res = new ImageIcon(this.getClass().getResource("/icons/meeting.gif"));
                    break;
                }
                res = new ImageIcon(this.getClass().getResource("/icons/tasks2.png"));
                break;
            }
            case 1: {
                Task task = (Task)tn.getUserObject();
                String path = task.getPriority() == 0 ? "/icons/task1.gif" : (task.getPriority() == 1 ? "/icons/task.gif" : "/icons/task2.gif");
                res = new ImageIcon(this.getClass().getResource(path));
                break;
            }
            case 2: {
                TaskInfo info = t.getTaskInfo();
                if (info == null || !(info instanceof Delay)) break;
                int type = ((Delay)info).getType();
                if (type == 0) {
                    res = new ImageIcon(this.getClass().getResource("/icons/alert1_16.gif"));
                    break;
                }
                if (type != 1) break;
                res = new ImageIcon(this.getClass().getResource("/icons/alert2_16.gif"));
                break;
            }
            case 3: {
                res = tn.getName();
                break;
            }
            case 4: {
                res = tn.getStart();
                break;
            }
            case 5: {
                res = tn.getEnd();
                break;
            }
            case 6: {
                res = new Integer(tn.getDuration());
                break;
            }
            case 7: {
                res = new Integer(tn.getCompletionPercentage());
                break;
            }
            case 8: {
                ResourceAssignment[] tAssign = t.getAssignments();
                StringBuffer sb = new StringBuffer();
                int nb = 0;
                for (int i = 0; i < tAssign.length; ++i) {
                    ResourceAssignment resAss = tAssign[i];
                    if (!resAss.isCoordinator()) continue;
                    sb.append(nb++ == 0 ? "" : ", ").append(resAss.getResource().getName());
                }
                res = sb.toString();
                break;
            }
            case 9: {
                String resStr = "";
                TaskDependency[] dep = t.getDependenciesAsDependant().toArray();
                int i = 0;
                if (dep != null && dep.length > 0) {
                    for (i = 0; i < dep.length - 1; ++i) {
                        resStr = resStr + dep[i].getDependee().getTaskID() + ", ";
                    }
                    resStr = resStr + dep[i].getDependee().getTaskID() + "";
                }
                res = resStr;
                break;
            }
            case 10: {
                res = new Integer(t.getTaskID());
                break;
            }
            default: {
                String colName = this.getColumnName(column);
                res = t.getCustomValues().getValue(colName);
            }
        }
        return res;
    }

    public void setValueAt(final Object value, final Object node, final int column) {
        if (value == null) {
            return;
        }
        if (this.isCellEditable(node, column)) {
            Mediator.getGanttProjectSingleton().getUndoManager().undoableEdit("Change properties column", new Runnable(){

                public void run() {
                    GanttTreeTableModel.this.setValue(value, node, column);
                }
            });
        } else {
            this.setValue(value, node, column);
        }
        Mediator.getGanttProjectSingleton().repaint();
        Mediator.getGanttProjectSingleton().setAskForSave(true);
    }

    private void setValue(Object value, Object node, int column) {
        switch (column) {
            case 0: 
            case 1: 
            case 2: {
                ((TaskNode)node).setTaskInfo((TaskInfo)value);
            }
            case 8: {
                break;
            }
            case 3: {
                ((TaskNode)node).setName(value.toString());
                break;
            }
            case 4: {
                ((TaskNode)node).setStart((GanttCalendar)value);
                ((TaskNode)node).applyThirdDateConstraint();
                break;
            }
            case 5: {
                ((TaskNode)node).setEnd((GanttCalendar)value);
                break;
            }
            case 6: {
                Task task = (Task)((TaskNode)node).getUserObject();
                TaskLength tl = task.getDuration();
                ((TaskNode)node).setDuration(task.getManager().createLength(tl.getTimeUnit(), ((Integer)value).intValue()));
                break;
            }
            case 7: {
                ((TaskNode)node).setCompletionPercentage((Integer)value);
                break;
            }
            default: {
                try {
                    ((Task)((TaskNode)node).getUserObject()).getCustomValues().setValue(this.getColumnName(column), value);
                    break;
                }
                catch (CustomColumnsException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void columnAdded(TableColumnModelEvent arg0) {
        ++this.nbCol;
    }

    public void columnRemoved(TableColumnModelEvent arg0) {
        --this.nbCol;
    }

    public void columnMoved(TableColumnModelEvent arg0) {
    }

    public void columnMarginChanged(ChangeEvent arg0) {
    }

    public void columnSelectionChanged(ListSelectionEvent arg0) {
    }

    public Task[] getNestedTasks(Task container) {
        TaskNode r = (TaskNode)this.root;
        Enumeration<TreeNode> e = r.children();
        Vector<TaskNode> v = new Vector<TaskNode>();
        while (e.hasMoreElements()) {
            v.add((TaskNode)e.nextElement());
        }
        Task[] res = new Task[v.size()];
        v.toArray(res);
        return res;
    }

    public boolean hasNestedTasks(Task container) {
        TaskNode r = (TaskNode)this.root;
        return r.getChildCount() > 0;
    }

    public Task getRootTask() {
        return (Task)((TaskNode)this.getRoot()).getUserObject();
    }

    public TaskNode getTaskNodeForTask(Task task) {
        Enumeration<TreeNode> enumeration = ((TaskNode)this.getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            TaskNode tn;
            Task t;
            TreeNode next = enumeration.nextElement();
            if (!(next instanceof TaskNode) || !(t = (Task)(tn = (TaskNode)next).getUserObject()).equals(task)) continue;
            return tn;
        }
        return null;
    }

    public Task getContainer(Task nestedTask) {
        return null;
    }

    public void move(Task whatMove, Task whereMove) {
    }

    public boolean areUnrelated(Task dependant, Task dependee) {
        return false;
    }

    public int getDepth(Task task) {
        return 0;
    }

    public void languageChanged(GanttLanguage.Event event) {
        this.changeLanguage(event.getLanguage());
    }

    public int compareDocumentOrder(Task next, Task dependeeTask) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Task task) {
        throw new UnsupportedOperationException();
    }
}

