/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.macify.eawt;

import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;

public class DefaultApplication
implements Application {
    private Object application;
    private Class applicationListenerClass;
    Map listenerMap = Collections.synchronizedMap(new HashMap());
    private boolean enabledAboutMenu = true;
    private boolean enabledPreferencesMenu;
    private boolean aboutMenuItemPresent = true;
    private boolean preferencesMenuItemPresent;
    private ClassLoader classLoader;

    public DefaultApplication() {
        try {
            Object object;
            Class<?> clazz;
            File file = new File("/System/Library/Java");
            if (file.exists() && URLClassLoader.class.isAssignableFrom(clazz = (object = ClassLoader.getSystemClassLoader()).getClass())) {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke(object, file.toURL());
            }
            object = Class.forName("com.apple.eawt.Application");
            this.application = ((Class)object).getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
            this.applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.application = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    @Override
    public boolean isMac() {
        return this.application != null;
    }

    @Override
    public void addAboutMenuItem() {
        if (this.isMac()) {
            this.callMethod(this.application, "addAboutMenuItem");
        } else {
            this.aboutMenuItemPresent = true;
        }
    }

    @Override
    public void addApplicationListener(ApplicationListener applicationListener) {
        if (!Modifier.isPublic(applicationListener.getClass().getModifiers())) {
            throw new IllegalArgumentException("ApplicationListener must be a public class");
        }
        if (this.isMac()) {
            Object object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.applicationListenerClass}, (InvocationHandler)new ApplicationListenerInvocationHandler(applicationListener));
            this.callMethod(this.application, "addApplicationListener", new Class[]{this.applicationListenerClass}, new Object[]{object});
            this.listenerMap.put(applicationListener, object);
        } else {
            this.listenerMap.put(applicationListener, applicationListener);
        }
    }

    @Override
    public void addPreferencesMenuItem() {
        if (this.isMac()) {
            this.callMethod("addPreferencesMenuItem");
        } else {
            this.preferencesMenuItemPresent = true;
        }
    }

    @Override
    public boolean getEnabledAboutMenu() {
        if (this.isMac()) {
            return this.callMethod("getEnabledAboutMenu").equals(Boolean.TRUE);
        }
        return this.enabledAboutMenu;
    }

    @Override
    public boolean getEnabledPreferencesMenu() {
        if (this.isMac()) {
            Object object = this.callMethod("getEnabledPreferencesMenu");
            return object.equals(Boolean.TRUE);
        }
        return this.enabledPreferencesMenu;
    }

    @Override
    public Point getMouseLocationOnScreen() {
        if (this.isMac()) {
            try {
                Method method = this.application.getClass().getMethod("getMouseLocationOnScreen", new Class[0]);
                return (Point)method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        return new Point(0, 0);
    }

    @Override
    public boolean isAboutMenuItemPresent() {
        if (this.isMac()) {
            return this.callMethod("isAboutMenuItemPresent").equals(Boolean.TRUE);
        }
        return this.aboutMenuItemPresent;
    }

    @Override
    public boolean isPreferencesMenuItemPresent() {
        if (this.isMac()) {
            return this.callMethod("isPreferencesMenuItemPresent").equals(Boolean.TRUE);
        }
        return this.preferencesMenuItemPresent;
    }

    @Override
    public void removeAboutMenuItem() {
        if (this.isMac()) {
            this.callMethod("removeAboutMenuItem");
        } else {
            this.aboutMenuItemPresent = false;
        }
    }

    @Override
    public synchronized void removeApplicationListener(ApplicationListener applicationListener) {
        if (this.isMac()) {
            Object v = this.listenerMap.get(applicationListener);
            this.callMethod(this.application, "removeApplicationListener", new Class[]{this.applicationListenerClass}, new Object[]{v});
        }
        this.listenerMap.remove(applicationListener);
    }

    @Override
    public void removePreferencesMenuItem() {
        if (this.isMac()) {
            this.callMethod("removeAboutMenuItem");
        } else {
            this.preferencesMenuItemPresent = false;
        }
    }

    @Override
    public void setEnabledAboutMenu(boolean bl) {
        if (this.isMac()) {
            this.callMethod(this.application, "setEnabledAboutMenu", new Class[]{Boolean.TYPE}, new Object[]{bl});
        } else {
            this.enabledAboutMenu = bl;
        }
    }

    @Override
    public void setEnabledPreferencesMenu(boolean bl) {
        if (this.isMac()) {
            this.callMethod(this.application, "setEnabledPreferencesMenu", new Class[]{Boolean.TYPE}, new Object[]{bl});
        } else {
            this.enabledPreferencesMenu = bl;
        }
    }

    @Override
    public int requestUserAttention(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Requested user attention type is not allowed: " + n);
        }
        try {
            Object object = this.getNSApplication();
            Field field = object.getClass().getField("UserAttentionRequestCritical");
            Field field2 = object.getClass().getField("UserAttentionRequestInformational");
            Field field3 = n == 1 ? field : field2;
            return (Integer)object.getClass().getMethod("requestUserAttention", Integer.TYPE).invoke(object, field3.get(null));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return -1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
    }

    @Override
    public void cancelUserAttentionRequest(int n) {
        try {
            Object object = this.getNSApplication();
            object.getClass().getMethod("cancelUserAttentionRequest", Integer.TYPE).invoke(object, new Integer(n));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    private Object getNSApplication() throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName("com.apple.cocoa.application.NSApplication");
            return clazz.getMethod("sharedApplication", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    @Override
    public void setApplicationIconImage(BufferedImage bufferedImage) {
        if (this.isMac()) {
            try {
                Method method = this.application.getClass().getMethod("setDockIconImage", Image.class);
                try {
                    method.invoke(this.application, bufferedImage);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                try {
                    Class<?> clazz = Class.forName("com.apple.cocoa.foundation.NSData");
                    Constructor<?> constructor = clazz.getConstructor(new byte[0].getClass());
                    Object obj = constructor.newInstance(new Object[]{byteArrayOutputStream.toByteArray()});
                    Class<?> clazz2 = Class.forName("com.apple.cocoa.application.NSImage");
                    Object obj2 = clazz2.getConstructor(clazz).newInstance(obj);
                    Object object = this.getNSApplication();
                    object.getClass().getMethod("setApplicationIconImage", clazz2).invoke(object, obj2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new RuntimeException(noSuchMethodException2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException);
                }
            }
        }
    }

    @Override
    public BufferedImage getApplicationIconImage() {
        if (this.isMac()) {
            try {
                Method method = this.application.getClass().getMethod("getDockIconImage", new Class[0]);
                try {
                    return (BufferedImage)method.invoke(this.application, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Class<?> clazz = Class.forName("com.apple.cocoa.foundation.NSData");
                    Class<?> clazz2 = Class.forName("com.apple.cocoa.application.NSImage");
                    Object object = this.getNSApplication();
                    Object object2 = object.getClass().getMethod("applicationIconImage", new Class[0]).invoke(object, new Object[0]);
                    Object object3 = clazz2.getMethod("TIFFRepresentation", new Class[0]).invoke(object2, new Object[0]);
                    Integer n = (Integer)clazz.getMethod("length", new Class[0]).invoke(object3, new Object[0]);
                    byte[] byArray = (byte[])clazz.getMethod("bytes", Integer.TYPE, Integer.TYPE).invoke(object3, 0, n);
                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                    return bufferedImage;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new RuntimeException(noSuchMethodException2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
        return null;
    }

    private Object callMethod(String string) {
        return this.callMethod(this.application, string, new Class[0], new Object[0]);
    }

    private Object callMethod(Object object, String string) {
        return this.callMethod(object, string, new Class[0], new Object[0]);
    }

    private Object callMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        try {
            if (classArray == null) {
                classArray = new Class[objectArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray[i] = objectArray[i].getClass();
                }
            }
            Method method = object.getClass().getMethod(string, classArray);
            return method.invoke(object, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    private ApplicationEvent createApplicationEvent(final Object object) {
        return (ApplicationEvent)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ApplicationEvent.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object object2, Method method, Object[] objectArray) throws Throwable {
                return object.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(object, objectArray);
            }
        });
    }

    class ApplicationListenerInvocationHandler
    implements InvocationHandler {
        private ApplicationListener applicationListener;

        ApplicationListenerInvocationHandler(ApplicationListener applicationListener) {
            this.applicationListener = applicationListener;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            ApplicationEvent applicationEvent = DefaultApplication.this.createApplicationEvent(objectArray[0]);
            try {
                Method method2 = this.applicationListener.getClass().getMethod(method.getName(), ApplicationEvent.class);
                return method2.invoke((Object)this.applicationListener, applicationEvent);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (method.getName().equals("equals") && objectArray.length == 1) {
                    return object == objectArray[0];
                }
                return null;
            }
        }
    }
}

