/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.web;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTaskPanel;
import org.makagiga.commons.UI;
import org.makagiga.web.WebDialog;
import org.makagiga.web.WebException;
import org.makagiga.web.WebProperties;
import org.makagiga.web.WebResult;
import org.makagiga.web.WebService;

public class WebPanel<W extends WebService>
extends MTaskPanel<WebResult> {
    private JComponent currentServiceComponent;
    private final MComboBox<W> services;
    private final WebProperties webProperties;
    private WebResult webResult;

    public WebPanel(WebProperties webProperties, W ... WArray) {
        this.webProperties = webProperties;
        MPanel mPanel = MPanel.createBorderPanel(5);
        this.services = new MComboBox();
        this.services.addAllItems(WArray);
        mPanel.addNorth(MPanel.createHLabelPanel(this.services, UI._("Services:")));
        this.setFrontComponent(mPanel);
        this.setFrontVisible(false, false);
        this.setFrontVisible(true, false);
        this.updateServiceComponent(this.getSelectedService());
        this.services.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebPanel.this.updateServiceComponent(WebPanel.this.getSelectedService());
            }
        });
    }

    public W getSelectedService() {
        return (W)((WebService)this.services.getSelectedItem());
    }

    public WebResult getWebResult() {
        return this.webResult;
    }

    public void showDialog(Window window, String string, Icon icon) {
        WebDialog webDialog = new WebDialog(window, string, icon, this);
        webDialog.packFixed();
        Component component = this.getFrontComponent();
        webDialog.exec(component instanceof JComponent ? (JComponent)component : this);
    }

    public void submit() throws WebException {
        W w = this.getSelectedService();
        MLogger.debug("web", "Using \"%s\" service", w);
        MLogger.debug("web", "Updating properties...");
        ((WebService)w).updateWebProperties(this.webProperties);
        this.services.setEnabled(false);
        this.start();
    }

    @Override
    protected WebResult doInBackground() throws Exception {
        MLogger.debug("web", "Submit...");
        this.webResult = null;
        W w = this.getSelectedService();
        ((WebService)w).setActive(true);
        return ((WebService)w).submit(this.webProperties);
    }

    @Override
    protected void done() {
        this.services.setEnabled(true);
        W w = this.getSelectedService();
        ((WebService)w).setActive(false);
        if (!this.isCancelled()) {
            try {
                this.webResult = (WebResult)this.getResult();
                MLogger.debug("web", "Submit result: \"%s\"", this.webResult.getValue());
                this.webResult.component = ((WebService)w).createResultComponent(this.webProperties);
                if (this.webResult.component != null) {
                    MDialog mDialog = new MDialog(this.getWindowAncestor(), UI._("Result"), "ui/info", 36);
                    mDialog.addCenter(this.webResult.component);
                    mDialog.packFixed();
                    mDialog.exec(this.webResult.component);
                } else {
                    MLogger.debug("web", "No result component");
                }
            }
            catch (Exception exception) {
                MMessage.error(this.getWindowAncestor(), exception);
            }
        }
    }

    protected void updateServiceComponent(W w) {
        JComponent jComponent = ((WebService)w).createMainComponent(this.webProperties);
        if (jComponent == this.currentServiceComponent) {
            return;
        }
        MLogger.debug("web", "Updating service component: \"%s\"", w);
        MPanel mPanel = (MPanel)this.getFrontComponent();
        UI.replaceComponent(mPanel, this.currentServiceComponent, jComponent, "Center", true);
        this.currentServiceComponent = jComponent;
        if (jComponent instanceof MPanel) {
            ((MPanel)MPanel.class.cast(jComponent)).alignLabels();
        }
    }
}

