/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree.formats;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.makagiga.commons.MDate;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLHelper;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tree.formats.IncollectorExport;

@XmlRootElement(name="data")
public final class Incollector {
    private List<Entry> entries;

    public void addEntry(Entry entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<Entry>();
        }
        this.entries.add(entry);
    }

    public void export(OutputStream outputStream) throws JAXBException {
        XMLHelper.marshal((Object)new IncollectorExport(this), outputStream);
    }

    public void export(String string) throws FileNotFoundException, JAXBException {
        XMLHelper.marshal((Object)new IncollectorExport(this), string);
    }

    @XmlElement(name="entry")
    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public static Incollector load(InputStream inputStream) throws JAXBException {
        return XMLHelper.unmarshal(Incollector.class, inputStream);
    }

    public static Incollector load(String string) throws FileNotFoundException, JAXBException {
        return XMLHelper.unmarshal(Incollector.class, string);
    }

    public void save(OutputStream outputStream) throws JAXBException {
        XMLHelper.marshal((Object)this, outputStream);
    }

    public void save(String string) throws FileNotFoundException, JAXBException {
        XMLHelper.marshal((Object)this, string);
    }

    public static final class Word
    implements Data {
        private String language;
        private String text;
        private String word;

        @XmlAttribute(name="language")
        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String string) {
            this.language = string;
        }

        @Override
        @XmlValue
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String string) {
            this.text = string;
        }

        @XmlAttribute(name="word")
        public String getWord() {
            return this.word;
        }

        public void setWord(String string) {
            this.word = string;
        }

        public String toString() {
            return this.language + "\n" + "\n" + "\t" + this.word + "\n" + "\n" + "\t" + this.text;
        }
    }

    public static final class WebAddress
    implements Data {
        private String name;
        private String text;

        @XmlAttribute(name="name")
        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        @Override
        @XmlValue
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String string) {
            this.text = string;
        }

        public String toString() {
            if (TK.isEmpty(this.name)) {
                return TK.isEmpty(this.text) ? UI._("No Title") : this.text;
            }
            return this.name + " - " + this.text;
        }
    }

    public static final class SourceCode
    implements Data {
        private String language;
        private String text;

        @XmlAttribute(name="language")
        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String string) {
            this.language = string;
        }

        @Override
        @XmlValue
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String string) {
            this.text = string;
        }

        public String toString() {
            return this.text;
        }
    }

    public static final class Serial
    implements Data {
        private String application;
        private String text;

        @XmlAttribute(name="application")
        public String getApplication() {
            return this.application;
        }

        public void setApplication(String string) {
            this.application = string;
        }

        @Override
        @XmlValue
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String string) {
            this.text = string;
        }

        public String toString() {
            return "\n\t" + this.application + "\n" + "\n" + "\t" + this.text;
        }
    }

    public static final class Quote
    implements Data {
        private String author;
        private String text;

        @XmlAttribute(name="author")
        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String string) {
            this.author = string;
        }

        @Override
        @XmlValue
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String string) {
            this.text = string;
        }

        public String toString() {
            return "\n" + this.text + "\n" + "\n" + "\t-- " + this.author;
        }
    }

    public static final class Note
    implements Data {
        private String text;
        private String title;

        public Note() {
        }

        public Note(String string, String string2) {
            this.title = string;
            this.text = string2;
        }

        @Override
        @XmlValue
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String string) {
            this.text = string;
        }

        @XmlAttribute(name="title")
        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public String toString() {
            return this.text;
        }
    }

    public static final class Entry {
        private Conversation conversation;
        private Data data;
        private int rating;
        private Note note;
        private Quote quote;
        private Serial serial;
        private SourceCode sourceCode;
        private String author;
        private String comment;
        private String date;
        private String tags = "";
        private String version = "1";
        private Type type;
        private WebAddress webAddress;
        private Word word;

        @XmlAttribute(name="author")
        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String string) {
            this.author = string;
        }

        @XmlElement(name="comment")
        public String getComment() {
            return this.comment;
        }

        public void setComment(String string) {
            this.comment = string;
        }

        @XmlElement(name="conversation")
        public Conversation getConversation() {
            return this.conversation;
        }

        public void setConversation(Conversation conversation) {
            this.data = conversation;
            this.conversation = conversation;
        }

        @XmlTransient
        public Data getData() {
            return this.data;
        }

        public void setData(Data data) {
            this.data = data;
        }

        @XmlAttribute(name="date")
        public String getDate() {
            return this.date;
        }

        public void setDate(String string) {
            this.date = string;
        }

        @XmlElement(name="note")
        public Note getNote() {
            return this.note;
        }

        public void setNote(Note note) {
            this.data = note;
            this.note = note;
        }

        @XmlElement(name="quote")
        public Quote getQuote() {
            return this.quote;
        }

        public void setQuote(Quote quote) {
            this.data = quote;
            this.quote = quote;
        }

        @XmlAttribute(name="rating")
        public int getRating() {
            return this.rating;
        }

        public void setRating(int n) {
            this.rating = n;
        }

        @XmlElement(name="serial")
        public Serial getSerial() {
            return this.serial;
        }

        public void setSerial(Serial serial) {
            this.data = serial;
            this.serial = serial;
        }

        @XmlElement(name="sourcecode")
        public SourceCode getSourceCode() {
            return this.sourceCode;
        }

        public void setSourceCode(SourceCode sourceCode) {
            this.data = sourceCode;
            this.sourceCode = sourceCode;
        }

        @XmlAttribute(name="tags")
        public String getTags() {
            return this.tags;
        }

        public void setTags(String string) {
            this.tags = string;
        }

        @XmlAttribute(name="version")
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        @XmlElement(name="webaddress")
        public WebAddress getWebAddress() {
            return this.webAddress;
        }

        public void setWebAddress(WebAddress webAddress) {
            this.data = webAddress;
            this.webAddress = webAddress;
        }

        @XmlElement(name="word")
        public Word getWord() {
            return this.word;
        }

        public void setWord(Word word) {
            this.data = word;
            this.word = word;
        }

        public Type getType() {
            if (this.type != null) {
                return this.type;
            }
            this.type = this.conversation != null ? Type.CONVERSATION : (this.note != null ? Type.NOTE : (this.quote != null ? Type.QUOTE : (this.serial != null ? Type.SERIAL : (this.sourceCode != null ? Type.SOURCE_CODE : (this.webAddress != null ? Type.WEB_ADDRESS : (this.word != null ? Type.WORD : Type.UNKNOWN))))));
            return this.type;
        }

        public void setMetaInfo(MetaInfo metaInfo) {
            MDate mDate = new MDate(metaInfo.getFile().lastModified());
            this.date = mDate.isValid() ? mDate.format("yyyy-MM-dd") : null;
            float f = metaInfo.getRating();
            this.rating = f <= 0.0f ? 0 : (f <= 0.2f ? 1 : (f <= 0.6f ? 2 : (f <= 1.0f ? 3 : 0)));
            String string = metaInfo.getTags();
            this.tags = TK.isEmpty(string) ? "" : string.replace(' ', ',');
            this.comment = metaInfo.getComment();
        }

        public MDate toMakagigaDate() {
            MDate mDate = MDate.parse(this.date, "yyyy-MM-dd", null);
            return mDate == null ? MDate.invalid() : mDate;
        }

        public float toMakagigaRating() {
            switch (this.rating) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return 0.2f;
                }
                case 2: {
                    return 0.6f;
                }
                case 3: {
                    return 1.0f;
                }
            }
            return 0.0f;
        }

        public String toMakagigaTags() {
            if (this.tags == null) {
                return "";
            }
            return this.tags.replace(' ', '_').replace(',', ' ');
        }

        public String toString() {
            if (this.data == null) {
                return "";
            }
            String string = this.data.toString();
            return string == null ? "" : string;
        }

        public static enum Type {
            CONVERSATION(UI._("Conversation")),
            NOTE(UI._("Note")),
            QUOTE(UI._("Quote")),
            SERIAL(UI._("Serial Number")),
            SOURCE_CODE(UI._("Source Code")),
            WEB_ADDRESS(UI._("Web Address")),
            WORD(UI._("Word")),
            UNKNOWN(UI._("Unknown"));

            private String text;

            private Type(String string2) {
                this.text = string2;
            }

            public String toString() {
                return this.text;
            }
        }
    }

    public static interface Data {
        public String getText();

        public void setText(String var1);
    }

    public static final class Conversation
    implements Data {
        private String text;
        private String title;

        @Override
        @XmlValue
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String string) {
            this.text = string;
        }

        @XmlAttribute(name="title")
        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public String toString() {
            return "\n\t" + this.title + "\n" + "\n" + this.text;
        }
    }
}

