/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import java.awt.Component;
import java.awt.Window;
import java.util.Set;
import javax.swing.AbstractButton;
import org.makagiga.MainWindow;
import org.makagiga.Vars;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MToggleButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.transition.TransitionPanel;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tags.Tags;
import org.makagiga.tree.AdvancedProperties;

public final class NewFolderDialog
extends MDialog {
    private final AdvancedProperties advancedProperties;
    private MTextField name;
    private String folderName;
    private static String lastName;
    private final TransitionPanel transitionPanel;

    public NewFolderDialog(MetaInfo metaInfo) {
        super((Window)MainWindow.getInstance(), MActionInfo.NEW_FOLDER, 7);
        this.changeButton((AbstractButton)this.getOKButton(), UI._("Create"));
        MToggleButton mToggleButton = new MToggleButton(UI._("Advanced")){

            @Override
            protected void onClick() {
                NewFolderDialog newFolderDialog = (NewFolderDialog)this.getWindowAncestor();
                newFolderDialog.transitionPanel.showNextCard();
            }
        };
        this.getButtonsPanel().add(mToggleButton);
        if (!((Boolean)Vars.newFolderShowAdvanced.get()).booleanValue()) {
            mToggleButton.setVisible(false);
        }
        this.advancedProperties = new AdvancedProperties(metaInfo, null);
        this.transitionPanel = new TransitionPanel();
        this.transitionPanel.add((Component)this.createGeneralTab(), "general");
        this.transitionPanel.add((Component)this.advancedProperties, "advanced");
        this.addCenter(this.transitionPanel);
        this.installValidatorMessage();
        this.packFixed(UI.WindowSize.MEDIUM);
    }

    @Override
    public boolean exec() {
        return this.exec(this.name);
    }

    public AdvancedProperties getAdvancedProperties() {
        return this.advancedProperties;
    }

    public String getFolderName() {
        return this.folderName;
    }

    @Deprecated
    public Tags getTags() {
        return new Tags();
    }

    @Override
    protected boolean onAccept() {
        this.name.saveAutoCompletion();
        lastName = this.folderName = this.name.isEmpty() ? null : this.name.getText();
        return true;
    }

    private MPanel createGeneralTab() {
        MPanel mPanel = MPanel.createVBoxPanel();
        if (lastName == null) {
            lastName = UI._("New Folder");
        }
        this.name = new MTextField(lastName);
        this.name.setAutoCompletion("rename");
        this.getValidatorSupport().add(new FolderNameValidator(this.name));
        MPanel mPanel2 = MPanel.createHLabelPanel(this.name, UI._("Name:"));
        mPanel2.limitHeight(this.name);
        mPanel.add(mPanel2);
        mPanel.addStretch();
        return mPanel;
    }

    private static final class FolderNameValidator
    extends FSHelper.NameValidator {
        private final Set<String> winDev = TK.newHashSet("AUX", "CON", "NUL", "PRN", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");

        private FolderNameValidator(MTextField mTextField) {
            super(mTextField);
        }

        @Override
        protected boolean isValid() throws Exception {
            if (!super.isValid()) {
                return false;
            }
            String string = this.getText().trim();
            FSHelper.checkName(string);
            String string2 = TK.toUpperCase(string);
            if (this.winDev.contains(string2)) {
                throw new Exception(UI._("This file name is reserved: {0}", string2));
            }
            return true;
        }
    }
}

