/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.presentation;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JButton;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MTimeline;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MWindow;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.pushingpixels.trident.TimelinePropertyBuilder;

public final class ControlPanel
extends MWindow
implements AWTEventListener {
    private final MTimer autohideTimer;
    private MTimeline<ControlPanel> hideAnimation;
    private final MToolBar toolBar;
    private final Rectangle area = new Rectangle();
    private TimelinePropertyBuilder<Integer> animationYProperty;

    public ControlPanel() {
        this.setAlwaysOnTop(true);
        this.toolBar = new MToolBar();
        this.toolBar.setBorder(null);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.addCenter(this.toolBar);
        this.hideAnimation = new MTimeline<ControlPanel>(this, 500L);
        this.hideAnimation.addPropertyToInterpolate("visible", (ControlPanel)((Object)Boolean.valueOf(true)), (ControlPanel)((Object)Boolean.valueOf(false)));
        this.autohideTimer = new MTimer(2500){

            @Override
            protected boolean onTimeout() {
                ControlPanel.this.hideAnimation.setEnabled(true);
                ControlPanel.this.hideAnimation.play();
                return false;
            }
        };
        this.autohideTimer.start();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
    }

    public JButton addAction(Action action) {
        return this.addAction(action, 0);
    }

    public JButton addAction(Action action, int n) {
        return this.toolBar.add(action, n);
    }

    public void addLabel(MLabel mLabel) {
        this.toolBar.add(mLabel);
    }

    public void addSeparator() {
        this.toolBar.addSeparator();
    }

    @Override
    public void dispose() {
        super.dispose();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.animationYProperty = null;
        this.autohideTimer.stop();
        this.hideAnimation = TK.dispose(this.hideAnimation);
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Point point = mouseEvent.getLocationOnScreen();
            if (point.y >= this.area.y && point.y <= this.area.y + this.area.height) {
                this.doShow(false);
            } else if (this.isVisible()) {
                this.autohideTimer.restart();
            }
        }
    }

    @Override
    public void showAtPosition(UI.VerticalPosition verticalPosition, UI.HorizontalPosition horizontalPosition) {
        super.showAtPosition(verticalPosition, horizontalPosition);
        this.area.setBounds(this.getBounds());
        if (this.animationYProperty == null) {
            int n = this.getVerticalPosition() == UI.VerticalPosition.TOP ? -this.getHeight() : UI.getScreenSize().height;
            this.animationYProperty = MTimeline.property("y").from(this.getY()).to(n).getWith(new TimelinePropertyBuilder.PropertyGetter<Integer>(){

                @Override
                public Integer get(Object object, String string) {
                    return ((ControlPanel)ControlPanel.class.cast(object)).getY();
                }
            }).setWith(new TimelinePropertyBuilder.PropertySetter<Integer>(){

                @Override
                public void set(Object object, String string, Integer n) {
                    ControlPanel controlPanel = (ControlPanel)object;
                    controlPanel.setLocation(controlPanel.getX(), n);
                }
            });
            this.hideAnimation.addPropertyToInterpolate(this.animationYProperty);
        }
    }

    protected void doShow(boolean bl) {
        if (bl) {
            this.autohideTimer.restart();
        } else {
            this.autohideTimer.stop();
        }
        this.showAtPosition(this.getVerticalPosition(), this.getHorizontalPosition());
        this.hideAnimation.setEnabled(false);
        this.hideAnimation.abort();
    }

    protected void forceRepaint() {
        this.toolBar.paintImmediately(this.toolBar.getBounds());
    }

    void readConfig(String string) {
        this.toolBar.readConfig(string);
    }
}

