/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.deleteprivatedata;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.makagiga.Tabs;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MCheckBoxTable;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.Tuple;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;
import org.makagiga.commons.crypto.MasterKey;
import org.makagiga.console.Console;
import org.makagiga.feeds.archive.Archive;
import org.makagiga.form.PropertyPanel;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.trash.TrashFS;
import org.makagiga.fs.tree.TreeFS;
import org.makagiga.plugins.AbstractPlugin;
import org.makagiga.plugins.PluginAction;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.tools.SessionManager;
import org.makagiga.tree.Tree;
import org.makagiga.tree.version.VersionControl;
import org.makagiga.tree.version.VersionException;
import org.makagiga.tree.version.VersionInfo;

public final class DeletePrivateDataPlugin
extends AbstractPlugin<Object>
implements PluginMenu {
    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if ("TOOLS_MENU".equals(string)) {
            mMenu.add(new PluginAction(this.getInfo()){

                @Override
                public void onAction() {
                    DeletePrivateDataPlugin.this.clear(this.getSourceWindow());
                }
            });
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
    }

    private void clear(Window window) {
        BooleanProperty booleanProperty = new BooleanProperty(true);
        BooleanProperty booleanProperty2 = new BooleanProperty(true);
        BooleanProperty booleanProperty3 = new BooleanProperty();
        BooleanProperty booleanProperty4 = new BooleanProperty(true);
        BooleanProperty booleanProperty5 = new BooleanProperty(true);
        BooleanProperty booleanProperty6 = new BooleanProperty();
        AbstractFS abstractFS = Tree.getInstance().getFS("trash");
        TrashFS trashFS = abstractFS instanceof TrashFS ? (TrashFS)abstractFS : null;
        Config config = Config.getDefault();
        config.readProperty(this.getGlobalEntry("clearClipboard"), booleanProperty3);
        config.readProperty(this.getGlobalEntry("deleteCache"), booleanProperty2);
        config.readProperty(this.getGlobalEntry("deleteHistory"), booleanProperty);
        config.readProperty(this.getGlobalEntry("deleteLogs"), booleanProperty4);
        config.readProperty(this.getGlobalEntry("emptyTrash"), booleanProperty5);
        MDialog mDialog = new MDialog(window, this.getName(), "ui/delete");
        PropertyPanel propertyPanel = new PropertyPanel();
        propertyPanel.setAutoUpdateModel(false);
        String string = FS.getProfile();
        string = string != null ? UI._("Profile: {0}", string) : UI._("Default Profile");
        propertyPanel.add(MLabel.createSmall(string, null));
        propertyPanel.addContentGap();
        propertyPanel.bind(booleanProperty2, UI._("Delete Cache and Thumbnails"));
        propertyPanel.bind(booleanProperty, UI._("Delete Text Auto Completion History"));
        propertyPanel.bind(booleanProperty4, UI._("Delete Logs"));
        propertyPanel.addContentGap();
        if (trashFS != null) {
            propertyPanel.bind(booleanProperty5, UI._("Empty Trash Bin")).setEnabled(!trashFS.isTrashEmpty());
        }
        propertyPanel.addSeparator(UI._("Advanced"));
        propertyPanel.bind(booleanProperty3, UI._("Clear Clipboard"));
        MCheckBox mCheckBox = (MCheckBox)propertyPanel.bind(booleanProperty6, UI._("Delete RSS Feeds Archive"));
        mCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MCheckBox mCheckBox = (MCheckBox)actionEvent.getSource();
                if (mCheckBox.isSelected() && !MMessage.confirm(UI.windowFor(mCheckBox), UI._("Note that this will delete all meta info (comment, tags, etc) associated with feed articles."))) {
                    mCheckBox.setSelected(false);
                }
            }
        });
        propertyPanel.addContentGap();
        propertyPanel.add(new MButton(UI._("Delete Previous Document Versions")){

            @Override
            protected void onClick() {
                DeletePrivateDataPlugin.this.deletePreviousFileVersions(this.getWindowAncestor());
            }
        });
        mDialog.addCenter(propertyPanel);
        mDialog.packFixed();
        if (mDialog.exec()) {
            propertyPanel.updateModel();
            Tabs tabs = Tabs.getInstance();
            tabs.deletePrivateData();
            if (((Boolean)booleanProperty.get()).booleanValue()) {
                AutoCompletion.deletePrivateData();
            }
            if (((Boolean)booleanProperty2.get()).booleanValue()) {
                FileCache.getInstance().clear();
            }
            if (((Boolean)booleanProperty3.get()).booleanValue()) {
                try {
                    MClipboard.clear();
                }
                catch (ClipboardException clipboardException) {
                    MMessage.error(null, clipboardException);
                }
                MClipboard.clearHistory();
            }
            if (((Boolean)booleanProperty6.get()).booleanValue()) {
                Archive.getInstance().clear();
            }
            if (((Boolean)booleanProperty4.get()).booleanValue()) {
                MApplication.getLogFile().clear();
                if (Console.isInstance()) {
                    Console.getInstance().getOutput().setText(null);
                }
            }
            if (((Boolean)booleanProperty5.get()).booleanValue() && trashFS != null) {
                trashFS.emptyTrash();
            }
            MFileChooser.deletePrivateData();
            SessionManager.deletePrivateData();
            MasterKey.deletePrivateData();
            config.removeString("User.name");
            MURLButton.deletePrivateData();
            config.removeString("NewFile.lastName");
            config.removeString("NewFolder.lastName");
            config.write(this.getGlobalEntry("clearClipboard"), booleanProperty3);
            config.write(this.getGlobalEntry("deleteCache"), booleanProperty2);
            config.write(this.getGlobalEntry("deleteHistory"), booleanProperty);
            config.write(this.getGlobalEntry("deleteLogs"), booleanProperty4);
            config.write(this.getGlobalEntry("emptyTrash"), booleanProperty5);
            config.sync();
        }
    }

    private void deletePreviousFileVersions(Window window) {
        final MArrayList mArrayList = MArrayList.create();
        new Tree.Scanner(TreeFS.getInstance()){

            @Override
            public void processItem(MetaInfo metaInfo) {
                try {
                    if (metaInfo.isFile()) {
                        for (VersionInfo versionInfo : VersionControl.getAllVersions(metaInfo)) {
                            mArrayList.add(Tuple.of(metaInfo, versionInfo));
                        }
                    }
                }
                catch (VersionException versionException) {
                    MLogger.exception(versionException);
                }
            }
        };
        MCheckBoxTable mCheckBoxTable = new MCheckBoxTable(UI._("Delete"), UI._("Version"), false, mArrayList);
        MDialog mDialog = mCheckBoxTable.createDialog(window, UI._("Confirm"), UI._("Delete Previous Document Versions"), MActionInfo.DELETE);
        if (!mDialog.exec()) {
            return;
        }
        for (MCheckBoxTable.CheckBoxItem checkBoxItem : (MCheckBoxTable.CheckBoxModel)mCheckBoxTable.getModel()) {
            if (!checkBoxItem.isSelected()) continue;
            try {
                MetaInfo metaInfo = (MetaInfo)((Tuple.Two)checkBoxItem.getValue()).get1();
                VersionControl.deleteAllVersions(metaInfo, true);
            }
            catch (VersionException versionException) {
                MMessage.error(window, versionException);
                break;
            }
        }
    }
}

