/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.awt.Color;
import javax.swing.Icon;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.UI;

public enum TaskState {
    OVERDUE(UI._("Overdue"), MHighlighter.WARNING_COLOR, "ui/error", true),
    TODAY(UI._("Today"), MHighlighter.DEFAULT_COLOR, "ui/warning", true),
    TOMORROW(UI._("Tomorrow"), MColor.getBrighter(MHighlighter.DEFAULT_COLOR, 50), "ui/warning", true),
    LATER(UI._("Later"), MHighlighter.OK_COLOR, "ui/next", false),
    UNKNOWN(UI._("No Date/Time"), null, "ui/misc", false);

    private final boolean important;
    private final Color color;
    private static final Color UNKNOWN_COLOR;
    private final String iconName;
    private final String text;

    public Color getColor() {
        return this.color;
    }

    public Color getColorForPaint() {
        return this.color == null ? UNKNOWN_COLOR : this.color;
    }

    public Icon getIcon() {
        return MIcon.stock(this.iconName);
    }

    public Icon getMediumIcon() {
        return MIcon.medium(this.iconName);
    }

    public Icon getSmallIcon() {
        return MIcon.small(this.iconName);
    }

    public boolean isImportant() {
        return this.important;
    }

    public MActionInfo toActionInfo() {
        return new MActionInfo(this.text, this.iconName);
    }

    public String toString() {
        return this.text;
    }

    private TaskState(String string2, Color color, String string3, boolean bl) {
        this.color = color;
        this.text = string2;
        this.iconName = string3;
        this.important = bl;
    }

    static {
        UNKNOWN_COLOR = MColor.SKY_BLUE.getBrighter(50);
    }
}

