/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.GroupLayout;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLayout;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTable;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;
import org.makagiga.commons.category.Category;
import org.makagiga.commons.category.CategoryAction;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskTable;

public class TaskPanel<T extends TaskTable>
extends MPanel
implements Focusable,
Lockable,
MDisposable {
    protected MTextField newTaskTextField;
    private MSearchPanel filterPanel;
    private MSmallButton addTaskButton;
    private final WeakReference<T> taskTableRef;

    public TaskPanel(T t) {
        super(true);
        this.taskTableRef = new WeakReference<T>(t);
        this.setMargin(2);
        this.newTaskTextField = new MTextField();
        this.newTaskTextField.setAutoCompletion("newtask");
        this.newTaskTextField.setPromptText(UI._("Enter a task Summary"));
        AutoCompletion autoCompletion = this.newTaskTextField.getAutoCompletion();
        autoCompletion.setMode(AutoCompletion.Mode.ANY_TEXT);
        this.newTaskTextField.setEnterPressAction(new MAction(){

            @Override
            public void onAction() {
                TaskPanel.this.doAddTask();
            }
        });
        this.addTaskButton = new MSmallButton(MIcon.small("ui/ok"), UI._("Add task to the list")){

            @Override
            protected void onClick() {
                TaskPanel.this.doAddTask();
            }
        };
        this.filterPanel = new MSearchPanel(true, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                String string = this.getText();
                Object t = TaskPanel.this.getTaskTable();
                ((TaskTable)t).filterTasks(string);
                if (TK.isEmpty(string)) {
                    this.setState(MTextFieldPanel.State.NORMAL);
                    int n = ((JTable)t).getSelectedRow();
                    if (n != -1) {
                        ((MTable)t).scrollToRow(n);
                    }
                } else if (((MTable)t).isEmpty(MV.VIEW)) {
                    this.setState(MTextFieldPanel.State.ERROR);
                } else {
                    this.setState(MTextFieldPanel.State.OK);
                }
            }

            @Override
            protected MMenu onPopupMenu() {
                return TaskPanel.this.createCategoryFilterMenu();
            }
        };
        this.filterPanel.getMenuButton().setVisible(true);
        this.filterPanel.getTextField().setToolTipText(UI._("Filter Tasks by Summary or Date/Time"));
        MLayout mLayout = this.getGroupLayout();
        mLayout.setDefaultVerticalAlignment(GroupLayout.Alignment.CENTER);
        mLayout.addGap().addComponent((Component)this.newTaskTextField, UI._("Add:")).addComponent(this.addTaskButton).addComponent(this.filterPanel);
    }

    public MSearchPanel getFilterPanel() {
        return this.filterPanel;
    }

    public T getTaskTable() {
        return (T)((TaskTable)this.taskTableRef.get());
    }

    public void setFilter(String string) {
        this.filterPanel.setText(string);
    }

    @Override
    public void focus() {
        this.newTaskTextField.requestFocusInWindow();
    }

    @Override
    public boolean isLocked() {
        return !this.newTaskTextField.isEditable();
    }

    @Override
    public void setLocked(boolean bl) {
        this.addTaskButton.setEnabled(!bl);
        this.newTaskTextField.setEditable(!bl);
        this.newTaskTextField.setEnabled(!bl);
    }

    @Override
    public final Object dispose(Object ... objectArray) {
        this.addTaskButton = null;
        this.filterPanel = null;
        this.newTaskTextField = null;
        return null;
    }

    private MMenu createCategoryFilterMenu() {
        MMenu mMenu = new MMenu();
        mMenu.setSplitMenu(true);
        mMenu.addTitle(UI._("Show Category"));
        CategoryManager categoryManager = CategoryManager.getSharedInstance();
        CategoryList categoryList = new CategoryList();
        for (Object object : (TaskModel)((TaskTable)this.taskTableRef.get()).getModel()) {
            categoryList.add(categoryManager, ((Task)object).getCategory());
        }
        if (categoryList.isEmpty()) {
            mMenu.add(UI._("No Items")).setEnabled(false);
        } else {
            String string = this.filterPanel.getText();
            for (Category category : categoryList) {
                mMenu.addRadioButton(new CategoryAction(category){

                    @Override
                    public void onAction() {
                        TaskPanel.this.filterPanel.setText(((Category)this.getData()).getName());
                    }
                }, category.getName().equals(string));
            }
        }
        return mMenu;
    }

    private void doAddTask() {
        this.newTaskTextField.saveAutoCompletion();
        ((TaskTable)this.getTaskTable()).addTask(this.newTaskTextField.getText(), true);
        this.newTaskTextField.clear();
    }
}

