/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MDateSpinner;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.TK;
import org.makagiga.todo.TaskTable;

public class DateTimeEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final MDateSpinner spinner = new MDateSpinner();

    public DateTimeEditor() {
        this.spinner.setDateTimeFormat(2, 3);
        this.spinner.setAutoCompletion("datetime");
        this.spinner.getAutoCompletion().consumeEnter.no();
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!DateTimeEditor.this.spinner.isDateValid()) {
                    DateTimeEditor.this.stopCellEditing();
                }
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.spinner.getSelectedDate();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        MDate mDate;
        if (jTable instanceof TaskTable) {
            ((TaskTable)TaskTable.class.cast(jTable)).setupCellEditor(this.spinner);
        }
        this.spinner.setValue((mDate = (MDate)object).isValid() ? mDate : MDate.now());
        this.spinner.makeDefault();
        return new Panel(this);
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return super.isCellEditable(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        try {
            if (TK.isEmpty(this.spinner.getText())) {
                this.spinner.clearDate();
            }
            this.spinner.commitEdit();
            this.spinner.saveAutoCompletion();
            return super.stopCellEditing();
        }
        catch (ParseException parseException) {
            MLogger.exception(parseException);
            return false;
        }
    }

    private static final class Panel
    extends MPanel {
        private final MSmallButton clearButton;
        private final WeakReference<DateTimeEditor> editorRef;

        private Panel(DateTimeEditor dateTimeEditor) {
            this.editorRef = new WeakReference<DateTimeEditor>(dateTimeEditor);
            this.addCenter(dateTimeEditor.spinner);
            this.clearButton = new MSmallButton(MIcon.small("ui/clearleft"), MActionInfo.NO_DATE_TIME.getText()){

                @Override
                protected void onClick() {
                    MDateSpinner mDateSpinner = ((Panel)Panel.class.cast(this.getParent())).getSpinner();
                    mDateSpinner.clearDate();
                }
            };
            this.clearButton.setEnabled(false);
            dateTimeEditor.spinner.setEnabled(false);
            new MTimer(200){

                @Override
                protected boolean onTimeout() {
                    Panel panel = Panel.this;
                    panel.clearButton.setEnabled(true);
                    MDateSpinner mDateSpinner = panel.getSpinner();
                    if (mDateSpinner != null) {
                        mDateSpinner.setEnabled(true);
                        mDateSpinner.makeDefault();
                    }
                    return false;
                }
            }.start();
            this.clearButton.setSafeAction(true);
            MSmallButton.setSafeActionIcon(this.clearButton, this.clearButton.getIcon());
            this.addEast(this.clearButton);
        }

        private MDateSpinner getSpinner() {
            DateTimeEditor dateTimeEditor = (DateTimeEditor)this.editorRef.get();
            return dateTimeEditor == null ? null : dateTimeEditor.spinner;
        }
    }
}

