/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyVetoException;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.UI;
import org.makagiga.todo.Priority;
import org.makagiga.todo.Task;

public class CircleRenderer
extends MComponent
implements MRenderer.Optimized,
TableCellRenderer {
    private Color selectionForeground;
    private int complete;
    private Priority priority;
    private static Stroke stroke;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.selectionForeground = bl ? jTable.getSelectionForeground() : null;
        this.setOpaque(true);
        MRenderer.setupTable(jTable, this, bl, bl2, n, n2);
        Task task = (Task)object;
        this.complete = task.getComplete();
        this.priority = task.getPriority();
        return this;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.priority == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        UI.setAntialiasing(graphics2D, true);
        boolean bl = this.complete == 100;
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = this.getBackground();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n, n2);
        }
        boolean bl2 = false;
        boolean bl3 = this.complete == 80 && color != null;
        Color color2 = null;
        float f = 0.8f;
        switch (this.priority) {
            case VERY_HIGH: 
            case HIGH: {
                bl2 = true;
                color2 = MColor.deriveColor(this.priority.getColor(), f);
                break;
            }
            case LOW: 
            case VERY_LOW: {
                color2 = MColor.deriveColor(this.priority.getColor(), f);
                break;
            }
            default: {
                color2 = MColor.GRAY;
            }
        }
        if (this.isPaintingForPrint()) {
            color2 = Color.BLACK;
        } else if (this.selectionForeground != null) {
            color2 = this.selectionForeground;
        } else if (bl && this.selectionForeground == null) {
            color2 = MColor.GRAY;
        }
        if (color2 == null) {
            color2 = MColor.GRAY;
        }
        graphics2D.setColor(color2);
        int n3 = 4;
        int n4 = Math.max(n2 - n3 * 2, 12);
        n4 -= n4 % 2;
        if (stroke == null) {
            stroke = new BasicStroke(1.5f);
        }
        graphics2D.setStroke(stroke);
        if (!bl3) {
            graphics2D.drawOval(n3, n3, n4, n4);
        }
        int n5 = -((int)((float)this.complete * 3.6f));
        graphics2D.fillArc(n3, n3, n4, n4, -45, n5);
        if (bl2) {
            UI.setTextAntialiasing(graphics2D, null);
            Font font = UI.getFont(this);
            graphics2D.setFont(font.deriveFont(3));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString("!", n3 + n4 + n3, n3 + n2 / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
        }
        if (bl3) {
            graphics2D.setColor(color);
            int n6 = n3 + n4 / 2;
            int n7 = 2;
            graphics2D.fillRect(n6 - n4 / 4, n6 - n4 / 4, n7, n7);
        }
        if (bl && color != null) {
            graphics2D.setColor(color);
            int n8 = n3 + n4 / 2;
            int n9 = 2;
            graphics2D.fillRect(n8 - n4 / 4, n8 - n4 / 4, n9, n9);
            graphics2D.fillRect(n8 + n4 / 4 - 1, n8 - n4 / 4, n9, n9);
            graphics2D.drawArc(n8 - n4 / 4, n8, n4 / 2, n4 / 4, 0, -180);
        }
    }
}

