/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.search;

import javax.swing.event.DocumentEvent;
import org.makagiga.MainWindow;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.fs.MetaInfo;
import org.makagiga.search.Query;
import org.makagiga.search.QueryEditor;
import org.makagiga.search.SortMethod;
import org.makagiga.tree.Tree;

public final class SearchBar
extends MSearchPanel
implements Focusable {
    private static SearchBar _instance;

    @Override
    public void focus() {
        this.makeDefault();
    }

    public static synchronized SearchBar getInstance() {
        if (_instance == null) {
            _instance = new SearchBar();
        }
        return _instance;
    }

    public static String getQuery() {
        SearchBar searchBar = SearchBar.getInstance();
        return searchBar.getText();
    }

    public static void setQuery(String string) {
        MainWindow.showTree(null);
        SearchBar searchBar = SearchBar.getInstance();
        searchBar.focus();
        if (string == null) {
            if (!MApplication.getStatusBar().isClosed()) {
                MStatusBar.info(UI._("Find files as you type"));
            }
        } else {
            searchBar.setText(string);
        }
    }

    @Override
    protected void onChange(DocumentEvent documentEvent) {
        this.search(this.getText());
    }

    @Override
    protected MMenu onPopupMenu() {
        MMenu mMenu = new MMenu();
        mMenu.add(new MAction(MActionInfo.SEARCH){

            @Override
            public void onAction() {
                String string = QueryEditor.getQuery(MainWindow.getInstance(), SearchBar.getQuery());
                if (string != null) {
                    SearchBar.this.setText(string);
                }
            }
        });
        mMenu.addSeparator();
        MainWindow mainWindow = MainWindow.getInstance();
        Object object = mainWindow.getElementById("quick-open-action");
        if (object instanceof MAction) {
            mMenu.add((MAction)object);
        }
        mMenu.add(new MAction(MActionInfo.SHOW_STARRED){

            @Override
            public void onAction() {
                SearchBar.this.setText("icon=\"ui/star\"");
            }
        });
        return mMenu;
    }

    private SearchBar() {
        MWhatsThis.set(this, UI._("Find Files")).setKeyStroke(118);
        this.getClearButton().setToolTipText(UI._("Show All"));
        this.getMenuButton().setVisible(true);
        GlassPainter glassPainter = (GlassPainter)this.getPainter();
        if (glassPainter != null) {
            glassPainter.setRoundType(GlassPainter.RoundType.NONE);
        }
        this.getMenuButton().setToolTipText(UI._("Select search options"));
        this.setAutoCompletion("query");
        this.getAutoCompletion().consumeEnter.no();
        this.setChangeEventDelay(500);
        this.setHintText(UI._("Search..."));
        this.setEnterPressAction(new MAction(){

            @Override
            public void onAction() {
                SearchBar.this.search(SearchBar.this.getText());
            }
        });
        this.setMargin(3);
        this.getTextField().setToolTipText(UI._("Search for name, content, comment, ..."));
    }

    private void search(String string) {
        Tree tree = Tree.getInstance();
        MetaInfo[] metaInfoArray = tree.getSelectedItems();
        MetaInfo metaInfo = metaInfoArray.length == 0 ? null : metaInfoArray[0];
        Query query = new Query(string, SortMethod.UNSORTED);
        query.setFilterTree(true);
        query.setProcessSearchFS(false);
        Query.Hits hits = query.start();
        if (hits.isEmpty()) {
            if (TK.isEmpty(string)) {
                this.setState(MTextFieldPanel.State.NORMAL);
                MStatusBar.ready();
            } else {
                this.setState(MTextFieldPanel.State.ERROR);
                if (!MApplication.getStatusBar().isClosed()) {
                    MStatusBar.warning(UI._("No item found: \"{0}\"", string));
                }
            }
        } else {
            this.setState(MTextFieldPanel.State.OK);
            if (this.getText().length() > 3) {
                this.saveAutoCompletion();
            }
            if (query.isAllVisible()) {
                MStatusBar.ready();
            } else if (!MApplication.getStatusBar().isClosed()) {
                MStatusBar.info(UI._("{0} item(s) found: \"{1}\"", hits.size(), string));
            }
        }
        if (metaInfo != null && metaInfo.isVisible()) {
            tree.selectItem(metaInfo, true);
        }
    }

    public static final class Action
    extends MAction {
        public Action() {
            super(UI._("Find Files..."), 118);
            this.setHTMLHelp(UI._("Search for files."));
        }

        @Override
        public void onAction() {
            SearchBar.setQuery(null);
        }
    }
}

