/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.util.Map;
import javax.swing.Icon;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;

public enum PluginType {
    EDITOR("editor", UI._("Editors/Viewers"), "ui/file", false, "Document editors and viewers..."),
    WIDGET("widget", UI._("Widgets"), "ui/desktop", true, null),
    LOOK_AND_FEEL("lookandfeel", UI._("Look and Feel"), "labels/emotion/happy", false, "Application skins, icon themes, ..."),
    INTERNET_SEARCH("internetsearch", UI._("Internet Search"), "ui/internet", false, null),
    GENERAL("general", UI._("General"), "ui/misc", true, null),
    FILE_SYSTEM("fs", UI._("Tree"), "ui/tree", false, null),
    LOCALE("locale", UI._("Locale"), "ui/locale", false, "Language translations / Spell checker dictionaries"),
    CONSOLE("console", UI._("Console"), "ui/misc", false, "Console commands...");

    private boolean scriptSupport;
    private static Map<String, PluginType> typeMap;
    private String iconName;
    private String shortDescription;
    private String text;
    private String type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginType fromType(String string) {
        if (string == null) {
            return null;
        }
        Class<PluginType> clazz = PluginType.class;
        synchronized (PluginType.class) {
            if (typeMap == null) {
                PluginType[] pluginTypeArray = PluginType.values();
                typeMap = TK.newHashMap(pluginTypeArray.length);
                for (PluginType pluginType : pluginTypeArray) {
                    typeMap.put(pluginType.type, pluginType);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return typeMap.get(string);
        }
    }

    public PluginManager.Table get() {
        return PluginManager.getTable(this.type, false);
    }

    public PluginManager.Table get(boolean bl) {
        return PluginManager.getTable(this.type, bl);
    }

    public PluginInfo getByID(String string) {
        for (PluginInfo pluginInfo : this.get()) {
            if (!pluginInfo.getID().equals(string)) continue;
            return pluginInfo;
        }
        return null;
    }

    public Icon getIcon() {
        return MIcon.stock(this.iconName);
    }

    public String getIconName() {
        return this.iconName;
    }

    @Deprecated
    public String getShortDescription() {
        return this.shortDescription;
    }

    public Icon getSmallIcon() {
        return MIcon.small(this.iconName);
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public boolean isScriptSupport() {
        return this.scriptSupport;
    }

    public static boolean isValidType(String string) {
        return PluginType.fromType(string) != null;
    }

    public String toString() {
        return this.text;
    }

    private PluginType(String string2, String string3, String string4, boolean bl, String string5) {
        this.type = string2;
        this.text = string3;
        this.iconName = string4;
        this.scriptSupport = bl;
        this.shortDescription = string5;
    }
}

