/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MSettingsDialog;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MTip;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.commons.script.ScriptYourself;
import org.makagiga.plugins.Pluggable;
import org.makagiga.plugins.PluginDownloader;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginInstaller;
import org.makagiga.plugins.PluginList;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginOptions;
import org.makagiga.plugins.PluginRenderer;
import org.makagiga.plugins.PluginType;
import org.makagiga.plugins.ScriptPlugin;

public final class PluginSettings
extends MSettingsDialog<Page> {
    private ActionGroup actionGroup;
    private final CoolHeader message;
    private final MSearchPanel filter;

    public PluginSettings(Window window) {
        super(window, UI._("Plugins"), "ui/plugin", 60, "plugins", 2);
        this.changeButton((AbstractButton)this.getUserButton(), PluginManager.UPDATE_PLUGINS_ACTION_INFO);
        this.changeButton((AbstractButton)this.getURLButton(), PluginManager.GET_MORE_PLUGINS_ACTION_INFO);
        this.createActions();
        this.filter = new MSearchPanel(true, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                ((Page)PluginSettings.this.getSelectedPage()).doFilter(this);
            }
        };
        Page page = new Page(null);
        this.addPage(page);
        this.setPageListVisible(false);
        this.getMainPanel().setMargin(0, 5, 5, 5);
        MToolBar mToolBar = new MToolBar();
        mToolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.actionGroup.updateToolBar(mToolBar);
        ScriptYourself.install(mToolBar, "plugin-settings");
        mToolBar.addGap();
        mToolBar.add(this.filter);
        mToolBar.addGap();
        this.setToolBar(mToolBar);
        MPanel mPanel = MPanel.createBorderPanel(5);
        this.message = new CoolHeader();
        this.message.setVisible(false);
        mPanel.addNorth(this.message);
        MTip mTip = new MTip(PluginSettings.class.getName());
        mTip.showNextTip(MTip.Visible.SELDOM);
        mPanel.addSouth(mTip);
        this.addSouth(mPanel);
        this.updateActions(null);
    }

    public static MPanel createConfigPanel(Pluggable pluggable, boolean bl) {
        return pluggable instanceof ScriptPlugin ? ((ScriptPlugin)ScriptPlugin.class.cast(pluggable)).createPluginConfigPanel(bl) : ((PluginOptions)PluginOptions.class.cast(pluggable)).createPluginConfigPanel();
    }

    @Override
    public void setNeedRestart(boolean bl) {
        super.setNeedRestart(bl);
        if (bl) {
            this.message.setWarningMessage(MApplication.getRestartMessage());
            this.message.setVisible(true);
        } else {
            this.message.setVisible(false);
        }
    }

    public static boolean showPluginOptionsDialog(Window window, PluginInfo pluginInfo) {
        return PluginSettings.showPluginOptionsDialog(window, 0, pluginInfo);
    }

    public static boolean showPluginOptionsDialog(Window window, int n, PluginInfo pluginInfo) {
        Pluggable pluggable = pluginInfo.getPluggable();
        if (!(pluggable instanceof PluginOptions)) {
            return false;
        }
        MPanel mPanel = PluginSettings.createConfigPanel(pluggable, true);
        if (mPanel == null) {
            return false;
        }
        Panel panel = new Panel(pluginInfo, mPanel);
        panel.setDialogFlags(panel.getDialogFlags() | n);
        return panel.exec(window);
    }

    @Override
    protected void onPageChange() {
        PluginList pluginList;
        Page page = (Page)this.getSelectedPage();
        if (page != null) {
            page.doFilter(this.filter);
        }
        if ((pluginList = this.getSelectedList()) != null) {
            pluginList.clearSelection();
            this.updateActions(null);
            pluginList.requestFocusInWindow();
        }
    }

    @Override
    protected boolean onReject() {
        this.apply();
        return true;
    }

    @Override
    protected void onURLClick() {
        PluginDownloader.getMorePlugins(this, null);
    }

    @Override
    protected void onUserClick() {
        PluginDownloader.update(this);
    }

    @Override
    protected void updatePagePanel(MPanel mPanel, Page page) {
        mPanel.removeAll();
        mPanel.addCenter(page);
        mPanel.validate();
    }

    private void about() {
        PluginInfo pluginInfo = this.getSelectedInfo();
        if (pluginInfo != null) {
            pluginInfo.about(this);
        }
    }

    private void createActions() {
        this.actionGroup = new ActionGroup();
        this.actionGroup.add("installFromFile", new MAction(UI._("Install from file..."), "ui/newfile"){

            @Override
            public void onAction() {
                if (PluginInstaller.showInstallDialog(this.getSourceWindow())) {
                    PluginSettings.this.setNeedRestart(true);
                }
            }
        }).setShowTextInToolBar(true);
        this.actionGroup.addSeparator();
        MAction mAction = new MAction(MActionInfo.UNINSTALL){

            @Override
            public void onAction() {
                PluginSettings.this.removePlugin();
            }
        };
        mAction.setHTMLHelp(UI._("Removes plugin from the disk.<br>Only external plugin can be removed."));
        this.actionGroup.add("delete", mAction);
        this.actionGroup.add("enableDisable", new MAction(UI._("Disable"), "ui/minus"){

            @Override
            public void onAction() {
                PluginSettings.this.togglePlugin();
            }
        }).setShowTextInToolBar(true);
        this.actionGroup.addStretch();
        this.actionGroup.add("moveUp", new MAction(UI._("Move Up"), "ui/up"){

            @Override
            public void onAction() {
                PluginSettings.this.movePlugin(true);
            }
        });
        this.actionGroup.add("moveDown", new MAction(UI._("Move Down"), "ui/down"){

            @Override
            public void onAction() {
                PluginSettings.this.movePlugin(false);
            }
        });
        this.actionGroup.addStretch();
        this.actionGroup.add("about", new MAction(MActionInfo.ABOUT){

            @Override
            public void onAction() {
                PluginSettings.this.about();
            }
        });
        ActionGroup.Item item = this.actionGroup.add("postPluginInfo", new MAction("Post plugin info to makagiga.sf.net (requires administrator password)"){

            @Override
            public void onAction() {
                PluginSettings.this.postPluginInfo();
            }
        });
        item.setVisibleInMenu(MLogger.isDeveloper());
        item.setVisibleInToolBar(false);
    }

    private PluginList getSelectedList() {
        Page page = (Page)this.getSelectedPage();
        return page == null ? null : page.list;
    }

    private void movePlugin(boolean bl) {
        PluginList pluginList = this.getSelectedList();
        int n = pluginList.getSelectedIndex();
        PluginInfo pluginInfo = (PluginInfo)pluginList.getSelectedItem();
        int n2 = bl ? n - 1 : n + 1;
        PluginInfo pluginInfo2 = (PluginInfo)pluginList.getItemAt(n2);
        pluginList.getDefaultModel().setElementAt(pluginInfo, n2);
        pluginList.getDefaultModel().setElementAt(pluginInfo2, n);
        pluginList.setSelectedIndex(n2, true);
        if (bl) {
            pluginInfo.priority.set((Integer)pluginInfo2.priority.get() + 1);
        } else {
            pluginInfo.priority.set((Integer)pluginInfo2.priority.get() - 1);
        }
        Config config = Config.getDefault();
        config.write("Plugin.priority." + pluginInfo.getID(), (Integer)pluginInfo.priority.get());
        config.sync();
    }

    private void postPluginInfo() {
        PluginInfo pluginInfo = this.getSelectedInfo();
        MMainWindow.openURI(MApplication.getHomePage() + "/updateplugininfo.php?action=upload&" + "uuid={0}&" + "type={1}&" + "name={2}&" + "description={3}&" + "copyright={4}&" + "homepage={5}&" + "license={6}&" + "version={7}&" + "requires={8}", pluginInfo.getID().replaceAll("\\{|\\}", ""), (String)pluginInfo.type.get(), (String)pluginInfo.name.get(), (String)pluginInfo.shortDescription.get(), ((String)pluginInfo.copyright.get()).replace("\n", "\\n"), (String)pluginInfo.homePageURL.get(), (String)pluginInfo.licenseName.get(), ((Integer)pluginInfo.version.get()).toString(), ((Integer)pluginInfo.requires.get()).toString());
    }

    private void removePlugin() {
        PluginInfo pluginInfo = this.getSelectedInfo();
        if (pluginInfo == null) {
            return;
        }
        if (!pluginInfo.canRemove()) {
            return;
        }
        if (!MMessage.customConfirm(this, MIcon.stock("ui/delete"), MActionInfo.UNINSTALL, null, UI._("Uninstall selected plugin?"), new Object[]{pluginInfo})) {
            return;
        }
        Config config = Config.getDefault();
        config.write("Plugin.remove." + pluginInfo.getID(), true);
        config.sync();
        this.getSelectedList().removeItem(pluginInfo);
        PluginManager.getInstance().unregister(pluginInfo);
        this.setNeedRestart(true);
        this.updateActions(null);
    }

    private void togglePlugin() {
        PluginInfo pluginInfo = this.getSelectedInfo();
        if (pluginInfo == null) {
            return;
        }
        pluginInfo.enabled.toggle();
        this.getSelectedList().repaintItem(pluginInfo);
        PluginManager pluginManager = PluginManager.getInstance();
        if (((Boolean)pluginInfo.enabled.get()).booleanValue()) {
            pluginManager.register(pluginInfo);
        } else {
            pluginManager.unregister(pluginInfo);
        }
        Config config = Config.getDefault();
        config.write("Plugin.enabled." + pluginInfo.getID(), pluginInfo.enabled);
        config.sync();
        this.setNeedRestart(true);
        this.updateActions(pluginInfo);
    }

    private void updateActions(PluginInfo pluginInfo) {
        if (pluginInfo == null) {
            this.actionGroup.setEnabled(false);
            MAction mAction = (MAction)this.actionGroup.getAction("enableDisable");
            mAction.setIconName("ui/minus");
            mAction.setName(UI._("Disable"));
        } else {
            this.actionGroup.setEnabled("about", true);
            this.actionGroup.setEnabled("delete", pluginInfo.canRemove());
            PluginList pluginList = this.getSelectedList();
            int n = pluginList.getSelectedIndex();
            this.actionGroup.setEnabled("moveDown", n != -1 && n < pluginList.getItemCount() - 1);
            this.actionGroup.setEnabled("moveUp", n != -1 && n > 0);
            this.actionGroup.setEnabled("postPluginInfo", !pluginInfo.isInternal());
            MAction mAction = (MAction)this.actionGroup.getAction("enableDisable");
            mAction.setEnabled(pluginInfo.isCompatible());
            if (((Boolean)pluginInfo.enabled.get()).booleanValue()) {
                mAction.setIconName("ui/minus");
                mAction.setName(UI._("Disable"));
            } else {
                mAction.setIconName("ui/plus");
                mAction.setName(UI._("Enable"));
            }
        }
        this.actionGroup.setEnabled("installFromFile", true);
    }

    PluginInfo getSelectedInfo() {
        PluginList pluginList = this.getSelectedList();
        return pluginList == null ? null : (PluginInfo)pluginList.getSelectedItem();
    }

    public static final class Panel
    extends MSettingsPage {
        private final Pluggable pluggable;
        private WeakReference<MPanel> panelRef;

        public Panel(PluginInfo pluginInfo, MPanel mPanel) {
            super(pluginInfo.toString(), pluginInfo.getIcon());
            this.pluggable = pluginInfo.getPluggable();
            this.setPanel(mPanel);
        }

        @Override
        protected void onInit() {
            if (this.panelRef == null) {
                this.setPanel(PluginSettings.createConfigPanel(this.pluggable, false));
            }
            ((PluginOptions)PluginOptions.class.cast(this.pluggable)).loadPluginConfig((MPanel)this.panelRef.get());
        }

        @Override
        protected void onOK() {
            if (this.panelRef == null) {
                this.setPanel(PluginSettings.createConfigPanel(this.pluggable, false));
            }
            ((PluginOptions)PluginOptions.class.cast(this.pluggable)).savePluginConfig((MPanel)this.panelRef.get());
        }

        private void setPanel(MPanel mPanel) {
            if (mPanel != null) {
                this.add(mPanel);
                this.panelRef = new WeakReference<MPanel>(mPanel);
            }
        }
    }

    public final class Page
    extends MSettingsPage {
        private List<PluginInfo> all;
        private PluginList list;
        private final PluginType type;

        @Deprecated
        public Page(PluginType pluginType) {
            super(pluginType == null ? "" : pluginType.getText(), pluginType == null ? null : pluginType.getSmallIcon());
            this.type = pluginType;
            this.setMargin(0);
        }

        @Override
        protected void onInit() {
            this.list = new PluginList(this.type){

                @Override
                protected void onAction() {
                    if (this.getActionType() == MList.ActionType.ITEM_POPUP_MENU) {
                        PluginSettings.this.actionGroup.createMenu().showPopup(this.getActionEvent());
                    }
                }

                @Override
                protected void onSelect() {
                    PluginSettings.this.updateActions((PluginInfo)Page.this.list.getSelectedItem());
                }
            };
            ((PluginRenderer)PluginRenderer.class.cast(this.list.getCellRenderer())).showType = true;
            this.add(new MScrollPane(this.list));
            this.all = MArrayList.create(this.list.getItemCount());
            for (PluginInfo pluginInfo : this.list) {
                this.all.add(pluginInfo);
            }
        }

        private void doFilter(MSearchPanel mSearchPanel) {
            if (this.list == null) {
                return;
            }
            this.list.filter(mSearchPanel, this.all, new MList.SearchableFilter(mSearchPanel.getText()));
            if (this.list.isEmpty() && mSearchPanel.isEmpty() && mSearchPanel.getState() != MTextFieldPanel.State.NORMAL) {
                mSearchPanel.setState(MTextFieldPanel.State.NORMAL);
            }
            this.list.sort(new Comparator<PluginInfo>(){

                @Override
                public int compare(PluginInfo pluginInfo, PluginInfo pluginInfo2) {
                    boolean bl = (Boolean)pluginInfo.enabled.get();
                    boolean bl2 = (Boolean)pluginInfo2.enabled.get();
                    if (bl && !bl2) {
                        return -1;
                    }
                    if (bl2 && !bl) {
                        return 1;
                    }
                    int n = pluginInfo.type.compareTo(pluginInfo2.type);
                    if (n == 0) {
                        n = pluginInfo.compareTo(pluginInfo2);
                    }
                    return n;
                }
            });
        }
    }

    public static final class Action
    extends MAction {
        public Action() {
            super(UI._("Plugins"), "ui/plugin");
            this.setHTMLHelp(UI._("Add or Remove Plugins"));
        }

        @Override
        public void onAction() {
            if (((Boolean)Kiosk.pluginManager.get()).booleanValue()) {
                PluginSettings pluginSettings = new PluginSettings(this.getSourceWindow());
                pluginSettings.exec(pluginSettings.filter);
            }
        }
    }
}

